/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Manifest;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.AbstractStorage;
import oracle.ojc.storage.DirectoryStorage;

public final class JarStorage
extends DirectoryStorage {
    RandomAccessFile r;
    private JarFileStorage manifestFile;
    @CodeSharingSafe(value="StaticField")
    private static AtomicInteger openJarCounter = new AtomicInteger(0);

    public JarStorage(AbstractStorage storage, String name) {
        super(storage, name);
        this.readJarDirectory();
        if (this.r != null) {
            openJarCounter.getAndIncrement();
        }
    }

    public JarStorage(File file) {
        super(file);
        this.readJarDirectory();
        if (this.r != null) {
            openJarCounter.getAndIncrement();
        }
    }

    public boolean isOpen() {
        return this.r != null;
    }

    public Manifest getManifest() {
        if (this.manifestFile == null) {
            return null;
        }
        try {
            byte[] bytes = this.manifestFile.read();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
            return new Manifest(bytesIn);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getOpenJarCount() {
        return openJarCounter.get();
    }

    private void readJarDirectory() {
        try {
            long newEntryCount;
            byte[] zip64Vec;
            this.r = new RandomAccessFile(this.file, "r");
            long[] dirvecStart = new long[1];
            byte[] dirvec = this.findDir(dirvecStart);
            long entryCount = JarStorage.get2LE(dirvec, 0);
            if (entryCount >= 65535L && (zip64Vec = this.findZip64Record(dirvecStart[0] - 20L)).length > 0 && (newEntryCount = JarStorage.get8LE(zip64Vec, 24)) > entryCount) {
                entryCount = newEntryCount;
            }
            int pos = 2;
            int i = 0;
            while ((long)i < entryCount) {
                pos = this.readEntry(dirvec, pos);
                ++i;
            }
        }
        catch (IOException e) {
            this.r = null;
        }
    }

    private byte[] findZip64Record(long startOfZip64Locator) throws IOException {
        byte[] recordLocator = new byte[20];
        this.r.seek(startOfZip64Locator);
        if (this.r.read(recordLocator, 0, 20) != 20) {
            return new byte[0];
        }
        int signature = JarStorage.get4LE(recordLocator, 0);
        if (signature != 117853008) {
            return new byte[0];
        }
        long recordOffset = JarStorage.get8LE(recordLocator, 8);
        byte[] zip64Record = new byte[56];
        this.r.seek(recordOffset);
        if (this.r.read(zip64Record, 0, 56) != 56) {
            return new byte[0];
        }
        signature = JarStorage.get4LE(zip64Record, 0);
        if (signature != 101075792) {
            return new byte[0];
        }
        return zip64Record;
    }

    private byte[] findDir(long[] dirvecStart) throws IOException {
        byte[] endbuf = new byte[1024];
        int endbufLen = endbuf.length;
        long endbufEnd = this.r.length();
        while (endbufEnd >= 22L) {
            int i;
            if (endbufEnd < (long)endbufLen) {
                endbufLen = (int)endbufEnd;
            }
            long endbufPos = endbufEnd - (long)endbufLen;
            this.r.seek(endbufPos);
            if (this.r.read(endbuf, 0, endbufLen) != endbufLen) {
                throw new IOException("read error");
            }
            for (i = endbufLen - 22; i >= 0 && (endbuf[i] != 80 || endbuf[i + 1] != 75 || endbuf[i + 2] != 5 || endbuf[i + 3] != 6 || endbufPos + (long)i + 22L + (long)JarStorage.get2LE(endbuf, i + 20) > this.r.length()); --i) {
            }
            if (i >= 0) {
                byte[] dirvec = new byte[JarStorage.get4LE(endbuf, i + 12) + 2];
                dirvec[0] = endbuf[i + 10];
                dirvec[1] = endbuf[i + 11];
                dirvecStart[0] = endbufPos + (long)i;
                this.r.seek(JarStorage.get4LE(endbuf, i + 16));
                if (this.r.read(dirvec, 2, dirvec.length - 2) != dirvec.length - 2) {
                    throw new IOException("read error");
                }
                return dirvec;
            }
            endbufEnd = endbufPos + 21L;
        }
        throw new IOException("bad zip file");
    }

    private int readEntry(byte[] dirbuf, int pos) throws IOException {
        String name;
        if (JarStorage.get4LE(dirbuf, pos) != 33639248) {
            throw new IOException("bad dir entry");
        }
        int dosTime = JarStorage.get4LE(dirbuf, pos + 12);
        int csize = JarStorage.get4LE(dirbuf, pos + 20);
        int size = JarStorage.get4LE(dirbuf, pos + 24);
        int offset = JarStorage.get4LE(dirbuf, pos + 42);
        int len = JarStorage.get2LE(dirbuf, pos + 28);
        char[] cbuf = new char[len];
        int clen = 0;
        DirectoryStorage curDir = this;
        int nameBase = pos + 46;
        int lastDirLen = 0;
        boolean utf8 = false;
        block3: for (int i = 0; i < len; ++i) {
            byte b = dirbuf[nameBase++];
            switch (b) {
                default: {
                    if ((b & 0x80) != 0) {
                        utf8 = true;
                    }
                    cbuf[clen++] = (char)(b & 0xFF);
                    continue block3;
                }
                case 47: 
                case 92: {
                    name = utf8 ? this.makeUTF8Name(cbuf, clen) : new String(cbuf, 0, clen);
                    utf8 = false;
                    lastDirLen = clen;
                    clen = 0;
                    DirectoryStorage d = (DirectoryStorage)curDir.find(name);
                    if (d != null) {
                        curDir = d;
                        continue block3;
                    }
                    JarDirectoryStorage dir = new JarDirectoryStorage(curDir, name);
                    curDir.entries.put(name, dir);
                    curDir = dir;
                }
            }
        }
        name = utf8 ? this.makeUTF8Name(cbuf, clen) : new String(cbuf, 0, clen);
        JarFileStorage jarFile = new JarFileStorage(this, curDir, name, offset, size, csize, dosTime);
        if (clen == 11 && lastDirLen == 8 && name.equalsIgnoreCase("manifest.mf") && curDir.getName().equalsIgnoreCase("meta-inf")) {
            this.manifestFile = jarFile;
        }
        curDir.entries.put(name, jarFile);
        return pos + 46 + len + JarStorage.get2LE(dirbuf, pos + 30) + JarStorage.get2LE(dirbuf, pos + 32);
    }

    private String makeUTF8Name(char[] cbuf, int len) throws IOException {
        byte[] bbuf = new byte[len];
        for (int x = 0; x < len; ++x) {
            bbuf[x] = (byte)cbuf[x];
        }
        return new String(bbuf, 0, len, "UTF-8");
    }

    static int get2LE(byte[] buf, int pos) {
        return ((buf[pos + 1] & 0xFF) << 8) + (buf[pos] & 0xFF);
    }

    static int get4LE(byte[] buf, int pos) {
        return ((buf[pos + 3] & 0xFF) << 24) + ((buf[pos + 2] & 0xFF) << 16) + ((buf[pos + 1] & 0xFF) << 8) + (buf[pos] & 0xFF);
    }

    static long get8LE(byte[] buf, int pos) {
        return ((buf[pos + 7] & 0xFF) << 56) + ((buf[pos + 6] & 0xFF) << 48) + ((buf[pos + 5] & 0xFF) << 40) + ((buf[pos + 4] & 0xFF) << 32) + ((buf[pos + 3] & 0xFF) << 24) + ((buf[pos + 2] & 0xFF) << 16) + ((buf[pos + 1] & 0xFF) << 8) + (buf[pos] & 0xFF);
    }

    @Override
    public void close() {
        try {
            if (this.r != null) {
                openJarCounter.getAndDecrement();
                this.r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.r = null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    @Override
    public Storage create(String name) throws IOException {
        throw new IOException("read only");
    }

    @Override
    public Storage createDir(String name) throws IOException {
        throw new IOException("read only");
    }

    private String getPath(DirectoryStorage parent, String name, boolean canonical) {
        StringBuilder buf = new StringBuilder();
        if (canonical) {
            buf.append(parent.getCanonicalPath());
        } else {
            buf.append(parent.getPath());
        }
        if (parent == this) {
            buf.append('!');
        }
        buf.append(File.separatorChar);
        buf.append(name);
        return buf.toString();
    }

    final class JarFileStorage
    extends AbstractStorage {
        JarStorage jarStorage;
        DirectoryStorage dir;
        String name;
        long modDate;
        int offset;
        int size;
        int csize;
        int dosTime;

        JarFileStorage(JarStorage jarStorage, DirectoryStorage dir, String name, int offset, int size, int csize, int dosTime) {
            super(null, name);
            this.jarStorage = jarStorage;
            this.dir = dir;
            this.name = name;
            this.offset = offset;
            this.size = size;
            this.csize = csize;
            this.dosTime = dosTime;
        }

        private byte[] header() throws IOException {
            this.jarStorage.r.seek(this.offset);
            byte[] header = new byte[30];
            this.jarStorage.r.readFully(header);
            if (JarStorage.get4LE(header, 0) != 67324752) {
                throw new IOException("zip file is corrupted");
            }
            if ((JarStorage.get2LE(header, 6) & 1) != 0) {
                throw new IOException("zip file is encrypted");
            }
            return header;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean inflateFully(byte[] dest, byte[] src) {
            boolean bl;
            block6: {
                InflaterInputStream inf = null;
                try {
                    ZippedFileInputStream in = new ZippedFileInputStream(src);
                    inf = new InflaterInputStream(in, new Inflater(true), src.length);
                    int readLength = inf.read(dest, 0, dest.length);
                    boolean bl2 = bl = readLength == dest.length;
                    if (inf == null) break block6;
                }
                catch (Throwable throwable) {
                    try {
                        if (inf != null) {
                            inf.close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                inf.close();
            }
            return bl;
        }

        @Override
        public byte[] read() throws IOException {
            if (this.jarStorage.r == null) {
                return new byte[0];
            }
            byte[] header = this.header();
            byte[] cbuf = new byte[this.csize];
            this.jarStorage.r.skipBytes(JarStorage.get2LE(header, 26) + JarStorage.get2LE(header, 28));
            this.jarStorage.r.readFully(cbuf, 0, this.csize);
            if (JarStorage.get2LE(header, 8) == 0) {
                return cbuf;
            }
            byte[] buf = new byte[this.size];
            if (!this.inflateFully(buf, cbuf)) {
                throw new IOException("zip file is corrupted");
            }
            return buf;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            if (this.jarStorage.r == null) {
                return 0;
            }
            byte[] header = this.header();
            boolean deflated = JarStorage.get2LE(header, 8) != 0;
            this.jarStorage.r.skipBytes(JarStorage.get2LE(header, 26) + JarStorage.get2LE(header, 28));
            if (!deflated) {
                int nbytes = this.csize < buf.length ? this.csize : buf.length;
                this.jarStorage.r.readFully(buf, 0, nbytes);
                return this.csize;
            }
            if (this.size > buf.length) {
                return this.size;
            }
            byte[] cbuf = new byte[this.csize];
            this.jarStorage.r.readFully(cbuf, 0, this.csize);
            byte[] ucbuf = new byte[this.size];
            if (!this.inflateFully(ucbuf, cbuf)) {
                throw new IOException("zip file is corrupted");
            }
            System.arraycopy(ucbuf, 0, buf, 0, this.size);
            return this.size;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return JarStorage.this.getPath(this.dir, this.name, false);
        }

        @Override
        public String getCanonicalPath() {
            return JarStorage.this.getPath(this.dir, this.name, true);
        }

        @Override
        public boolean isInJar() {
            return true;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long modDate() {
            if (this.modDate == 0L) {
                this.modDate = this.dostime2Date(this.dosTime);
            }
            return this.modDate;
        }

        private long dostime2Date(int dostime) {
            GregorianCalendar cal = new GregorianCalendar((dostime >> 25 & 0x7F) + 1980, (dostime >> 21 & 0xF) - 1, dostime >> 16 & 0x1F, dostime >> 11 & 0x1F, dostime >> 5 & 0x3F, dostime << 1 & 0x3E);
            return cal.getTimeInMillis();
        }

        private class ZippedFileInputStream
        extends InputStream {
            private byte[] cbuf;
            private int bytesRead;
            private int bytesLeft;

            ZippedFileInputStream(byte[] buf) throws IOException {
                this.cbuf = buf;
                this.bytesRead = 0;
                this.bytesLeft = buf.length;
            }

            @Override
            public int available() {
                return this.bytesLeft;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.bytesLeft <= 0) {
                    return -1;
                }
                if (len < 0) {
                    len = 0;
                }
                if (len > this.bytesLeft) {
                    len = this.bytesLeft;
                }
                System.arraycopy(this.cbuf, this.bytesRead, b, off, len);
                this.bytesRead += len;
                this.bytesLeft -= len;
                return len;
            }

            @Override
            public int read() throws IOException {
                if (this.bytesLeft <= 0) {
                    return -1;
                }
                byte n = this.cbuf[this.bytesRead];
                ++this.bytesRead;
                --this.bytesLeft;
                return n;
            }

            @Override
            public long skip(long n) {
                if (n < 0L) {
                    n = 0L;
                }
                if (n > (long)this.bytesLeft) {
                    n = this.bytesLeft;
                }
                this.bytesRead = (int)((long)this.bytesRead + n);
                this.bytesLeft = (int)((long)this.bytesLeft - n);
                return n;
            }
        }
    }

    final class JarDirectoryStorage
    extends DirectoryStorage {
        DirectoryStorage parent;
        String name;

        JarDirectoryStorage(DirectoryStorage parent, String name) {
            super(null, name);
            this.parent = parent;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return JarStorage.this.getPath(this.parent, this.name, false);
        }

        @Override
        public String getCanonicalPath() {
            return JarStorage.this.getPath(this.parent, this.name, true);
        }

        @Override
        public boolean isInJar() {
            return true;
        }
    }
}

