/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocBlockTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocInlineTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;

public class DocCommentSym
extends DocSym
implements SourceDocComment {
    @CodeSharingSafe(value="StaticField")
    public static final DocCommentSym[] EMPTY_ARRAY = new DocCommentSym[0];

    public DocCommentSym() {
        this.docOwning = this;
    }

    @Override
    public boolean isHidden() {
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            if (!DocCommentSym.tag2name((short)221).equals(docBlockTagSym.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeprecated() {
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            if (!DocCommentSym.tag2name((short)203).equals(docBlockTagSym.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<SourceDocBlockTag> getBlockTags() {
        return this.getChildrenList(82);
    }

    @Override
    public Collection<SourceDocTag> findTags(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name null or empty");
        }
        ArrayList<SourceDocTag> list = new ArrayList<SourceDocTag>();
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            if (!name.equals(docBlockTagSym.getName())) continue;
            list.add(docBlockTagSym);
        }
        for (DocInlineTagSym docInlineTagSym : this.getInlineTags()) {
            if (!name.equals(docInlineTagSym.getName())) continue;
            list.add(docInlineTagSym);
        }
        return list;
    }

    @Override
    public Collection<SourceDocBlockTag> findExceptionTags() {
        ArrayList<SourceDocBlockTag> list = new ArrayList<SourceDocBlockTag>();
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            if (!docBlockTagSym.isException()) continue;
            list.add(docBlockTagSym);
        }
        return list;
    }

    @Override
    public SourceDocBlockTag findExceptionTag(String exceptionName) {
        if (exceptionName == null || exceptionName.length() == 0) {
            throw new IllegalArgumentException("exceptionName null or empty");
        }
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            SourceDocReference reference = docBlockTagSym.getReference();
            if (reference == null || !exceptionName.equals(reference.getNormalizedText())) continue;
            return docBlockTagSym;
        }
        return null;
    }

    @Override
    public SourceDocBlockTag findParameterTag(String parameterName) {
        if (parameterName == null || parameterName.length() == 0) {
            throw new IllegalArgumentException("parameterName null or empty");
        }
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            SourceDocReference reference = docBlockTagSym.getReference();
            if (reference == null || !parameterName.equals(reference.getDocText())) continue;
            return docBlockTagSym;
        }
        return null;
    }

    @Override
    public Collection<SourceDocTag> findReferenceTags() {
        ArrayList<SourceDocTag> list = new ArrayList<SourceDocTag>();
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            if (!docBlockTagSym.isReference()) continue;
            list.add(docBlockTagSym);
        }
        for (DocInlineTagSym docInlineTagSym : this.getInlineTags()) {
            if (!docInlineTagSym.isReference()) continue;
            list.add(docInlineTagSym);
        }
        return list;
    }

    @Override
    public Collection<SourceDocTag> findReferenceTags(String referenceName) {
        if (referenceName == null || referenceName.length() == 0) {
            throw new IllegalArgumentException("referenceName null or empty");
        }
        ArrayList<SourceDocTag> list = new ArrayList<SourceDocTag>();
        for (DocBlockTagSym docBlockTagSym : this.getChildren(82)) {
            if (!docBlockTagSym.isReference(referenceName)) continue;
            list.add(docBlockTagSym);
        }
        for (DocInlineTagSym docInlineTagSym : this.getInlineTags()) {
            if (!docInlineTagSym.isReference(referenceName)) continue;
            list.add(docInlineTagSym);
        }
        return list;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 82: 
            case 84: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    public boolean checkSafeToDelete(TreeSym parent) {
        return true;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

