/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeBinding;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;

public class LambdaParameterSym
extends FormalParameterSym
implements SourceLambdaParameter {
    private boolean isInferredFormalParameter;

    public void setInferredFormalParamater(boolean isInferredFormalParameter) {
        this.isInferredFormalParameter = isInferredFormalParameter;
    }

    @Override
    public boolean isInferredFormalParameter() {
        return this.isInferredFormalParameter;
    }

    @Override
    public SourceLambdaExpression getOwningLambdaExpression() {
        for (SourceElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getSymbolKind() != 79) continue;
            return (SourceLambdaExpression)parent;
        }
        return null;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: 
            case 27: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    public JavaType getResolvedType() {
        JavaType resolvedType = super.getResolvedType();
        if (resolvedType != null) {
            return resolvedType;
        }
        if (this.isInferredFormalParameter) {
            TypeBinding binding = (TypeBinding)this.getInternalBinding(12);
            if (binding != null) {
                return binding.getResolvedType();
            }
            resolvedType = this.getInferredFormalParameterResolvedType();
            if (resolvedType != null) {
                binding = new TypeBinding(resolvedType);
                this.setInternalBinding(binding);
            }
            return resolvedType;
        }
        return null;
    }

    private JavaType getInferredFormalParameterResolvedType() {
        JavaType[] parameterTypes;
        JavaMethod javaMethod;
        SourceLambdaExpression owner;
        int index = this.getParameterIndex();
        if (index >= 0 && (owner = this.getOwningLambdaExpression()) != null && (javaMethod = owner.getTargetMethod()) != null && index < (parameterTypes = javaMethod.getParameterTypes()).length) {
            JavaType parameterType = parameterTypes[index];
            if (parameterType != null && parameterType.getElementKind() == 11) {
                JavaWildcardType wildcardType = (JavaWildcardType)parameterType;
                if (!wildcardType.getLowerBounds().isEmpty()) {
                    return wildcardType.getLowerBounds().iterator().next();
                }
                if (!wildcardType.getUpperBounds().isEmpty()) {
                    return wildcardType.getUpperBounds().iterator().next();
                }
                return wildcardType.getTypeErasure();
            }
            return parameterType;
        }
        return null;
    }

    private int getParameterIndex() {
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 12) {
            List<SourceVariable> list = ((SourceFormalParameterList)((Object)parentSym)).getSourceParameters();
            for (int x = 0; x < list.size(); ++x) {
                if (list.get(x) != this) continue;
                return x;
            }
        }
        return -1;
    }
}

