/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.Collection;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer4;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocTagSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;

abstract class CompilerLayer5j
extends CompilerLayer4 {
    CompilerLayer5j() {
    }

    public JavaElement resolve(DocReferenceSym sym) {
        if (sym.refParameterName != null) {
            return this.resolveParameterReference(sym);
        }
        return this.resolveReference(sym);
    }

    private JavaElement resolveParameterReference(DocReferenceSym sym) {
        int length;
        String name = sym.refParameterName;
        if (name == null || name.length() == 0) {
            return null;
        }
        MemberSym member = sym.getOwningMemberSym();
        if (member == null) {
            return null;
        }
        String typeParamRef = null;
        if (name.charAt(0) == '<' && name.charAt((length = name.length()) - 1) == '>') {
            typeParamRef = name.substring(1, length - 1);
        }
        if (typeParamRef != null) {
            List<SourceTypeParameter> typeParams = member.getSourceTypeParameters();
            for (SourceTypeParameter sourceTypeParameter : typeParams) {
                if (!typeParamRef.equals(sourceTypeParameter.getName())) continue;
                return sourceTypeParameter;
            }
        } else if (member.symKind == 6 || member.symKind == 19) {
            MethodSym method = (MethodSym)member;
            for (FormalParameterSym formalParameterSym : method.getSourceParameters()) {
                if (!name.equals(formalParameterSym.getName())) continue;
                return formalParameterSym;
            }
        }
        this.error(sym, (short)78, name);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaElement resolveReference(DocReferenceSym sym) {
        CompilerContext savedContext = this.getCompilerContext();
        try {
            JavaElement element;
            JavaElement javaPackage;
            JavaElement variable;
            List<SourceVariable> variables;
            MemberSym owner;
            SourceDocTag docTag;
            CompilerContext context = this.newContext(sym);
            this.setCompilerContext(context);
            context.suppressErrors = true;
            String typeName = sym.refClassName;
            if (typeName != null && (docTag = sym.getOwningTag()) != null && ((DocTagSym)docTag).tagCode == 209) {
                int index;
                if (typeName.startsWith("<") && (index = typeName.indexOf(62)) > 0) {
                    typeName = typeName.substring(index + 1).trim();
                }
                if (typeName.endsWith(">") && (index = typeName.lastIndexOf("</")) > 0) {
                    typeName = typeName.substring(0, index).trim();
                }
            }
            String memberName = sym.refMemberName;
            if (typeName == null && memberName == null && sym.getOwningTag().getName().equals("@value") && (owner = sym.getOwningMemberSym()) != null && owner.isStatic() && owner.isFinal() && owner.symKind == 9 && (variables = ((SourceFieldDeclaration)((Object)owner)).getVariables()) != null && variables.size() > 0) {
                variable = variables.get(0);
                memberName = variable.getName();
                typeName = owner.getOwningClass().getName();
            }
            JavaType type = null;
            if (typeName != null) {
                SourceFile sourceFile;
                type = this.resolveType(sym, typeName);
                if (type != null && !typeName.equals(type.getRawName()) && (sourceFile = sym.getOwningSourceFile()) != null && sourceFile.isPackageInfoFile()) {
                    type = null;
                }
                if (type == null && memberName == null && (javaPackage = this.getKnownPackage(typeName)) != null) {
                    variable = javaPackage;
                    return variable;
                }
                if (type == null) {
                    javaPackage = this.error(sym, (short)78, typeName);
                    return javaPackage;
                }
                if (memberName == null) {
                    javaPackage = type;
                    return javaPackage;
                }
            } else if (memberName == null) {
                javaPackage = this.error(sym, (short)81);
                return javaPackage;
            }
            if (memberName.length() == 0) {
                javaPackage = this.error(sym, (short)81);
                return javaPackage;
            }
            if ("<init>".equals(memberName)) {
                javaPackage = this.error(sym, (short)78, memberName);
                return javaPackage;
            }
            List<String> parameters = sym.refMethodParameters;
            JavaType[] arguments = null;
            if (parameters != null) {
                int count = parameters.size();
                arguments = count > 0 ? new JavaType[count] : JavaType.EMPTY_ARRAY;
                boolean argumentsResolved = true;
                for (int i = 0; i < count; ++i) {
                    String argumentTypeName = parameters.get(i);
                    JavaType argumentType = this.resolveType(context.symCookie, argumentTypeName);
                    if (argumentType == null) {
                        argumentsResolved = false;
                        this.error(sym, (short)78, argumentTypeName);
                        continue;
                    }
                    arguments[i] = argumentType;
                }
                if (!argumentsResolved) {
                    JavaElement javaElement = null;
                    return javaElement;
                }
            }
            if ((element = type != null ? this.processQualifiedReference(type, memberName, arguments) : this.processUnqualifiedReference(memberName, arguments)) == null) {
                this.error(sym, (short)78, memberName);
            }
            JavaElement javaElement = element;
            return javaElement;
        }
        finally {
            this.setCompilerContext(savedContext);
        }
    }

    private JavaElement processUnqualifiedReference(String name, JavaType[] arguments) {
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        Sym scope = context.cleanAndInitializeScope();
        while (scope != null) {
            ClassSym classSym;
            JavaElement element;
            if (scope.symKind == 3 && (element = this.processQualifiedReference(classSym = (ClassSym)scope, name, arguments)) != null) {
                return element;
            }
            scope = context.nextScope();
        }
        return null;
    }

    private JavaElement processQualifiedReference(JavaType type, String name, JavaType[] arguments) {
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        if (type != null) {
            boolean constructorCall;
            JavaField field;
            if (arguments == null && (field = type.getField(name)) != null) {
                return field;
            }
            if (type.hasTypeParameters() && !type.hasActualTypeArguments()) {
                type = CommonUtilities.createTypeErasedClass(this.provider, type);
            }
            if (constructorCall = name.equals(type.getName())) {
                return type.getDeclaredConstructor(arguments);
            }
            if (arguments == null) {
                Collection<JavaMethod> collection = type.getMethods(name);
                if (collection.size() > 0) {
                    return collection.iterator().next();
                }
            } else {
                return type.getMethod(name, arguments);
            }
        }
        return null;
    }
}

