/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2;

public enum JdkVersion {
    JDK_UNKNOWN(0, "1.3"),
    JDK_1_3(1, "1.3"),
    JDK_1_4(2, "1.4"),
    JDK_1_5(3, "1.5"),
    JDK_1_6(4, "1.6"),
    JDK_1_7(5, "1.7"),
    JDK_1_8(6, "1.8"),
    JDK_9(7, "9");

    private byte j2se;
    private String version;

    public static JdkVersion getMinVersion() {
        return JDK_1_3;
    }

    public static JdkVersion getMaxVersion() {
        JdkVersion[] jdkVersions = JdkVersion.values();
        return jdkVersions[jdkVersions.length - 1];
    }

    public boolean hasGenerics() {
        return this.j2se >= JdkVersion.JDK_1_5.j2se;
    }

    public boolean isJdk3OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_3.j2se;
    }

    public boolean isJdk4OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_4.j2se;
    }

    public boolean isJdk5OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_5.j2se;
    }

    public boolean isJdk6OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_6.j2se;
    }

    public boolean isJdk7OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_7.j2se;
    }

    public boolean isJdk8OrAbove() {
        return this.j2se >= JdkVersion.JDK_1_8.j2se;
    }

    public boolean isJdk9OrAbove() {
        return this.j2se >= JdkVersion.JDK_9.j2se;
    }

    public boolean isHigherVersion(JdkVersion that) {
        return this.j2se > that.j2se;
    }

    public boolean isHigherOrEqualVersion(JdkVersion that) {
        return this.j2se >= that.j2se;
    }

    public boolean isLowerVersion(JdkVersion that) {
        return this.j2se < that.j2se;
    }

    public boolean isLowerOrEqualVersion(JdkVersion that) {
        return this.j2se <= that.j2se;
    }

    public static JdkVersion getJdkVersion(byte j2se) {
        switch (j2se) {
            case 1: {
                return JDK_1_3;
            }
            case 2: {
                return JDK_1_4;
            }
            case 3: {
                return JDK_1_5;
            }
            case 4: {
                return JDK_1_6;
            }
            case 5: {
                return JDK_1_7;
            }
            case 6: {
                return JDK_1_8;
            }
            case 7: {
                return JDK_9;
            }
        }
        return JDK_UNKNOWN;
    }

    public static JdkVersion getJdkVersion(String version) {
        char c;
        int index;
        if (version == null) {
            return JDK_UNKNOWN;
        }
        for (index = 0; index < version.length() && ((c = version.charAt(index)) == '.' || Character.isDigit(c)); ++index) {
        }
        version = version.substring(0, index);
        while (version.endsWith(".")) {
            version = version.substring(0, version.length() - 1);
        }
        if (version.length() == 0) {
            return JDK_UNKNOWN;
        }
        index = version.indexOf(46);
        if (index > 0) {
            if (index == 1 && version.charAt(0) == '1') {
                if ((index = version.indexOf(46, index + 1)) > 0) {
                    version = version.substring(0, index);
                }
                if (version.equals("1.9")) {
                    version = version.substring(2);
                }
            } else {
                version = version.substring(0, index);
            }
        }
        switch (version) {
            case "1.3": {
                return JDK_1_3;
            }
            case "1.4": {
                return JDK_1_4;
            }
            case "1.5": {
                return JDK_1_5;
            }
            case "1.6": {
                return JDK_1_6;
            }
            case "1.7": {
                return JDK_1_7;
            }
            case "1.8": {
                return JDK_1_8;
            }
            case "9": {
                return JDK_9;
            }
        }
        return JDK_UNKNOWN;
    }

    @Deprecated
    public byte getJ2se() {
        return this.j2se;
    }

    public String getVersionString() {
        return this.version;
    }

    private JdkVersion(int j2se, String version) {
        this.j2se = (byte)j2se;
        this.version = version;
    }

    public String toString() {
        return this.version;
    }
}

