/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.performance;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public final class PerformanceTracker {
    private static final String DUMP_FILE;
    private static final boolean ENABLED;
    private static final PerformanceTracker _tracker;
    private static final Date _startTimestamp;
    private final HashMap<String, HashMap<String, PerformanceData>> _perfData = new HashMap();
    private PrintWriter _fileDump;

    private PerformanceTracker() {
    }

    public static PerformanceTracker get() {
        return _tracker;
    }

    public void track(String key, Object listenerObj, long nanoTime) {
        if (ENABLED && listenerObj != null) {
            this.track(key, listenerObj.getClass().getName(), nanoTime);
        }
    }

    private synchronized void track(String key, String implName, long nanoTime) {
        PerformanceData data;
        HashMap<String, PerformanceData> keyInfo = this._perfData.get(key);
        if (keyInfo == null) {
            keyInfo = new HashMap();
            this._perfData.put(key, keyInfo);
        }
        if ((data = keyInfo.get(implName)) == null) {
            data = new PerformanceData();
            keyInfo.put(implName, data);
        }
        data.add(nanoTime);
    }

    private static boolean isConsoleDump() {
        return "-".equals(DUMP_FILE);
    }

    public synchronized void resetStatistics() {
        this._perfData.clear();
        try {
            this.setupFileDump();
            this.writeln("PerformanceTracker statistics cleared on " + DateFormat.getDateTimeInstance().format(new Date()));
        }
        finally {
            this.tearDownFileDump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpSummary() {
        if (ENABLED) {
            try {
                this.setupFileDump();
                this.writeln();
                this.writeln("==================================================================================");
                this.writeln("Performance Tracker intialized on: " + DateFormat.getDateTimeInstance().format(_startTimestamp));
                this.writeln("This report was generated on: " + DateFormat.getDateTimeInstance().format(new Date()));
                if (PerformanceTracker.isConsoleDump()) {
                    this.writeln("This information is not being written to a file (i.e. console only).");
                } else {
                    this.writeln("This information is also being written to the file " + new File(DUMP_FILE).getAbsolutePath());
                }
                this.writeln("Reporting callback methods with execution times that are more than two standard deviations above the mean:");
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(this._perfData.keySet());
                Collections.sort(keys);
                for (String key : keys) {
                    PerformanceInfo info;
                    long milliTime;
                    HashMap<String, PerformanceData> keyInfo = this._perfData.get(key);
                    int numMeans = 0;
                    long cumulativeMeans = 0L;
                    long minMeanInNanos = Long.MAX_VALUE;
                    long maxMeanInNanos = Long.MIN_VALUE;
                    ArrayList<PerformanceInfo> perfInfos = new ArrayList<PerformanceInfo>();
                    for (String implName : keyInfo.keySet()) {
                        PerformanceData data = keyInfo.get(implName);
                        if (data._numTimes <= 0) continue;
                        long meanTime = data._totalTime / (long)data._numTimes;
                        if (meanTime < minMeanInNanos) {
                            minMeanInNanos = meanTime;
                        }
                        if (meanTime > maxMeanInNanos) {
                            maxMeanInNanos = meanTime;
                        }
                        cumulativeMeans += meanTime;
                        ++numMeans;
                        perfInfos.add(new PerformanceInfo(meanTime, data._numTimes, implName));
                    }
                    if (numMeans <= 0) continue;
                    long meanOfMeansInMillis = cumulativeMeans / (long)numMeans / 1000000L;
                    Collections.sort(perfInfos);
                    long standardDeviation = PerformanceTracker.stddev(perfInfos, meanOfMeansInMillis);
                    long thresholdValueInMillis = meanOfMeansInMillis + (standardDeviation << 1);
                    this.writeln();
                    this.writeln(key + " [" + numMeans + " impls, Mean = " + meanOfMeansInMillis + " ms, Std Dev = " + standardDeviation + " ms, Min = " + minMeanInNanos / 1000000L + " ms, Max = " + maxMeanInNanos / 1000000L + " ms, Threshold (mean+2SD) = " + thresholdValueInMillis + " ms.]");
                    Iterator<PerformanceInfo> iterator = perfInfos.iterator();
                    while (iterator.hasNext() && (milliTime = (info = iterator.next())._nanoTime / 1000000L) > thresholdValueInMillis) {
                        double deviationInMillis = milliTime - meanOfMeansInMillis;
                        double numSigmas = deviationInMillis / (double)standardDeviation;
                        this.writeln("    [" + milliTime + " ms] " + info._implName + " (called " + info._numInvocations + " time" + (info._numInvocations > 1 ? "s; " : "; ") + String.format("%.1f", numSigmas) + " sigma)");
                    }
                }
                this.writeln("==================================================================================");
                this.writeln();
            }
            finally {
                this.tearDownFileDump();
            }
        }
    }

    private void setupFileDump() {
        if (!PerformanceTracker.isConsoleDump()) {
            try {
                this._fileDump = new PrintWriter(new BufferedWriter(new FileWriter(DUMP_FILE, true)));
            }
            catch (IOException e) {
                this._fileDump = null;
                e.printStackTrace();
            }
        }
    }

    private void tearDownFileDump() {
        if (this._fileDump != null) {
            try {
                this._fileDump.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._fileDump = null;
        }
    }

    private static final long stddev(ArrayList<PerformanceInfo> infos, long meanInMillis) {
        int length = infos.size();
        long[] deviations = new long[length];
        int k = 0;
        for (PerformanceInfo info : infos) {
            long actual = info._nanoTime / 1000000L;
            deviations[k++] = actual - meanInMillis;
        }
        for (int i = 0; i < length; ++i) {
            long deviation = deviations[i];
            deviations[i] = deviation * deviation;
        }
        long sumOfSquares = 0L;
        for (int i = 0; i < length; ++i) {
            sumOfSquares += deviations[i];
        }
        long sd2 = sumOfSquares / (long)length;
        long stddev = PerformanceTracker.sqrt(sd2);
        return stddev;
    }

    private void writeln() {
        System.out.println();
        if (this._fileDump != null) {
            this._fileDump.println();
        }
    }

    private void writeln(String text) {
        System.out.println(text);
        if (this._fileDump != null) {
            this._fileDump.println(text);
        }
    }

    private static long sqrt(long number) {
        long guess = number >> 1;
        long sqrt = 0L;
        for (int iters = 0; guess != sqrt && iters < 100; ++iters) {
            sqrt = guess;
            guess = guess + number / guess >> 1;
        }
        return sqrt;
    }

    static {
        String[] dumpFile = new String[]{System.getProperty("oracle.ide.performance.PerformanceTracker")};
        DUMP_FILE = dumpFile[0];
        boolean bl = ENABLED = DUMP_FILE != null && !"off".equals(DUMP_FILE);
        if (ENABLED) {
            System.out.println(">>>> oracle.ide.performance.PerformanceTracker is enabled.");
            if (PerformanceTracker.isConsoleDump()) {
                System.out.println(">>>>    Performance statistics will be dumped to the console only.");
            } else {
                System.out.println(">>>>    Performance statistics will be appended to the file " + new File(DUMP_FILE).getAbsolutePath());
            }
        }
        _tracker = new PerformanceTracker();
        _startTimestamp = new Date();
    }

    private static final class PerformanceData {
        private long _totalTime;
        private int _numTimes;

        private PerformanceData() {
        }

        public void add(long time) {
            this._totalTime += time;
            ++this._numTimes;
        }
    }

    private static class PerformanceInfo
    implements Comparable<PerformanceInfo> {
        private final long _nanoTime;
        private final int _numInvocations;
        private final String _implName;

        PerformanceInfo(long nanoTime, int numInvocations, String implName) {
            this._nanoTime = nanoTime;
            this._numInvocations = numInvocations;
            this._implName = implName;
        }

        @Override
        public int compareTo(PerformanceInfo other) {
            long diff;
            long l = diff = other != null ? this._nanoTime - other._nanoTime : 1L;
            return diff > 0L ? -1 : (diff < 0L ? 1 : 0);
        }
    }
}

