/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.protocol;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import oracle.help.CustomProtocolHandler;
import oracle.help.common.util.java.StaticLocaleContext;

public class DefaultExternalProtocolHandler
implements CustomProtocolHandler {
    private static final String EXTERNAL_ERROR_MESSAGE = "external.errormessage";
    private static final String EXTERNAL_ERROR_DIALOG_TITLE = "external.errordialogtitle";
    private static final String MISC_RESOURCE_BUNDLE = "oracle.help.resource.MiscBundle";

    @Override
    public void handleValue(String value) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                URI uri = null;
                try {
                    uri = new URI(value);
                    desktop.browse(uri);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (URISyntaxException use) {
                    use.printStackTrace();
                }
            } else {
                ResourceBundle bundle = ResourceBundle.getBundle(MISC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
                JOptionPane.showMessageDialog(new JFrame(), bundle.getString(EXTERNAL_ERROR_MESSAGE), bundle.getString(EXTERNAL_ERROR_DIALOG_TITLE), 1);
            }
        }
    }
}

