/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.platform.mt.jrf;

import com.oracle.jrf.mt.tenant.runtime.TenantContext;
import com.oracle.jrf.mt.tenant.runtime.TenantContextFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adf.share.platform.mt.MTHelper;
import oracle.adfinternal.share.platform.mt.jrf.JRFTenantContext;
import oracle.javatools.annotations.Concealed;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextManager;
import weblogic.server.GlobalServiceLocator;

@Concealed
public final class JRFTenantContextFactory
extends oracle.adf.share.platform.mt.TenantContextFactory {
    private final Object wrappedFactory;
    final boolean supportableInitialization;
    Object cicManager = null;
    private boolean cicAttempted = false;
    private String cicException = null;

    public JRFTenantContextFactory() {
        this(false);
    }

    @Concealed
    public JRFTenantContextFactory(boolean supportableInitialization) {
        Struct s = new Struct();
        try {
            JRFTenantContextFactory.getUsableServiceLocator(s);
        }
        catch (Throwable t) {
            for (Throwable supp : s.suppressed) {
                t.addSuppressed(supp);
            }
            if (supportableInitialization) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new IllegalStateException(t);
            }
            MTHelper.throwTenantInvalidException(t);
        }
        this.wrappedFactory = s.wrappedFactory;
        this.supportableInitialization = supportableInitialization;
    }

    public static Object getUsableServiceLocator(Struct s) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        s.factoryClazz = TenantContextFactory.class;
        try {
            JRFTenantContextFactory.getWrappedFactoryOrThrow(GlobalServiceLocator.getServiceLocator(), "GlobalServiceLocator", s);
        }
        catch (Throwable ise) {
            s.suppressed.add(ise);
            try {
                JRFTenantContextFactory.getWrappedFactoryOrThrow(ServiceLocatorUtilities.createAndPopulateServiceLocator((String)"weblogic"), "createAndPopulate(weblogic)", s);
            }
            catch (Throwable ise2) {
                s.suppressed.add(ise2);
                JRFTenantContextFactory.getWrappedFactoryOrThrow(ServiceLocatorUtilities.createAndPopulateServiceLocator((String)"default"), "createAndPopulate(default)", s);
            }
        }
        return s.locatorInst;
    }

    private static void getWrappedFactoryOrThrow(Object locatorInst, String msg, Struct s) throws IllegalAccessException, InvocationTargetException {
        if (locatorInst == null) {
            throw new IllegalStateException(msg);
        }
        s.wrappedFactory = ((ServiceLocator)locatorInst).getService(s.factoryClazz, new Annotation[0]);
        if (s.wrappedFactory == null) {
            throw new IllegalStateException("Service " + s.factoryClazz.getName() + " not found, " + msg + ".");
        }
        s.locatorInst = locatorInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean initCICAccess() {
        if (this.cicManager != null) {
            return true;
        }
        if (this.cicAttempted) {
            if (this.cicException != null) {
                throw new IllegalStateException(this.cicException);
            }
            return false;
        }
        Logger logger = Logger.getLogger(this.getClass().getName());
        ComponentInvocationContextManager cicManager = null;
        try {
            ComponentInvocationContextManager tmpManager = ComponentInvocationContextManager.getInstance();
            ComponentInvocationContext context = tmpManager.getCurrentComponentInvocationContext();
            if (context == null) {
                tmpManager = null;
                throw new IllegalStateException("ComponentInvocationContext null");
            }
            String partitionName = context.getPartitionName();
            if (partitionName == null || partitionName.length() == 0) {
                tmpManager = null;
                throw new IllegalStateException("PartitionName null");
            }
            if ("DOMAIN".equals(partitionName) && !AdfServerPlatformUtil.isWebLogicJRF()) {
                tmpManager = null;
            }
            cicManager = tmpManager;
        }
        catch (Throwable t) {
            if (AdfServerPlatformUtil.isWebLogicJRF()) {
                IllegalStateException xx = t instanceof IllegalStateException ? (IllegalStateException)t : new IllegalStateException(t);
                this.cicException = String.valueOf(xx);
                throw xx;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "", t);
            } else if (logger.isLoggable(Level.CONFIG)) {
                logger.config(String.valueOf(t));
            }
        }
        finally {
            this.cicManager = cicManager;
            this.cicAttempted = true;
        }
        return cicManager != null;
    }

    @Override
    public final oracle.adf.share.platform.mt.TenantContext getTenantContext() {
        try {
            TenantContext wrappedContext = ((TenantContextFactory)this.wrappedFactory).getTenantContext();
            if (wrappedContext == null) {
                throw new IllegalStateException("Factory " + this.wrappedFactory.getClass().getName() + " not able to get a TenantContext");
            }
            return new JRFTenantContext(wrappedContext, this);
        }
        catch (Throwable t) {
            if (this.supportableInitialization) {
                if (t instanceof IllegalStateException) {
                    throw (IllegalStateException)t;
                }
                throw new IllegalStateException(t);
            }
            MTHelper.throwTenantInvalidException(t);
            return null;
        }
    }

    public static class Struct {
        final ArrayList<Throwable> suppressed = new ArrayList();
        Class factoryClazz = null;
        Object wrappedFactory = null;
        Object locatorInst = null;

        public ArrayList<Throwable> getSuppressed() {
            return this.suppressed;
        }
    }
}

