/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform.mt;

import java.beans.Beans;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adf.share.platform.mt.TenantContext;
import oracle.adf.share.platform.mt.TenantContextFactory;
import oracle.adf.share.platform.resources.ADFPlatformMessageBundle;
import oracle.adfinternal.share.platform.mt.jrf.JRFTenantContextFactory;
import oracle.javatools.annotations.Concealed;

public abstract class MTHelper {
    private static final String sharedModeFlagName = "com.oracle.adf.SharedMode";
    public static final String sharedModeSysProp = "com.oracle.adfinternal.SharedMode";

    private static String getSharedModeAppParam() throws Exception {
        return MTHelper.getApplicationParam(sharedModeFlagName);
    }

    private static String getApplicationParam(String paramName) throws Exception {
        String modeVal = null;
        Class infoManagerClazz = ClassUtils.forName("weblogic.application.info.InfoManager", MTHelper.class);
        Object infoMgrInst = infoManagerClazz.getMethod("getInstance", new Class[0]).invoke(null, null);
        modeVal = (String)infoManagerClazz.getMethod("getApplicationParam", String.class).invoke(infoMgrInst, paramName);
        return modeVal;
    }

    @Concealed
    public static boolean getSharedMode() {
        boolean ret = false;
        String flagVal = null;
        Logger logger = Logger.getLogger(MTHelper.class.getName());
        if (AdfServerPlatformUtil.isWebLogicJRF()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Weblogic env as isWeblogic is true. Getting sharedMode param com.oracle.adf.SharedMode value from weblogic-application.xml");
            }
            try {
                flagVal = MTHelper.getSharedModeAppParam();
                ret = Boolean.parseBoolean(flagVal);
            }
            catch (Throwable t) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Weblogic InfoManager call to get shared parameter com.oracle.adf.SharedMode from weblogic-application.xml failed in weblogic environment. Defaulting to false value for shared mode flag. This exception is only logged for information and not thorwn. Application should continue to work with share mode flag = false", t);
                }
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Not Weblogic env as isWeblogic is false. Getting sharedMode flag com.oracle.adfinternal.SharedMode value as a system property ");
            }
            ret = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean(MTHelper.sharedModeSysProp);
                }
            });
        }
        return ret;
    }

    @Deprecated
    public static boolean getMultitenancyEnabled() {
        return DeprecatedEnabledHolder.mtEnabled;
    }

    public static boolean isMultitenancySupportable() {
        return SingletonHolder.mtSupportable;
    }

    public static void throwTenantInvalidException() {
        String msg = ADFPlatformMessageBundle.get("MT_ENABLED_BUT_INCOMPLETE_TENANT_CONTEXT");
        Logger.getLogger(MTHelper.class.getName()).log(AdfServerPlatformUtil.INCIDENT_ERROR, msg);
        throw new IllegalStateException(msg);
    }

    public static void throwTenantInvalidException(Throwable t) {
        String msg = ADFPlatformMessageBundle.get("MT_ENABLED_BUT_INCOMPLETE_TENANT_CONTEXT");
        Logger.getLogger(MTHelper.class.getName()).log(AdfServerPlatformUtil.INCIDENT_ERROR, msg, t);
        throw new IllegalStateException(msg);
    }

    private static ArrayList<Callable> initCloudHelper() {
        if (!SingletonHolder.mtSupportable) {
            return null;
        }
        final TenantContext tenantContext = TenantContextFactory.getInstance().getTenantContext();
        ArrayList<Callable> ret = new ArrayList<Callable>(2);
        ret.add(new Callable(){

            public Object call() throws Exception {
                UUID uuid;
                TenantContext tc = TenantContextFactory.getInstance().getTenantContext();
                if (tc != null && (uuid = tc.getServiceUUID()) != null) {
                    return uuid;
                }
                MTHelper.throwTenantInvalidException();
                return null;
            }
        });
        ret.add(new Callable(){

            public Object call() throws Exception {
                return tenantContext.getCurrentPartitionName();
            }
        });
        return ret;
    }

    private static class DeprecatedEnabledHolder {
        private static final boolean mtEnabled = DeprecatedEnabledHolder.initMTEnabled();

        private DeprecatedEnabledHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean initMTEnabled() {
            if (!MTHelper.isMultitenancySupportable()) {
                return false;
            }
            boolean ret = false;
            String msg = null;
            String MSG_KEY = "MT_GF_HK2_ACCESS";
            Throwable tt = null;
            try {
                ClassUtils.forName("org.glassfish.hk2.utilities.ServiceLocatorUtilities", MTHelper.class).getMethod("createAndPopulateServiceLocator", new Class[0]);
                ClassUtils.forName("org.glassfish.hk2.api.ServiceLocator", MTHelper.class).getMethod("getService", Class.class, new Annotation[0].getClass());
                MSG_KEY = "MT_JRF_HELPER_ENABLED";
                ret = (Boolean)ClassUtils.forName("com.oracle.jrf.mt.tenant.MTHelper", MTHelper.class).getMethod("isMultitenancyEnabled", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                try {
                    msg = String.valueOf(t);
                    tt = t;
                }
                catch (Throwable throwable) {
                    Logger logger = Logger.getLogger(MTHelper.class.getName());
                    if (logger.isLoggable(Level.FINE) && tt != null) {
                        logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
                    } else if (logger.isLoggable(Level.CONFIG)) {
                        msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                        logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
                    }
                    throw throwable;
                }
                Logger logger = Logger.getLogger(MTHelper.class.getName());
                if (logger.isLoggable(Level.FINE) && tt != null) {
                    logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
                } else if (logger.isLoggable(Level.CONFIG)) {
                    msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                    logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
                }
            }
            Logger logger = Logger.getLogger(MTHelper.class.getName());
            if (logger.isLoggable(Level.FINE) && tt != null) {
                logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
            } else if (logger.isLoggable(Level.CONFIG)) {
                msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
            }
            return ret;
        }
    }

    private static class SingletonHolder {
        private static final boolean mtSupportable = SingletonHolder.initMTSupportable();

        private SingletonHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private static boolean initMTSupportable() {
            boolean ret;
            block21: {
                ret = false;
                String msg = null;
                String MSG_KEY = "MT_JRF_ACCESS_TEST";
                Throwable tt = null;
                int hash = -2;
                if (ClassUtils.getClassLoader(MTHelper.class).getResource("com/oracle/jrf/mt/tenant/runtime/TenantContextFactory.class") == null) {
                    throw new IllegalStateException("com/oracle/jrf/mt/tenant/runtime/TenantContextFactory.class");
                }
                hash = new JRFTenantContextFactory(true).getTenantContext().getServiceUUID().hashCode();
                ret = true;
                if (ret) break block21;
                if (AdfServerPlatformUtil.isWebLogicJRF()) {
                    if (tt != null) {
                        MTHelper.throwTenantInvalidException(tt);
                    }
                    MTHelper.throwTenantInvalidException(new IllegalStateException("hashCode=" + hash));
                }
                try {
                    Level level = Beans.isDesignTime() ? Level.FINE : Level.CONFIG;
                    Logger logger = Logger.getLogger(MTHelper.class.getName());
                    if (logger.isLoggable(level)) {
                        msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                        logger.log(level, String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret), logger.isLoggable(Level.FINE) ? tt : null);
                    }
                    break block21;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                }
                break block21;
                catch (Throwable t) {
                    try {
                        msg = String.valueOf(t);
                        tt = t;
                        if (ret) break block21;
                    }
                    catch (Throwable throwable) {
                        if (!ret) {
                            if (AdfServerPlatformUtil.isWebLogicJRF()) {
                                if (tt != null) {
                                    MTHelper.throwTenantInvalidException(tt);
                                }
                                MTHelper.throwTenantInvalidException(new IllegalStateException("hashCode=" + hash));
                            }
                            try {
                                Level level = Beans.isDesignTime() ? Level.FINE : Level.CONFIG;
                                Logger logger = Logger.getLogger(MTHelper.class.getName());
                                if (logger.isLoggable(level)) {
                                    msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                                    logger.log(level, String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret), logger.isLoggable(Level.FINE) ? tt : null);
                                }
                            }
                            catch (Throwable t2) {
                                t2.printStackTrace(System.err);
                            }
                        }
                        throw throwable;
                    }
                    if (AdfServerPlatformUtil.isWebLogicJRF()) {
                        if (tt != null) {
                            MTHelper.throwTenantInvalidException(tt);
                        }
                        MTHelper.throwTenantInvalidException(new IllegalStateException("hashCode=" + hash));
                    }
                    try {
                        Level level = Beans.isDesignTime() ? Level.FINE : Level.CONFIG;
                        Logger logger = Logger.getLogger(MTHelper.class.getName());
                        if (logger.isLoggable(level)) {
                            msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                            logger.log(level, String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret), logger.isLoggable(Level.FINE) ? tt : null);
                        }
                    }
                    catch (Throwable t3) {
                        t3.printStackTrace(System.err);
                    }
                }
            }
            return ret;
        }
    }
}

