/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.platform.resources.ADFPlatformMessageBundle;
import oracle.javatools.annotations.Concealed;

public class AdfServerPlatformUtil {
    private static final Logger logger = Logger.getLogger(AdfServerPlatformUtil.class.getName());
    private static final String CONFIG_HELPER_CLASS = "oracle.adfinternal.share.platform.app.PlatformConfigHelper";
    private static final String CONFIG_HELPER_RESOURCE = "oracle.adfinternal.share.platform.app.PlatformConfigHelper".replace('.', '/') + ".class";
    public static final Level INCIDENT_ERROR = SingletonHolder.access$1000();

    public static boolean isWebLogic() {
        return SingletonHolder.isWebLogic;
    }

    public static boolean isWebLogicJRF() {
        return SingletonHolder.isWebLogic;
    }

    public static boolean isWebLogicCore() {
        return SingletonHolder.isWebLogicCore;
    }

    @Deprecated
    public static boolean isWebSphere() {
        return SingletonHolder.isWebSphere;
    }

    @Deprecated
    public static boolean isWebSphereND() {
        return SingletonHolder.isWebSphereND;
    }

    @Deprecated
    public static boolean isWebSphereAS() {
        return SingletonHolder.isWebSphereAS;
    }

    @Deprecated
    public static boolean isJBoss() {
        return SingletonHolder.isJBoss;
    }

    public static boolean isJEE() {
        return SingletonHolder.isJEE;
    }

    public static boolean isGlassFish() {
        return SingletonHolder.isGlassfish;
    }

    public static boolean isTomcat() {
        return SingletonHolder.isTomcat;
    }

    @Concealed
    public static String getInternalPlatformName() {
        return SingletonHolder.platName;
    }

    private static Class loadOracleChecksum(ClassLoader cl) throws Exception {
        Class<?> clazz = null;
        try {
            if (cl != null) {
                clazz = Class.forName("oracle.security.misc.Checksum", true, cl);
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            clazz = AdfServerPlatformUtil.loadOracleChecksum(cl.getParent());
        }
        return clazz;
    }

    public static byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        Class clazz;
        if (data == null) {
            return new byte[0];
        }
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((clazz = AdfServerPlatformUtil.loadOracleChecksum(AdfServerPlatformUtil.getThreadContextClassLoader())) == null) {
            return new byte[0];
        }
        Method checkSumMethod = null;
        if (algorithm.toUpperCase().equals("MD5")) {
            checkSumMethod = clazz.getMethod("MD5", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("SHA")) {
            checkSumMethod = clazz.getMethod("SHA", byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, new Object[]{data, null});
            }
        } else if (algorithm.toUpperCase().equals("MD2")) {
            checkSumMethod = clazz.getMethod("MD2", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else if (algorithm.toUpperCase().equals("MD4")) {
            checkSumMethod = clazz.getMethod("MD4", byte[].class, byte[].class, byte[].class);
            if (checkSumMethod != null) {
                return (byte[])checkSumMethod.invoke(null, data, null, null);
            }
        } else {
            ResourceBundle platformRes = ResourceBundle.getBundle(ADFPlatformMessageBundle.class.getName());
            throw new NoSuchAlgorithmException(algorithm + " " + platformRes.getString("CHECKSUM_ALGORITHM_NOT_SUPPORTED"));
        }
        return new byte[0];
    }

    public static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    public static String setSystemProperty(final String name, final String value) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.setProperty(name, value);
            }
        });
    }

    public static String clearSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.clearProperty(name);
            }
        });
    }

    private static final ClassLoader getThreadContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static boolean isODLAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "odl");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform odl=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isODLAvailable;
    }

    public static boolean isDMSAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "dms");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform dms=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isDMSAvailable;
    }

    public static boolean isMDSAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "mds");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform mds=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isMDSAvailable;
    }

    public static boolean isJRFAvailable() {
        return SingletonHolder.isJRFAvailable;
    }

    public static boolean isDFWAvailable() {
        Boolean plat = AdfServerPlatformUtil.isPlatformFeatureEnabled(AdfServerPlatformUtil.getPlatformConfigMap(), "dfw");
        if (plat != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("platform dfw=" + plat);
            }
            return plat;
        }
        return SingletonHolder.isDFWAvailable;
    }

    private static Map<String, String> getPlatformConfigMap() {
        return null;
    }

    private static boolean isClassAvailable(String cn) {
        String RES_NAME = cn.endsWith(".class") ? cn : cn.replace('.', '/') + ".class";
        return ClassUtils.getClassLoader(AdfServerPlatformUtil.class).getResource(RES_NAME) != null;
    }

    private static Boolean isPlatformFeatureEnabled(Map<String, String> m, String feat) {
        if (m == null || m.isEmpty()) {
            return null;
        }
        String en = m.get(feat + "_enabled");
        if (en != null) {
            return Boolean.parseBoolean(en);
        }
        en = m.get("default_enabled");
        if (en != null) {
            return Boolean.parseBoolean(en);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final Level INCIDENT_ERROR;
        private static final boolean isODLAvailable;
        private static final boolean isDMSAvailable;
        private static final boolean isJRFAvailable;
        private static final boolean isMDSAvailable;
        private static final boolean isDFWAvailable;
        private static final boolean isWebLogic;
        private static final boolean isWebLogicCore;
        private static final boolean isWebSphere;
        private static final boolean isWebSphereND;
        private static final boolean isWebSphereAS;
        private static final boolean isJBoss;
        private static final boolean isGlassfish;
        private static final boolean isTomcat;
        private static final boolean isJEE;
        private static final String platName;

        private SingletonHolder() {
        }

        private static boolean isNDClassCheck() {
            String cn = "oracle.jrf.was.WasServerPlatformSupport";
            try {
                Class c = ClassUtils.forName("oracle.jrf.was.WasServerPlatformSupport", AdfServerPlatformUtil.class);
                Method method = c.getMethod("isND", new Class[0]);
                Boolean ret = (Boolean)method.invoke(null, new Object[0]);
                return ret;
            }
            catch (Throwable t) {
                if (logger.isLoggable(Level.CONFIG)) {
                    boolean FINE = logger.isLoggable(Level.FINE);
                    logger.log(Level.CONFIG, FINE ? cn : "" + t, FINE ? t : null);
                }
                return false;
            }
        }

        private static boolean initMDSAvailable(Map<String, Object> props) {
            String adfmMds = (String)props.get("oracle.adfm.usemds");
            String jboMds = (String)props.get("oracle.jbo.usemds");
            if ("false".equalsIgnoreCase(adfmMds) || "false".equalsIgnoreCase(jboMds)) {
                return false;
            }
            if ("true".equalsIgnoreCase(adfmMds) || "true".equalsIgnoreCase(jboMds)) {
                return true;
            }
            if (isWebLogicCore) {
                return false;
            }
            return AdfServerPlatformUtil.isClassAvailable("oracle/mds/core/MDSInstance.class");
        }

        static /* synthetic */ Level access$1000() {
            return INCIDENT_ERROR;
        }

        static {
            boolean localIsJee;
            boolean gfVersion;
            Level level;
            block8: {
                level = null;
                if (AdfServerPlatformUtil.isClassAvailable("oracle/core/ojdl/logging/ODLLevel.class")) {
                    String cn = "oracle.core.ojdl.logging.ODLLevel";
                    try {
                        Class c = ClassUtils.forName("oracle.core.ojdl.logging.ODLLevel", AdfServerPlatformUtil.class);
                        Field f = c.getDeclaredField("INCIDENT_ERROR");
                        level = (Level)f.get(null);
                    }
                    catch (Throwable t) {
                        if (!logger.isLoggable(Level.CONFIG)) break block8;
                        boolean FINE = logger.isLoggable(Level.FINE);
                        logger.log(Level.CONFIG, FINE ? cn : "" + t, FINE ? t : null);
                    }
                }
            }
            isODLAvailable = level != null;
            INCIDENT_ERROR = level != null ? level : Level.parse(String.valueOf(Level.SEVERE.intValue() + 100));
            isDMSAvailable = AdfServerPlatformUtil.isClassAvailable("oracle/dms/instrument/EventIntf.class");
            isDFWAvailable = AdfServerPlatformUtil.isClassAvailable("oracle/dfw/dump/ComponentDiagnosticDump.class");
            Map<String, Object> props = System.getSecurityManager() == null ? new InitAction().run() : AccessController.doPrivileged(new InitAction());
            boolean isWebLogicName = props.get("weblogic.Name") != null;
            isJRFAvailable = props.get("common.components.home") != null;
            isWebLogic = isWebLogicName && isJRFAvailable;
            isWebLogicCore = isWebLogicName && !isJRFAvailable;
            isMDSAvailable = SingletonHolder.initMDSAvailable(props);
            boolean bl = isWebSphere = props.get("was.install.root") != null || props.get("server.root") != null;
            if (isWebSphere) {
                boolean nd;
                isWebSphereND = nd = SingletonHolder.isNDClassCheck();
                isWebSphereAS = !nd;
            } else {
                isWebSphereND = false;
                isWebSphereAS = false;
            }
            isJBoss = props.get("jboss.home.dir") != null;
            boolean bl2 = gfVersion = props.get("glassfish.version") != null;
            if (gfVersion) {
                isTomcat = AdfServerPlatformUtil.isClassAvailable("org/apache/tomcat/dbcp/dbcp/DelegatingConnection.class");
                isGlassfish = !isTomcat;
            } else {
                isTomcat = false;
                isGlassfish = false;
            }
            boolean bl3 = localIsJee = isWebLogic || isWebLogicCore || isTomcat || isGlassfish || isWebSphere || isJBoss;
            if (!localIsJee) {
                boolean bl4 = localIsJee = props.get("surefire.test.class.path") != null;
            }
            String pn = !(isJEE = localIsJee) ? "jse" : (isWebLogic ? "weblogic" : (isWebLogicCore ? "weblogic-core" : (isGlassfish ? "glassfish" : (isWebSphere ? "websphere" : (isTomcat ? "tomcat" : (isJBoss ? "jboss" : "unrecognized-jee"))))));
            platName = pn;
        }
    }

    private static class InitAction
    implements PrivilegedAction<Map<String, Object>> {
        static final String[] serverIdNames = new String[]{"weblogic.Name", "common.components.home", "was.install.root", "server.root", "jboss.home.dir", "glassfish.version", "oracle.adfm.usemds", "oracle.jbo.usemds", "surefire.test.class.path"};

        private InitAction() {
        }

        @Override
        public Map<String, Object> run() {
            HashMap<String, Object> map = new HashMap<String, Object>(serverIdNames.length);
            for (int i = 0; i < serverIdNames.length; ++i) {
                String k = serverIdNames[i];
                map.put(k, System.getProperty(k));
            }
            return map;
        }
    }
}

