/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util.impl;

import java.lang.ref.Reference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LRUReferenceMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -3234203085337704377L;
    private Logger logger = Logger.getLogger(LRUReferenceMap.class.getName());
    private final int declaredSize;

    public LRUReferenceMap() {
        this(32);
    }

    public LRUReferenceMap(int capacity) {
        super(capacity, 0.75f, true);
        this.declaredSize = capacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        V eo = eldest.getValue();
        if (eo instanceof Reference) {
            Reference eldestRef = (Reference)eo;
            if (eldestRef.get() == null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Removing null valued eldest: " + eldest.getKey() + ", map size=" + this.size());
                }
                return true;
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Non-null eldest: " + eldest.getKey() + ", map size=" + this.size());
            }
        }
        return this.size() > this.declaredSize;
    }
}

