/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import oracle.adfdtinternal.model.dvt.util.gui.BIColorChoice;
import oracle.adfdtinternal.model.dvt.util.gui.FontButton;
import oracle.adfdtinternal.model.dvt.util.gui.ViewLabel;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.BorderPainter;
import oracle.dss.dataView.gui.DatePanel;
import oracle.dss.dataView.gui.NumberFormatPanel;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.CrosstabAttribute;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.BasePanel;
import oracle.dss.gridView.gui.FontPanel;
import oracle.dss.gridView.gui.FormatGeneralPanel;
import oracle.dss.gridView.gui.HeaderFormatGeneralPanel;
import oracle.dss.gridView.gui.SamplePanel;
import oracle.dss.rules.DiscriminatorRule;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.util.ErrorHandler;

public class OptionsPanel
extends BasePanel
implements ItemListener,
PropertyChangeListener,
ChangeListener,
ActionListener,
FocusListener,
HelpContext {
    private ResourceBundle rBundle = null;
    private JPanel horzGridLinesPanel;
    private int oldHorzLineWidth;
    private int oldVertLineWidth;
    private boolean m_ok;
    protected int m_currentType;
    protected JCheckBox m_horzBox;
    protected JCheckBox m_vertBox;
    protected JCheckBox m_3DBox;
    protected BIColorChoice m_horzColor;
    protected BIColorChoice m_vertColor;
    protected JLabel m_horzLabel;
    protected JLabel m_vertLabel;
    protected JCheckBox m_columnHeaderBox;
    protected JCheckBox m_rowHeaderBox;
    protected JLabel m_rowHeaderStyleLabel;
    protected JLabel m_samplesLabel;
    protected JLabel m_inlineLabel;
    protected JLabel m_outlineLabel;
    protected JRadioButton m_inlineRadioButton;
    protected JRadioButton m_outlineRadioButton;
    protected JLabel m_imageButton;
    protected String m_applicationName;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh = null;
    protected int m_adjustHeight = 0;
    protected String m_strHelpContextID;
    protected FormatsTable m_formatsTable;
    protected JPanel m_formatsPanel;
    protected Dimension prefSize;
    protected JPanel rowHeaderstylePanel;
    protected JPanel vertGridLinesPanel;
    protected JPanel ThreeDPanel;
    protected JPanel m_gridLinesPanel;
    protected JPanel m_headersPanel;
    protected boolean inlineOutlineVisible = false;
    protected JPanel m_upperPanel;
    protected JButton m_editButton;
    protected FormatsTableModel m_formatsTableModel;
    protected JPanel m_editPanel;
    protected HelpProvider m_helpProvider;
    public static final String PROPERTY_HORIZONTAL_GRID_VISIBLE = "HorizontalGridVisible";
    public static final String PROPERTY_HORIZONTAL_GRID_COLOR = "HorizontalGridColor";
    public static final String PROPERTY_HORIZONTAL_GRID_LINE_WIDTH = "HorizontalGridLineWidth";
    public static final String PROPERTY_VERTICAL_GRID_VISIBLE = "VerticalGridVisible";
    public static final String PROPERTY_VERTICAL_GRID_COLOR = "VerticalGridColor";
    public static final String PROPERTY_VERTICAL_GRID_LINE_WIDTH = "VerticalGridLineWidth";
    public static final String PROPERTY_3D_GRID_VISIBLE = "3DGridLineVisible";
    public static final String PROPERTY_BACKGROUND_VISIBLE = "BackgroundPictureVisible";
    public static final String PROPERTY_BACKGROUND_PICTURE_NAME = "BackgroundPictureName";
    public static final String PROPERTY_COLUMN_HEADERS_VISIBLE = "ColumnHeadersVisible";
    public static final String PROPERTY_ROW_HEADERS_VISIBLE = "RowHeadersVisible";
    public static final String PROPERTY_ROW_NUMBERS_VISIBLE = "RowNumbersVisible";
    public static final String PROPERTY_ROW_HEADERS_STYLE = "RowHeadersStyle";
    public static String DEFAULT_FORMAT_CHANGED = "DefaultFormatChanged";
    public static final String OUTLINE = "outline";
    public static final String INLINE = "inline";

    public OptionsPanel(UIGridView gridView) {
        super(gridView);
        this._initialize(gridView);
    }

    @Override
    public void setGridView(UIGridView gridView) {
        super.setGridView(gridView);
        this.m_mainPanel.removeAll();
        boolean visible = this.isDefaultFormattingVisible();
        this._initialize(gridView);
        this.setDefaultFormattingVisible(visible);
        this.m_mainPanel.revalidate();
    }

    public UIGridView getGridView() {
        return this.m_gridView;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.m_editButton.setEnabled(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void _initialize(UIGridView gridView) {
        if (gridView != null) {
            this.setLocale(gridView.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        String titleText = this.m_gridView.getViewType() == 2 ? this.rBundle.getString("Select options table") : this.rBundle.getString("Select options");
        this.setTitleText(titleText);
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_headersPanel = new JPanel();
        this.m_headersPanel.setLayout(new BoxLayout(this.m_headersPanel, 1));
        this.m_headersPanel.setAlignmentY(0.0f);
        String translatedText = this.rBundle.getString("Show column");
        this.m_columnHeaderBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_columnHeaderBox.setName("ShowColumnHeaders");
        this.m_columnHeaderBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_columnHeaderBox.setAlignmentX(0.0f);
        translatedText = this.m_gridView != null && this.m_gridView.getViewType() == 2 ? this.rBundle.getString("Show row numbers") : this.rBundle.getString("Show row");
        this.m_rowHeaderBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_rowHeaderBox.setName("ShowRowHeaders");
        this.m_rowHeaderBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_rowHeaderBox.setAlignmentX(0.0f);
        this.ThreeDPanel = new JPanel();
        this.ThreeDPanel.setLayout(new BoxLayout(this.ThreeDPanel, 0));
        this.ThreeDPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("3D Gridlines");
        this.m_3DBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_3DBox.setName("3DGridlines");
        this.m_3DBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_3DBox.setAlignmentX(0.0f);
        this.ThreeDPanel.add(this.m_3DBox);
        this.m_headersPanel.add(this.m_columnHeaderBox);
        this.m_headersPanel.add(Box.createVerticalStrut(5));
        this.m_headersPanel.add(this.m_rowHeaderBox);
        this.m_headersPanel.add(Box.createVerticalStrut(5));
        this.m_headersPanel.add(this.ThreeDPanel);
        JPanel inlineAndOutlinePanel = null;
        if (this.m_gridView != null && this.m_gridView.getViewType() == 0) {
            inlineAndOutlinePanel = new JPanel();
            inlineAndOutlinePanel.setLayout(new BoxLayout(inlineAndOutlinePanel, 1));
            inlineAndOutlinePanel.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString(INLINE);
            this.m_inlineRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_inlineRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_inlineRadioButton.setMinimumSize(this.m_inlineRadioButton.getPreferredSize());
            this.m_inlineRadioButton.setMaximumSize(this.m_inlineRadioButton.getPreferredSize());
            this.m_inlineRadioButton.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString(OUTLINE);
            this.m_outlineRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_outlineRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_outlineRadioButton.setMinimumSize(this.m_outlineRadioButton.getPreferredSize());
            this.m_outlineRadioButton.setMaximumSize(this.m_outlineRadioButton.getPreferredSize());
            this.m_outlineRadioButton.setAlignmentX(0.0f);
            ButtonGroup group = new ButtonGroup();
            group.add(this.m_inlineRadioButton);
            group.add(this.m_outlineRadioButton);
            inlineAndOutlinePanel.add(this.m_inlineRadioButton);
            inlineAndOutlinePanel.add(Box.createVerticalStrut(5));
            inlineAndOutlinePanel.add(this.m_outlineRadioButton);
            inlineAndOutlinePanel.add(Box.createVerticalGlue());
            translatedText = this.rBundle.getString("Samples");
            this.m_samplesLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
            this.m_samplesLabel.setMinimumSize(this.m_samplesLabel.getPreferredSize());
            this.m_samplesLabel.setMaximumSize(this.m_samplesLabel.getPreferredSize());
            this.m_imageButton = new JLabel(new ImageIcon(ImageUtils.getImageResource(OptionsPanel.class, (String)"images/Inline.gif"))){

                @Override
                public boolean isFocusTraversable() {
                    return false;
                }
            };
            this.m_imageButton.setBackground(this.getBackground());
            this.m_imageButton.setBorder(null);
            this.m_imageButton.setRequestFocusEnabled(false);
            JPanel subPanel = new JPanel();
            subPanel.setLayout(new BoxLayout(subPanel, 1));
            subPanel.setAlignmentX(0.0f);
            subPanel.add(this.m_samplesLabel);
            subPanel.add(Box.createVerticalStrut(3));
            subPanel.add(this.m_imageButton);
            subPanel.add(Box.createVerticalGlue());
            int height = Math.max(inlineAndOutlinePanel.getPreferredSize().height, subPanel.getPreferredSize().height);
            inlineAndOutlinePanel.setPreferredSize(new Dimension(inlineAndOutlinePanel.getPreferredSize().width, height));
            inlineAndOutlinePanel.setMinimumSize(inlineAndOutlinePanel.getPreferredSize());
            inlineAndOutlinePanel.setMaximumSize(inlineAndOutlinePanel.getPreferredSize());
            subPanel.setPreferredSize(new Dimension(subPanel.getPreferredSize().width, height));
            subPanel.setMinimumSize(subPanel.getPreferredSize());
            subPanel.setMaximumSize(subPanel.getPreferredSize());
            this.rowHeaderstylePanel = new JPanel();
            this.rowHeaderstylePanel.setLayout(new BoxLayout(this.rowHeaderstylePanel, 0));
            this.rowHeaderstylePanel.setAlignmentX(0.0f);
            this.rowHeaderstylePanel.add(Box.createHorizontalStrut(24));
            this.rowHeaderstylePanel.add(inlineAndOutlinePanel);
            this.rowHeaderstylePanel.add(Box.createHorizontalStrut(3));
            this.rowHeaderstylePanel.add(subPanel);
            this.rowHeaderstylePanel.add(Box.createHorizontalGlue());
        }
        this.m_gridLinesPanel = new JPanel();
        this.m_gridLinesPanel.setLayout(new BoxLayout(this.m_gridLinesPanel, 1));
        this.m_gridLinesPanel.setAlignmentY(0.0f);
        translatedText = this.rBundle.getString("Show Hg lines");
        this.m_horzBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_horzBox.setName("ShowHorizGridLines");
        this.m_horzBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_horzBox.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Show Vg lines");
        this.m_vertBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_vertBox.setName("ShowVertGridLines");
        this.m_vertBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_vertBox.setAlignmentX(0.0f);
        int width = Math.max(this.m_horzBox.getPreferredSize().width, this.m_vertBox.getPreferredSize().width);
        this.m_horzBox.setPreferredSize(new Dimension(width, this.m_horzBox.getPreferredSize().height));
        this.m_horzBox.setMaximumSize(this.m_horzBox.getPreferredSize());
        this.m_horzBox.setMinimumSize(this.m_horzBox.getPreferredSize());
        this.m_vertBox.setPreferredSize(new Dimension(width, this.m_vertBox.getPreferredSize().height));
        this.m_vertBox.setMaximumSize(this.m_vertBox.getPreferredSize());
        this.m_vertBox.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.horzGridLinesPanel = new JPanel();
        this.horzGridLinesPanel.setLayout(new BoxLayout(this.horzGridLinesPanel, 0));
        this.horzGridLinesPanel.setAlignmentX(0.0f);
        this.m_horzColor = new BIColorChoice();
        this.m_horzColor.setName("HorizColorChoice");
        this.m_horzColor.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        this.m_horzColor.setLocale(this.m_gridView.getLocale());
        this.m_horzColor.setTransparentAllowed(true);
        this.m_horzColor.setAlignmentX(0.0f);
        this.horzGridLinesPanel.add(this.m_horzBox);
        this.horzGridLinesPanel.add(Box.createHorizontalStrut(12));
        this.horzGridLinesPanel.add((Component)this.m_horzColor);
        this.vertGridLinesPanel = new JPanel();
        this.vertGridLinesPanel.setLayout(new BoxLayout(this.vertGridLinesPanel, 0));
        this.vertGridLinesPanel.setAlignmentX(0.0f);
        this.m_vertColor = new BIColorChoice();
        this.m_vertColor.setName("VertColorChoice");
        this.m_vertColor.setCustomColorsEnabled(this.m_gridView.isCustomColorsEnabled());
        this.m_vertColor.setLocale(this.m_gridView.getLocale());
        this.m_vertColor.setTransparentAllowed(true);
        this.m_vertColor.setAlignmentX(0.0f);
        this.vertGridLinesPanel.add(this.m_vertBox);
        this.vertGridLinesPanel.add(Box.createHorizontalStrut(12));
        this.vertGridLinesPanel.add((Component)this.m_vertColor);
        this.m_gridLinesPanel.add(this.horzGridLinesPanel);
        this.m_gridLinesPanel.add(Box.createVerticalStrut(5));
        this.m_gridLinesPanel.add(this.vertGridLinesPanel);
        this.m_gridLinesPanel.add(Box.createVerticalGlue());
        this.m_upperPanel = new JPanel();
        this.m_upperPanel.setLayout(new BoxLayout(this.m_upperPanel, 0));
        this.m_upperPanel.add(this.m_headersPanel);
        this.m_upperPanel.add(Box.createHorizontalStrut(24));
        this.m_upperPanel.add(this.m_gridLinesPanel);
        this.m_upperPanel.add(Box.createHorizontalGlue());
        this.m_upperPanel.setAlignmentX(0.0f);
        this.m_formatsPanel = new JPanel();
        this.m_formatsPanel.setLayout(new BoxLayout(this.m_formatsPanel, 1));
        this.m_formatsPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("EditDefault");
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        label.setAlignmentX(0.0f);
        this.m_formatsPanel.add(label);
        this.m_formatsPanel.add(Box.createVerticalStrut(5));
        this.m_formatsTable = new FormatsTable();
        this.m_formatsTable.setRowHeight(19);
        this.m_formatsTable.setAlignmentX(0.0f);
        this.m_formatsTableModel = new FormatsTableModel();
        this.m_formatsTable.setModel(this.m_formatsTableModel);
        this.m_formatsTable.getColumnModel().getColumn(1).setCellRenderer(new AttributeCellRenderer());
        this.m_formatsTable.addFocusListener(this);
        JScrollPane m_scrollPane = new JScrollPane(this.m_formatsTable);
        m_scrollPane.setVerticalScrollBarPolicy(20);
        m_scrollPane.setHorizontalScrollBarPolicy(30);
        m_scrollPane.setAlignmentX(0.0f);
        label.setLabelFor(m_scrollPane);
        JPanel panel = new JPanel();
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        this.m_editPanel = new JPanel();
        this.m_editPanel.setAlignmentX(0.0f);
        this.m_editPanel.setLayout(new BoxLayout(this.m_editPanel, 1));
        this.m_editButton = new JButton(StringUtils.stripMnemonic((String)this.rBundle.getString("Edit")));
        this.m_editButton.setName("EditFormatButton");
        this.m_editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Edit")));
        this.m_editButton.setPreferredSize(new Dimension(this.m_editButton.getPreferredSize().width + 10, this.m_editButton.getPreferredSize().height));
        this.m_editButton.setMinimumSize(this.m_editButton.getPreferredSize());
        this.m_editButton.setMaximumSize(this.m_editButton.getPreferredSize());
        this.m_editButton.addActionListener(this);
        this.m_editButton.setAlignmentX(0.0f);
        this.m_editButton.setEnabled(false);
        this.m_editPanel.add(this.m_editButton);
        this.m_editPanel.add(Box.createVerticalGlue());
        panel.add(m_scrollPane);
        panel.add(Box.createHorizontalStrut(12));
        panel.add(this.m_editPanel);
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel) {
            panel.setPreferredSize(new Dimension(m_scrollPane.getPreferredSize().width + this.m_editButton.getPreferredSize().width, this.m_formatsTable.getPreferredSize().height + label.getPreferredSize().height + 12));
        } else if (UIManager.getLookAndFeel() instanceof MotifLookAndFeel) {
            panel.setPreferredSize(new Dimension(m_scrollPane.getPreferredSize().width + this.m_editButton.getPreferredSize().width, this.m_formatsTable.getPreferredSize().height + label.getPreferredSize().height + 11));
        } else if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            panel.setPreferredSize(new Dimension(m_scrollPane.getPreferredSize().width + this.m_editButton.getPreferredSize().width, this.m_formatsTable.getPreferredSize().height + label.getPreferredSize().height + 7));
        } else {
            panel.setPreferredSize(new Dimension(m_scrollPane.getPreferredSize().width + this.m_editButton.getPreferredSize().width, this.m_formatsTable.getPreferredSize().height + label.getPreferredSize().height + 6));
        }
        panel.setMinimumSize(panel.getPreferredSize());
        panel.setMaximumSize(panel.getPreferredSize());
        this.m_formatsPanel.add(panel);
        this.m_mainPanel.add(this.m_upperPanel);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.m_formatsPanel);
        this.calculatePanelSizes();
        this.calculatePreferredSize();
        this.m_vertColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_horzColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_horzBox.addItemListener(this);
        this.m_vertBox.addItemListener(this);
        this.m_3DBox.addItemListener(this);
        this.m_columnHeaderBox.addItemListener(this);
        this.m_rowHeaderBox.addItemListener(this);
        if (this.m_gridView != null && this.m_gridView.getViewType() == 0) {
            this.m_outlineRadioButton.addChangeListener(this);
        }
        this._init();
        this.setFocusComponent();
    }

    private void calculatePanelSizes() {
        int width = Math.max(this.m_columnHeaderBox.getPreferredSize().width, this.m_rowHeaderBox.getPreferredSize().width);
        int pWidth = this.inlineOutlineVisible ? Math.max(this.rowHeaderstylePanel.getPreferredSize().width, width) : Math.max(this.ThreeDPanel.getPreferredSize().width, width);
        int pHeight = this.m_columnHeaderBox.getPreferredSize().height + 5 + this.m_rowHeaderBox.getPreferredSize().height;
        pHeight = this.inlineOutlineVisible ? (pHeight += 5 + this.rowHeaderstylePanel.getPreferredSize().height) : (pHeight += 5 + this.ThreeDPanel.getPreferredSize().height);
        this.m_headersPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_headersPanel.setMinimumSize(this.m_headersPanel.getPreferredSize());
        this.m_headersPanel.setMaximumSize(this.m_headersPanel.getPreferredSize());
        pWidth = this.m_horzBox.getPreferredSize().width + 12 + this.m_horzColor.getPreferredSize().width;
        pHeight = Math.max(this.m_horzBox.getPreferredSize().height, this.m_horzColor.getPreferredSize().height);
        this.horzGridLinesPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.horzGridLinesPanel.setMinimumSize(this.horzGridLinesPanel.getPreferredSize());
        this.horzGridLinesPanel.setMaximumSize(this.horzGridLinesPanel.getPreferredSize());
        pWidth = this.m_vertBox.getPreferredSize().width + 12 + this.m_vertColor.getPreferredSize().width;
        pHeight = Math.max(this.m_vertBox.getPreferredSize().height, this.m_vertColor.getPreferredSize().height);
        this.vertGridLinesPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.vertGridLinesPanel.setMinimumSize(this.vertGridLinesPanel.getPreferredSize());
        this.vertGridLinesPanel.setMaximumSize(this.vertGridLinesPanel.getPreferredSize());
        pWidth = Math.max(this.horzGridLinesPanel.getPreferredSize().width, this.vertGridLinesPanel.getPreferredSize().width);
        if (this.inlineOutlineVisible) {
            pWidth = Math.max(this.ThreeDPanel.getPreferredSize().width, pWidth);
        }
        pHeight = this.horzGridLinesPanel.getPreferredSize().height + 5 + this.vertGridLinesPanel.getPreferredSize().height;
        if (this.inlineOutlineVisible) {
            pHeight += 5 + this.ThreeDPanel.getPreferredSize().height;
        }
        this.m_gridLinesPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_gridLinesPanel.setMaximumSize(this.m_gridLinesPanel.getPreferredSize());
        this.m_gridLinesPanel.setMinimumSize(this.m_gridLinesPanel.getPreferredSize());
        pWidth = this.m_headersPanel.getPreferredSize().width + 24 + this.m_gridLinesPanel.getPreferredSize().width;
        pHeight = Math.max(this.m_headersPanel.getPreferredSize().height, this.m_gridLinesPanel.getPreferredSize().height);
        this.m_upperPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_upperPanel.setMaximumSize(this.m_upperPanel.getPreferredSize());
        this.m_upperPanel.setMinimumSize(this.m_upperPanel.getPreferredSize());
    }

    private void calculatePreferredSize() {
        int maxWidth = Math.max(this.m_upperPanel.getPreferredSize().width, this.m_formatsPanel.getPreferredSize().width);
        int pWidth = maxWidth + 10 + 10;
        int pHeight = this.m_upperPanel.getPreferredSize().height + 15 + this.m_formatsPanel.getPreferredSize().height + this.m_label.getPreferredSize().height + 10 + 15 + 10;
        this.prefSize = new Dimension(pWidth, pHeight);
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    private void _init() {
        Color color;
        if (this.m_gridView == null) {
            return;
        }
        this.m_horzBox.setSelected(this.m_gridView.isHGridVisible());
        this.m_vertBox.setSelected(this.m_gridView.isVGridVisible());
        if (this.m_gridView.getHGridColor() == null || this.m_gridView.getHGridColor().getAlpha() == 0) {
            this.m_horzColor.setSelectedColor(null);
        } else {
            color = this.m_gridView.getHGridColor();
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_horzColor.getColorPalette(), (Color)color)) {
                this.m_horzColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_horzColor.getColorPalette(), (Color)color, (boolean)false));
            }
            this.m_horzColor.setSelectedColor(color);
        }
        if (this.m_gridView.getVGridColor() == null || this.m_gridView.getVGridColor().getAlpha() == 0) {
            this.m_vertColor.setSelectedColor(null);
        } else {
            color = this.m_gridView.getVGridColor();
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_vertColor.getColorPalette(), (Color)color)) {
                this.m_vertColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_vertColor.getColorPalette(), (Color)color, (boolean)false));
            }
            this.m_vertColor.setSelectedColor(color);
        }
        this.m_3DBox.setSelected(this.m_gridView.isGrid3D());
        this.m_columnHeaderBox.setSelected(this.m_gridView.isColumnHeaderVisible());
        this.m_rowHeaderBox.setSelected(this.m_gridView.isRowHeaderVisible());
        if (this.m_gridView.getViewType() == 0) {
            this.m_outlineRadioButton.setSelected(((CrosstabAttribute)((Object)this.m_gridView)).isOutline());
            this.m_inlineRadioButton.setSelected(!this.m_outlineRadioButton.isSelected());
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        if (this.m_horzColor != null) {
            this.m_horzColor.setLocale(loc);
        }
        if (this.m_vertColor != null) {
            this.m_vertColor.setLocale(loc);
        }
    }

    public void setDefaultFormattingVisible(boolean visible) {
        this.m_formatsPanel.setVisible(visible);
    }

    public boolean isDefaultFormattingVisible() {
        return this.m_formatsPanel.isVisible();
    }

    @Override
    public boolean apply() {
        this.m_gridView.setHGridVisible(this.m_horzBox.isSelected());
        this.m_gridView.setVGridVisible(this.m_vertBox.isSelected());
        this.m_gridView.setGrid3D(this.m_3DBox.isSelected());
        if (this.m_horzBox.isSelected()) {
            if (this.m_horzColor.getSelectedColor() == null) {
                this.m_gridView.setHGridColor(new Color(255, 255, 255, 0));
            } else {
                this.m_gridView.setHGridColor(this.m_horzColor.getSelectedColor());
            }
        }
        if (this.m_vertBox.isSelected()) {
            if (this.m_vertColor.getSelectedColor() == null) {
                this.m_gridView.setVGridColor(new Color(255, 255, 255, 0));
            } else {
                this.m_gridView.setVGridColor(this.m_vertColor.getSelectedColor());
            }
        }
        this.m_gridView.setColumnHeaderVisible(this.m_columnHeaderBox.isSelected());
        this.m_gridView.setRowHeaderVisible(this.m_rowHeaderBox.isSelected());
        if (this.m_gridView.getViewType() == 0) {
            ((CrosstabAttribute)((Object)this.m_gridView)).setOutline(this.m_outlineRadioButton.isSelected());
        }
        if (this.isDefaultFormattingVisible()) {
            int autoFitScope = this.m_gridView.getAutoFitScope();
            this.m_gridView.setAutoFitScope(0);
            TableCell tableCell = this.m_formatsTableModel.getTableCell(0);
            this.m_gridView.getColumnHeader().setViewStyle(tableCell.a_viewStyle);
            tableCell = this.m_formatsTableModel.getTableCell(1);
            this.m_gridView.getRowHeader().setViewStyle(tableCell.a_viewStyle);
            tableCell = this.m_formatsTableModel.getTableCell(2);
            this.m_gridView.getPagingControl().setViewStyle(tableCell.a_viewStyle);
            tableCell = this.m_formatsTableModel.getTableCell(3);
            this.m_gridView.getDatabody().setViewStyle(tableCell.a_viewStyle);
            this.m_gridView.getViewFormat().merge((Mergeable)tableCell.a_viewFormat);
            if (tableCell.a_negativeRed) {
                NumberValueDiscriminator numberValueDiscriminator = new NumberValueDiscriminator(0.0, 1);
                ViewStyle viewStyle = new ViewStyle();
                viewStyle.setForeground(Color.red);
                DiscriminatorRule discriminatorRule = new DiscriminatorRule((Discriminator)numberValueDiscriminator, (Mergeable)viewStyle);
                RuleBundle ruleBundle = this.m_gridView.getGridViewDatabodyStyleManager().getUIBundle();
                if (ruleBundle == null) {
                    ruleBundle = new RuleBundle();
                }
                ruleBundle.addRule((Rule)discriminatorRule);
                this.m_gridView.getGridViewDatabodyStyleManager().setUIBundle(this.m_gridView, ruleBundle);
            }
            UIFormat tmp_UIFormat = new UIFormat((String)this.m_formatsTable.getValueAt(3, 0), 3, 1, 2, null, null, null, tableCell.a_negativeRed, tableCell.a_numberOrDate, tableCell.a_patternString);
            if (this.m_gridView.getUIFormats() == null) {
                this.m_gridView.setUIFormats(new Vector());
            }
            this.m_gridView.getUIFormats().addElement(tmp_UIFormat);
            this.m_gridView.setAutoFitScope(autoFitScope);
            this.m_gridView.dataStyleAndFormatAndMetadataStyleChanged();
        }
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void setInlineOutlineVisible(boolean visible) {
        if (visible != this.inlineOutlineVisible) {
            this.inlineOutlineVisible = visible;
            if (visible) {
                this.m_headersPanel.remove(this.ThreeDPanel);
                this.m_headersPanel.add(this.rowHeaderstylePanel);
                this.m_gridLinesPanel.add(Box.createVerticalStrut(5));
                this.m_gridLinesPanel.add(this.ThreeDPanel);
            } else {
                this.m_headersPanel.remove(this.rowHeaderstylePanel);
                this.m_gridLinesPanel.remove(Box.createVerticalStrut(5));
                this.m_gridLinesPanel.remove(this.ThreeDPanel);
                this.m_headersPanel.add(this.ThreeDPanel);
            }
            this.calculatePanelSizes();
            this.calculatePreferredSize();
        }
    }

    public boolean isInlineOutlineVisible() {
        return this.inlineOutlineVisible;
    }

    public String getHelpContextID() {
        if (this.m_gridView != null && this.m_gridView.getViewType() == 2) {
            return this.getClass().getName() + "_Table";
        }
        return this.getClass().getName() + "_Crosstab";
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.m_outlineRadioButton) {
            if (this.m_outlineRadioButton.isSelected()) {
                this.firePropertyChange(PROPERTY_ROW_HEADERS_STYLE, INLINE, OUTLINE);
                this.m_imageButton.setIcon(new ImageIcon(ImageUtils.getImageResource(OptionsPanel.class, (String)"images/Outline.gif")));
            } else {
                this.firePropertyChange(PROPERTY_ROW_HEADERS_STYLE, OUTLINE, INLINE);
                this.m_imageButton.setIcon(new ImageIcon(ImageUtils.getImageResource(OptionsPanel.class, (String)"images/Inline.gif")));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_editButton) {
            int row = this.m_formatsTable.getSelectedRow();
            if (row < 0) {
                return;
            }
            TableCell tableCell = this.m_formatsTableModel.getTableCell(row);
            ViewStyle vs = tableCell.a_viewStyle;
            ViewFormat vf = tableCell.a_viewFormat;
            boolean negativeRed = tableCell.a_negativeRed;
            int numberOrDate = tableCell.a_numberOrDate;
            String patternString = tableCell.a_patternString;
            if (row == 3) {
                FormatGeneralPanel tmpFormatGeneralPanel = new FormatGeneralPanel(vs);
                tmpFormatGeneralPanel.setLocale(super.getLocale());
                FontPanel tmpFontPanel = new FontPanel(vs, 1);
                NumberFormatPanel tmpNumberFormatPanel = null;
                DatePanel tmpDatePanel = null;
                int numberCategory = numberOrDate >> 4;
                int dateCategory = numberOrDate & 0xF;
                ViewFormat viewFormat = vf;
                if (viewFormat == null) {
                    viewFormat = new ViewFormat();
                    viewFormat.setLocale(this.getLocale());
                }
                if (viewFormat.getLocale() == null) {
                    viewFormat.setLocale(this.getLocale());
                }
                tmpFormatGeneralPanel.setFormatName(this.m_formatsTable.getValueAt(row, 0).toString(), false);
                boolean visible = false;
                if (this.m_gridView.getModel() != null && this.m_gridView.getModel().getDataDirector() != null && this.m_gridView.getModel().getDataDirector().getSupportedDataMap() != null) {
                    visible = this.m_gridView.getModel().getDataDirector().getSupportedDataMap().contains((Object)"dataRatio");
                }
                tmpFormatGeneralPanel.setDataBarOptionVisible(visible);
                if (dateCategory != 15) {
                    tmpDatePanel = new DatePanel(viewFormat);
                    tmpDatePanel.setLocale(super.getLocale());
                    tmpDatePanel.setCategoryType(dateCategory);
                    tmpDatePanel.setErrorHandler(this.getErrorHandler());
                }
                if (numberCategory != 15) {
                    tmpNumberFormatPanel = new NumberFormatPanel(viewFormat);
                    tmpNumberFormatPanel.setLocale(super.getLocale());
                    tmpNumberFormatPanel.setNegativeRed(negativeRed);
                    tmpNumberFormatPanel.setFormatType(numberCategory);
                    if (numberCategory == 5) {
                        tmpNumberFormatPanel.setCurrentCustomPatternString(patternString);
                    }
                }
                tmpFontPanel.addPropertyChangeListener(tmpFormatGeneralPanel);
                tmpFormatGeneralPanel.addPropertyChangeListener(tmpFontPanel);
                JTabbedPane tmpTabbedPane = new JTabbedPane();
                String tabText = this.rBundle.getString("TabGeneral");
                tmpTabbedPane.add(tabText, tmpFormatGeneralPanel);
                tabText = this.rBundle.getString("TabFont");
                tmpTabbedPane.add(tabText, tmpFontPanel);
                SamplePanel tmpSamplePanel = null;
                if (tmpNumberFormatPanel != null && tmpDatePanel != null) {
                    tabText = this.rBundle.getString("TabNumber");
                    tmpTabbedPane.add(tabText, (Component)tmpNumberFormatPanel);
                    tabText = this.rBundle.getString("TabDate");
                    tmpTabbedPane.add(tabText, tmpDatePanel);
                    tmpSamplePanel = new SamplePanel(tmpFormatGeneralPanel, tmpFontPanel, tmpNumberFormatPanel, tmpDatePanel, null);
                } else if (tmpNumberFormatPanel != null) {
                    tabText = this.rBundle.getString("TabNumber");
                    tmpTabbedPane.add(tabText, (Component)tmpNumberFormatPanel);
                    tmpSamplePanel = new SamplePanel(tmpFormatGeneralPanel, tmpFontPanel, tmpNumberFormatPanel);
                } else if (tmpDatePanel != null) {
                    tabText = this.rBundle.getString("TabDate");
                    tmpTabbedPane.add(tabText, tmpDatePanel);
                    tmpSamplePanel = new SamplePanel(tmpFormatGeneralPanel, tmpFontPanel, tmpDatePanel);
                }
                tmpTabbedPane.setLocale(super.getLocale());
                tmpFontPanel.setLocale(super.getLocale());
                tmpSamplePanel.setLocale(super.getLocale());
                JPanel tmpPanel = new JPanel();
                if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                    tmpPanel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
                }
                tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
                tmpPanel.add(tmpTabbedPane);
                tmpPanel.add(tmpSamplePanel);
                tmpTabbedPane.setAlignmentX(0.0f);
                tmpSamplePanel.setAlignmentX(0.0f);
                PanelDialog tmpDialog = this.createPanelDialog(this.rBundle.getString("EditDefaultCellFormat"), true, tmpPanel, this.m_bHelpEnabled, 1, tmpTabbedPane, this.getHelpProvider());
                this.m_ok = false;
                tmpDialog.show();
                if (this.m_ok) {
                    if (tmpNumberFormatPanel != null) {
                        numberCategory = tmpNumberFormatPanel.getFormatType();
                        numberOrDate = numberCategory << 4;
                    } else {
                        numberOrDate = 240;
                    }
                    if (tmpDatePanel != null) {
                        dateCategory = tmpDatePanel.getCategoryType();
                        numberOrDate |= dateCategory;
                    } else {
                        numberOrDate |= 0xF;
                    }
                    if (numberCategory == 5) {
                        patternString = tmpNumberFormatPanel.getCurrentCustomPatternString();
                    }
                    tmpFormatGeneralPanel.apply(vs);
                    tmpFontPanel.apply();
                    tmpDatePanel.apply();
                    viewFormat = tmpDatePanel.getViewFormat();
                    viewFormat.merge((Mergeable)tmpNumberFormatPanel.apply());
                    tableCell.a_viewFormat = viewFormat;
                    tableCell.a_negativeRed = tmpNumberFormatPanel.isNegativeRed();
                    tableCell.a_patternString = patternString;
                    tableCell.a_numberOrDate = numberOrDate;
                    tableCell.setAttributeLabel();
                    this.m_formatsTable.repaint();
                }
                tmpTabbedPane.removeAll();
                tmpDialog.cleanUp();
                tmpDialog.dispose();
                tmpPanel.remove(tmpSamplePanel);
                tmpFontPanel.removePropertyChangeListener(tmpFormatGeneralPanel);
                tmpFormatGeneralPanel.removePropertyChangeListener(tmpFontPanel);
                tmpFontPanel.cleanUp();
                tmpFontPanel = null;
                tmpFormatGeneralPanel.cleanUp();
                tmpFormatGeneralPanel = null;
                if (tmpDatePanel != null) {
                    tmpDatePanel.cleanUp();
                    tmpDatePanel = null;
                }
                if (tmpNumberFormatPanel != null) {
                    tmpNumberFormatPanel.cleanUp();
                    tmpNumberFormatPanel = null;
                }
                tmpSamplePanel.cleanUp();
                tmpSamplePanel = null;
            } else {
                HeaderFormatGeneralPanel tmpFormatGeneralPanel = new HeaderFormatGeneralPanel(vs, this.m_gridView, false);
                FontPanel tmpFontPanel = new FontPanel(vs, 1);
                tmpFormatGeneralPanel.setFormatName((String)this.m_formatsTable.getValueAt(row, 0), false);
                JTabbedPane tmpTabbedPane = new JTabbedPane();
                String tabText = this.rBundle.getString("TabGeneral");
                tmpTabbedPane.add(tabText, tmpFormatGeneralPanel);
                tabText = this.rBundle.getString("TabFont");
                tmpTabbedPane.add(tabText, tmpFontPanel);
                SamplePanel tmpSamplePanel = new SamplePanel(tmpFormatGeneralPanel, tmpFontPanel, null);
                tmpTabbedPane.setLocale(super.getLocale());
                tmpFormatGeneralPanel.setLocale(super.getLocale());
                tmpFontPanel.setLocale(super.getLocale());
                tmpSamplePanel.setLocale(super.getLocale());
                tmpFontPanel.addPropertyChangeListener(tmpFormatGeneralPanel);
                tmpFormatGeneralPanel.addPropertyChangeListener(tmpFontPanel);
                JPanel tmpPanel = new JPanel();
                if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                    tmpPanel.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
                }
                tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
                tmpPanel.add(tmpTabbedPane);
                tmpPanel.add(tmpSamplePanel);
                tmpTabbedPane.setAlignmentX(0.0f);
                tmpSamplePanel.setAlignmentX(0.0f);
                PanelDialog tmpDialog = this.createPanelDialog(this.rBundle.getString("EditDefaultHeader"), true, tmpPanel, this.m_bHelpEnabled, 1, tmpTabbedPane, this.getHelpProvider());
                this.m_ok = false;
                tmpDialog.show();
                if (this.m_ok) {
                    tmpFormatGeneralPanel.apply(vs);
                    tmpFontPanel.apply();
                    tableCell.setAttributeLabel();
                    this.m_formatsTable.repaint();
                }
                tmpTabbedPane.removeAll();
                tmpDialog.cleanUp();
                tmpDialog.dispose();
                tmpPanel.remove(tmpSamplePanel);
                tmpFontPanel.removePropertyChangeListener(tmpFormatGeneralPanel);
                tmpFormatGeneralPanel.removePropertyChangeListener(tmpFontPanel);
                tmpFontPanel.cleanUp();
                tmpFontPanel = null;
                tmpFormatGeneralPanel.cleanUp();
                tmpFormatGeneralPanel = null;
                tmpSamplePanel.cleanUp();
                tmpSamplePanel = null;
            }
            this.firePropertyChange(DEFAULT_FORMAT_CHANGED, 0, 1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == this.m_horzBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_VISIBLE, false, true);
                this.m_horzColor.setEnabled(true);
                this.m_3DBox.setEnabled(true);
            } else {
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_VISIBLE, true, false);
                this.m_horzColor.setEnabled(false);
                if (!this.m_vertBox.isSelected()) {
                    this.m_3DBox.setEnabled(false);
                }
            }
        } else if (e.getItem() == this.m_vertBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_VISIBLE, false, true);
                this.m_vertColor.setEnabled(true);
                this.m_3DBox.setEnabled(true);
            } else {
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_VISIBLE, true, false);
                this.m_vertColor.setEnabled(false);
                if (!this.m_horzBox.isSelected()) {
                    this.m_3DBox.setEnabled(false);
                }
            }
        } else if (e.getItem() == this.m_3DBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_3D_GRID_VISIBLE, false, true);
            } else {
                this.firePropertyChange(PROPERTY_3D_GRID_VISIBLE, true, false);
            }
        } else if (e.getItem() == this.m_columnHeaderBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_COLUMN_HEADERS_VISIBLE, false, true);
            } else {
                this.firePropertyChange(PROPERTY_COLUMN_HEADERS_VISIBLE, true, false);
            }
        } else if (e.getItem() == this.m_rowHeaderBox) {
            if (e.getStateChange() == 1) {
                this.firePropertyChange(PROPERTY_ROW_HEADERS_VISIBLE, false, true);
                if (this.m_inlineRadioButton != null) {
                    this.m_inlineRadioButton.setEnabled(true);
                }
                if (this.m_outlineRadioButton != null) {
                    this.m_outlineRadioButton.setEnabled(true);
                }
            } else {
                this.firePropertyChange(PROPERTY_ROW_HEADERS_VISIBLE, true, false);
                if (this.m_inlineRadioButton != null) {
                    this.m_inlineRadioButton.setEnabled(false);
                }
                if (this.m_outlineRadioButton != null) {
                    this.m_outlineRadioButton.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.m_horzColor && e.getPropertyName().equals("selectedColor")) {
            this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_COLOR, e.getOldValue(), e.getNewValue());
        } else if (e.getSource() == this.m_vertColor && e.getPropertyName().equals("selectedColor")) {
            this.firePropertyChange(PROPERTY_VERTICAL_GRID_COLOR, e.getOldValue(), e.getNewValue());
        }
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHorizontalGridLineShow(boolean show) {
        this.m_horzBox.setSelected(show);
    }

    public boolean isHorizontalGridLineShow() {
        return this.m_horzBox.isSelected();
    }

    public void setVerticalGridLineShow(boolean show) {
        this.m_vertBox.setSelected(show);
    }

    public boolean isVerticalGridLineShow() {
        return this.m_vertBox.isSelected();
    }

    protected ViewStyle getDefaultPageControlViewStyle() {
        return this.m_formatsTableModel.getTableCell((int)2).a_viewStyle;
    }

    protected ViewStyle getDefaultRowHeaderViewStyle() {
        return this.m_formatsTableModel.getTableCell((int)1).a_viewStyle;
    }

    protected ViewStyle getDefaultColumnHeaderViewStyle() {
        return this.m_formatsTableModel.getTableCell((int)0).a_viewStyle;
    }

    protected ViewStyle getDefaultDatabodyViewStyle() {
        return this.m_formatsTableModel.getTableCell((int)3).a_viewStyle;
    }

    protected void updateViewStyle() {
        for (int i = 0; i < 4; ++i) {
            this.m_formatsTableModel.getTableCell(i).setAttributeLabel();
        }
        this.repaint();
    }

    private PanelDialog createPanelDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                return new PanelDialog((Dialog)owner, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
            }
            if (owner instanceof Frame) {
                return new PanelDialog((Frame)owner, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (owner == null) {
            return new PanelDialog((Frame)null, title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }
        return null;
    }

    private class PanelDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private int m_initialWidth;
        private int m_initialHeight;
        private boolean m_bHelpEnabled;
        private JTabbedPane m_tabbedPane;
        private String m_strHelpContextID;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected int m_action;
        private final Border _sBorder;
        private final Border _sBorderButtons;

        public PanelDialog(Frame parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            super(parentFrame);
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }

        public PanelDialog(Dialog owner, String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            super(owner);
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled, action, tabbedPane, helpProvider);
        }

        private void _initDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled, int action, JTabbedPane tabbedPane, HelpProvider helpProvider) {
            this.m_bHelpEnabled = bHelpEnabled;
            this.m_tabbedPane = tabbedPane;
            this.setHelpProvider(helpProvider);
            this.setTitle(title);
            this.setModal(modal);
            this.m_panel = p;
            this.m_action = action;
            this.setHelpEnabled(true);
            this.init();
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.setLocation((screenSize.width - frameSize.height) / 2, (screenSize.height - frameSize.width) / 2);
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
        }

        public String getHelpContextID() {
            String strReturn = "";
            Component tmpComponent = this.m_tabbedPane.getSelectedComponent();
            if (tmpComponent instanceof HelpContext) {
                strReturn = ((HelpContext)tmpComponent).getHelpContextID();
            }
            tmpComponent = null;
            return strReturn;
        }

        public void cleanUp() {
            this.getContentPane().remove(this.m_panel);
            this.m_tabbedPane = null;
            this.m_panel.removeAll();
            this.m_panel = null;
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            OptionsPanel.this.m_helpProvider = helpProvider;
        }

        public HelpProvider getHelpProvider() {
            return OptionsPanel.this.m_helpProvider;
        }

        public void setHelpEnabled(boolean bValue) {
            this.m_bHelpEnabled = bValue;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            content.setBorder(this._sBorder);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            content.add(this.m_panel);
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                String translatedText = OptionsPanel.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
            }
            JPanel buttonPanel_east = new JPanel();
            String translatedText = OptionsPanel.this.rBundle.getString("OK");
            this.okButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            translatedText = OptionsPanel.this.rBundle.getString("Cancel");
            this.cancelButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)buttonPanel);
            this.m_panel.setAlignmentX(0.0f);
            buttonPanel.setAlignmentX(0.0f);
            this.setResizable(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int originalHeight;
                    int originalWidth;
                    int width = originalWidth = PanelDialog.this.getWidth();
                    int height = originalHeight = PanelDialog.this.getHeight();
                    if (PanelDialog.this.m_initialWidth != -1) {
                        width = Math.max(PanelDialog.this.m_initialWidth, width);
                    }
                    if (PanelDialog.this.m_initialHeight != -1) {
                        height = Math.max(PanelDialog.this.m_initialHeight, height);
                    }
                    if (originalWidth != width || originalHeight != height) {
                        PanelDialog.this.setSize(width, height);
                    }
                    PanelDialog.this.validate();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                OptionsPanel.this.m_ok = false;
                this.setVisible(false);
                this.dispose();
                this.getParent().repaint();
            } else if (e.getSource() == this.okButton) {
                OptionsPanel.this.m_ok = true;
                this.setVisible(false);
                this.dispose();
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (this.getHelpProvider() != null) {
                        this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }
    }

    private class AttributeCellRenderer
    extends JPanel
    implements TableCellRenderer {
        AttributeLabel tmpLabel;

        public AttributeCellRenderer() {
            this.setBackground(Color.white);
            this.setOpaque(true);
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(new EmptyBorder(1, 2, 1, 2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.removeAll();
            this.tmpLabel = OptionsPanel.this.m_formatsTableModel.getTableCell((int)row).a_attribute;
            this.add(this.tmpLabel);
            this.tmpLabel.setPreferredSize(new Dimension(this.getPreferredSize().width - 4, this.tmpLabel.getPreferredSize().height));
            this.tmpLabel.setMinimumSize(this.tmpLabel.getPreferredSize());
            this.tmpLabel.setMaximumSize(this.tmpLabel.getPreferredSize());
            this.setPreferredSize(new Dimension(OptionsPanel.this.m_formatsTable.getColumnModel().getColumn(1).getWidth(), Math.max(18, this.tmpLabel.getPreferredSize().height + 2)));
            if (table.getRowHeight(row) != this.getPreferredSize().height) {
                table.setRowHeight(row, this.getPreferredSize().height);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.getAccessibleContext().setAccessibleName(this.tmpLabel.label.getText());
            return this;
        }
    }

    class AttributeLabel
    extends JPanel {
        private int _sizeLimit = 30;
        private int topLineStyle;
        private int bottomLineStyle;
        private int rightLineStyle;
        private int leftLineStyle;
        private Color topLineColor;
        private Color bottomLineColor;
        private Color rightLineColor;
        private Color leftLineColor;
        private int topLineWidth;
        private int bottomLineWidth;
        private int rightLineWidth;
        private int leftLineWidth;
        ViewLabel label;

        public AttributeLabel(String text) {
            this.label = new ViewLabel(text);
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createHorizontalStrut(2));
            this.add(this.label);
            this.setBackground(null);
            this.label.setForeground(Color.black);
            this.setOpaque(true);
        }

        public AttributeLabel() {
            this("");
        }

        public void setOutlineStyle(int topStyle, int bottomStyle, int leftStyle, int rightStyle) {
            if (topStyle != -1) {
                this.topLineStyle = topStyle;
            }
            if (bottomStyle != -1) {
                this.bottomLineStyle = bottomStyle;
            }
            if (rightStyle != -1) {
                this.rightLineStyle = rightStyle;
            }
            if (leftStyle != -1) {
                this.leftLineStyle = leftStyle;
            }
        }

        public void setOutlineColor(Color topColor, Color bottomColor, Color leftColor, Color rightColor) {
            this.topLineColor = topColor;
            this.bottomLineColor = bottomColor;
            this.rightLineColor = rightColor;
            this.leftLineColor = leftColor;
        }

        public void setOutlineWidth(int topWidth, int bottomWidth, int leftWidth, int rightWidth) {
            this.topLineWidth = topWidth;
            this.bottomLineWidth = bottomWidth;
            this.rightLineWidth = rightWidth;
            this.leftLineWidth = leftWidth;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(OptionsPanel.this.m_formatsTable.getColumnModel().getColumn(1).getWidth() - 4, this.label.getPreferredSize().height + this.topLineWidth + this.bottomLineWidth + 1);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Border b = this.getBorder();
            Insets insets = b != null ? b.getBorderInsets(this) : new Insets(0, 0, 0, 0);
            int x = insets.left;
            int y = insets.top;
            BorderPainter.paintBorder((Graphics)g, (int)x, (int)y, (int)this.getPreferredSize().width, (int)(this.getPreferredSize().height - 1), (int)0, (Color)Color.black, (int)this.topLineStyle, (int)this.bottomLineStyle, (int)this.leftLineStyle, (int)this.rightLineStyle, (int)this.topLineWidth, (int)this.bottomLineWidth, (int)this.leftLineWidth, (int)this.rightLineWidth, (Color)this.topLineColor, (Color)this.bottomLineColor, (Color)this.leftLineColor, (Color)this.rightLineColor);
        }
    }

    class TableCell {
        public ViewStyle a_viewStyle;
        public ViewFormat a_viewFormat;
        public boolean a_negativeRed;
        public int a_numberOrDate;
        public String a_patternString;
        public AttributeLabel a_attribute;
        private static final String Sep = ", ";

        public TableCell(ViewStyle vs, ViewFormat vf, boolean negativeRed, int numberOrDate, String patternString) {
            this.a_viewStyle = vs;
            this.a_viewFormat = vf;
            this.a_negativeRed = negativeRed;
            this.a_numberOrDate = numberOrDate;
            this.a_patternString = patternString;
            this.setAttributeLabel();
        }

        public void setAttributeLabel() {
            String string = "";
            this.a_attribute = new AttributeLabel(string);
            if (this.a_viewStyle != null) {
                string = string + this.a_viewStyle.getFontName() + Sep;
                string = string + this.a_viewStyle.getFontSize() + OptionsPanel.this.rBundle.getString("pt") + Sep;
                if (this.a_viewStyle.isFontBold()) {
                    string = string + OptionsPanel.this.rBundle.getString("Bold") + Sep;
                }
                if (this.a_viewStyle.isFontItalic()) {
                    string = string + OptionsPanel.this.rBundle.getString("Italic") + Sep;
                }
                this.a_attribute.label.setUnderline(this.a_viewStyle.isUnderline());
                this.a_attribute.label.setStrikeThrough(this.a_viewStyle.isStrikeThrough());
                this.a_attribute.label.setFont(this.a_viewStyle.getFont());
                this.a_attribute.setBackground(this.a_viewStyle.getBackground());
                this.a_attribute.label.setForeground(this.a_viewStyle.getForeground());
                this.a_attribute.label.setHorizontalAlignment(this.a_viewStyle.getHorizontalAlignment());
                this.a_attribute.setOutlineStyle(this.a_viewStyle.getBorderStyle(1), this.a_viewStyle.getBorderStyle(4), this.a_viewStyle.getBorderStyle(2), this.a_viewStyle.getBorderStyle(8));
                this.a_attribute.setOutlineColor(this.a_viewStyle.getBorderColor(1), this.a_viewStyle.getBorderColor(4), this.a_viewStyle.getBorderColor(2), this.a_viewStyle.getBorderColor(8));
                this.a_attribute.setOutlineWidth(this.a_viewStyle.isBorderWidthUsed(1) ? this.a_viewStyle.getBorderWidth(1) : 0, this.a_viewStyle.isBorderWidthUsed(4) ? this.a_viewStyle.getBorderWidth(4) : 0, this.a_viewStyle.isBorderWidthUsed(2) ? this.a_viewStyle.getBorderWidth(2) : 0, this.a_viewStyle.isBorderWidthUsed(8) ? this.a_viewStyle.getBorderWidth(8) : 0);
            }
            if (this.a_viewFormat != null) {
                String tmp = this.a_viewFormat.DoubleToString(1234567.0);
                string = string + MessageFormat.format(OptionsPanel.this.rBundle.getString("Number:"), tmp);
            }
            if (string.indexOf(Sep) != -1) {
                String subString = string.substring(string.length() - 2, string.length());
                if (subString != "" && subString.equals(Sep)) {
                    this.a_attribute.label.setText(string.substring(0, string.length() - 2));
                } else {
                    this.a_attribute.label.setText(string);
                }
            } else {
                this.a_attribute.label.setText(string);
            }
        }
    }

    private class FormatsTableModel
    extends DefaultTableModel {
        TableCell[] data;

        public FormatsTableModel() {
            Object[] row = new Object[2];
            row[0] = OptionsPanel.this.rBundle.getString("Default column header");
            this.addRow(row);
            row[0] = OptionsPanel.this.rBundle.getString("Default row header");
            this.addRow(row);
            row[0] = OptionsPanel.this.rBundle.getString("Default page control");
            this.addRow(row);
            row[0] = OptionsPanel.this.rBundle.getString("Default data cell");
            this.addRow(row);
            this._init();
        }

        public TableCell getTableCell(int row) {
            return this.data[row];
        }

        private void _init() {
            this.data = new TableCell[4];
            this.data[0] = new TableCell((ViewStyle)OptionsPanel.this.m_gridView.getColumnHeader().getViewStyle().clone(), null, false, -1, null);
            this.data[1] = new TableCell((ViewStyle)OptionsPanel.this.m_gridView.getRowHeader().getViewStyle().clone(), null, false, -1, null);
            this.data[2] = new TableCell((ViewStyle)OptionsPanel.this.m_gridView.getPagingControl().getViewStyle().clone(), null, false, -1, null);
            this.data[3] = new TableCell((ViewStyle)OptionsPanel.this.m_gridView.getDatabody().getViewStyle().clone(), (ViewFormat)OptionsPanel.this.m_gridView.getViewFormat().clone(), false, 0, null);
            if (OptionsPanel.this.m_gridView.getUIFormats() != null) {
                for (int i = 0; i < OptionsPanel.this.m_gridView.getUIFormats().size(); ++i) {
                    UIFormat tmpUIFormat = (UIFormat)OptionsPanel.this.m_gridView.getUIFormats().elementAt(i);
                    if (tmpUIFormat.getFormatType() != 1) continue;
                    this.data[3].a_negativeRed = tmpUIFormat.isNegativeRed();
                    this.data[3].a_numberOrDate = tmpUIFormat.getNumberOrDateCategory();
                    this.data[3].a_patternString = tmpUIFormat.getNumberOrDateFormatString();
                }
            }
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return OptionsPanel.this.rBundle.getString("FormatsColumn");
            }
            return OptionsPanel.this.rBundle.getString("AttributesColumn");
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 1) {
                return this.data[row].a_attribute;
            }
            return super.getValueAt(row, column);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }
    }

    private class FormatsTable
    extends JTable {
        public FormatsTable() {
            this.setBackground(Color.white);
            this.getTableHeader().setReorderingAllowed(false);
            this.setSelectionMode(0);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 9 && e.getID() == 401 && !e.isControlDown()) {
                int anchorRow = this.getSelectionModel().getAnchorSelectionIndex();
                int anchorColumn = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                if (anchorColumn == this.getColumnCount() - 1 && anchorRow == this.getRowCount() - 1 && !e.isShiftDown()) {
                    if (FocusManager.isFocusManagerEnabled()) {
                        FocusManager.getCurrentManager().focusNextComponent(this);
                        e.consume();
                    }
                    return;
                }
                if (anchorColumn == 0 && anchorRow == 0 && e.isShiftDown()) {
                    if (FocusManager.isFocusManagerEnabled()) {
                        FocusManager.getCurrentManager().focusPreviousComponent(this);
                        e.consume();
                    }
                    return;
                }
            }
            super.processKeyEvent(e);
        }
    }
}

