/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlmonitor.models;

import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.sqlmonitor.nodes.DetailTreeNode;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DetailTreeModel
extends AbstractTreeTableModel {
    protected Connection _conn;
    public String _sqlId;
    public int _sessionId;
    public int _sessionSerial;
    public String execution_started;
    public String last_refresh_time;
    public String execution_id;
    public String user_fetch_count;
    public String status;
    public String sql;
    public int cpu;
    public String _user;
    public String _osuser;
    public String _process;
    public String _machine;
    public String _program;
    public String _module;
    public String _client;
    private HashMap<String, String> _iowaits = new HashMap();
    public String _xml;
    private int _end;
    private String _status;
    ArrayList<DetailTreeNode> nodes = new ArrayList();

    public DetailTreeModel(Connection connection, String string, int n, int n2) {
        super((Object)new DetailTreeNode("..."));
        this._sqlId = string;
        this._sessionId = n;
        this._sessionSerial = n2;
        this._conn = connection;
        DetailTreeNode detailTreeNode = new DetailTreeNode();
        detailTreeNode.id = "0";
        detailTreeNode.operation = "...";
        this.root = detailTreeNode;
        this.loadXML();
    }

    public void updateContent(Connection connection, String string, int n, int n2) {
        this._end = 0;
        this.nodes = new ArrayList();
        this._sqlId = string;
        this._sessionId = n;
        this._sessionSerial = n2;
        this._conn = connection;
        this.loadXML();
    }

    public void refresh() {
        this.loadXML();
    }

    public void reset() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DetailTreeModel.this.fireTreeStructureChanged((Object)DetailTreeModel.this, new TreeNode[]{(TreeNode)DetailTreeModel.this.root}, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public String getXML() {
        if (this._xml == null) {
            this.loadXML();
        }
        return this._xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadXML() {
        Object object;
        if (this._conn == null) {
            return;
        }
        ((DetailTreeNode)this.root).removeAllChildren();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this._conn.prepareStatement("select dbms_sqltune.report_sql_monitor(sql_id=>?,session_id=>?,session_serial=>?,type=>'XML') from dual");
            preparedStatement.setString(1, this._sqlId);
            preparedStatement.setInt(2, this._sessionId);
            preparedStatement.setInt(3, this._sessionSerial);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getClob(1);
                this._xml = object.getSubString(1L, (int)object.length());
                this.parseXML();
            }
            preparedStatement = this._conn.prepareStatement("select username,schemaname,osuser,process,machine,program,module ,client_info from v$session where sid =? and serial# = ?");
            preparedStatement.setInt(1, this._sessionId);
            preparedStatement.setInt(2, this._sessionSerial);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this._user = resultSet.getString(1);
                this._osuser = resultSet.getString(3);
                this._process = resultSet.getString(4);
                this._machine = resultSet.getString(5);
                this._program = resultSet.getString(6);
                this._module = resultSet.getString(7);
                this._client = resultSet.getString(8);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        object = new Runnable(){

            @Override
            public void run() {
                DetailTreeModel.this.fireTreeStructureChanged((Object)DetailTreeModel.this, new TreeNode[]{(TreeNode)DetailTreeModel.this.root}, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            object.run();
        } else {
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseXML() {
        Object object;
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            if (this._xml == null) {
                return;
            }
            object = new InputSource(new StringReader(this._xml));
            dOMParser.parse((InputSource)object);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
        XMLDocument xMLDocument = dOMParser.getDocument();
        if (xMLDocument == null) return;
        object = xMLDocument.getElementsByTagName("sql_monitor_report");
        Node node = object.item(0);
        Object object2 = XMLHelper.getChildNode((Node)node, (String)"target");
        if (object2 != null) {
            Object object3;
            Object object4;
            Object object5;
            if (object2.getAttributes().getNamedItem("sql_exec_start") != null) {
                this.execution_started = object2.getAttributes().getNamedItem("sql_exec_start").getNodeValue();
            }
            this.last_refresh_time = XMLHelper.getNodeValue((Node)object2, (String)"last_refresh_time");
            this.status = XMLHelper.getNodeValue((Node)object2, (String)"status");
            if (object2.getAttributes().getNamedItem("sql_exec_id") != null) {
                this.execution_id = object2.getAttributes().getNamedItem("sql_exec_id").getNodeValue();
            }
            String string = XMLHelper.getNodeValue((Node)object2, (String)"duration");
            try {
                this._end = Integer.valueOf(string);
            }
            catch (Exception exception) {
                this._end = 0;
            }
            this._status = XMLHelper.getNodeValue((Node)object2, (String)"status");
            this.sql = XMLHelper.getNodeValue((Node)object2, (String)"sql_fulltext");
            Node node2 = XMLHelper.getChildNode((Node)node, (String)"stats");
            NodeList nodeList = node2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object5 = nodeList.item(i);
                String string2 = object5.getAttributes().getNamedItem("name").getNodeValue();
                object4 = object5.getTextContent();
                if (!string2.equals("user_fetch_count")) continue;
                this.user_fetch_count = object4;
            }
            Node node3 = XMLHelper.getChildNode((Node)node, (String)"activity_sampled");
            if (node3 != null) {
                object5 = node3.getChildNodes();
                for (int i = 0; i < object5.getLength(); ++i) {
                    object4 = object5.item(i);
                    if (object4.getAttributes().getNamedItem("class") == null) continue;
                    object3 = object4.getAttributes().getNamedItem("class").getNodeValue();
                    String string3 = object4.getTextContent();
                    if (((String)object3).equals("Cpu")) {
                        this.cpu = Integer.valueOf(string3);
                    }
                    if (!((String)object3).equals("User I/O")) continue;
                    this._iowaits.put((String)object3, string3);
                }
            }
            if ((object5 = XMLHelper.getChildNode((Node)node, (String)"plan_monitor")) == null) return;
            NodeList nodeList2 = object5.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                object3 = nodeList2.item(i);
                this.nodes.add(this.createNode((Node)object3));
            }
        }
        for (DetailTreeNode detailTreeNode : this.nodes) {
            if (detailTreeNode.pId == null) {
                this.root = detailTreeNode;
                continue;
            }
            object2 = this.nodes.get(Integer.valueOf(detailTreeNode.pId));
            ((DefaultMutableTreeNode)object2).add(detailTreeNode);
            detailTreeNode.parent = object2;
        }
    }

    private DetailTreeNode createNode(Node node) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Node node2;
        Node node3;
        DetailTreeNode detailTreeNode = new DetailTreeNode();
        detailTreeNode.id = node.getAttributes().getNamedItem("id").getNodeValue();
        if (node.getAttributes().getNamedItem("parent_id") != null) {
            detailTreeNode.pId = node.getAttributes().getNamedItem("parent_id").getNodeValue();
        }
        String string2 = node.getAttributes().getNamedItem("name").getNodeValue();
        if (node.getAttributes().getNamedItem("options") != null) {
            string2 = string2 + " (" + node.getAttributes().getNamedItem("options").getNodeValue() + ")";
        }
        detailTreeNode.operation = string2;
        Node node4 = XMLHelper.getChildNode((Node)node, (String)"object");
        if (node4 != null) {
            detailTreeNode.name = XMLHelper.getNodeValue((Node)node4, (String)"name");
        }
        if ((node3 = XMLHelper.getChildNode((Node)node, (String)"optimizer")) != null) {
            detailTreeNode.cost = XMLHelper.getNodeValue((Node)node3, (String)"cost");
            detailTreeNode.est_rows = XMLHelper.getNodeValue((Node)node3, (String)"cardinality");
        }
        if ((node2 = XMLHelper.getChildNode((Node)node, (String)"stats")) != null) {
            object3 = node2.getChildNodes();
            object2 = "0";
            String string3 = "0";
            object = "0";
            string = "0";
            for (int i = 0; i < object3.getLength(); ++i) {
                Node node5 = object3.item(i);
                String string4 = node5.getAttributes().getNamedItem("name").getNodeValue();
                String string5 = node5.getTextContent();
                if (string4.equals("cardinality")) {
                    detailTreeNode.actual_rows = string5;
                }
                if (string4.equals("starts")) {
                    detailTreeNode.executions = string5;
                }
                if (string4.equals("memory")) {
                    object2 = string5;
                }
                if (string4.equals("max_memory")) {
                    string3 = string5;
                }
                if (string4.equals("temp")) {
                    object = string5;
                }
                if (string4.equals("max_temp")) {
                    string = string5;
                }
                if (string4.equals("last_active")) {
                    detailTreeNode.active = string5.equals(this.last_refresh_time) && !this._status.startsWith("DONE");
                }
                if (string4.equals("from_sql_exec_start")) {
                    detailTreeNode.sec_from_start = Integer.valueOf(string5);
                }
                if (!string4.equals("duration")) continue;
                detailTreeNode.run_duration = Integer.valueOf(string5);
            }
            detailTreeNode.memory = (String)object2 + " / " + string3;
            detailTreeNode.temp = (String)object + " / " + string;
            detailTreeNode.total_duration = this._end;
            detailTreeNode.status = this._status;
        }
        if ((object3 = XMLHelper.getChildNode((Node)node, (String)"activity_sampled")) != null) {
            object2 = object3.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                object = object2.item(i);
                string = object.getAttributes().getNamedItem("class").getNodeValue();
                String string6 = object.getTextContent();
                if (!string.equals("Cpu")) continue;
                detailTreeNode.cpu = String.valueOf(this.cpu) + "/" + string6 + "/" + String.valueOf(DetailTreeModel.Round(Float.valueOf(string6).floatValue() / (float)this.cpu * 100.0f, 2));
            }
        }
        return detailTreeNode;
    }

    public static float Round(float f, int n) {
        float f2 = (float)Math.pow(10.0, n);
        float f3 = Math.round(f *= f2);
        return f3 / f2;
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public int getColumnCount() {
        return 10;
    }

    public String getColumnName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "OPERATION";
                break;
            }
            case 1: {
                string = "NAME";
                break;
            }
            case 2: {
                string = "ESTIMATED_ROWS";
                break;
            }
            case 3: {
                string = "COST";
                break;
            }
            case 4: {
                string = "TIMELINE";
                break;
            }
            case 5: {
                string = "EXECUTIONS";
                break;
            }
            case 6: {
                string = "ACTUAL_ROWS";
                break;
            }
            case 7: {
                string = "MEMORY/MEMORY(MAX)";
                break;
            }
            case 8: {
                string = "TEMP/TEMP(MAX)";
                break;
            }
            case 9: {
                string = "CPU";
                break;
            }
            case 10: {
                string = "WAIT";
                break;
            }
            default: {
                string = "INVALID";
            }
        }
        return string;
    }

    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object object, int n) {
        String string = this.getColumnName(n);
        return ((DetailTreeNode)object).getValue(string);
    }
}

