/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.validators;

import java.math.BigInteger;
import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.AbstractChildDBObjectValidator;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.db.validators.ValidationLevel;

public class FileSpecificationValidator
extends AbstractChildDBObjectValidator<FileSpecification> {
    private static Integer n1 = new Integer(1);

    public FileSpecificationValidator(DBObjectProvider dBObjectProvider) {
        super(dBObjectProvider);
    }

    @DBObjectValidator.PropertyValidator(value={"fileSize"}, level=ValidationLevel.FULL)
    public void validateFileSize(FileSpecification fileSpecification, FileSpecification fileSpecification2) throws ValidationException {
        Tablespace tablespace;
        Tablespace.TablespaceType tablespaceType;
        BigInteger bigInteger = fileSpecification2.getFileSize();
        if (bigInteger != null && bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new ValidationException((DBObject)fileSpecification2, APIBundle.format((String)"STORAGE_PROPERTY_ERROR_TOO_SMALL", (Object[])new Object[]{"File Size", n1}));
        }
        if (fileSpecification2.getParent() instanceof Tablespace && bigInteger == null && (tablespaceType = (Tablespace.TablespaceType)(tablespace = (Tablespace)fileSpecification2.getParent()).getProperty("TablespaceType")).equals((Object)Tablespace.TablespaceType.UNDO)) {
            throw new ValidationException((DBObject)fileSpecification2, APIBundle.get((String)"TABLESPACE_SIZE_ERROR"));
        }
    }

    protected Collection<String> listAlwaysValidProperties() {
        Collection collection = super.listAlwaysValidProperties();
        collection.add("reuse");
        collection.add("directory");
        collection.add("autoExtendProperties");
        collection.add(Property.createPath((String[])new String[]{"autoExtendProperties", "autoExtendOn"}));
        collection.add(Property.createPath((String[])new String[]{"autoExtendProperties", "nextSize"}));
        collection.add(Property.createPath((String[])new String[]{"autoExtendProperties", "maxSize"}));
        return collection;
    }
}

