/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sxml;

import java.util.logging.Level;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.ora.sxml.DataTypeSXMLGenerator;
import oracle.javatools.db.ora.sxml.SXMLFragmentGenerator;
import oracle.javatools.db.ora.sxml.SXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class ColumnSXMLGenerator
extends SXMLFragmentGenerator {
    @Override
    protected void populateNode(Node node, Document document, Object object) {
        block14: {
            block13: {
                if (!(object instanceof Table)) break block13;
                Table table = (Table)object;
                for (Column column : table.getColumns()) {
                    OracleColumnProperties oracleColumnProperties = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
                    if (oracleColumnProperties == null || oracleColumnProperties.getOwnedObjects().length <= 0) continue;
                    Node node2 = this.findOrCreateNodeBefore(document, node, "RELATIONAL_TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES", "PARALLEL");
                    Node node3 = this.findOrCreateNode(document, node2, "COL_LIST");
                    Node node4 = this.createNode(document, node3, "COL_LIST_ITEM");
                    Node node5 = this.findOrCreateNode(document, node4, "NAME");
                    node5.appendChild(document.createTextNode(column.getName()));
                    try {
                        DataTypeUsage dataTypeUsage = column.getDataTypeUsage();
                        DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                        if (dataType != null) {
                            Node node6 = this.findOrCreateNode(document, node4, "DATATYPE");
                            node6.appendChild(document.createTextNode(DataTypeSXMLGenerator.getDataTypeElementText(dataType, dataTypeUsage)));
                        }
                    }
                    catch (DBException dBException) {
                        DBLog.getLogger((Object)this).log(Level.SEVERE, "SXML - could not resolve datatype for column {0}: {1}", new Object[]{DBUtil.getFullyQualifiedName((DBObject)column), dBException.getMessage()});
                    }
                    this.getParentGenerator().populateNode(node4, document, oracleColumnProperties);
                }
                break block14;
            }
            if (!(object instanceof TablePartition)) break block14;
            TablePartition tablePartition = (TablePartition)object;
            for (LOBDescriptor lOBDescriptor : tablePartition.getLOBDescriptors()) {
                for (DBObjectID dBObjectID : lOBDescriptor.getColumns()) {
                    Object object2;
                    Column column = null;
                    try {
                        column = (Column)dBObjectID.resolveID();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    if (column == null) continue;
                    Node node7 = this.findOrCreateNodeBefore(document, node, "COLUMN_PROPERTIES/COL_LIST", "SUBPARTITION_LIST");
                    Node node8 = this.createNode(document, node7, "COL_LIST_ITEM");
                    Node node9 = this.findOrCreateNode(document, node8, "NAME");
                    node9.appendChild(document.createTextNode(column.getName()));
                    Node node10 = this.findOrCreateNode(document, node8, "DATATYPE");
                    DataType dataType = null;
                    try {
                        object2 = column.getDataTypeUsage();
                        dataType = DataTypeHelper.getDataType((DataTypeUsage)object2);
                        if (dataType != null) {
                            node10.appendChild(document.createTextNode(DataTypeSXMLGenerator.getDataTypeElementText(dataType, object2)));
                        }
                    }
                    catch (DBException dBException) {
                        dBException.printStackTrace();
                    }
                    object2 = null;
                    if (LOBDescriptor.isVARRAYColumn((Column)column)) {
                        Node node11 = this.findOrCreateNodeAfter(document, node8, "VARRAY_PROPERTIES", "DATATYPE");
                        Node node12 = this.createNode(document, node11, "STORE_AS");
                        node12.appendChild(document.createTextNode("LOB"));
                        object2 = this.createNode(document, node11, "LOB_PROPERTIES/STORAGE_TABLE");
                    } else {
                        object2 = this.findOrCreateNodeAfter(document, node8, "LOB_PROPERTIES/STORAGE_TABLE", "DATATYPE");
                    }
                    this.getParentGenerator().populateNode((Node)object2, document, lOBDescriptor);
                }
            }
        }
    }

    @Override
    protected void readNode(Node node, Object object) {
        SXMLReader sXMLReader = (SXMLReader)this.getParentGenerator();
        if (object instanceof Table) {
            Table table = (Table)object;
            Node node2 = this.findNode(node, "RELATIONAL_TABLE/TABLE_PROPERTIES/COLUMN_PROPERTIES/COL_LIST");
            if (node2 != null) {
                SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node2);
                while (childXMLElementIterator2.hasNext()) {
                    Node node3 = (Node)childXMLElementIterator2.next();
                    String string = this.nodeText(node3, "NAME");
                    Column column = table.getColumn(string);
                    OracleColumnProperties oracleColumnProperties = new OracleColumnProperties();
                    column.setProperty("OracleColumnProperties", (Object)oracleColumnProperties);
                    sXMLReader.fillInObject(oracleColumnProperties, node3, null);
                    if (!this.nodeExists(node3, "XMLTYPE_PROPERTIES/ELEMENT")) continue;
                    String string2 = this.getXmlSchemaOwningSchemaName(node, string);
                    String string3 = this.nodeText(node3, "XMLTYPE_PROPERTIES/XMLSCHEMA");
                    String string4 = this.nodeText(node3, "XMLTYPE_PROPERTIES/ELEMENT");
                    NameBasedID nameBasedID = new NameBasedID("XML SCHEMA", string2, string3);
                    NameBasedID nameBasedID2 = new NameBasedID("XMLSchemaElement", string4, (DBObjectID)nameBasedID);
                    oracleColumnProperties.getXMLTypeColumnProperties().setElementID((DBObjectID)nameBasedID2);
                }
            }
        } else if (object instanceof TablePartition) {
            boolean bl = false;
        }
    }

    private String getXmlSchemaOwningSchemaName(Node node, String string) {
        String string2 = null;
        Node node2 = this.findNode(node, "RELATIONAL_TABLE/COL_LIST");
        if (node2 != null) {
            SXMLFragmentGenerator.childXMLElementIterator childXMLElementIterator2 = new SXMLFragmentGenerator.childXMLElementIterator(node2);
            while (childXMLElementIterator2.hasNext()) {
                Node node3 = (Node)childXMLElementIterator2.next();
                String string3 = this.nodeText(node3, "NAME");
                if (!string3.equals(string)) continue;
                string2 = this.nodeText(node3, "CUSTOMER_AREA/ODB_PROPERTY_LIST/XMLTYPE_COLUMN_XMLSCHEMA_OWNER");
                break;
            }
        }
        return string2;
    }
}

