/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.ModelObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class ModelBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        ModelObject modelObject = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "model_clause")) {
            ModelObject modelObject2 = new ModelObject();
            List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            for (int i = 1; i < list.size(); ++i) {
                ParseNode parseNode2 = list.get(i);
                if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "cell_reference_options")) {
                    ModelObject.CellReferenceOptions cellReferenceOptions = this.buildCellReferenceOptions(parseNode2, expressionContext);
                    modelObject2.setCellReferenceOptions(cellReferenceOptions);
                    continue;
                }
                if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "return_rows_clause")) {
                    this.addReturnRowsClause(modelObject2, parseNode2, expressionContext);
                    continue;
                }
                if (oracleSQLQueryBuilderHelper.isRule(parseNode2, "reference_model")) {
                    this.addReferenceModel(modelObject2, parseNode2, expressionContext);
                    continue;
                }
                if (!oracleSQLQueryBuilderHelper.isRule(parseNode2, "main_model")) continue;
                this.addMainModel(modelObject2, parseNode2, expressionContext);
                break;
            }
            modelObject = modelObject2;
        }
        return modelObject;
    }

    private ModelObject.CellReferenceOptions buildCellReferenceOptions(ParseNode parseNode, ExpressionContext expressionContext) {
        ModelObject.CellReferenceOptions cellReferenceOptions = new ModelObject.CellReferenceOptions();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        for (ParseNode parseNode2 : oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode)) {
            if (oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "IGNORE")) {
                cellReferenceOptions.setIgnoreNav(true);
                continue;
            }
            if (oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "KEEP")) {
                cellReferenceOptions.setKeepNav(true);
                continue;
            }
            if (oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "DIMENSION")) {
                cellReferenceOptions.setUniqueDimension(true);
                continue;
            }
            if (!oracleSQLQueryBuilderHelper.isKeyword(parseNode2, "SINGLE")) continue;
            cellReferenceOptions.setUniqueSingleReference(true);
        }
        return cellReferenceOptions;
    }

    private void addReturnRowsClause(ModelObject modelObject, ParseNode parseNode, ExpressionContext expressionContext) {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(1), "UPDATED")) {
            modelObject.setReturnUpdatedRows(true);
        } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(1), "ALL")) {
            modelObject.setReturnAllRows(true);
        }
    }

    private void addReferenceModel(ModelObject modelObject, ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        throw new SQLQueryException("Cannot handle reference_model clause");
    }

    private void addMainModel(ModelObject modelObject, ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        String string;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        int n = 0;
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(n), "MAIN")) {
            string = oracleSQLQueryBuilderHelper.getContent(list.get(n + 1));
            modelObject.setMainModelName(string);
            n += 2;
        }
        this.addModelColumnClauses(modelObject, list.get(n), expressionContext);
        if (oracleSQLQueryBuilderHelper.isRule(list.get(++n), "cell_reference_options")) {
            string = this.buildCellReferenceOptions(list.get(n), expressionContext);
            ++n;
            modelObject.setMainModelCellReferenceOptions((SQLFragment)string);
        }
        this.addModelRulesClause(modelObject, list.get(n), expressionContext);
    }

    private void addModelColumnClauses(ModelObject modelObject, ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        ModelObject.ModelColumnClauses modelColumnClauses = new ModelObject.ModelColumnClauses();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        Object var7_7 = null;
        if (oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "PARTITION")) {
            SQLFragment sQLFragment = expressionContext.createFragment(list.get(2), (SQLFragment)modelObject);
            modelColumnClauses.setPartitionByExpressionList(sQLFragment);
        }
        int n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "DIMENSION");
        SQLFragment sQLFragment = this.buildExpressionList(list, n + 2, expressionContext);
        modelColumnClauses.setDimensionByExpressionList(sQLFragment);
        n = oracleSQLQueryBuilderHelper.getKeywordIndex(list, "MEASURES");
        SQLFragment sQLFragment2 = this.buildExpressionList(list, n + 1, expressionContext);
        modelColumnClauses.setMeasuresExpressionList(sQLFragment2);
        modelObject.setModelColumnClauses((SQLFragment)modelColumnClauses);
    }

    private SQLFragment buildExpressionList(List<ParseNode> list, int n, ExpressionContext expressionContext) throws SQLQueryException {
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        int n2 = oracleSQLQueryBuilderHelper.getKeywordIndex(list, n, ")");
        List<List<ParseNode>> list2 = oracleSQLQueryBuilderHelper.getCommaSeparatedList(list.subList(n + 1, n2));
        ExpressionList expressionList = expressionContext.createExpressionList(list2, null);
        return expressionList;
    }

    private void addModelRulesClause(ModelObject modelObject, ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        SQLFragment sQLFragment;
        Object object;
        List<Object> list;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list2 = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
        ModelObject.ModelRulesClause modelRulesClause = new ModelObject.ModelRulesClause();
        int n = 0;
        if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(n), "RULES")) {
            modelRulesClause.setRulesPresent(true);
            if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(++n), "UPDATE")) {
                ++n;
                modelRulesClause.setRulesUpdate(true);
            } else if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(n), "UPSERT")) {
                modelRulesClause.setRulesUpsert(true);
                if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(++n), "ALL")) {
                    ++n;
                    modelRulesClause.setRulesAll(true);
                }
            }
            if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(n), "AUTOMATIC")) {
                n += 2;
                modelRulesClause.setAutomatic(true);
                modelRulesClause.setOrder(true);
            } else if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(n), "SEQUENTIAL")) {
                n += 2;
                modelRulesClause.setSequential(true);
                modelRulesClause.setOrder(true);
            }
            if (oracleSQLQueryBuilderHelper.isRule(list2.get(n), "model_iterate_clause")) {
                list = oracleSQLQueryBuilderHelper.getOrderedChildren(list2.get(n));
                ++n;
                object = oracleSQLQueryBuilderHelper.getContent((ParseNode)list.get(2));
                modelRulesClause.setIterateNumber((String)object);
                if (list.size() > 5 && oracleSQLQueryBuilderHelper.isKeyword((ParseNode)list.get(4), "UNTIL")) {
                    sQLFragment = expressionContext.createFragment((ParseNode)list.get(6), (SQLFragment)modelObject);
                    modelRulesClause.setUntilCondition(sQLFragment);
                }
            }
        }
        list = new ArrayList();
        while (!oracleSQLQueryBuilderHelper.isKeyword(list2.get(n), ")")) {
            SQLFragment sQLFragment2;
            if (!oracleSQLQueryBuilderHelper.isKeyword(list2.get(n), "(", ",")) {
                throw new SQLQueryException("Failed to find expected '(' or ',' in model_rules_clause");
            }
            object = new ModelObject.ModelRulesCellAssignmentExpr();
            if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(++n), "UPDATE")) {
                ++n;
                object.setUpdate(true);
            } else if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(n), "UPSERT")) {
                object.setUpsert(true);
                if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(++n), "ALL")) {
                    ++n;
                    object.setAll(true);
                }
            }
            sQLFragment = expressionContext.createFragment(list2.get(n), null);
            object.setModelRulesCellAssignment(sQLFragment);
            if (oracleSQLQueryBuilderHelper.isKeyword(list2.get(++n), "=")) {
                ++n;
            } else {
                sQLFragment2 = expressionContext.createFragment(list2.get(n), (SQLFragment)object);
                if (sQLFragment2 == null) {
                    throw new SQLQueryException("Failed to find expected order_by_clause in model_rules_clause");
                }
                object.setOrderBy(sQLFragment2);
                n += 2;
            }
            sQLFragment2 = expressionContext.createFragment(list2.get(n), (SQLFragment)object);
            if (sQLFragment2 == null) {
                throw new SQLQueryException("Failed to find expected expr in model_rules_clause");
            }
            ++n;
            object.setExpr(sQLFragment2);
            list.add(object);
        }
        object = new ExpressionList(list.toArray(new SQLFragment[list.size()]));
        modelRulesClause.setCellAssignmentExprs(object);
        modelObject.setModelRulesClause((SQLFragment)modelRulesClause);
    }
}

