/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;

public class GroupByExpressionBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        GroupByExpression groupByExpression;
        ExpressionList expressionList = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "expression_list")) {
            expressionList = new ExpressionList();
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "rollup_cube_clause")) {
            groupByExpression = new GroupByExpression();
            expressionList = groupByExpression;
            List<ParseNode> list = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            if (oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "ROLLUP")) {
                groupByExpression.setGroupByType(GroupByExpression.GroupingType.ROLLUP);
            } else if (oracleSQLQueryBuilderHelper.isKeyword(list.get(0), "CUBE")) {
                groupByExpression.setGroupByType(GroupByExpression.GroupingType.CUBE);
            }
        } else if (oracleSQLQueryBuilderHelper.isRule(parseNode, "grouping_sets_clause")) {
            groupByExpression = new GroupByExpression();
            expressionList = groupByExpression;
            groupByExpression.setGroupByType(GroupByExpression.GroupingType.GROUPING_SETS);
        }
        if (expressionList != null) {
            SQLFragment[] sQLFragmentArray;
            groupByExpression = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode);
            boolean bl = false;
            ParseNode parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)groupByExpression, "grouping_expression_list");
            if (parseNode2 == null) {
                parseNode2 = oracleSQLQueryBuilderHelper.getRuleNode((List<ParseNode>)groupByExpression, "\"expr_list\"");
            }
            if (parseNode2 != null) {
                sQLFragmentArray = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode2);
                bl = oracleSQLQueryBuilderHelper.isKeyword((ParseNode)sQLFragmentArray.get(0), "(");
            }
            if ((sQLFragmentArray = expressionContext.getArgList(expressionList, parseNode2)).length == 1 && sQLFragmentArray[0] instanceof ExpressionList && oracleSQLQueryBuilderHelper.isRule(parseNode, "rollup_cube_clause")) {
                sQLFragmentArray = ((ExpressionList)sQLFragmentArray[0]).getArguments();
            }
            if (expressionList instanceof GroupByExpression) {
                if (bl) {
                    sQLFragmentArray = new SQLFragment[]{new ExpressionList(sQLFragmentArray)};
                }
                ((GroupByExpression)expressionList).setArguments(sQLFragmentArray);
            } else {
                expressionList.setArguments(sQLFragmentArray);
            }
        }
        return expressionList;
    }
}

