/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.parser.ParseNode;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.ora.sql.ExpressionContext;
import oracle.javatools.db.ora.sql.ExpressionFactory;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilder;
import oracle.javatools.db.ora.sql.OracleSQLQueryBuilderHelper;
import oracle.javatools.db.ora.sql.UnrecognizedFragmentException;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionUsage;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLCallable;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SequenceUsage;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.WithClauseUsage;
import oracle.javatools.util.ModelUtil;

public class ColumnBuilder
extends ExpressionFactory {
    @Override
    public SQLFragment createFragment(ExpressionContext expressionContext, ParseNode parseNode) throws SQLQueryException {
        SQLFragment sQLFragment;
        SQLQueryException sQLQueryException;
        block9: {
            sQLQueryException = null;
            sQLFragment = null;
            OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
            if (oracleSQLQueryBuilderHelper.isLeaf(parseNode) || oracleSQLQueryBuilderHelper.isDotSeperatedList(parseNode) || oracleSQLQueryBuilderHelper.isRule(parseNode, "column", "col_oj")) {
                Object object = expressionContext.getQueryContext();
                if (object instanceof String && "MAKE_REF".equalsIgnoreCase((String)object)) {
                    sQLFragment = this.createColumnUsage(parseNode, expressionContext);
                } else {
                    try {
                        sQLFragment = this.createColumnUsage(parseNode, expressionContext);
                    }
                    catch (SQLQueryCancelledException sQLQueryCancelledException) {
                        throw sQLQueryCancelledException;
                    }
                    catch (SQLQueryException sQLQueryException2) {
                        sQLQueryException = sQLQueryException2;
                        sQLFragment = this.createFunctionUsageFromSqlColdef(parseNode, expressionContext);
                        if (sQLFragment != null) break block9;
                        List<ParseNode> list = oracleSQLQueryBuilderHelper.getDotSeparatedList(parseNode);
                        StringBuilder stringBuilder = new StringBuilder();
                        for (ParseNode parseNode2 : list) {
                            if (stringBuilder.length() != 0) {
                                stringBuilder.append(".");
                            }
                            stringBuilder.append(oracleSQLQueryBuilderHelper.getContent(parseNode2));
                        }
                        sQLFragment = expressionContext.getQueryBuilder().createFromFactory(expressionContext.getCreating(), stringBuilder.toString(), oracleSQLQueryBuilderHelper.getNodeStartOffset(parseNode));
                    }
                }
            }
        }
        if (sQLQueryException != null && sQLFragment == null) {
            throw sQLQueryException;
        }
        return sQLFragment;
    }

    private FunctionUsage createFunctionUsageFromSqlColdef(ParseNode parseNode, ExpressionContext expressionContext) {
        FunctionUsage functionUsage = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        List<ParseNode> list = oracleSQLQueryBuilderHelper.getDotSeparatedList(parseNode);
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        for (ParseNode object2 : list) {
            if (oracleSQLQueryBuilderHelper.isLeaf(object2)) continue;
            bl = false;
            break;
        }
        if (bl) {
            DBObjectID dBObjectID;
            if (list.size() >= 3) {
                string = oracleSQLQueryBuilderHelper.getContent(list.get(0));
                list.remove(0);
            }
            if (list.size() >= 2) {
                string2 = oracleSQLQueryBuilderHelper.getContent(list.get(0));
                list.remove(0);
            }
            if (list.size() >= 1) {
                string3 = oracleSQLQueryBuilderHelper.getContent(list.get(0));
                list.remove(0);
            }
            ArrayList arrayList = new ArrayList();
            for (ParseNode parseNode2 : list) {
                arrayList.add(oracleSQLQueryBuilderHelper.getContent(parseNode2));
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (ModelUtil.hasLength((String)string)) {
                stringBuilder.append(".").append(string);
            }
            if (ModelUtil.hasLength((String)string2)) {
                stringBuilder.append(".").append(string2);
            }
            if (ModelUtil.hasLength((String)string3)) {
                stringBuilder.append(".").append(string3);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    stringBuilder.append(".").append(string4);
                }
            }
            if ((dBObjectID = expressionContext.findIdForFunctionString(stringBuilder.substring(1))) != null && !(dBObjectID instanceof ReferenceID)) {
                functionUsage = new FunctionUsage();
                functionUsage.setObjectID(dBObjectID);
            }
        }
        return functionUsage;
    }

    private SQLFragment createColumnUsage(ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        SQLFragment sQLFragment;
        ColumnKeywordUsage columnKeywordUsage;
        String string;
        ColumnKeywordUsage columnKeywordUsage2 = null;
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        OracleSQLQueryBuilder oracleSQLQueryBuilder = expressionContext.getQueryBuilder();
        SQLFragment sQLFragment2 = expressionContext.getCreating();
        boolean bl = false;
        if (oracleSQLQueryBuilderHelper.isRule(parseNode, "col_oj")) {
            bl = true;
            parseNode = oracleSQLQueryBuilderHelper.getOrderedChildren(parseNode).get(0);
        }
        List<String> list = this.getBits(parseNode, expressionContext);
        ArrayList<String> arrayList = new ArrayList<String>(list);
        int n = 0;
        FromObject fromObject = sQLFragment2 instanceof FromObject ? (FromObject)sQLFragment2 : null;
        FromObject fromObject2 = null;
        String string2 = null;
        if (list.size() > 1) {
            ++n;
            string2 = list.remove(0);
            fromObject2 = expressionContext.findFromObject(string2, fromObject);
            if (fromObject2 == null && list.size() > 0 && (fromObject2 = expressionContext.findFromObject(string2 = string2 + "." + list.get(0), fromObject)) != null) {
                ++n;
                list.remove(0);
            }
            if (fromObject2 == null) {
                DBObjectProvider dBObjectProvider;
                string = expressionContext.getDefaultSchemaName();
                columnKeywordUsage = null;
                sQLFragment = null;
                for (String object2 : arrayList) {
                    dBObjectProvider = expressionContext.getProvider();
                    sQLFragment = new ReferenceID("UNSPECIFIED_TYPE", string, dBObjectProvider.getInternalName(object2));
                    sQLFragment.setParent((DBObjectID)columnKeywordUsage);
                    sQLFragment.setProvider(dBObjectProvider);
                    string = null;
                    columnKeywordUsage = sQLFragment;
                }
                if (sQLFragment != null) {
                    DBObject dBObject = null;
                    try {
                        dBObject = sQLFragment.resolveID();
                    }
                    catch (DBException dBException) {
                        dBObject = null;
                    }
                    if (dBObject instanceof SQLCallable) {
                        FunctionUsage functionUsage = new FunctionUsage();
                        functionUsage.setObjectID(dBObject.getID());
                        columnKeywordUsage2 = functionUsage;
                    } else {
                        String string3 = sQLFragment.getName();
                        if (dBObject == null && arrayList.size() >= 2 && ("NEXTVAL".equals(string3) || "CURRVAL".equals(string3))) {
                            try {
                                dBObject = sQLFragment.getParent().resolveID();
                                if (dBObject instanceof Sequence) {
                                    dBObjectProvider = new SequenceUsage();
                                    dBObjectProvider.setObjectID(dBObject.getID());
                                    dBObjectProvider.setMode(SequenceUsage.Mode.valueOf((String)string3));
                                    columnKeywordUsage2 = dBObjectProvider;
                                }
                            }
                            catch (DBException dBException) {
                                dBObject = null;
                            }
                        }
                    }
                }
            }
            if (fromObject2 == null && columnKeywordUsage2 == null) {
                oracleSQLQueryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_FIND_FROM", (Object[])new Object[]{string2})));
            }
        }
        if (columnKeywordUsage2 == null) {
            string = list.remove(0);
            columnKeywordUsage = null;
            if ("*".equals(string)) {
                columnKeywordUsage = new ColumnKeywordUsage(string, fromObject2);
            } else if (fromObject2 == null) {
                columnKeywordUsage = oracleSQLQueryBuilder.findColumnInFromObjects(string, true, sQLFragment2, fromObject);
                if (columnKeywordUsage == null) {
                    if (sQLFragment2 instanceof OrderByObject) {
                        sQLFragment = expressionContext.getProvider().getDescriptor();
                        for (SelectObject selectObject : expressionContext.getQuery().getSelectObjects()) {
                            String string4 = selectObject.getUsableAlias();
                            if (string4 == null || !sQLFragment.areNamesEqual(string, string4, "COLUMN", true)) continue;
                            oracleSQLQueryBuilder.ensureID((DBObject)selectObject);
                            columnKeywordUsage = new SelectObjectUsage(selectObject, null);
                            break;
                        }
                    }
                    if (columnKeywordUsage == null) {
                        oracleSQLQueryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_CANT_RESOLVE_COL", (Object[])new Object[]{string})));
                    }
                }
            } else {
                oracleSQLQueryBuilder.ensureID((DBObject)fromObject2);
                sQLFragment = fromObject2.getExpression();
                boolean bl2 = false;
                if (sQLFragment instanceof WithClauseUsage) {
                    FromObject fromObject3 = ((WithClauseUsage)sQLFragment).resolveFromObject();
                    sQLFragment = fromObject3.getExpression();
                    bl2 = true;
                }
                if (sQLFragment instanceof RelationUsage) {
                    columnKeywordUsage = oracleSQLQueryBuilder.findColumnInRelation(string, true, (RelationUsage)sQLFragment);
                    if (columnKeywordUsage == null) {
                        oracleSQLQueryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_ON_REL", (Object[])new Object[]{string, string2})));
                    }
                } else if (sQLFragment instanceof SQLQuery) {
                    SQLQuery sQLQuery = (SQLQuery)sQLFragment;
                    columnKeywordUsage = oracleSQLQueryBuilder.findColumnInSubQuery(string, true, sQLQuery);
                    if (columnKeywordUsage == null) {
                        columnKeywordUsage = oracleSQLQueryBuilder.findColumnInStarSubQuery(string, true, fromObject2);
                    }
                    if (columnKeywordUsage == null) {
                        oracleSQLQueryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_IN_QUERY", (Object[])new Object[]{string})));
                    } else if (bl2) {
                        columnKeywordUsage.setFromObjectID(fromObject2.getID());
                    }
                } else if (sQLFragment instanceof SynonymUsage) {
                    SchemaObject schemaObject = ((SynonymUsage)sQLFragment).getReferencedObject();
                    if (schemaObject instanceof Relation) {
                        columnKeywordUsage = oracleSQLQueryBuilder.findColumnInRelation(string, true, (Relation)schemaObject);
                    }
                    if (columnKeywordUsage == null) {
                        oracleSQLQueryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_NO_COL_ON_SYN", (Object[])new Object[]{string, string2})));
                    } else {
                        columnKeywordUsage.setFromObjectID(fromObject2.getID());
                    }
                } else {
                    columnKeywordUsage = oracleSQLQueryBuilder.findColumnInFromExpression(string, true, sQLFragment, false, fromObject2, sQLFragment2);
                    if (columnKeywordUsage == null) {
                        oracleSQLQueryBuilder.throwException(new SQLQueryException(APIBundle.format((String)"SQL_MISSING_COL", (Object[])new Object[]{string, string2})));
                    }
                }
            }
            columnKeywordUsage.setQualified(n > 0);
            if (columnKeywordUsage instanceof ColumnUsage) {
                if (list.size() > 0) {
                    ((ColumnUsage)columnKeywordUsage).setAttributes(list.toArray(new String[list.size()]));
                }
                if (bl) {
                    ((ColumnUsage)columnKeywordUsage).setOuterJoin(true);
                }
            }
            columnKeywordUsage2 = columnKeywordUsage;
        }
        return columnKeywordUsage2;
    }

    private List<String> getBits(ParseNode parseNode, ExpressionContext expressionContext) throws SQLQueryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        OracleSQLQueryBuilderHelper oracleSQLQueryBuilderHelper = expressionContext.getHelper();
        if (oracleSQLQueryBuilderHelper.isLeaf(parseNode)) {
            arrayList.add(oracleSQLQueryBuilderHelper.getContent(parseNode));
        } else if (oracleSQLQueryBuilderHelper.isDotSeperatedList(parseNode)) {
            List<ParseNode> list = oracleSQLQueryBuilderHelper.getDotSeparatedList(parseNode);
            for (ParseNode parseNode2 : list) {
                if (oracleSQLQueryBuilderHelper.isLeaf(parseNode2)) {
                    arrayList.add(oracleSQLQueryBuilderHelper.getContent(parseNode2));
                    continue;
                }
                arrayList.addAll(this.getBits(parseNode2, expressionContext));
            }
        } else {
            String string = parseNode.toString();
            String string2 = oracleSQLQueryBuilderHelper.getSourceFragment(parseNode);
            DBLog.getLogger((Object)this).fine("OracleSQLQueryBuilder: Node cannot be built - Unrecognized SQL fragment\n Rules: " + string + "\n Source fragment: " + string2);
            throw new UnrecognizedFragmentException(oracleSQLQueryBuilderHelper.getSourceFragment(parseNode));
        }
        return arrayList;
    }
}

