/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.javatools.db.AbstractIncrementer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ddl.BundleDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.ora.OracleTablespaceUtil;
import oracle.javatools.db.ora.ddl.OracleDDLSupport;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

public class OracleDDLGenerator
extends BundleDDLGenerator<OracleDDLType> {
    private final int m_version;

    public OracleDDLGenerator(Class<? extends OracleDatabase> clazz, DBObjectProvider dBObjectProvider) {
        this(clazz, OracleDatabaseDescriptor.getDatabaseVersion(clazz), dBObjectProvider);
    }

    public OracleDDLGenerator(Class<? extends OracleDatabase> clazz, int n, DBObjectProvider dBObjectProvider) {
        super(clazz, dBObjectProvider, OracleDDLSupport.getInstance().getBundles(clazz, n));
        this.registerTokens();
        this.m_version = n;
    }

    protected OracleDDLType getDDLType(String string) {
        return OracleDDLType.getDDLType((String)string);
    }

    private int getDatabaseVersion() {
        return this.m_version;
    }

    protected void registerTokens() {
        this.registerSimpleDropDDL("FUNCTION");
        this.registerSimpleDropDDL("SEQUENCE");
        this.registerSimpleDropDDL("MATERIALIZED VIEW");
        this.registerSimpleDropDDL("PROCEDURE");
        this.registerSimpleDropDDL("TRIGGER");
        this.registerSimpleDropDDL("PACKAGE");
        this.registerSimpleDropDDL("PACKAGE BODY");
        this.registerSimpleDropDDL("TYPE BODY");
        for (Map.Entry<String, TokenGenerator> entry : OracleDDLSupport.getInstance().getGlobalTokenGenerators().entrySet()) {
            this.registerTokenGenerator(entry.getKey(), entry.getValue());
        }
        this.registerTopLevelChild("TABLE", "indexes", "INDEX");
        this.registerTopLevelChild("MATERIALIZED VIEW", "indexes", "INDEX");
    }

    protected final void registerSimpleDropDDL(String string) {
        this.registerDropDDL(string, OracleDDLSupport.getInstance().getSimpleDropDDL(), (DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.DROP));
    }

    protected DDL<OracleDDLType> finish(DDLOptions dDLOptions, DDL<OracleDDLType> dDL) {
        String string;
        if (dDL != null) {
            dDL.remove((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.NOOP));
        }
        if (ModelUtil.hasLength((String)(string = dDLOptions.getSpoolFile())) && dDL != null && dDL.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON)).isEmpty()) {
            dDL.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLON), MessageFormat.format("SPOOL {0}\n", string));
            dDL.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SPOOLOFF), "SPOOL OFF");
        }
        if (!(!dDLOptions.isSqlBlankLines() || dDL == null || dDL.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.CMT)).isEmpty() && dDL.get((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.CMC)).isEmpty())) {
            dDL.append((DDLType)OracleDDLType.getDDLType((OracleStatementType)OracleStatementType.SET_SQLBLANKLINES_ON), "SET SQLBLANKLINES ON");
        }
        return super.finish(dDLOptions, dDL);
    }

    public boolean supportsProperty(Class<? extends DBObject> clazz, String string) {
        boolean bl = super.supportsProperty(clazz, string);
        if (Table.class.isAssignableFrom(clazz) && "PARTITIONED TABLE".equals(Property.stripProperties((String)string))) {
            bl = this.supportsProperty(clazz, "OracleTablePartitions");
        }
        return bl;
    }

    public boolean canCreateProperty(SystemObject systemObject, String string) {
        boolean bl = super.canCreateProperty(systemObject, string);
        if (bl) {
            string = Property.stripProperties((String)string);
            if (systemObject instanceof Tablespace) {
                Tablespace tablespace = (Tablespace)systemObject;
                Tablespace.TablespaceType tablespaceType = (Tablespace.TablespaceType)tablespace.getProperty("TablespaceType");
                Tablespace.TablespaceType tablespaceType2 = OracleTablespaceUtil.getTypeSpecificProperties().get(string);
                if (tablespaceType2 != null) {
                    boolean bl2 = bl = tablespaceType2 == tablespaceType;
                    if (bl && string.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties"}))) {
                        OracleTablespaceProperties oracleTablespaceProperties = (OracleTablespaceProperties)tablespace.getProperty("OracleTablespaceProperties");
                        bl = oracleTablespaceProperties == null || oracleTablespaceProperties.getExtentManagementType() != OracleTablespaceProperties.ExtentManagementType.LOCAL;
                    }
                } else if (string.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"})) || string.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "uniformSize"}))) {
                    OracleTablespaceProperties oracleTablespaceProperties = (OracleTablespaceProperties)tablespace.getProperty("OracleTablespaceProperties");
                    bl = oracleTablespaceProperties != null && oracleTablespaceProperties.getExtentManagementType() == OracleTablespaceProperties.ExtentManagementType.LOCAL;
                }
            } else if (systemObject instanceof Table) {
                Table table = (Table)systemObject;
                Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
                if (string.contains("OracleInMemoryProperties") || string.contains("OracleInMemoryColumnProperties")) {
                    bl = tableType == Table.TableType.NORMAL;
                } else if (string.endsWith("virtualExpressionSource")) {
                    bl = tableType.equals((Object)Table.TableType.NORMAL);
                } else if (string.equals(Property.createPath((String[])new String[]{"OracleTableProperties", "tableCompression"}))) {
                    bl = tableType == Table.TableType.NORMAL;
                } else if (string.startsWith("OracleExternalTableProperties")) {
                    bl = tableType == Table.TableType.EXTERNAL;
                } else if (string.startsWith("OracleIndexOrganizedTableProperties")) {
                    bl = tableType == Table.TableType.INDEX_ORGANIZED;
                } else if (string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions"}))) {
                    OracleTablePartitions.PartitionType partitionType;
                    OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)systemObject.getProperty("OracleTablePartitions");
                    OracleTablePartitions.PartitionType partitionType2 = partitionType = oracleTablePartitions == null ? null : oracleTablePartitions.getPartitionType();
                    if (string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "referenceConstraintID"}))) {
                        bl = partitionType == OracleTablePartitions.PartitionType.REFERENCE;
                    } else if (string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionColumns"}))) {
                        bl = partitionType != null && partitionType != OracleTablePartitions.PartitionType.REFERENCE;
                    } else if (string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionType"})) || string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionColumns"}))) {
                        bl = partitionType != null && partitionType != OracleTablePartitions.PartitionType.REFERENCE && partitionType != OracleTablePartitions.PartitionType.HASH;
                    } else if (string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitions", "values"})) || string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitions", "valuesLessThan"}))) {
                        bl = partitionType != OracleTablePartitions.PartitionType.REFERENCE;
                    } else if (string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitions", "segmentAttributes"}))) {
                        bl = partitionType != OracleTablePartitions.PartitionType.HASH || string.endsWith("tablespaceID") || string.endsWith("segmentAttributes");
                    } else if (string.startsWith(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitions", "segmentAttributes"}))) {
                        OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions.getSubpartitionModel();
                        bl = oracleTablePartitions2 == null || string.endsWith("tablespaceID") || string.endsWith("segmentAttributes");
                    }
                } else if (tableType == Table.TableType.EXTERNAL) {
                    if (string.startsWith("constraints") || string.startsWith("indexes") || string.startsWith("OracleTablePartitions") || string.startsWith("OracleStorageProperties") || string.equals("Comment") || string.equals(Property.createPath((String[])new String[]{"columns", "notNull"})) || string.equals(Property.createPath((String[])new String[]{"columns", "default"})) || string.equals(Property.createPath((String[])new String[]{"columns", "Comment"}))) {
                        bl = false;
                    }
                } else if (tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
                    if (string.startsWith("OracleTablePartitions")) {
                        bl = false;
                    } else if (string.startsWith("OracleStorageProperties")) {
                        bl = this.getDatabaseVersion() >= 110 ? string.equals("OracleStorageProperties") || string.equals(Property.createPath((String[])new String[]{"OracleStorageProperties", "tablespaceID"})) : false;
                    }
                }
            } else if (systemObject instanceof Index) {
                Index index = (Index)systemObject;
                Index.IndexType indexType = index.getIndexType();
                if (string.equals("reverse")) {
                    Table table = index.getTable();
                    bl = table != null && table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED ? false : indexType == Index.IndexType.NORMAL || indexType == Index.IndexType.UNIQUE;
                } else if (string.equals("domainIndextype") || string.equals("domainIndextypeParameters")) {
                    bl = indexType == Index.IndexType.DOMAIN;
                } else if (string.equals("keyCompression")) {
                    if (indexType == Index.IndexType.DOMAIN || indexType == Index.IndexType.BITMAP) {
                        bl = false;
                    }
                } else if (string.startsWith(Property.createPath((String[])new String[]{"OracleIndexPartitions", "partitions", "subpartitions", "partitions", "segmentAttributes"}))) {
                    bl = string.endsWith("segmentAttributes") || string.endsWith("tablespaceID");
                }
            }
        } else if (systemObject instanceof Table && "PARTITIONED TABLE".equals(string)) {
            bl = this.canCreateProperty(systemObject, "OracleTablePartitions");
        }
        return bl;
    }

    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        Collection<Object> collection = null;
        int n = this.getDatabaseVersion();
        String string2 = Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionType"});
        if (dBObject2 instanceof Relation && string.equals(string2)) {
            OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)dBObject2.getProperty("OracleTablePartitions");
            collection = oracleTablePartitions != null ? this.getSubPartitionTypes() : Collections.emptyList();
        } else if (dBObject2 instanceof Relation && string.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionType"}))) {
            DBObject dBObject3 = dBObject2.getParent();
            if (dBObject3 instanceof OracleTablePartitions) {
                collection = this.getSubPartitionTypes();
            } else {
                ArrayList arrayList = new ArrayList();
                arrayList.add(OracleTablePartitions.PartitionType.HASH);
                arrayList.add(OracleTablePartitions.PartitionType.LIST);
                arrayList.add(OracleTablePartitions.PartitionType.RANGE);
                if (n >= 110 && !(dBObject2 instanceof MaterializedView) && dBObject2.getProperty("TableType") != Table.TableType.INDEX_ORGANIZED) {
                    arrayList.add(OracleTablePartitions.PartitionType.REFERENCE);
                }
                collection = arrayList;
            }
        } else if (string.equals("LOBCache")) {
            Table table = (Table)DBUtil.findParentOfType((DBObject)dBObject2, Table.class);
            if (table != null && table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
                collection = Arrays.asList(LOBDescriptor.LOBCache.NOCACHE, LOBDescriptor.LOBCache.CACHE_READS);
            }
        } else if (string.equals("onDeleteAction")) {
            collection = Arrays.asList(FKConstraint.ReferentialAction.NO_ACTION, FKConstraint.ReferentialAction.CASCADE, FKConstraint.ReferentialAction.SET_NULL);
        } else if ((dBObject2 instanceof Tablespace || dBObject2 instanceof OracleTablespaceProperties) && dBObject == null && Property.getLastProperty((String)string).equals("onlineStatus")) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(null);
            arrayList.add(OracleTablespaceProperties.OnlineStatus.ONLINE);
            arrayList.add(OracleTablespaceProperties.OnlineStatus.OFFLINE);
            collection = arrayList;
        } else {
            String string3 = Property.getLastProperty((String)string);
            if ("tableCompression".equals(string3) || "defaultTableCompression".equals(string3)) {
                ArrayList arrayList = new ArrayList();
                if (dBObject == null) {
                    arrayList.add(null);
                }
                arrayList.add(OracleTableProperties.OracleTableCompression.NOCOMPRESS);
                arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS);
                if (n == 110) {
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS);
                } else if (n == 112) {
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
                } else if (n >= 120) {
                    arrayList.add(OracleTableProperties.OracleTableCompression.ROW_STORE_COMPRESS_ADVANCED);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_ROW_LEVEL_LOCKING);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_LOW_ROW_LEVEL_LOCKING);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_QUERY_HIGH_ROW_LEVEL_LOCKING);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_LOW_ROW_LEVEL_LOCKING);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
                    arrayList.add(OracleTableProperties.OracleTableCompression.COLUMN_STORE_COMPRESS_FOR_ARCHIVE_HIGH_ROW_LEVEL_LOCKING);
                }
                collection = arrayList;
            } else if ("constraintType".equals(string3)) {
                Relation relation = (Relation)DBUtil.findParentOfType((DBObject)dBObject2, Relation.class);
                Object object = relation == null ? null : relation.getProperty("TableType");
                boolean bl = object == Table.TableType.TRANSACTION_TEMP || object == Table.TableType.SESSION_TEMP;
                ArrayList arrayList = new ArrayList();
                arrayList.add("PKConstraint");
                arrayList.add("UniqueConstraint");
                arrayList.add("CheckConstraint");
                if (!bl) {
                    arrayList.add("FKConstraint");
                }
                collection = arrayList;
            } else if ("accessDriverType".equals(string3)) {
                ArrayList arrayList = new ArrayList();
                arrayList.add("ORACLE_LOADER");
                arrayList.add("ORACLE_DATAPUMP");
                if (n >= 12102) {
                    arrayList.add("ORACLE_BIGDATA");
                    arrayList.add("ORACLE_HIVE");
                    arrayList.add("ORACLE_HDFS");
                }
                collection = arrayList;
            }
        }
        if (collection == null) {
            collection = super.getAllowedPropertyValues(dBObject, dBObject2, string);
        }
        return collection;
    }

    public Collection<String> getRestrictingProperties(Class<? extends SystemObject> clazz, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Table.class.isAssignableFrom(clazz)) {
            boolean bl = clazz.equals(Table.class);
            if (bl && (string.equals("Comment") || string.startsWith("OracleStorageProperties") || string.startsWith("OracleTableProperties"))) {
                arrayList.add("TableType");
            } else if (bl && string.equals(Property.createPath((String[])new String[]{"OracleExternalTableProperties", "accessParameters"}))) {
                arrayList.add(Property.createPath((String[])new String[]{"OracleExternalTableProperties", "accessDriverType"}));
            } else if (string.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionColumns"})) || string.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "referenceConstraintID"})) || string.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionColumns"})) || string.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionType"})) || string.equals(Property.createPath((String[])new String[]{"OracleTablePartitions", "subpartitionModel", "partitionColumns"}))) {
                arrayList.add(Property.createPath((String[])new String[]{"OracleTablePartitions", "partitionType"}));
            }
        } else if (clazz.equals(Index.class)) {
            if (string.equals("reverse") || string.equals("keyCompression") || string.equals("domainIndextype") || string.equals("domainIndextypeParameters")) {
                arrayList.add("indexType");
            } else if (string.equals(Property.createPath((String[])new String[]{"OracleIndexPartitions", "globalPartitionColumns"}))) {
                arrayList.add("columnExpressions");
            }
        } else if (clazz.equals(Tablespace.class)) {
            if (OracleTablespaceUtil.getTypeSpecificProperties().containsKey(string)) {
                arrayList.add("TablespaceType");
            }
            if (string.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "OracleStorageProperties"})) || string.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "autoAllocate"})) || string.equals(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "uniformSize"}))) {
                arrayList.add(Property.createPath((String[])new String[]{"OracleTablespaceProperties", "extentManagementType"}));
            }
        }
        return arrayList;
    }

    private Collection<OracleTablePartitions.PartitionType> getSubPartitionTypes() {
        ArrayList<OracleTablePartitions.PartitionType> arrayList = new ArrayList<OracleTablePartitions.PartitionType>();
        int n = this.getDatabaseVersion();
        arrayList.add(OracleTablePartitions.PartitionType.HASH);
        arrayList.add(OracleTablePartitions.PartitionType.LIST);
        if (n >= 110) {
            arrayList.add(OracleTablePartitions.PartitionType.RANGE);
        }
        return arrayList;
    }

    protected boolean canCreate(Class<? extends SystemObject> clazz, String string) {
        boolean bl = super.canCreate(clazz, string);
        if (!bl) {
            if (Table.class.isAssignableFrom(clazz) && Property.stripProperties((String)string).equals("PARTITIONED TABLE")) {
                bl = this.canCreate(clazz, "OracleTablePartitions");
            } else if (Table.class.equals(clazz)) {
                bl = this.isSupportedColumnSequenceProperty(string, "columns");
            }
        }
        return bl;
    }

    protected boolean canChangeWithAlter(SystemObject systemObject, SystemObject systemObject2, String string) {
        boolean bl = super.canChangeWithAlter(systemObject, systemObject2, string);
        if (bl && systemObject2 instanceof MaterializedViewLog) {
            MaterializedViewLog materializedViewLog = (MaterializedViewLog)systemObject2;
            if ("objectIdLogged".equals(string) && Boolean.FALSE.equals(materializedViewLog.getObjectIdLogged()) || "primaryKeyLogged".equals(string) && Boolean.FALSE.equals(materializedViewLog.getPrimaryKeyLogged()) || "rowidLogged".equals(string) && Boolean.FALSE.equals(materializedViewLog.getRowidLogged()) || "sequenceLogged".equals(string) && Boolean.FALSE.equals(materializedViewLog.getSequenceLogged())) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean isSupportedColumnSequenceProperty(String string, String string2) {
        String[] stringArray;
        String string3 = null;
        if (string2 == null) {
            string3 = string;
        } else if (string2 != null && (stringArray = Property.getProperties((String)string)).length == 2 && string2.equals(stringArray[0])) {
            string3 = stringArray[1];
        }
        return string3 != null && "AUTO_GENERATED_SEQUENCE".equals(string3) || "AUTO_GENERATED_SEQUENCE_TRIGGER".equals(string3) || "ColumnSequenceExpander.TriggerNullCheck".equals(string3);
    }

    public Object getImplicitDefaultValue(DBObject dBObject, String string) {
        Object object = null;
        if (dBObject instanceof MaterializedView && "Comment".equals(Property.stripProperties((String)string))) {
            object = "snapshot table for snapshot " + DBUtil.getFullyQualifiedName((DBObject)dBObject, (boolean)true);
        } else if (dBObject instanceof AbstractIncrementer) {
            if ("maxValue".equals(string)) {
                int n = this.getDatabaseVersion();
                object = n >= 111 ? new BigInteger("9999999999999999999999999999") : new BigInteger("999999999999999999999999999");
            } else if ("minValue".equals(string)) {
                object = BigInteger.ONE;
            }
        }
        return object;
    }

    protected Nullable.NullBehaviour getNullBehaviour(PropertyInfo propertyInfo, boolean bl) {
        String string = propertyInfo.getPropertyName();
        Nullable.NullBehaviour nullBehaviour = "startWith".equals(string) ? Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE : (this.isSupportedColumnSequenceProperty(string, null) ? Nullable.NullBehaviour.NULL_MEANS_NOT_SPECIFIED_AND_IGNORE : super.getNullBehaviour(propertyInfo, bl));
        return nullBehaviour;
    }
}

