/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.View;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleRelationBuilder;
import oracle.javatools.db.sql.SQLQuery;

public class OracleViewBuilder
extends OracleRelationBuilder<View> {
    protected OracleViewBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "VIEW");
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"SQLQuery", "restriction"})
    public void fillInQueryText(final View view) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)view, "SELECT /*OracleDictionaryQueries.ALL_VIEW_TEXT_QUERY*/\n       TEXT_LENGTH, TEXT FROM SYS.ALL_VIEWS WHERE OWNER = ? AND VIEW_NAME = ?", view.getSchema(), view);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        int n = resultSet.getInt(1);
                        String string = resultSet.getString(2);
                        if (string != null) {
                            if ((string = string.trim()).toUpperCase().trim().endsWith(View.Restriction.CHECK_OPTION.toString())) {
                                view.setRestriction(View.Restriction.CHECK_OPTION);
                                string = string.substring(0, string.toUpperCase().lastIndexOf("WITH") - 1);
                            } else if (string.toUpperCase().trim().endsWith(View.Restriction.READ_ONLY.toString())) {
                                view.setRestriction(View.Restriction.READ_ONLY);
                                string = string.substring(0, string.toUpperCase().lastIndexOf("WITH") - 1);
                            }
                            SQLQuery sQLQuery = (SQLQuery)OracleViewBuilder.this.newObject(SQLQuery.class, null);
                            sQLQuery.setQueryString(string);
                            view.setSQLQuery(sQLQuery);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)view, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @Override
    @AbstractDBObjectBuilder.PropertyBuilder(value={"constraints"})
    public void fillInConstraints(View view) throws DBException {
        super.fillInConstraints(view);
    }

    protected boolean canBuildComponents() {
        return true;
    }
}

