/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.resource.APIBundle;

public class OracleTablespaceBuilder
extends OracleDBObjectBuilder<Tablespace> {
    private static final String ENABLED = "ENABLED";
    private static final String DIRECT_LOAD_OPERATIONS = "DIRECT LOAD ONLY";
    private static final String ALL_OPERATIONS = "FOR ALL OPERATIONS";
    private static final String OLTP = "OLTP";
    private static final String BASIC = "BASIC";
    private static final String QUERY_LOW = "QUERY LOW";
    private static final String QUERY_HIGH = "QUERY HIGH";
    private static final String ARCHIVE_LOW = "ARCHIVE LOW";
    private static final String ARCHIVE_HIGH = "ARCHIVE HIGH";
    private static final String AUTO = "AUTO";
    private static final String LOGGING = "LOGGING";
    private static final String NO = "NO";
    private static final String YES = "YES";
    private static final String ONLINE = "ONLINE";
    private static final String OFFLINE = "OFFLINE";
    private static final String AVAILABLE = "AVAILABLE";
    private static final String NOGUARANTEE = "NOGUARANTEE";
    private static final String GUARANTEE = "GUARANTEE";
    private static final String UNIFORM = "UNIFORM";
    private static final String TEMPORARY = "TEMPORARY";
    private static final String UNDO = "UNDO";
    private static final String PERMANENT = "PERMANENT";
    private static final String DICTIONARY = "DICTIONARY";
    private static final String LOCAL = "LOCAL";

    public OracleTablespaceBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "TABLESPACE");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"TablespaceType", "OracleTablespaceProperties", "fileType"})
    public void buildTablespace(final Tablespace tablespace) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)tablespace, this.getTablespaceQuery(), tablespace);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        OracleTablespaceBuilder.this.fillInTablespaceProps(resultSet, tablespace);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)tablespace, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    private OracleTablespaceProperties fillInTablespaceProps(ResultSet resultSet, Tablespace tablespace) throws SQLException {
        Object object;
        OracleTablespaceProperties.ExtentManagementType extentManagementType;
        BaseOracleDatabase baseOracleDatabase = this.getDatabase();
        OracleTablespaceProperties.ExtentManagementType extentManagementType2 = extentManagementType = LOCAL.equals(resultSet.getString(12)) ? OracleTablespaceProperties.ExtentManagementType.LOCAL : OracleTablespaceProperties.ExtentManagementType.DICTIONARY;
        if (resultSet.getString(1).equals(NO)) {
            tablespace.setFileType(Tablespace.FileType.SMALLFILE);
        } else {
            tablespace.setFileType(Tablespace.FileType.BIGFILE);
        }
        String string = resultSet.getString(2);
        Tablespace.TablespaceType tablespaceType = string.equals(TEMPORARY) ? Tablespace.TablespaceType.TEMPORARY : (string.equals(UNDO) ? Tablespace.TablespaceType.UNDO : Tablespace.TablespaceType.PERMANENT);
        tablespace.setProperty("TablespaceType", (Object)tablespaceType);
        string = new OracleTablespaceProperties();
        int n = resultSet.getInt(3);
        string.setBlockSize(resultSet.wasNull() ? null : Integer.valueOf(n));
        if (tablespaceType == Tablespace.TablespaceType.PERMANENT) {
            String string2;
            if (extentManagementType == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
                int n2 = resultSet.getInt(3);
                string.setMinExtent(resultSet.wasNull() ? null : Integer.valueOf(n2));
            }
            if (((String)(object = resultSet.getString(5))).equals(ENABLED)) {
                string2 = resultSet.getString(6);
                if (string2 == null || string2.equals(BASIC)) {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS);
                } else if (string2.equals(DIRECT_LOAD_OPERATIONS)) {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_DIRECT_LOAD_OPERATIONS);
                } else if (string2.equals(ALL_OPERATIONS)) {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ALL_OPERATIONS);
                } else if (string2.equals(OLTP)) {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_OLTP);
                } else if (string2.equals(QUERY_LOW)) {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_LOW);
                } else if (string2.equals(QUERY_HIGH)) {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_QUERY_HIGH);
                } else if (string2.equals(ARCHIVE_LOW)) {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_LOW);
                } else {
                    string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.COMPRESS_FOR_ARCHIVE_HIGH);
                }
            } else {
                string.setDefaultTableCompression(OracleTableProperties.OracleTableCompression.NOCOMPRESS);
            }
            OracleTableBuilder.fillInMemoryProperties((DBObject)string, resultSet, baseOracleDatabase);
            string.setSegmentManagement(resultSet.getString(7).equals(AUTO) ? OracleTablespaceProperties.SegmentManagement.AUTO : OracleTablespaceProperties.SegmentManagement.MANUAL);
            string.setLogging(resultSet.getString(8).equals(LOGGING) ? OracleTablespaceProperties.LoggingType.LOGGING : OracleTablespaceProperties.LoggingType.NOLOGGING);
            string.setForceLogging(!resultSet.getString(9).equals(NO));
            string2 = resultSet.getString(10);
            if (string2.equals(ONLINE)) {
                string.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.ONLINE);
            } else if (string2.equals(OFFLINE)) {
                string.setOnlineStatus(OracleTablespaceProperties.OnlineStatus.OFFLINE);
            }
        }
        if (tablespaceType == Tablespace.TablespaceType.UNDO) {
            object = resultSet.getString(11);
            if (((String)object).equals(NOGUARANTEE)) {
                string.setRetention(OracleTablespaceProperties.RetentionType.NOGUARANTEE);
            } else if (((String)object).equals(GUARANTEE)) {
                string.setRetention(OracleTablespaceProperties.RetentionType.GUARANTEE);
            }
        }
        if (tablespaceType == Tablespace.TablespaceType.TEMPORARY) {
            baseOracleDatabase.setOracleBuilder(string, new OTPBuilder(baseOracleDatabase));
        }
        string.setExtentManagementType(extentManagementType);
        string.setAutoAllocate(!resultSet.getString(13).equals(UNIFORM));
        if (extentManagementType == OracleTablespaceProperties.ExtentManagementType.DICTIONARY) {
            this.fillInStorageProps(resultSet, (OracleTablespaceProperties)string);
        }
        if (!string.isAutoAllocate() && (object = resultSet.getBigDecimal(15)) != null) {
            string.setUniformSize(((BigDecimal)object).toBigInteger());
        }
        tablespace.setProperty("OracleTablespaceProperties", (Object)string);
        return string;
    }

    private void fillInStorageProps(ResultSet resultSet, OracleTablespaceProperties oracleTablespaceProperties) throws SQLException {
        if (Tablespace.TablespaceType.PERMANENT == oracleTablespaceProperties.getParent().getProperty("TablespaceType")) {
            BigInteger bigInteger;
            OracleStorageProperties oracleStorageProperties = new OracleStorageProperties();
            BigDecimal bigDecimal = resultSet.getBigDecimal(14);
            oracleStorageProperties.setInitialExtent(bigDecimal == null ? null : bigDecimal.toBigInteger());
            BigDecimal bigDecimal2 = resultSet.getBigDecimal(15);
            oracleStorageProperties.setNextExtent(bigDecimal2 == null ? null : bigDecimal2.toBigInteger());
            BigDecimal bigDecimal3 = resultSet.getBigDecimal(16);
            oracleStorageProperties.setMinExtent(bigDecimal3 == null ? null : bigDecimal3.toBigInteger());
            BigDecimal bigDecimal4 = resultSet.getBigDecimal(17);
            BigInteger bigInteger2 = bigInteger = bigDecimal4 == null ? null : bigDecimal4.toBigInteger();
            if (bigInteger != null && bigInteger.equals(OracleTableBuilder.MAXEXTENTS_UNLIMITED)) {
                bigInteger = BigInteger.ZERO;
            }
            oracleStorageProperties.setMaxExtent(bigInteger);
            int n = resultSet.getInt(18);
            oracleStorageProperties.setPercentIncrease(resultSet.wasNull() ? null : Integer.valueOf(n));
            oracleTablespaceProperties.setProperty("OracleStorageProperties", (Object)oracleStorageProperties);
        }
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"fileSpecifications"}, depends={"OracleTablespaceProperties"})
    public void fillInDataFiles(final Tablespace tablespace) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)tablespace, "SELECT /*OracleDictionaryQueries.DBA_TABLESPACE_DATA_FILES_QUERY*/ \n       FILE_NAME,      BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      STATUS\nFROM   SYS.DBA_DATA_FILES\nWHERE  TABLESPACE_NAME = ?\nUNION\nSELECT FILE_NAME, BYTES\n,      MAXBYTES\n,      AUTOEXTENSIBLE\n,      INCREMENT_BY\n,      STATUS\nFROM   SYS.DBA_TEMP_FILES\nWHERE  TABLESPACE_NAME = ?", tablespace, tablespace);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        Object object;
                        Object object2;
                        FileSpecification fileSpecification = new FileSpecification();
                        String string = resultSet.getString(1);
                        if (string.indexOf("\\") != -1) {
                            fileSpecification.setDirectory(string.substring(0, string.lastIndexOf("\\")));
                            fileSpecification.setName(string.substring(string.lastIndexOf("\\") + 1, string.length()));
                        } else if (string.indexOf("/") != -1) {
                            fileSpecification.setDirectory(string.substring(0, string.lastIndexOf("/")));
                            fileSpecification.setName(string.substring(string.lastIndexOf("/") + 1, string.length()));
                        } else {
                            fileSpecification.setName(string);
                        }
                        BigDecimal bigDecimal = resultSet.getBigDecimal(2);
                        if (bigDecimal != null && !resultSet.wasNull()) {
                            fileSpecification.setFileSize(bigDecimal.toBigInteger());
                        }
                        AutoExtendProperties autoExtendProperties = new AutoExtendProperties();
                        String string2 = resultSet.getString(4);
                        if (string2 != null && string2.equals(OracleTablespaceBuilder.YES)) {
                            object2 = resultSet.getBigDecimal(3);
                            autoExtendProperties.setMaxSize(object2 == null ? null : ((BigDecimal)object2).toBigInteger());
                            object = (OracleTablespaceProperties)tablespace.getProperty("OracleTablespaceProperties");
                            Integer n = object.getBlockSize();
                            BigDecimal bigDecimal2 = resultSet.getBigDecimal(5);
                            if (n != null) {
                                bigDecimal2 = bigDecimal2.multiply(BigDecimal.valueOf(n.intValue()));
                            }
                            autoExtendProperties.setNextSize(bigDecimal2 == null ? null : bigDecimal2.toBigInteger());
                            autoExtendProperties.setAutoExtendOn(true);
                        } else {
                            autoExtendProperties.setAutoExtendOn(false);
                        }
                        fileSpecification.setAutoExtendProperties(autoExtendProperties);
                        object2 = resultSet.getString(6);
                        object = OracleTablespaceBuilder.AVAILABLE.equals(object2) || OracleTablespaceBuilder.ONLINE.equals(object2) ? FileSpecification.FileStatus.ONLINE : (OracleTablespaceBuilder.OFFLINE.equals(object2) ? FileSpecification.FileStatus.OFFLINE : null);
                        fileSpecification.setStatus(object);
                        fileSpecification.setID((DBObjectID)new NameBasedID((DBObject)fileSpecification, tablespace.getID()));
                        tablespace.addFileSpecification(fileSpecification);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)tablespace, sQLException);
                }
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBSQLException dBSQLException) {
            Throwable throwable = dBSQLException.getCause();
            if (throwable instanceof SQLException && ((SQLException)throwable).getErrorCode() == 942) {
                this.getLogger().warning(APIBundle.format((String)"TABLESPACE_FILESPEC_LOAD_ERR", (Object[])new Object[]{tablespace.getName(), dBSQLException.getMessage()}));
            }
            throw dBSQLException;
        }
    }

    private String getTablespaceQuery() {
        String string = null;
        String string2 = this.getDatabase().getDatabaseType();
        int n = this.getDatabase().getDatabaseVersion();
        string = "Oracle Lite".equals(string2) || n <= 92 ? "SELECT NULL\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      NULL\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?" : (n >= 12102 ? "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\n/* In-Memory Properties */\n,      UT.DEF_INMEMORY\n,      UT.DEF_INMEMORY_COMPRESSION\n,      UT.DEF_INMEMORY_PRIORITY\n,      UT.DEF_INMEMORY_DUPLICATE\n,      UT.DEF_INMEMORY_DISTRIBUTE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?" : (n >= 110 ? "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      UT.COMPRESS_FOR\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT \nWHERE   UT.TABLESPACE_NAME = ?" : "SELECT UT.BIGFILE\n,      UT.CONTENTS\n,      UT.BLOCK_SIZE\n,      UT.MIN_EXTLEN\n,      UT.DEF_TAB_COMPRESSION\n,      NULL\n,      UT.SEGMENT_SPACE_MANAGEMENT\n,      UT.LOGGING\n,      UT.FORCE_LOGGING\n,      UT.STATUS\n,      UT.RETENTION\n/* Extent Management Properties */\n,      UT.EXTENT_MANAGEMENT\n,      UT.ALLOCATION_TYPE\n/* Storage Properties */\n,      UT.INITIAL_EXTENT\n,      UT.NEXT_EXTENT\n,      UT.MIN_EXTENTS\n,      UT.MAX_EXTENTS\n,      UT.PCT_INCREASE\nFROM  SYS.USER_TABLESPACES UT\nWHERE UT.TABLESPACE_NAME = ?"));
        return string;
    }

    public static class OTPBuilder
    extends OracleDBObjectBuilder<OracleTablespaceProperties> {
        OTPBuilder(BaseOracleDatabase baseOracleDatabase) {
            super(baseOracleDatabase, "OracleTablespaceProperties");
        }

        protected boolean canBuildComponents() {
            return true;
        }

        @AbstractDBObjectBuilder.PropertyBuilder(value={"tablespaceGroup"}, depends={"TablespaceType"})
        public void buildTablespaceGroup(OracleTablespaceProperties oracleTablespaceProperties) throws DBException {
            Tablespace tablespace = (Tablespace)oracleTablespaceProperties.getParent();
            QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)tablespace, "SELECT /*OracleDictionaryQueries.DBA_TABLESPACE_GROUP_QUERY*/ \ngroup_name FROM sys.dba_tablespace_groups WHERE tablespace_name = ?", tablespace);
            try {
                oracleTablespaceProperties.setTablespaceGroup(queryWrapper.executeSingleCellQuery());
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (throwable instanceof SQLException && ((SQLException)throwable).getErrorCode() == 942) {
                    this.getLogger().fine("Could not build tablespaceGroup");
                }
                throw dBException;
            }
        }
    }
}

