/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.compilation.CompilationErrorInfo;
import oracle.javatools.db.compilation.CompilationResults;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.PlSqlWrapper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.IndextypeBuilder;
import oracle.javatools.db.ora.OracleTriggerBuilder;
import oracle.javatools.db.ora.PlSqlSourceBuilder;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.parser.PlSqlParserFactory;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.jdbc.OracleConnection;

public class OracleDatabaseImpl
extends BaseOracleDatabase {
    protected static final String CTXSYS = "CTXSYS";
    protected static final String EFXSYS = "EFXSYS";
    protected static final String MDSYS = "MDSYS";
    protected static final String ORDSYS = "ORDSYS";
    protected static final String SYS = "SYS";
    protected static final String XDB = "XDB";
    private static final Map<String, MultiMap<String, Indextype>> s_builtinIndextypes = new HashMap<String, MultiMap<String, Indextype>>();
    private final Map<DBObjectID, Collection<String>> m_objPrivMap = new DBObjectIDMap(true);
    private static final String ERRORS_QUERY = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY*/\n       A.OWNER, A.TYPE, A.NAME,        A.LINE, A.POSITION, REPLACE(A.TEXT, CHR(10), ' ') TEXT, 'ERROR' ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ";
    private static final String ERRORS_QUERY_10G = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY_10G*/\n       A.OWNER, A.TYPE, A.NAME,        A.LINE, A.POSITION, REPLACE(A.TEXT, CHR(10), ' ') TEXT, A.ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ";
    private static final String SET_WARNINGS_FLAG = "BEGIN /*OracleDatabaseImpl.ALL_SET_WARNINGS_FLAG*/\n       DBMS_WARNING.ADD_WARNING_SETTING_CAT( ?, ? , ? ); END;";
    private static final String ENABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_ENABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = TRUE";
    private static final String DISABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_DISABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = FALSE";
    private static final String TEST_SQL_STMT = "declare cols integer; cid  integer; tab dbms_sql.desc_tab;begin cid := dbms_sql.open_cursor; dbms_sql.parse(cid,?,dbms_sql.native); dbms_sql.describe_columns(cid,cols,tab); dbms_sql.close_cursor(cid);exception when others then ? := dbms_sql.last_error_position; ? := sqlerrm; dbms_sql.close_cursor(cid);end;";
    private static String s_api_version = null;
    private Boolean m_partitioning;
    private Boolean m_debugInfo;
    private String m_compatibleLevel;

    OracleDatabaseImpl(String string, String string2, Connection connection, int n) {
        super(string, string2, connection, "Oracle Database", n);
    }

    protected Boolean isConnectionClosedImpl(SQLException sQLException, Connection connection) {
        int n;
        Boolean bl = this.implementsInterface(connection, "oracle.ucp.jdbc.ValidConnection") ? Boolean.valueOf(sQLException != null && sQLException.getErrorCode() == 31) : (connection instanceof OracleConnection && !this.implementsInterface(connection, "weblogic.jdbc.extensions.WLConnection") ? (sQLException == null ? Boolean.valueOf(false) : Boolean.valueOf((n = sQLException.getErrorCode()) == 17008 || n == 2396 || n == 2399 || n == 1012)) : super.isConnectionClosedImpl(sQLException, connection));
        return bl;
    }

    private boolean implementsInterface(Connection connection, String string) {
        boolean bl = false;
        block0: for (Class<?> clazz = connection.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!clazz2.getName().equals(string)) continue;
                bl = true;
                break block0;
            }
        }
        return bl;
    }

    @Override
    public void clearAllCaches() {
        super.clearAllCaches();
        this.m_partitioning = null;
        this.m_debugInfo = null;
    }

    protected void reconnected(Connection connection) {
        super.reconnected(connection);
        this.setSQLTraceOnIfReqd(connection);
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean hasObjectPrivilege(SystemObject systemObject, String string) {
        if (systemObject != null && string != null) {
            Object object;
            String string2;
            Schema schema;
            if (systemObject instanceof SchemaObject) {
                schema = ((SchemaObject)systemObject).getSchema();
                string2 = schema == null ? null : schema.getName();
            } else {
                schema = null;
                string2 = SYS;
            }
            if (this.hasSystemPrivilege(systemObject.getType(), schema, string)) {
                return true;
            }
            Collection<String> collection = this.m_objPrivMap.get(systemObject.getID());
            if (collection == null) {
                object = new ArrayList<String>();
                collection = object;
                this.m_objPrivMap.put(systemObject.getID(), collection);
                QueryWrapper queryWrapper = this.newQueryWrapper(systemObject, "SELECT /*OracleDictionaryQueries.OBJECT_ALTER_CHECK*/ \n       PRIVILEGE \nFROM SYS.ALL_TAB_PRIVS\nWHERE TABLE_SCHEMA = ?\nAND TABLE_NAME = ?\nAND GRANTEE IN (SELECT USER FROM SYS.DUAL\n                UNION ALL\n                SELECT 'PUBLIC' FROM SYS.DUAL\n                UNION ALL\n                SELECT ROLE FROM SYS.SESSION_ROLES)", string2, systemObject.getName());
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable((Collection)object, queryWrapper){
                    final /* synthetic */ Collection val$privs;
                    final /* synthetic */ QueryWrapper val$privsWrap;
                    {
                        this.val$privs = collection;
                        this.val$privsWrap = queryWrapper;
                    }

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            while (resultSet.next()) {
                                this.val$privs.add(resultSet.getString(1));
                            }
                        }
                        catch (SQLException sQLException) {
                            this.val$privsWrap.throwDBException(sQLException);
                        }
                    }
                };
                try {
                    queryWrapper.executeQuery(queryRunnable);
                }
                catch (DBException dBException) {
                    this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getConnectionName(), dBException.getMessage()}));
                }
            }
            object = "MODIFY".equals(string) ? "ALTER" : string;
            return collection.contains(object);
        }
        return false;
    }

    public boolean supportsPartitioning() {
        if (this.m_partitioning == null) {
            QueryWrapper queryWrapper = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.ALL_PARTITIONING_QUERY*/\n       VALUE FROM V$OPTION WHERE PARAMETER='Partitioning'", new Object[0]);
            try {
                this.m_partitioning = Boolean.valueOf(queryWrapper.executeSingleCellQuery());
            }
            catch (DBException dBException) {
                this.getLogger().warning(APIBundle.format((String)"PARTITION_CHECK_ERR", (Object[])new Object[]{this.getConnectionName(), dBException.getMessage()}));
                if (dBException instanceof CancelledException) {
                    return false;
                }
                this.m_partitioning = Boolean.FALSE;
            }
        }
        return this.m_partitioning;
    }

    public String getCompatibleLevel() {
        block3: {
            if (this.m_compatibleLevel == null) {
                QueryWrapper queryWrapper = this.newQueryWrapper(null, "SELECT /*OracleDictionaryQueries.COMPATIBILITY_QUERY*/ value FROM database_compatible_level", new Object[0]);
                try {
                    this.m_compatibleLevel = queryWrapper.executeSingleCellQuery();
                }
                catch (DBException dBException) {
                    this.getLogger().warning(APIBundle.format((String)"COMPATIBLE_LEVEL_ERR", (Object[])new Object[]{this.getConnectionName(), dBException.getMessage()}));
                    if (dBException instanceof CancelledException) break block3;
                    this.m_compatibleLevel = "";
                }
            }
        }
        return this.m_compatibleLevel;
    }

    @Deprecated
    public final String getNLSSessionValue(String string) {
        return this.getSessionParameterValue(string);
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("TRIGGER", (DBObjectBuilder)new OracleTriggerBuilder(this));
        this.registerBuilder("FUNCTION", (DBObjectBuilder)new PlSqlSourceBuilder(this, "FUNCTION"));
        this.registerBuilder("PROCEDURE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PROCEDURE"));
        this.registerBuilder("PACKAGE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PACKAGE"));
        this.registerBuilder("PACKAGE BODY", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PACKAGE BODY"));
        this.registerBuilder("INDEXTYPE", (DBObjectBuilder)new IndextypeBuilder(this));
    }

    protected boolean hasRole(String string) {
        boolean bl;
        block4: {
            bl = false;
            if (string != null) {
                try {
                    String[] stringArray;
                    Schema schema = this.getSchema(this.getUserName());
                    if (schema == null || (stringArray = (String[])schema.getProperty("USER_ROLES")) == null) break block4;
                    for (String string2 : stringArray) {
                        if (!string.equals(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (DBException dBException) {
                    this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getConnectionName(), dBException.getMessage()}));
                }
            }
        }
        return bl;
    }

    protected boolean hasPrivilege(String string) {
        boolean bl;
        block4: {
            bl = false;
            if (string != null) {
                try {
                    String[] stringArray;
                    Schema schema = this.getSchema(this.getUserName());
                    if (schema == null || (stringArray = (String[])schema.getProperty("USER_PRIVS")) == null) break block4;
                    for (String string2 : stringArray) {
                        if (!string.equals(string2)) continue;
                        bl = true;
                        break;
                    }
                }
                catch (DBException dBException) {
                    this.getLogger().warning(APIBundle.format((String)"PRIVS_LOAD_ERR", (Object[])new Object[]{this.getConnectionName(), dBException.getMessage()}));
                }
            }
        }
        return bl;
    }

    protected boolean isConnectionAliveImpl(Connection connection) throws SQLException, DBException {
        boolean bl;
        OracleConnection oracleConnection = this.getOracleConnection(connection);
        if (oracleConnection != null) {
            try {
                int n = oracleConnection.pingDatabase();
                bl = n == 0;
            }
            catch (SQLException sQLException) {
                bl = false;
            }
        } else {
            bl = super.isConnectionAliveImpl(connection);
        }
        return bl;
    }

    private OracleConnection getOracleConnection(Connection connection) {
        OracleConnection oracleConnection = null;
        if (connection instanceof OracleConnection) {
            oracleConnection = (OracleConnection)connection;
        } else {
            try {
                if (connection.isWrapperFor(OracleConnection.class)) {
                    oracleConnection = connection.unwrap(OracleConnection.class);
                }
            }
            catch (Throwable throwable) {
                oracleConnection = null;
            }
        }
        return oracleConnection;
    }

    public CompilationResults submitDatabaseSource(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        return this.submitDatabaseSources(string, arrayList).get(0);
    }

    public List<CompilationResults> submitDatabaseSources(String string, List<String> list) {
        int n;
        ArrayList<CompilationResults> arrayList = new ArrayList();
        ArrayList<PlSqlIdentifier> arrayList2 = new ArrayList<PlSqlIdentifier>();
        CompilationResults[] compilationResultsArray = new CompilationResults[list.size()];
        this.setCompilerOptions();
        PlSqlParserFactory plSqlParserFactory = this.getDescriptor().getPlSqlParserFactory((DBObjectProvider)this);
        String string2 = this.getUserName();
        if (ModelUtil.hasLength((String)string)) {
            string2 = string;
        }
        for (n = 0; n < list.size(); ++n) {
            CompilationResults compilationResults;
            try {
                CancelledException.checkInterrupt();
                String string3 = list.get(n);
                compilationResults = plSqlParserFactory.createParser(string3);
                PlSqlToken plSqlToken = compilationResults.getNameToken();
                String string4 = plSqlToken == null ? null : this.getInternalName(plSqlToken.getSource());
                PlSqlToken plSqlToken2 = compilationResults.getSchemaToken();
                String string5 = plSqlToken2 == null ? null : this.getInternalName(plSqlToken2.getSource());
                if (ModelUtil.hasLength(string5) && ModelUtil.areDifferent((Object)string2, (Object)string5) || !ModelUtil.hasLength((String)string5) && ModelUtil.areDifferent((Object)string2, (Object)this.getUserName())) {
                    int n2 = plSqlToken2 == null ? plSqlToken.getStart() : plSqlToken2.getStart();
                    int n3 = plSqlToken.getEnd();
                    StringBuilder stringBuilder = new StringBuilder(string3);
                    stringBuilder.replace(n2, n3 + 1, this.getExternalName(string2) + "." + this.getExternalName(string4));
                    string3 = stringBuilder.toString();
                    compilationResults = plSqlParserFactory.createParser(string3);
                }
                string3 = "CREATE OR REPLACE\n" + string3.substring(compilationResults.getStartOffsetOfObject(), compilationResults.getEndOffsetOfObject() + 1);
                PlSqlIdentifier plSqlIdentifier = PlSqlIdentifier.getPlSqlIdentifier((String)string3, (String)string2, (boolean)true);
                arrayList2.add(plSqlIdentifier);
                StatementWrapper statementWrapper = new StatementWrapper((Database)this, new String[]{string3});
                statementWrapper.execute();
                continue;
            }
            catch (DBException dBException) {
                compilationResults = new CompilationResults();
                compilationResults.setSubmitFailed(true);
                compilationResults.addError(new CompilationErrorInfo(1, 1, dBException.getMessage()));
                compilationResultsArray[n] = compilationResults;
            }
        }
        arrayList = this.getCompilationResults(arrayList2);
        for (n = 0; n < list.size(); ++n) {
            if (compilationResultsArray[n] == null) continue;
            arrayList.remove(n);
            arrayList.add(n, compilationResultsArray[n]);
        }
        return arrayList;
    }

    public void setCompilerOptions() {
        Boolean bl;
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        PlSqlCompilerOptions plSqlCompilerOptions = globalSettings == null ? null : globalSettings.getPlSqlCompilerOptions();
        Boolean bl2 = bl = plSqlCompilerOptions == null ? Boolean.FALSE : Boolean.valueOf(plSqlCompilerOptions.isGeneratePlSqlDebugInfo());
        if (ModelUtil.areDifferent((Object)this.m_debugInfo, (Object)bl)) {
            this.m_debugInfo = bl;
            this.generateDebugInfo();
        }
        this.setWarningFlags(plSqlCompilerOptions);
    }

    private void generateDebugInfo() {
        try {
            StatementWrapper statementWrapper = new StatementWrapper((Database)this, new String[]{this.m_debugInfo != false ? ENABLE_DEBUG : DISABLE_DEBUG});
            statementWrapper.execute();
        }
        catch (DBException dBException) {
            this.getLogger().warning(dBException.getMessage());
        }
    }

    private void setWarningFlags(PlSqlCompilerOptions plSqlCompilerOptions) {
        if (this.getDatabaseVersion() >= 100 && plSqlCompilerOptions != null) {
            for (PlSqlCompilerOptions.WarningCategory warningCategory : PlSqlCompilerOptions.WarningCategory.values()) {
                PlSqlCompilerOptions.WarningValue warningValue = plSqlCompilerOptions.getWarningValue(warningCategory);
                if (warningValue == null) continue;
                try {
                    PlSqlWrapper plSqlWrapper = new PlSqlWrapper((Database)this, SET_WARNINGS_FLAG, new Object[]{warningCategory.name(), warningValue.name(), "SESSION"});
                    plSqlWrapper.executePlSql(new PlSqlWrapper.PlSqlRunnable(){});
                }
                catch (DBException dBException) {
                    this.getLogger().warning(dBException.getMessage());
                }
            }
        }
    }

    private String getErrorQuery() {
        return this.getDatabaseVersion() >= 100 ? ERRORS_QUERY_10G : ERRORS_QUERY;
    }

    public void testSQLStatement(final String string) throws DBException {
        PlSqlWrapper plSqlWrapper = new PlSqlWrapper((Database)this, TEST_SQL_STMT, new Object[]{string});
        plSqlWrapper.executePlSql(new PlSqlWrapper.PlSqlRunnable(){

            public void prepareCall(CallableStatement callableStatement) throws SQLException, DBException {
                callableStatement.registerOutParameter(2, 4);
                callableStatement.registerOutParameter(3, 12);
            }

            public void processCall(CallableStatement callableStatement) throws SQLException, DBException {
                int n = callableStatement.getInt(2);
                String string2 = callableStatement.getString(3);
                if (n > 0) {
                    throw new InvalidSQLException(string, string2, Integer.valueOf(n));
                }
            }
        });
    }

    public List<CompilationResults> getCompilationResults(List<PlSqlIdentifier> list) {
        ArrayList<CompilationResults> arrayList;
        block5: {
            arrayList = new ArrayList<CompilationResults>();
            final HashMap<PlSqlIdentifier, CompilationResults> hashMap = new HashMap<PlSqlIdentifier, CompilationResults>();
            ArrayList<QueryWrapper> arrayList2 = new ArrayList<QueryWrapper>();
            for (PlSqlIdentifier object : list) {
                QueryWrapper queryWrapper = new QueryWrapper((Database)this, this.getErrorQuery(), new Object[]{object.getName(), object.getPlsqlType() == null ? null : object.getPlsqlType().toString(), object.getSchemaName()});
                arrayList2.add(queryWrapper);
                hashMap.put(object, new CompilationResults());
            }
            try {
                CancelledException.checkInterrupt();
                if (arrayList2.size() <= 0) break block5;
                final QueryWrapper queryWrapper = QueryWrapper.union((QueryWrapper[])arrayList2.toArray(new QueryWrapper[arrayList2.size()]));
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            while (resultSet.next()) {
                                String string = resultSet.getString("OWNER");
                                String string2 = resultSet.getString("TYPE");
                                String string3 = resultSet.getString("NAME");
                                PlSqlIdentifier plSqlIdentifier = new PlSqlIdentifier(string3, string, PlSqlIdentifier.PlSqlType.valueOf((String)string2.replaceAll(" ", "_")));
                                CompilationResults compilationResults = (CompilationResults)hashMap.get(plSqlIdentifier);
                                CompilationErrorInfo compilationErrorInfo = new CompilationErrorInfo(resultSet.getInt("LINE"), resultSet.getInt("POSITION"), resultSet.getString("TEXT"), "WARNING".equals(resultSet.getString("ATTRIBUTE")));
                                compilationResults.addError(compilationErrorInfo);
                            }
                        }
                        catch (SQLException sQLException) {
                            queryWrapper.throwDBException(sQLException);
                        }
                    }
                };
                queryWrapper.executeQuery(queryRunnable);
                for (PlSqlIdentifier plSqlIdentifier : list) {
                    arrayList.add((CompilationResults)hashMap.get(plSqlIdentifier));
                }
            }
            catch (DBException dBException) {
                for (PlSqlIdentifier plSqlIdentifier : list) {
                    CompilationResults compilationResults = new CompilationResults(plSqlIdentifier.getName(), plSqlIdentifier.getPlsqlType().toString());
                    compilationResults.setSubmitFailed(true);
                    compilationResults.addError(new CompilationErrorInfo(1, 1, dBException.getMessage()));
                }
            }
        }
        return arrayList;
    }

    protected String queryCurrentSchemaName() throws DBException {
        String string = null;
        if (this.getConnection() instanceof OracleConnection) {
            ConnectionWrapper connectionWrapper = new ConnectionWrapper((Database)this, APIBundle.get((String)"GET_CURR_SCHEMA"));
            ConnectionWrapper.SQLCallable<String> sQLCallable = new ConnectionWrapper.SQLCallable<String>(connectionWrapper){

                public String call() throws SQLException {
                    return ((OracleConnection)this.getConnection()).getCurrentSchema();
                }
            };
            string = (String)connectionWrapper.call((ConnectionWrapper.SQLCallable)sQLCallable);
        }
        return string;
    }

    public Database createStandaloneDatabase(Schema schema) throws DBException {
        StatementWrapper statementWrapper;
        Connection connection;
        Database database = null;
        if (schema != null && (connection = this.createDuplicateConnection()) != null && (statementWrapper = new StatementWrapper(this.getConnectionName(), connection, new String[]{"ALTER SESSION SET current_schema = " + this.getExternalName(schema.getName(), "SCHEMA")})).execute()) {
            database = DatabaseFactory.createStandaloneDatabase((String)this.getConnectionName(), (Connection)connection);
        }
        return database;
    }

    static Collection<String> listBuiltInIndextypeSchemas(Class clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        while (clazz != null && !clazz.equals(Object.class)) {
            Map map = (Map)s_builtinIndextypes.get(clazz.getName());
            if (map != null) {
                hashSet.addAll(map.keySet());
            }
            clazz = clazz.getSuperclass();
        }
        return hashSet;
    }

    static Collection<Indextype> listBuiltInIndextypes(Class clazz, String string) {
        Collection collection = null;
        while (clazz != null && !clazz.equals(Object.class)) {
            Collection collection2;
            Map map = (Map)s_builtinIndextypes.get(clazz.getName());
            if (map != null && (collection2 = (Collection)map.get(string)) != null) {
                collection = collection2;
            }
            clazz = clazz.getSuperclass();
        }
        return collection == null ? Collections.emptyList() : collection;
    }

    static void registerBuiltInIndextypes(Class clazz, String string, String ... stringArray) {
        if (stringArray != null) {
            MultiMap multiMap = s_builtinIndextypes.get(clazz.getName());
            if (multiMap == null) {
                multiMap = new MultiMap();
                s_builtinIndextypes.put(clazz.getName(), (MultiMap<String, Indextype>)multiMap);
            }
            Schema schema = new Schema(string);
            for (int i = 0; i < stringArray.length; ++i) {
                Indextype indextype = new Indextype(stringArray[i], schema);
                indextype.setID((DBObjectID)new ReferenceID((DBObject)indextype));
                multiMap.add((Object)string, (Object)indextype);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAPIVersionForSQLTrace() {
        String string;
        if (s_api_version == null && ModelUtil.hasLength((String)(string = System.getenv("ADE_VIEW_ROOT")))) {
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(string + "/ade_info.vmd");
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            try {
                String string2 = null;
                try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (string2.startsWith("VIEW_LABEL")) {
                            s_api_version = string2.substring(string2.indexOf(" ")).trim();
                        }
                        if (!string2.startsWith("VIEW_TRANS_NAME")) continue;
                        String string3 = string2.substring(string2.indexOf(" ")).trim();
                        if (ModelUtil.areDifferent((Object)string3, (Object)"NONE")) {
                            s_api_version = s_api_version + "/" + string3;
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return s_api_version;
    }

    public static void setAPIVersionForSQLTrace(String string) {
        s_api_version = string;
    }

    private void setSQLTraceOnIfReqd(Connection connection) {
        String string = System.getProperty("db-sqltrace");
        if (ModelUtil.hasLength((String)string)) {
            QueryWrapper queryWrapper;
            Object object;
            String[] stringArray;
            String[] stringArray2 = new String[]{};
            if (connection instanceof OracleConnection) {
                stringArray = ((OracleConnection)connection).getProperties();
                String string2 = (String)stringArray.get("database") + ":" + ((String)stringArray.get("user")).toLowerCase();
                stringArray2 = string2.split(":");
            }
            stringArray = string.split(",");
            boolean bl = false;
            String string3 = null;
            block4: for (int i = 0; i < stringArray.length && !bl; ++i) {
                int n;
                object = stringArray[i].split(":");
                string3 = object[0];
                queryWrapper = new String[4];
                for (n = 0; n < ((String[])object).length - 1 && n < ((String[])queryWrapper).length; ++n) {
                    queryWrapper[n] = object[n + 1];
                }
                while (n < 4) {
                    queryWrapper[n] = "";
                    ++n;
                }
                queryWrapper[3] = queryWrapper[3].toLowerCase();
                bl = true;
                for (n = 0; n < stringArray2.length && n < 4; ++n) {
                    if (queryWrapper[n].equals("")) continue;
                    if (n == 0) {
                        String string4 = queryWrapper[n].length() > stringArray2[n].length() ? stringArray2[n] : queryWrapper[n];
                        Object object2 = queryWrapper[n].length() > stringArray2[n].length() ? queryWrapper[n] : stringArray2[n];
                        string4 = string4 + '.';
                        if (((String)(object2 = (String)object2 + '.')).startsWith(string4)) continue;
                        bl = false;
                        continue block4;
                    }
                    if (queryWrapper[n].equals(stringArray2[n])) continue;
                    bl = false;
                    continue block4;
                }
            }
            if (bl) {
                StatementWrapper statementWrapper = new StatementWrapper((Database)this, new String[]{"ALTER SESSION SET SQL_TRACE=TRUE"});
                try {
                    statementWrapper.execute();
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                object = "SELECT /* :DB-API:" + this.getUserName() + ":" + string3 + ":" + OracleDatabaseImpl.getAPIVersionForSQLTrace() + ": */ 1 FROM SYS.DUAL";
                queryWrapper = new QueryWrapper((Database)this, (String)object);
                try {
                    QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                        public void processResultSet(ResultSet resultSet) throws DBException {
                        }
                    };
                    queryWrapper.executeQuery(queryRunnable);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
    }
}

