/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.marshal.PartialParseCompleteException;
import oracle.javatools.db.marshal.SingleElementHandler;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DBObjectXMLHandler
extends DBObjectHandler {
    private String m_namespace;

    public DBObjectXMLHandler(String string) {
        this.m_namespace = string;
    }

    public final String getNamespace() {
        return this.m_namespace;
    }

    public boolean canRead(Reader reader, DBObjectProvider dBObjectProvider) throws IOException {
        SingleElementHandler singleElementHandler = new SingleElementHandler(null);
        DBObjectXMLHandler.read(reader, singleElementHandler, true);
        return ModelUtil.areEqual((Object)this.getNamespace(), (Object)singleElementHandler.getNamespace());
    }

    protected static final void read(Reader reader, DefaultHandler defaultHandler, boolean bl) throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(DBObjectXMLHandler.class.getClassLoader());
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(reader), defaultHandler);
        }
        catch (PartialParseCompleteException partialParseCompleteException) {
            if (!bl) {
                throw new IllegalStateException("parser quit after name and id but we didn't request that.");
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Error parsing file: " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("Error parsing file: " + sAXException.getMessage());
            iOException.initCause(sAXException);
            throw iOException;
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }
}

