/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.jdbc.JdbcSynonymBuilder;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.jdbc.JdbcViewBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class JdbcDDLDatabase
extends DDLDatabase
implements JdbcDatabase {
    private static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String DMD_SCHEMA_NAME = "DMD_SCHEMA_NAME";
    public static final String DMD_CATALOG_NAME = "DMD_CATALOG_NAME";
    public static final String DMD_NULL_SCHEMA = "<null>";
    private Map<String, Schema> m_dmdSchemas;
    private boolean m_supportsSchemas;
    private String m_quoteString;
    private boolean m_useSystemTable;

    public JdbcDDLDatabase(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    protected JdbcDDLDatabase(String string, String string2, Connection connection, String string3, int n) {
        super(string, string2, connection, string3, n);
    }

    public Schema getSchema(String string) throws DBException {
        if (!ModelUtil.hasLength((String)string)) {
            string = this.getCurrentSchemaName();
        }
        return super.getSchema(string);
    }

    protected Schema findSchema(String string) throws DBException {
        if (!ModelUtil.hasLength((String)string)) {
            string = this.getCurrentSchemaName();
        }
        return super.findSchema(string);
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        if (dBObjectCriteria.getTypes().contains("SCHEMA")) {
            if (dBObjectCriteria.getTypes().size() > 1) {
                throw new IllegalStateException("Cannot list schemas and schema objects at the same time!");
            }
            ArrayList<Schema> arrayList = new ArrayList<Schema>();
            for (Schema schema : this.loadSchemasImpl().values()) {
                if (!dBObjectCriteria.accept((SystemObject)schema)) continue;
                arrayList.add(schema);
            }
            return arrayList;
        }
        Schema schema = this.findSchema(dBObjectCriteria.getSchemaName());
        String[] stringArray = dBObjectCriteria.getTypeArray();
        String string = dBObjectCriteria.getNameLike();
        String string2 = null;
        String string3 = null;
        if (this.isUseSchema() && schema != null) {
            string2 = (String)schema.getProperty(DMD_SCHEMA_NAME);
            if (DMD_NULL_SCHEMA.equals(string2)) {
                string2 = null;
            }
            if ((string3 = (String)schema.getProperty(DMD_CATALOG_NAME)) == null) {
                string3 = this.getCatalog();
            }
        }
        String string4 = this.getNameForDriver(string);
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            String string5 = databaseMetaData.getDatabaseProductName();
            if ("EXCEL".equals(string5)) {
                stringArray = null;
                if ("%".equals(string)) {
                    string4 = null;
                }
            }
            if (this.m_useSystemTable && stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("TABLE")) continue;
                    stringArray[i] = SYSTEM_TABLE;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new DBException((Throwable)sQLException);
        }
        return this.listObjectsImpl(string3, string2, stringArray, string, schema);
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(final String string, String string2, final String[] stringArray, final String string3, final Schema schema) throws DBException {
        ConnectionWrapper connectionWrapper;
        final String string4 = this.getNameForDriver(string2);
        ConnectionWrapper connectionWrapper2 = connectionWrapper = new ConnectionWrapper((Database)this, APIBundle.format((String)"LIST_OBJECTS", (Object[])new Object[]{string4}));
        connectionWrapper2.getClass();
        ConnectionWrapper.SQLCallable sQLCallable = new ConnectionWrapper.SQLCallable<Collection<T>>(connectionWrapper2){

            public Collection<T> call() throws SQLException, DBException {
                Collection collection;
                ResultSet resultSet = null;
                try {
                    resultSet = JdbcDDLDatabase.this.getListObjectsResultSet(string, string4, stringArray, string3);
                    collection = JdbcDDLDatabase.this.listObjectsImpl(resultSet, string, string4, string3, schema);
                }
                catch (Throwable throwable) {
                    JdbcDDLDatabase.this.close(resultSet);
                    throw throwable;
                }
                JdbcDDLDatabase.this.close(resultSet);
                return collection;
            }
        };
        return (Collection)connectionWrapper.call(sQLCallable);
    }

    protected <T extends SystemObject> Collection<T> listObjectsImpl(ResultSet resultSet, String string, String string2, String string3, Schema schema) throws SQLException, DBException {
        ArrayList<SystemObject> arrayList = new ArrayList<SystemObject>();
        while (resultSet != null && resultSet.next()) {
            String string4;
            Schema schema2;
            DBObjectBuilder dBObjectBuilder;
            SystemObject systemObject = null;
            String string5 = resultSet.getString(1);
            String string6 = this.catalogIsSchema() ? string5 : resultSet.getString(2);
            String string7 = resultSet.getString(3);
            String string8 = resultSet.getString(4);
            if (SYSTEM_TABLE.equals(string8)) {
                string8 = "TABLE";
            }
            if ((dBObjectBuilder = this.getBuilderForType(string8)) == null || !this.catalogMatches(string, string5) || !this.schemaMatches(string2, string6) || !this.tableMatches(string3, string7) || (systemObject = this.findOrCreateObject(string8, null, schema2 = string6 == null ? schema : this.findSchema(string6), string7, null)) == null) continue;
            if (resultSet.getMetaData().getColumnCount() > 4 && !dBObjectBuilder.isBuildableProperty("Comment") && ModelUtil.hasLength((String)(string4 = resultSet.getString(5)))) {
                systemObject.setProperty("Comment", (Object)string4);
            }
            arrayList.add(systemObject);
        }
        return arrayList;
    }

    private ResultSet getListObjectsResultSet(String string, String string2, String[] stringArray, String string3) throws SQLException {
        ResultSet resultSet = null;
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            resultSet = databaseMetaData.getTables(string, string2, string3, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.isUnsupportedOperation(sQLException)) {
                throw sQLException;
            }
            this.close(resultSet);
            resultSet = null;
        }
        return resultSet;
    }

    protected void close(ResultSet ... resultSetArray) {
        if (resultSetArray != null) {
            for (ResultSet resultSet : resultSetArray) {
                if (resultSet == null) continue;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public String getIdentifierQuoteString() {
        DatabaseDescriptor databaseDescriptor = this.getDescriptor();
        if (databaseDescriptor == null) {
            if (this.m_quoteString == null) {
                try {
                    DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
                    this.m_quoteString = databaseMetaData.getIdentifierQuoteString();
                }
                catch (SQLException sQLException) {
                    this.m_quoteString = "";
                }
            }
            return this.m_quoteString;
        }
        return super.getIdentifierQuoteString();
    }

    protected void registerBuilders() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            object = false;
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            try (ResultSet resultSet = databaseMetaData.getTableTypes();){
                while (resultSet.next()) {
                    String string = resultSet.getString(1).trim();
                    if (string.equals(SYSTEM_TABLE)) {
                        if (object != null) {
                            object = true;
                        }
                        string = "TABLE";
                    } else if (string.equals("TABLE")) {
                        object = null;
                    }
                    hashSet.add(string);
                }
                if (object != null && ((Boolean)object).booleanValue()) {
                    this.m_useSystemTable = true;
                }
            }
        }
        catch (SQLException sQLException) {
            hashSet.add("TABLE");
        }
        object = this.getCatalog();
        this.registerBuilders(hashSet, (String)object);
    }

    protected void registerBuilders(Collection<String> collection, String string) {
        if (collection.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new JdbcTableBuilder(this, string));
        }
        if (collection.contains("VIEW")) {
            this.registerBuilder("VIEW", (DBObjectBuilder)new JdbcViewBuilder(this, string));
        }
        if (collection.contains("SYNONYM")) {
            this.registerBuilder("SYNONYM", (DBObjectBuilder)new JdbcSynonymBuilder((JdbcDatabase)this, string, true));
        }
        if (collection.contains("ALIAS")) {
            this.registerBuilder("ALIAS", (DBObjectBuilder)new JdbcSynonymBuilder((JdbcDatabase)this, string, false));
        }
    }

    public String normaliseDefaultValue(DataType dataType, String string) {
        return string;
    }

    public String normaliseDataTypeName(String string) {
        return string;
    }

    public boolean isUseSchema() {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return this.m_supportsSchemas;
    }

    protected boolean useCatalogFromSchema() {
        return true;
    }

    public String getNameForDriver(String string) {
        return string;
    }

    public boolean catalogIsSchema() {
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            boolean bl = databaseMetaData.supportsCatalogsInTableDefinitions();
            boolean bl2 = databaseMetaData.supportsSchemasInTableDefinitions();
            return !bl2 || bl;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public final Schema[] listSchemas(boolean bl) throws DBException {
        Collection<Schema> collection = this.loadSchemasImpl().values();
        return collection.toArray(new Schema[collection.size()]);
    }

    protected Map<String, Schema> loadSchemasImpl() throws DBException {
        Map<String, Schema> map = this.m_dmdSchemas;
        if (map == null) {
            String string;
            map = new TreeMap<String, Schema>();
            this.populateSchemas(map);
            boolean bl = map.isEmpty();
            if ((bl || this.alwaysIncludeDefaultSchema()) && !map.containsKey(string = this.getCurrentSchemaName())) {
                Schema schema = this.createSchema(string);
                schema.setProperty("isDefaultSchema", (Object)Boolean.TRUE);
                schema.setProperty(DMD_SCHEMA_NAME, (Object)schema.getName());
                map.put(string, schema);
            }
            this.m_dmdSchemas = map;
            this.m_supportsSchemas = !bl;
        }
        return map;
    }

    protected boolean alwaysIncludeDefaultSchema() {
        return false;
    }

    @Deprecated
    protected void populateSchemas() throws DBException {
    }

    protected void populateSchemas(final Map<String, Schema> map) throws DBException {
        ConnectionWrapper connectionWrapper;
        ConnectionWrapper connectionWrapper2 = connectionWrapper = new ConnectionWrapper((Database)this, APIBundle.get((String)"LIST_SCHEMAS"));
        connectionWrapper2.getClass();
        ConnectionWrapper.SQLRunnable sQLRunnable = new ConnectionWrapper.SQLRunnable(connectionWrapper2){

            public void run() throws SQLException {
                block31: {
                    try (ResultSet resultSet = this.getConnection().getMetaData().getSchemas();){
                        Object object;
                        Object object2;
                        while (resultSet.next()) {
                            object2 = resultSet.getString(1);
                            object = null;
                            if (JdbcDDLDatabase.this.useCatalogFromSchema()) {
                                if (resultSet.getMetaData().getColumnCount() > 1) {
                                    object = resultSet.getString(2);
                                }
                            } else {
                                object = JdbcDDLDatabase.this.getCatalog();
                            }
                            JdbcDDLDatabase.this.createAndCacheSchema((String)object, (String)object2, map);
                        }
                        if (!JdbcDDLDatabase.this.catalogIsSchema()) break block31;
                        object2 = this.getConnection().getMetaData();
                        object = object2.getCatalogs();
                        Throwable throwable = null;
                        try {
                            while (object.next()) {
                                String string = object.getString(1);
                                if (!ModelUtil.hasLength((String)string)) continue;
                                JdbcDDLDatabase.this.createAndCacheSchema(string, string, JdbcDDLDatabase.DMD_NULL_SCHEMA, map);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object != null) {
                                if (throwable != null) {
                                    try {
                                        object.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    object.close();
                                }
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        if (JdbcDDLDatabase.this.isUnsupportedOperation(sQLException)) break block31;
                        throw sQLException;
                    }
                }
            }
        };
        connectionWrapper.run(sQLRunnable);
    }

    @Deprecated
    protected void createAndCacheSchema(String string, String string2, String string3) {
        Map<String, Schema> map = this.m_dmdSchemas;
        if (map == null) {
            this.m_dmdSchemas = map = new TreeMap<String, Schema>();
        }
        this.createAndCacheSchema(string, string2, string3, map);
    }

    protected final void createAndCacheSchema(String string, String string2, Map<String, Schema> map) {
        String string3 = ModelUtil.hasLength((String)string2) ? string2 : DMD_NULL_SCHEMA;
        this.createAndCacheSchema(string3, string, string2, map);
    }

    protected final void createAndCacheSchema(String string, String string2, String string3, Map<String, Schema> map) {
        if (!map.containsKey(string)) {
            Schema schema = this.createSchema(string);
            schema.setProperty(DMD_SCHEMA_NAME, (Object)string3);
            schema.setProperty(DMD_CATALOG_NAME, (Object)string2);
            map.put(string, schema);
        }
    }

    protected String queryCurrentSchemaName() throws DBException {
        String string = null;
        try {
            string = super.queryCurrentSchemaName();
        }
        catch (DBException dBException) {
            this.getLogger().fine(dBException.getMessage());
        }
        if (!ModelUtil.hasLength((String)string) && this.catalogIsSchema()) {
            string = this.getCatalog();
        }
        if (!ModelUtil.hasLength((String)string)) {
            string = this.getUserName();
        }
        return ModelUtil.hasLength((String)string) ? string : DMD_NULL_SCHEMA;
    }

    @Deprecated
    protected String getDefaultSchemaName() {
        return null;
    }

    public Schema getDefaultSchema() throws DBException {
        Schema schema = super.getDefaultSchema();
        if (schema == null && this.m_dmdSchemas.size() == 1) {
            schema = this.m_dmdSchemas.values().iterator().next();
        }
        return schema;
    }

    private boolean catalogMatches(String string, String string2) {
        return !ModelUtil.hasLength((String)string) || !ModelUtil.hasLength((String)string2) || this.nameMatches(string, string2);
    }

    private boolean schemaMatches(String string, String string2) {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return !this.m_supportsSchemas || !ModelUtil.hasLength((String)string) || !ModelUtil.hasLength((String)string2) || this.nameMatches(string, string2);
    }

    private boolean nameMatches(String string, String string2) {
        return this.getDescriptor().areNamesEqual(string, string2, null, false);
    }

    protected boolean tableMatches(String string, String string2) {
        String string3 = string == null ? ".*" : string.replaceAll("%", ".*");
        return this.nameMatches(string, string2) || string2.matches(string3);
    }

    public void clearAllCaches() {
        super.clearAllCaches();
        this.m_dmdSchemas = null;
        this.m_quoteString = null;
    }
}

