/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

public abstract class InformixDatabaseImpl
extends JdbcDDLDatabase
implements InformixDatabase {
    private static final String IBM_INFORMIX_JDBC_DRIVER = "IBM Informix JDBC Driver";
    private String m_driverName;

    protected InformixDatabaseImpl(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    @Override
    public String normaliseDataTypeName(String string) {
        String string2 = string.trim().replaceAll("\\s", " ");
        return string2.compareToIgnoreCase("INT") == 0 ? "INTEGER" : string2;
    }

    @Override
    public String normaliseDefaultValue(DataType dataType, String string) {
        if (dataType instanceof CharacterDataType) {
            string = string.replaceAll("'", "''");
            string = "'" + string + "'";
        }
        return string;
    }

    @Override
    public String getNameForDriver(String string) {
        if (string != null && this.getDriverName() != null && this.getDriverName().startsWith(IBM_INFORMIX_JDBC_DRIVER)) {
            String string2 = string.toLowerCase();
            return string.equals(string2) ? string : null;
        }
        return string;
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        Collection<T> collection;
        SystemObject systemObject;
        Schema schema;
        if (!dBObjectCriteria.getTypes().contains("SCHEMA") && this.getDriverName().startsWith(IBM_INFORMIX_JDBC_DRIVER)) {
            schema = this.findSchema(dBObjectCriteria.getSchemaName());
            systemObject = dBObjectCriteria.getTypeArray();
            String string = dBObjectCriteria.getNameLike();
            collection = new ArrayList<T>();
            for (SystemObject systemObject2 : systemObject) {
                DBObjectCriteria dBObjectCriteria2 = DBObjectCriteria.createCriteria((String)systemObject2, (Schema)schema, (String)string);
                collection.addAll(super.listObjectsImpl(dBObjectCriteria2));
            }
        } else {
            collection = super.listObjectsImpl(dBObjectCriteria);
        }
        schema = collection.iterator();
        while (schema.hasNext()) {
            systemObject = (SystemObject)schema.next();
            if (systemObject.getType() != "VIEW" || !systemObject.getName().equals("sysdomains") && !systemObject.getName().equals("sysindexes")) continue;
            schema.remove();
        }
        return collection;
    }

    private String getDriverName() {
        if (this.m_driverName == null) {
            try {
                this.m_driverName = this.getConnection().getMetaData().getDriverName();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.m_driverName;
    }

    protected Boolean isConnectionClosedImpl(SQLException sQLException, Connection connection) {
        Boolean bl = connection.getClass().getName().startsWith("com.informix.jdbc") ? Boolean.valueOf(sQLException != null && "IX000".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -79730) : super.isConnectionClosedImpl(sQLException, connection);
        return bl;
    }
}

