/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.specification.ExportDomains;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;

public class FileExportSpecification<P extends FilePackageExportSpecification>
implements ExportSpecification {
    private final Object id;
    private final String owner;
    private final String source;
    private final ExportDomains domains;
    private final Map<String, P> packages;
    private final P defaultPackageAccess;
    private final P nullPackageAccess;

    public FileExportSpecification(Object id, String owner, String source, ExportDomains domains, Map<String, P> packages, P defaultPackageAccess, P nullPackageAccess) {
        this.id = id;
        this.owner = owner;
        this.source = source;
        this.domains = domains;
        this.packages = packages;
        this.defaultPackageAccess = defaultPackageAccess;
        this.nullPackageAccess = nullPackageAccess;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public P getPackage(String name) {
        if (this.packages != null) {
            return (P)this.packages.computeIfAbsent(name, v -> this.domains.controls(name) ? this.defaultPackageAccess : this.nullPackageAccess);
        }
        return this.defaultPackageAccess;
    }

    public ExportDomains getDomains() {
        return this.domains;
    }

    protected Collection<String> getPackageNames() {
        return this.packages != null ? this.packages.keySet() : null;
    }

    protected P getDefaultPackageAccess() {
        return this.defaultPackageAccess;
    }

    protected P getNullPackageAccess() {
        return this.nullPackageAccess;
    }

    public boolean equals(Object that) {
        return this.getClass() == that.getClass() && this.id.equals(((FileExportSpecification)that).id) && this.owner.equals(((FileExportSpecification)that).owner);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }

    public static FileExportSpecification mergeExportSpecifications(Object id, List<? extends FileExportSpecification> specifications, List<String> issues, ExportSpecificationReader<FileExportSpecification, FilePackageExportSpecification, FileTypeExportSpecification> factory) {
        if (specifications.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        FileExportSpecification left = specifications.get(0);
        StringBuilder mergedSources = new StringBuilder();
        ExportDomains mergedDomain = new ExportDomains(new String[0]);
        LinkedHashMap<String, ExportSpecification.PackageExportSpecification> mergedPackages = new LinkedHashMap<String, ExportSpecification.PackageExportSpecification>();
        String leftId = FileExportSpecification.idString(left.getId());
        String owner = left.getOwner();
        Object defaultPackageAccess = left.getDefaultPackageAccess();
        Object nullPackageAccess = left.getNullPackageAccess();
        for (FileExportSpecification fileExportSpecification : specifications) {
            Object greaterAccess;
            String greaterId;
            Object lesserAccess;
            String lesserId;
            String rightId = FileExportSpecification.idString(fileExportSpecification.getId());
            if (!Objects.equals(owner, fileExportSpecification.getOwner())) {
                issues.add(String.format("error: conflicting owner for merged export specification: using \"%s\" from %s over \"%s\" from %s", owner, leftId, fileExportSpecification.getOwner(), rightId));
                if (owner == null) {
                    owner = fileExportSpecification.getOwner();
                }
            }
            if (FileExportSpecification.compareAccess(defaultPackageAccess, fileExportSpecification.getDefaultPackageAccess()) != 0) {
                if (FileExportSpecification.compareAccess(defaultPackageAccess, fileExportSpecification.getDefaultPackageAccess()) > 0) {
                    lesserId = rightId;
                    lesserAccess = fileExportSpecification.getDefaultPackageAccess();
                    greaterId = leftId;
                    greaterAccess = defaultPackageAccess;
                    defaultPackageAccess = lesserAccess;
                } else {
                    lesserId = leftId;
                    lesserAccess = defaultPackageAccess;
                    greaterId = rightId;
                    greaterAccess = fileExportSpecification.getDefaultPackageAccess();
                }
                issues.add(String.format("error: conflicting default package access for merged export specification: using \"%s\" from %s over \"%s\" from %s", lesserAccess, lesserId, greaterAccess, greaterId));
            }
            if (FileExportSpecification.compareAccess(nullPackageAccess, fileExportSpecification.getNullPackageAccess()) != 0) {
                if (FileExportSpecification.compareAccess(nullPackageAccess, fileExportSpecification.getNullPackageAccess()) > 0) {
                    lesserId = rightId;
                    lesserAccess = fileExportSpecification.getNullPackageAccess();
                    greaterId = leftId;
                    greaterAccess = nullPackageAccess;
                    nullPackageAccess = lesserAccess;
                } else {
                    lesserId = leftId;
                    lesserAccess = nullPackageAccess;
                    greaterId = rightId;
                    greaterAccess = fileExportSpecification.getNullPackageAccess();
                }
                issues.add(String.format("error: conflicting null package access for merged export specification: using \"%s\" from %s over \"%s\" from %s", lesserAccess, lesserId, greaterAccess, greaterId));
            }
            if (mergedSources.length() > 0) {
                mergedSources.append('\n');
            }
            mergedSources.append(fileExportSpecification.getSource());
            mergedDomain.add(fileExportSpecification.getDomains());
            Collection<String> packageNames = fileExportSpecification.getPackageNames();
            for (String packageName : packageNames) {
                ExportSpecification.PackageExportSpecification rightPackage = fileExportSpecification.getPackage(packageName);
                if (mergedPackages.containsKey(packageName)) {
                    Set<String> mergedResources;
                    LinkedHashMap<String, ExportSpecification.TypeExportSpecification> mergedTypes;
                    Access packageAccess;
                    FilePackageExportSpecification leftPackage = (FilePackageExportSpecification)mergedPackages.get(packageName);
                    if (leftPackage.getAccess() == ((FilePackageExportSpecification)rightPackage).getAccess()) {
                        packageAccess = leftPackage.getAccess();
                    } else if (FileExportSpecification.compareAccess(leftPackage.getAccess(), ((FilePackageExportSpecification)rightPackage).getAccess()) > 0) {
                        packageAccess = ((FilePackageExportSpecification)rightPackage).getAccess();
                        issues.add(String.format("error: conflicting access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, ((FilePackageExportSpecification)rightPackage).getAccess(), rightId, leftPackage.getAccess(), leftId}));
                    } else {
                        packageAccess = leftPackage.getAccess();
                        issues.add(String.format("error: conflicting access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, leftPackage.getAccess(), leftId, ((FilePackageExportSpecification)rightPackage).getAccess(), rightId}));
                    }
                    Object defaultTypeResourceAccess = leftPackage.getDefaultTypeResourceAccess();
                    Object leftAccess = leftPackage.getDefaultTypeResourceAccess();
                    Object rightAccess = ((FilePackageExportSpecification)rightPackage).getDefaultTypeResourceAccess();
                    if (((FileTypeExportSpecification)leftAccess).getAccess() != ((FileTypeExportSpecification)rightAccess).getAccess() || ((FileTypeExportSpecification)leftAccess).getExtension() != ((FileTypeExportSpecification)rightAccess).getExtension() || ((FileTypeExportSpecification)leftAccess).getDefaultMemberAccess() != ((FileTypeExportSpecification)rightAccess).getDefaultMemberAccess()) {
                        Access defaultMemberAccess;
                        Access extension;
                        Access access;
                        if (((FileTypeExportSpecification)leftAccess).getAccess() == ((FileTypeExportSpecification)rightAccess).getAccess()) {
                            access = ((FileTypeExportSpecification)leftAccess).getAccess();
                        } else if (FileExportSpecification.compareAccess(((FileTypeExportSpecification)leftAccess).getAccess(), ((FileTypeExportSpecification)rightAccess).getAccess()) > 0) {
                            access = ((FileTypeExportSpecification)rightAccess).getAccess();
                            issues.add(String.format("error: conflicting default type and resource access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, ((FileTypeExportSpecification)rightAccess).getAccess(), rightId, ((FileTypeExportSpecification)leftAccess).getAccess(), leftId}));
                        } else {
                            access = ((FileTypeExportSpecification)leftAccess).getAccess();
                            issues.add(String.format("error: conflicting default type and resource access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, ((FileTypeExportSpecification)leftAccess).getAccess(), leftId, ((FileTypeExportSpecification)rightAccess).getAccess(), rightId}));
                        }
                        if (((FileTypeExportSpecification)leftAccess).getExtension() == ((FileTypeExportSpecification)rightAccess).getExtension()) {
                            extension = ((FileTypeExportSpecification)leftAccess).getExtension();
                        } else if (FileExportSpecification.compareAccess(((FileTypeExportSpecification)leftAccess).getExtension(), ((FileTypeExportSpecification)rightAccess).getExtension()) > 0) {
                            extension = ((FileTypeExportSpecification)rightAccess).getExtension();
                            issues.add(String.format("error: conflicting default extension access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, ((FileTypeExportSpecification)rightAccess).getExtension(), rightId, ((FileTypeExportSpecification)leftAccess).getExtension(), leftId}));
                        } else {
                            extension = ((FileTypeExportSpecification)leftAccess).getExtension();
                            issues.add(String.format("error: conflicting default extension access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, ((FileTypeExportSpecification)leftAccess).getExtension(), leftId, ((FileTypeExportSpecification)rightAccess).getExtension(), rightId}));
                        }
                        if (((FileTypeExportSpecification)leftAccess).getDefaultMemberAccess() == ((FileTypeExportSpecification)rightAccess).getDefaultMemberAccess()) {
                            defaultMemberAccess = ((FileTypeExportSpecification)leftAccess).getDefaultMemberAccess();
                        } else if (FileExportSpecification.compareAccess(((FileTypeExportSpecification)leftAccess).getDefaultMemberAccess(), ((FileTypeExportSpecification)rightAccess).getDefaultMemberAccess()) > 0) {
                            defaultMemberAccess = ((FileTypeExportSpecification)rightAccess).getDefaultMemberAccess();
                            issues.add(String.format("error: conflicting default member access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, ((FileTypeExportSpecification)rightAccess).getDefaultMemberAccess(), rightId, ((FileTypeExportSpecification)leftAccess).getDefaultMemberAccess(), leftId}));
                        } else {
                            defaultMemberAccess = ((FileTypeExportSpecification)leftAccess).getDefaultMemberAccess();
                            issues.add(String.format("error: conflicting default member access for merged package %s: using \"%s\" from %s over \"%s\" from %s", new Object[]{packageName, ((FileTypeExportSpecification)leftAccess).getDefaultMemberAccess(), leftId, ((FileTypeExportSpecification)rightAccess).getDefaultMemberAccess(), rightId}));
                        }
                        defaultTypeResourceAccess = factory.createTypeAccessModel(access, extension, null, defaultMemberAccess);
                    }
                    Set<String> leftTypeNames = leftPackage.getTypeNames();
                    Set<String> rightTypeNames = ((FilePackageExportSpecification)rightPackage).getTypeNames();
                    if (leftTypeNames == null && rightTypeNames == null) {
                        mergedTypes = null;
                    } else if (leftTypeNames != null && rightTypeNames != null) {
                        mergedTypes = new LinkedHashMap<String, ExportSpecification.TypeExportSpecification>();
                        for (String typeName : leftTypeNames) {
                            mergedTypes.put(typeName, leftPackage.getType(typeName));
                        }
                        for (String typeName : rightTypeNames) {
                            Set<String> mergedMembers;
                            FileTypeExportSpecification leftType = (FileTypeExportSpecification)mergedTypes.get(typeName);
                            ExportSpecification.TypeExportSpecification rightType = ((FilePackageExportSpecification)rightPackage).getType(typeName);
                            if (leftType == null) {
                                mergedTypes.put(typeName, rightType);
                                continue;
                            }
                            if (leftType.getAccess() == ((FileTypeExportSpecification)rightType).getAccess() && leftType.getExtension() == ((FileTypeExportSpecification)rightType).getExtension() && leftType.getDefaultMemberAccess() == ((FileTypeExportSpecification)rightType).getDefaultMemberAccess() && Objects.equals(leftType.getMemberNames(), ((FileTypeExportSpecification)rightType).getMemberNames())) {
                                issues.add(String.format("warning: duplicated type %s in %s and %s", typeName, leftId, rightId));
                                continue;
                            }
                            issues.add(String.format("error: conflicting type %s: using most concealed meet of %s and %s", typeName, leftId, rightId));
                            if (leftType.getMemberNames() == null) {
                                mergedMembers = ((FileTypeExportSpecification)rightType).getMemberNames();
                            } else if (((FileTypeExportSpecification)rightType).getMemberNames() == null) {
                                mergedMembers = leftType.getMemberNames();
                            } else {
                                mergedMembers = new LinkedHashSet<String>(leftType.getMemberNames());
                                mergedMembers.retainAll(((FileTypeExportSpecification)rightType).getMemberNames());
                            }
                            FileTypeExportSpecification mergedType = factory.createTypeAccessModel(FileExportSpecification.min(leftType.getAccess(), ((FileTypeExportSpecification)rightType).getAccess()), FileExportSpecification.min(leftType.getExtension(), ((FileTypeExportSpecification)rightType).getExtension()), mergedMembers, FileExportSpecification.min(leftType.getDefaultMemberAccess(), ((FileTypeExportSpecification)rightType).getDefaultMemberAccess()));
                            mergedTypes.put(typeName, mergedType);
                        }
                    } else if (leftTypeNames == null) {
                        issues.add(String.format("error: conflicting type export for merged package %s: using specific types of %s over all types of %s", packageName, rightId, leftId));
                        mergedTypes = new LinkedHashMap();
                        for (String typeName : rightTypeNames) {
                            mergedTypes.put(typeName, ((FilePackageExportSpecification)rightPackage).getType(typeName));
                        }
                    } else {
                        issues.add(String.format("error: conflicting type export for merged package %s: using specific types of %s over all types of %s", packageName, leftId, rightId));
                        mergedTypes = new LinkedHashMap();
                        for (String typeName : leftTypeNames) {
                            mergedTypes.put(typeName, leftPackage.getType(typeName));
                        }
                    }
                    if (leftPackage.getResourceNames() == null && ((FilePackageExportSpecification)rightPackage).getResourceNames() == null) {
                        mergedResources = null;
                    } else if (leftPackage.getResourceNames() != null && ((FilePackageExportSpecification)rightPackage).getResourceNames() != null) {
                        mergedResources = new LinkedHashSet<String>(leftPackage.getResourceNames());
                        mergedResources.addAll(((FilePackageExportSpecification)rightPackage).getResourceNames());
                    } else if (leftPackage.getResourceNames() == null) {
                        issues.add(String.format("error: conflicting resource export for merged package %s: using specific resources of %s over all resources of %s", packageName, rightId, leftId));
                        mergedResources = ((FilePackageExportSpecification)rightPackage).getResourceNames();
                    } else {
                        issues.add(String.format("error: conflicting resource export for merged package %s: using specific resources of %s over all resources of %s", packageName, leftId, rightId));
                        mergedResources = leftPackage.getResourceNames();
                    }
                    mergedPackages.put(packageName, factory.createPackageAccessModel(packageAccess, (Map<String, FileTypeExportSpecification>)mergedTypes, mergedResources, (FileTypeExportSpecification)defaultTypeResourceAccess));
                    continue;
                }
                mergedPackages.put(packageName, rightPackage);
            }
        }
        return factory.createAccessModel(id, owner, mergedSources.toString(), mergedDomain, (Map<String, FilePackageExportSpecification>)mergedPackages, (FilePackageExportSpecification)defaultPackageAccess, (FilePackageExportSpecification)nullPackageAccess);
    }

    private static String idString(Object id) {
        if (id instanceof URL) {
            id = URLFileSystem.getPlatformPathName((URL)((URL)id));
        } else if (id instanceof Path) {
            Paths.toString((Path)id);
        }
        return String.valueOf(id);
    }

    private static int compareAccess(FilePackageExportSpecification left, FilePackageExportSpecification right) {
        return FileExportSpecification.compareAccess(left.getAccess(), right.getAccess());
    }

    private static Access min(Access left, Access right) {
        return left == Access.CONCEALED ? left : right;
    }

    private static int compareAccess(Access left, Access right) {
        if (left == right) {
            return 0;
        }
        return left == Access.CONCEALED || right == Access.EXPORTED ? -1 : 1;
    }

    public static class FileTypeExportSpecification
    implements ExportSpecification.TypeExportSpecification {
        private final Access access;
        private final Access extension;
        private final Set<String> members;
        private final Access defaultMemberAccess;

        public FileTypeExportSpecification(Access access, Access extension, Set<String> members, Access defaultMemberAccess) {
            this.access = access;
            this.extension = extension;
            this.members = members;
            this.defaultMemberAccess = defaultMemberAccess;
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public Access getExtension() {
            return this.extension;
        }

        @Override
        public Access getMember(String name) {
            if (this.defaultMemberAccess != null || this.members == null) {
                return this.defaultMemberAccess;
            }
            if (this.members.contains(name)) {
                return Access.EXPORTED;
            }
            return Access.CONCEALED;
        }

        protected Set<String> getMemberNames() {
            return this.members;
        }

        protected Access getDefaultMemberAccess() {
            return this.defaultMemberAccess;
        }
    }

    public static class FilePackageExportSpecification<T extends FileTypeExportSpecification>
    implements ExportSpecification.PackageExportSpecification {
        private final Access access;
        private final Map<String, T> types;
        private final Set<String> resources;
        private final T defaultTypeResourceAccess;

        public FilePackageExportSpecification(Access access, Map<String, T> types, Set<String> resources, T defaultTypeResourceAccess) {
            this.access = access;
            this.types = types;
            this.resources = resources;
            this.defaultTypeResourceAccess = defaultTypeResourceAccess;
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        public T getType(String name) {
            if (this.types != null) {
                return (T)((FileTypeExportSpecification)this.types.getOrDefault(name, this.defaultTypeResourceAccess));
            }
            return this.defaultTypeResourceAccess;
        }

        @Override
        public Access getResource(String name) {
            if (this.resources != null) {
                return this.resources.contains(name) ? Access.EXPORTED : Access.CONCEALED;
            }
            return ((FileTypeExportSpecification)this.defaultTypeResourceAccess).getAccess();
        }

        protected Set<String> getTypeNames() {
            return this.types != null ? this.types.keySet() : null;
        }

        protected Set<String> getResourceNames() {
            return this.resources;
        }

        protected T getDefaultTypeResourceAccess() {
            return this.defaultTypeResourceAccess;
        }
    }
}

