/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ExportDomains
implements Iterable<Domain> {
    private static final Comparator<Object> DOMAIN_STRING_COMPARATOR = (left, right) -> {
        String leftName = left instanceof String ? (String)left : ((Domain)left).name;
        String rightName = right instanceof String ? (String)right : ((Domain)right).name;
        return leftName.compareTo(rightName);
    };
    private final Set<Domain> set = new TreeSet<Domain>();
    private List<Domain> list;

    public ExportDomains(String ... names) {
        for (String name : names) {
            this.add(name);
        }
    }

    public void add(String name) {
        this.add(name, Collections.emptySet());
    }

    public void add(String name, Set<String> exceptions) {
        if (this.list != null) {
            throw new IllegalStateException("domain frozen");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name empty");
        }
        this.set.add(new Domain(name, exceptions));
    }

    public void add(ExportDomains domain) {
        if (this.list != null) {
            throw new IllegalStateException("domain frozen");
        }
        domain.freeze();
        this.set.addAll(domain.set);
    }

    public boolean controlsAll() {
        this.freeze();
        return this.set.isEmpty();
    }

    private void freeze() {
        if (this.list == null) {
            this.list = new ArrayList<Domain>(this.set);
        }
    }

    public boolean controls(String packageName) {
        if (this.controlsAll()) {
            return true;
        }
        Domain domain = this.getDomain(packageName);
        return domain != null && !domain.excepts(packageName);
    }

    public Domain getDomain(String packageName) {
        Domain predecessor;
        int index;
        this.freeze();
        if (this.list.isEmpty()) {
            return null;
        }
        if (!packageName.endsWith(".")) {
            packageName = packageName + '.';
        }
        if ((index = Collections.binarySearch(this.list, packageName, DOMAIN_STRING_COMPARATOR)) >= 0) {
            return this.list.get(index);
        }
        if (index < -1 && packageName.startsWith((predecessor = this.list.get(-index - 2)).name)) {
            return predecessor;
        }
        return null;
    }

    public int getDomainCount() {
        this.freeze();
        return this.set.size();
    }

    @Override
    public Iterator<Domain> iterator() {
        this.freeze();
        return this.list.iterator();
    }

    public String toString() {
        Collection<Domain> domains;
        StringBuilder builder = new StringBuilder();
        if (this.list != null) {
            builder.append('[');
            domains = this.list;
        } else {
            builder.append("mutable[");
            domains = this.set;
        }
        String prefix = "";
        for (Domain domain : domains) {
            builder.append(prefix);
            domain.toString(builder);
            prefix = ",";
        }
        return builder.append(']').toString();
    }

    public final class Domain
    implements Comparable<Domain> {
        private final String name;
        private final List<String> exceptions;

        Domain(String name, Set<String> exceptions) {
            if (!name.endsWith(".")) {
                throw new IllegalArgumentException("trailing \".\" required");
            }
            this.name = name;
            if (exceptions == null || exceptions.isEmpty()) {
                this.exceptions = Collections.emptyList();
            } else {
                this.exceptions = new ArrayList<String>(exceptions);
                Collections.sort(this.exceptions);
            }
        }

        public String getName() {
            return this.name;
        }

        public List<String> getExceptions() {
            return this.exceptions;
        }

        public boolean excepts(String packageName) {
            int index;
            if (this.exceptions.isEmpty()) {
                return false;
            }
            if (!packageName.endsWith(".")) {
                packageName = packageName + '.';
            }
            return (index = Collections.binarySearch(this.exceptions, packageName)) >= 0 || index < -1 && packageName.startsWith(this.exceptions.get(-index - 2));
        }

        public String getException(String packageName) {
            String predecessor;
            int index;
            if (this.exceptions.isEmpty()) {
                return "";
            }
            if (!packageName.endsWith(".")) {
                packageName = packageName + '.';
            }
            if ((index = Collections.binarySearch(this.exceptions, packageName)) >= 0) {
                return this.exceptions.get(index);
            }
            if (index < -1 && packageName.startsWith(predecessor = this.exceptions.get(-index - 2))) {
                return predecessor;
            }
            return null;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Domain)) {
                return false;
            }
            return !this.name.equals(((Domain)that).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Domain that) {
            return this.name.compareTo(that.name);
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder builder) {
            builder.append(this.name, 0, this.name.length() - 1);
            if (!this.exceptions.isEmpty()) {
                builder.append("[");
                String prefix = "";
                for (String exception : this.exceptions) {
                    builder.append(prefix).append(exception, 0, exception.length() - 1);
                    prefix = ",";
                }
                builder.append("]");
            }
            return builder;
        }
    }
}

