/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.library;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import org.xml.sax.SAXException;

public class ClassPathEntry {
    private final URL url;
    private final EntryType type;
    private final String key;
    private final boolean manifest;
    private final Object origin;
    private boolean resolved;
    private ExportSpecification exportSpecification;

    public ClassPathEntry(URL url, EntryType type, String key, boolean manifest) {
        if (!type.isSupplied()) {
            throw new IllegalArgumentException("type not supplied");
        }
        this.manifest = manifest;
        this.url = url;
        this.type = type;
        this.key = key != null ? key : "";
        this.origin = null;
        this.resolved = !type.isExporting();
    }

    public ClassPathEntry(ClassPathEntry suppliedEntry, ClassPathEntry manifestEntry) {
        this.url = suppliedEntry.url;
        this.type = suppliedEntry.type;
        this.manifest = false;
        this.key = suppliedEntry.key;
        this.origin = manifestEntry;
        this.exportSpecification = suppliedEntry.exportSpecification;
        this.resolved = true;
    }

    public ClassPathEntry(URL url, ClassPathEntry entry) {
        this.url = url;
        this.type = EntryType.DERIVED_MANIFEST;
        this.manifest = false;
        this.key = "";
        this.origin = entry;
        this.resolved = true;
    }

    public ClassPathEntry(ClassPathEntry entry, LibraryDependency dependency) {
        this.url = entry.getUrl();
        this.type = EntryType.DERIVED_DEPENDENCY;
        this.manifest = false;
        this.key = "";
        this.origin = dependency;
        this.exportSpecification = dependency.isReexported() && entry.isSupplied() ? entry.exportSpecification : null;
        this.resolved = true;
    }

    public ClassPathEntry(URL url, LibraryDependency dependency) {
        this.url = url;
        this.type = EntryType.DERIVED_DEPENDENCY;
        this.manifest = false;
        this.key = "";
        this.origin = dependency;
        this.exportSpecification = null;
        this.resolved = true;
    }

    public boolean isResolved() {
        return this.isResolved();
    }

    public URL getUrl() {
        return this.url;
    }

    public EntryType getType() {
        return this.type;
    }

    public boolean isSupplied() {
        return this.type.isSupplied();
    }

    public String getKey() {
        return this.key;
    }

    public boolean isManifest() {
        return this.manifest;
    }

    public ClassPathEntry getClassPathOrigin() {
        return this.type == EntryType.DERIVED_MANIFEST ? (ClassPathEntry)this.origin : null;
    }

    public LibraryDependency getDependencyOrigin() {
        return this.type == EntryType.DERIVED_DEPENDENCY ? (LibraryDependency)this.origin : null;
    }

    public void resolve(ExportSpecificationReader reader, Map<String, ExportSpecification> libraryExportSpecifications, List<String> issues) {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        switch (this.type) {
            case SUPPLIED_NONE: {
                this.exportSpecification = reader.getFixedAccessModel(Access.CONCEALED);
                break;
            }
            case SUPPLIED_EMBEDDED: {
                URL specificationUrl = URLFactory.newURL((URL)this.url, (String)"META-INF/lib-exports.xml");
                try {
                    this.exportSpecification = reader.read(specificationUrl, URLFileSystem.openInputStream((URL)specificationUrl), issues);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    this.exportSpecification = reader.getFixedAccessModel(Access.CONCEALED);
                    issues.add("Error: embedded export specification " + URLFileSystem.getPlatformPathName((URL)specificationUrl) + " not read: " + e);
                }
                break;
            }
            case SUPPLIED_LIBRARY: {
                this.exportSpecification = libraryExportSpecifications.get(this.key);
                if (this.exportSpecification != null) break;
                this.exportSpecification = reader.getFixedAccessModel(Access.CONCEALED);
                if (libraryExportSpecifications.containsKey(this.key)) break;
                if (this.key.isEmpty()) {
                    issues.add("Error: no default library export specification provided");
                    break;
                }
                issues.add("Error: no library export specification for key \"" + this.key + "\" provided");
                break;
            }
            case SUPPLIED_ALL: {
                this.exportSpecification = reader.getFixedAccessModel(Access.EXPORTED);
                break;
            }
            default: {
                this.exportSpecification = null;
            }
        }
    }

    public ExportSpecification getResolvedExportSpecification() {
        if (!this.resolved) {
            throw new IllegalStateException("entry not resolved");
        }
        return this.exportSpecification;
    }

    public boolean equals(Object that) {
        return that instanceof ClassPathEntry && URLFileSystem.equals((URL)this.url, (URL)((ClassPathEntry)that).url);
    }

    public int hashCode() {
        return URLFileSystem.hashCode((URL)this.url);
    }

    public String toString() {
        return "Entry " + (Object)((Object)this.type) + " " + URLFileSystem.getPlatformPathName((URL)this.url);
    }

    public static enum EntryType {
        SUPPLIED_NONE,
        SUPPLIED_EMBEDDED,
        SUPPLIED_LIBRARY,
        SUPPLIED_ALL,
        SUPPLIED_ABSENT,
        DERIVED_MANIFEST,
        DERIVED_DEPENDENCY;


        public boolean isSupplied() {
            return this.ordinal() <= SUPPLIED_ABSENT.ordinal();
        }

        public boolean isDerived() {
            return this.ordinal() > SUPPLIED_ABSENT.ordinal();
        }

        public boolean isExporting() {
            return this.ordinal() < SUPPLIED_ABSENT.ordinal();
        }
    }
}

