/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class AtomicBufferedFileWriter
extends BufferedWriter {
    private final Path path;
    private final Path workPath;
    private final BufferedWriter writer;
    private final boolean existed;
    private boolean comparing;
    private BufferedReader reader;
    private final String lineSeparator = System.getProperty("line.separator");
    private final CharArraySequence singleChar = new CharArraySequence(new char[1]);
    private final CharArraySequence multipleChars = new CharArraySequence(null);

    public static BufferedWriter newWriter(Path path) throws IOException {
        return AtomicBufferedFileWriter.newWriter(path, false);
    }

    public static BufferedWriter newWriter(Path path, boolean compareContent) throws IOException {
        Path workPath = Files.createTempFile(path.getParent(), path.getFileName().toString(), ".tmp", new FileAttribute[0]);
        BufferedWriter writer = Files.newBufferedWriter(workPath, new OpenOption[0]);
        return new AtomicBufferedFileWriter(path, workPath, writer, compareContent);
    }

    private AtomicBufferedFileWriter(Path path, Path workPath, BufferedWriter writer, boolean comparing) throws IOException {
        super(writer);
        this.path = path;
        this.workPath = workPath;
        this.writer = writer;
        if (comparing) {
            try {
                this.reader = Files.newBufferedReader(path);
            }
            catch (FileNotFoundException e) {
                this.reader = null;
            }
            this.comparing = this.reader != null;
            this.existed = this.reader != null;
        } else {
            this.reader = null;
            this.existed = Files.exists(path, new LinkOption[0]);
            this.comparing = false;
        }
    }

    private void compare(CharSequence sequence, int offset, int length) throws IOException {
        try {
            int end = offset + length;
            for (int i = offset; i < end; ++i) {
                if (sequence.charAt(i) == this.reader.read()) continue;
                this.comparing = false;
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reader = null;
                return;
            }
        }
        catch (IOException e) {
            this.comparing = false;
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    public Path getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.writer.close();
            if (this.comparing) {
                block23: {
                    try {
                        if (this.reader.read() != -1) break block23;
                        Files.delete(this.workPath);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block23;
                    }
                    finally {
                        try {
                            this.reader.close();
                        }
                        catch (IOException e) {}
                    }
                    return;
                }
                this.reader = null;
            }
            if (this.existed) {
                Path backupPath = Files.createTempFile(this.path.getParent(), this.path.getFileName().toString(), ".bak", new FileAttribute[0]);
                Files.move(this.path, backupPath, StandardCopyOption.ATOMIC_MOVE);
                try {
                    Files.move(this.workPath, this.path, StandardCopyOption.ATOMIC_MOVE);
                    try {
                        Files.delete(backupPath);
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException e) {
                    Files.move(backupPath, this.path, StandardCopyOption.ATOMIC_MOVE);
                }
            } else {
                Files.move(this.workPath, this.path, StandardCopyOption.ATOMIC_MOVE);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.comparing) {
                ((CharArraySequence)this.singleChar).array[0] = (char)c;
                this.compare(this.singleChar, 0, 1);
            }
            this.writer.write(c);
        }
    }

    @Override
    public void write(char[] characters) throws IOException {
        this.write(characters, 0, characters.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] characters, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.comparing) {
                CharArraySequence.access$002(this.multipleChars, characters);
                this.compare(this.multipleChars, offset, length);
            }
            this.writer.write(characters, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int offset, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.comparing) {
                this.compare(string, offset, length);
            }
            this.writer.write(string, offset, length);
        }
    }

    @Override
    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    private final class CharArraySubSequence
    implements CharSequence {
        private final char[] array;
        private final int offset;
        private final int length;

        public CharArraySubSequence(char[] array, int start, int end) {
            if (start < 0) {
                throw new IndexOutOfBoundsException("start negative");
            }
            if (end < 0) {
                throw new IndexOutOfBoundsException("end negative");
            }
            if (start > end) {
                throw new IndexOutOfBoundsException("start (" + start + ") > end (" + end + ")");
            }
            this.array = array;
            this.offset = start;
            this.length = end - start;
        }

        @Override
        public char charAt(int index) {
            if (index >= this.length) {
                throw new IndexOutOfBoundsException("index (" + index + ") >= length (" + this.length + ")");
            }
            return this.array[this.offset + index];
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end > this.length) {
                throw new IndexOutOfBoundsException("end (" + end + ") > length (" + this.length + ")");
            }
            return new CharArraySubSequence(this.array, this.offset + start, this.offset + end);
        }

        @Override
        public String toString() {
            return String.valueOf(this.array, this.offset, this.length);
        }
    }

    private class CharArraySequence
    implements CharSequence {
        private char[] array;

        CharArraySequence(char[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public char charAt(int index) {
            return this.array[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end > this.array.length) {
                throw new IndexOutOfBoundsException("end (" + end + ") > length (" + this.array.length + ")");
            }
            return new CharArraySubSequence(this.array, start, end);
        }

        static /* synthetic */ char[] access$002(CharArraySequence x0, char[] x1) {
            x0.array = x1;
            return x1;
        }
    }
}

