/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.command;

import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.exports.command.CommandInterface;
import oracle.javatools.exports.file.Paths;

public class CommandLog {
    public static final Severity ERROR = Severity.ERROR;
    public static final Severity WARNING = Severity.WARNING;
    public static final Severity NOTE = Severity.NOTE;
    private final Map<String, Collection<Issue>> issues = new TreeMap<String, Collection<Issue>>();
    private Path middlewareHome;
    private CommandInterface ui;
    private Object[] arguments = new Object[32];
    private int highwater = this.arguments.length;

    public CommandLog() {
        this(null, null);
    }

    public CommandLog(Path middlewareHome, CommandInterface ui) {
        if (middlewareHome == null) {
            middlewareHome = Paths.get("", new String[0]);
        }
        this.middlewareHome = middlewareHome;
        this.ui = ui;
    }

    public void progress(String format, Object ... arguments) {
        if (this.ui != null) {
            this.ui.coarse(format, arguments);
        } else {
            System.out.println(String.format(format, arguments));
        }
    }

    public void error(String format, Object ... arguments) {
        this.log(Severity.ERROR, format, arguments);
    }

    public void error(String scope, String format, Object ... arguments) {
        this.log(scope, Severity.ERROR, format, arguments);
    }

    public void error(Path scope, String format, Object ... arguments) {
        this.log(this.trim(scope), Severity.ERROR, format, arguments);
    }

    public void error(Object scope, String format, Object ... arguments) {
        this.log(this.trim(scope), Severity.ERROR, format, arguments);
    }

    public void warning(String format, Object ... arguments) {
        this.log(Severity.WARNING, format, arguments);
    }

    public void warning(String scope, String format, Object ... arguments) {
        this.log(scope, Severity.WARNING, format, arguments);
    }

    public void warning(Path scope, String format, Object ... arguments) {
        this.log(this.trim(scope), Severity.WARNING, format, arguments);
    }

    public void warning(Object scope, String format, Object ... arguments) {
        this.log(this.trim(scope), Severity.WARNING, format, arguments);
    }

    public void note(String format, Object ... arguments) {
        this.log(Severity.NOTE, format, arguments);
    }

    public void note(String scope, String format, Object ... arguments) {
        this.log(scope, Severity.NOTE, format, arguments);
    }

    public void note(Path scope, String format, Object ... arguments) {
        this.log(this.trim(scope), Severity.NOTE, format, arguments);
    }

    public void note(Object scope, String format, Object ... arguments) {
        this.log(this.trim(scope), Severity.NOTE, format, arguments);
    }

    public void log(Severity severity, String format, Object ... arguments) {
        this.log("", severity, format, arguments);
    }

    public void log(Object scope, Severity severity, String format, Object ... arguments) {
        int i;
        int length = arguments.length;
        for (i = 0; i < length; ++i) {
            Object argument = arguments[i];
            if (argument instanceof Path) {
                argument = this.trim((Path)argument);
            }
            this.arguments[i] = argument;
        }
        for (i = length; i < this.highwater; ++i) {
            this.arguments[i] = "?";
        }
        this.highwater = length;
        Issue issue = new Issue(severity, this.trim(scope), String.format(format, this.arguments));
        this.issues.computeIfAbsent(issue.getScope(), e -> new ArrayList()).add(issue);
    }

    public void log(Path scope, Severity severity, String format, Object ... arguments) {
        this.log(this.trim(scope), severity, format, arguments);
    }

    public Map<String, Collection<Issue>> getIssues() {
        return this.issues;
    }

    public String trim(Path path) {
        if (this.middlewareHome.getNameCount() == 0) {
            return Paths.toString(path);
        }
        if (Paths.isJarScheme(path)) {
            String baseString = path.getFileSystem().toString();
            Path basePath = Paths.get(baseString, new String[0]);
            if (basePath.startsWith(this.middlewareHome)) {
                baseString = this.middlewareHome.relativize(basePath).toString();
            }
            if (path.getNameCount() > 0) {
                baseString = baseString + "!" + path.toString();
            }
            return baseString;
        }
        if (path.startsWith(this.middlewareHome)) {
            path = this.middlewareHome.relativize(path);
        }
        return path.toString();
    }

    public String trim(Object pathOrString) {
        return pathOrString instanceof Path ? this.trim((Path)pathOrString) : String.valueOf(pathOrString);
    }

    public void log(Path scope, List<String> issues) {
        String basePath = this.middlewareHome.toString();
        if (!basePath.isEmpty() && !basePath.endsWith("/")) {
            basePath = basePath + '/';
        }
        for (String issue : issues) {
            int match;
            if (!basePath.isEmpty() && (match = issue.indexOf(basePath)) >= 0) {
                StringBuilder builder = new StringBuilder();
                int offset = 0;
                do {
                    builder.append(issue, offset, match);
                } while ((match = issue.indexOf(basePath, offset = match + basePath.length())) >= 0);
                builder.append(issue, offset, issue.length());
            }
            if (issue.regionMatches(true, 0, "error", 0, "error".length())) {
                if ((issue = issue.substring("error".length())).charAt(0) == ':') {
                    issue = issue.substring(1).trim();
                }
                this.error(scope, "%s", issue);
                continue;
            }
            if (issue.regionMatches(true, 0, "warning", 0, "warning".length())) {
                if ((issue = issue.substring("warning".length())).charAt(0) == ':') {
                    issue = issue.substring(1).trim();
                }
                this.warning(scope, "%s", issue);
                continue;
            }
            if (issue.regionMatches(true, 0, "note", 0, "note".length())) {
                if ((issue = issue.substring("note".length())).charAt(0) == ':') {
                    issue = issue.substring(1).trim();
                }
                this.note(scope, "%s", issue);
                continue;
            }
            this.note(scope, "%s", issue);
        }
    }

    public void writeIssues(Path path) {
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            for (Map.Entry<String, Collection<Issue>> entry : this.getIssues().entrySet()) {
                String scope = entry.getKey();
                if (!scope.isEmpty()) {
                    writer.print("-- ");
                    writer.println(scope);
                }
                for (Issue issue : entry.getValue()) {
                    switch (issue.getSeverity()) {
                        case ERROR: {
                            writer.print("error:   ");
                            break;
                        }
                        case WARNING: {
                            writer.print("warning: ");
                            break;
                        }
                        case NOTE: {
                            writer.print("note:    ");
                        }
                    }
                    writer.println(issue.getMessage());
                }
                writer.println();
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static class Issue {
        private Severity severity;
        private String scope;
        private String message;

        public Severity getSeverity() {
            return this.severity;
        }

        String getScope() {
            return this.scope;
        }

        public String getMessage() {
            return this.message;
        }

        Issue(Severity severity, String scope, String message) {
            this.severity = severity;
            this.scope = scope;
            this.message = message;
        }
    }

    public static enum Severity {
        ERROR,
        WARNING,
        NOTE;

    }
}

