/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.classpath.AccessPolicy;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.command.CommandLog;
import oracle.javatools.exports.comment.CommentModel;
import oracle.javatools.exports.specification.ExportDomains;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.FileExportSpecification;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.util.ArraySortedSet;
import org.xml.sax.SAXException;

public class ClassPathRoot {
    private final Object origin;
    private final Path path;
    private final AccessPolicy<?> accessPolicy;
    private final Map<String, String> comments;
    private final CommandLog log;
    private final Path realPath;
    private final Path rootPath;
    private Set<String> packages = new ArraySortedSet();
    private static AccessPolicy<?> NONE_ACCESS_POLICY = new FixedAccessPolicy(Access.CONCEALED);
    private static AccessPolicy<?> ALL_ACCESS_POLICY = new FixedAccessPolicy(Access.EXPORTED);
    private static AccessPolicy<?> FOREIGN_ACCESS_POLICY = new FixedAccessPolicy(null);
    private static AccessPolicy<?> JDK_ACCESS_POLICY = new FixedAccessPolicy(null);
    private static ExportSpecificationReader<FileAccessPolicy, FilePackageAccessPolicy, FileTypeAccessPolicy> accessModelReader;
    private static CommentModel commentModel;

    public ClassPathRoot(Object origin, Path path, AccessPolicy<?> accessPolicy, Map<String, String> comments, CommandLog log) {
        this.origin = origin;
        this.path = path;
        this.accessPolicy = accessPolicy;
        this.comments = comments != null ? comments : Collections.emptyMap();
        this.log = log;
        Path realPath = null;
        Path rootPath = null;
        try {
            realPath = path.toRealPath(new LinkOption[0]);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                rootPath = FileSystems.newFileSystem(path, null).getPath("/", new String[0]);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                rootPath = path;
            }
        }
        catch (NoSuchFileException e) {
            log.warning(origin, "root %s does not exist", path);
        }
        catch (FileSystemNotFoundException e) {
            log.warning(origin, "root %s is not a file system root", path);
        }
        catch (IOException e) {
            log.warning(origin, "root %s is not readable: %s", path, e);
        }
        this.realPath = realPath;
        this.rootPath = rootPath;
    }

    public ClassPathRoot(Object origin, URL url, AccessPolicy<?> accessPolicy, Map<String, String> comments, CommandLog log) {
        Path realPath;
        Path path;
        Path rootPath;
        this.origin = origin;
        this.accessPolicy = accessPolicy;
        this.comments = comments != null ? comments : Collections.emptyMap();
        this.log = log;
        if (JarUtil.isJarURL((URL)url) || URLFileSystem.isRegularFile((URL)url)) {
            URL fileUrl = JarUtil.getJarFileURL((URL)url);
            Path filePath = Paths.get(fileUrl.getPath(), new String[0]);
            String entry = JarUtil.getJarEntry((URL)url);
            if (entry == null || entry.isEmpty()) {
                entry = "/";
            }
            try {
                path = rootPath = FileSystems.newFileSystem(filePath, null).getPath(entry, new String[0]);
                try {
                    realPath = rootPath.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    realPath = null;
                }
            }
            catch (NoSuchFileException e) {
                rootPath = null;
                path = Paths.get(fileUrl.getPath() + entry, new String[0]);
                realPath = null;
                log.warning(origin, "root %s does not exist", path);
            }
            catch (FileSystemNotFoundException e) {
                rootPath = null;
                path = Paths.get(fileUrl.getPath() + entry, new String[0]);
                realPath = null;
                log.warning(origin, "root %s is not a file system root", path);
            }
            catch (IOException e) {
                rootPath = null;
                path = Paths.get(fileUrl.getPath() + entry, new String[0]);
                realPath = null;
                log.warning(origin, "root %s is not readable: %s", path, e);
            }
        } else {
            rootPath = path = Paths.get(url.getPath(), new String[0]);
            try {
                realPath = path.toRealPath(new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                realPath = null;
                log.warning(origin, "root %s does not exist", path);
            }
            catch (IOException e) {
                realPath = null;
                log.warning(origin, "root %s is not readable: %s", path, e);
            }
        }
        this.path = path;
        this.rootPath = rootPath;
        this.realPath = realPath;
    }

    public Object getOrigin() {
        return this.origin;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean exists() {
        return this.realPath != null && this.rootPath != null;
    }

    public boolean isForeign() {
        return this.accessPolicy == FOREIGN_ACCESS_POLICY;
    }

    public boolean isProprietary() {
        return this.accessPolicy != JDK_ACCESS_POLICY && this.accessPolicy != FOREIGN_ACCESS_POLICY;
    }

    public boolean isJDK() {
        return this.accessPolicy == JDK_ACCESS_POLICY;
    }

    public AccessPolicy<?> getAccessPolicy() {
        return this.accessPolicy;
    }

    Map<String, String> getComments() {
        return this.comments;
    }

    public Path getReferencePath() {
        return this.realPath != null ? this.realPath : this.path;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public String toString() {
        return this.path + " " + this.accessPolicy;
    }

    public CommandLog getLog() {
        return this.log;
    }

    void addPackage(String packag) {
        this.packages.add(packag);
    }

    public Set<String> getContainedPackages() {
        return this.packages;
    }

    public void closeFileSystem() {
        if (this.rootPath == null) {
            return;
        }
        FileSystem fileSystem = this.rootPath.getFileSystem();
        if (fileSystem != FileSystems.getDefault()) {
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                this.log.log(CommandLog.Severity.ERROR, "exception closing file system %s: %s", fileSystem, e);
            }
        }
    }

    public static AccessPolicy<?> foreignAccessPolicy() {
        return FOREIGN_ACCESS_POLICY;
    }

    public static AccessPolicy<?> jdkAccessPolicy() {
        return JDK_ACCESS_POLICY;
    }

    public static AccessPolicy<?> annotationAccessPolicy(String owner, String source, ExportDomains domains) {
        return new AnnotationAccessPolicy(owner, source, domains);
    }

    public static AccessPolicy<?> fileAccessPolicy(Path exportsPath, boolean validate, List<String> issues) throws ParserConfigurationException, SAXException, IOException {
        if (accessModelReader == null) {
            accessModelReader = new AccessPolicyReader();
            accessModelReader.setSchemaValidating(validate);
            accessModelReader.setDomainValidating(validate);
        }
        return accessModelReader.read(exportsPath, issues);
    }

    public static Map<String, String> comments(Path commentsPath, boolean validate, List<String> issues) throws ParserConfigurationException, SAXException, IOException {
        if (commentModel == null) {
            InputStream schema;
            if (validate) {
                URL fileName = CommentModel.class.getResource("lib-comments.xsd");
                issues.add("loading comments schema from %s" + fileName);
                schema = CommentModel.class.getResourceAsStream("lib-comments.xsd");
                if (schema == null) {
                    throw new ParserConfigurationException("comment schema not found at " + fileName);
                }
            } else {
                schema = null;
            }
            commentModel = new CommentModel(schema);
        }
        return commentModel.create(commentsPath, issues);
    }

    private static class FileMemberAccessPolicy
    implements AccessPolicy.MemberAccessPolicy {
        private final Access access;

        public FileMemberAccessPolicy(Access access) {
            this.access = access;
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return null;
        }
    }

    static class FileTypeAccessPolicy
    extends FileExportSpecification.FileTypeExportSpecification
    implements AccessPolicy.TypeAccessPolicy {
        private static final AccessPolicy.MemberAccessPolicy MEMBER_EXPORTED_POLICY = new FileMemberAccessPolicy(Access.EXPORTED);
        private static final AccessPolicy.MemberAccessPolicy MEMBER_CONCEALED_POLICY = new FileMemberAccessPolicy(Access.CONCEALED);
        private static final AccessPolicy.MemberAccessPolicy MEMBER_NULL_POLICY = new FileMemberAccessPolicy(null);

        FileTypeAccessPolicy(Access access, Access extension, Set<String> members, Access defaultMemberAccess) {
            super(access, extension, members, defaultMemberAccess);
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public AccessPolicy.MemberAccessPolicy getAccessForMethodOrConstructor(String name, ClassFile.ClassMethod method) {
            return this.getMemberPolicy(name);
        }

        @Override
        public AccessPolicy.MemberAccessPolicy getAccessForField(String name, ClassFile.ClassField field) {
            return this.getMemberPolicy(name);
        }

        private AccessPolicy.MemberAccessPolicy getMemberPolicy(String name) {
            Access access = this.getMember(name);
            if (access == null) {
                return MEMBER_NULL_POLICY;
            }
            return access == Access.EXPORTED ? MEMBER_EXPORTED_POLICY : MEMBER_CONCEALED_POLICY;
        }

        @Override
        protected Access getDefaultMemberAccess() {
            return super.getDefaultMemberAccess();
        }
    }

    static class FilePackageAccessPolicy
    extends FileExportSpecification.FilePackageExportSpecification<FileTypeAccessPolicy>
    implements AccessPolicy.PackageAccessPolicy<FileTypeAccessPolicy> {
        FilePackageAccessPolicy(Access access, Map<String, FileTypeAccessPolicy> types, Set<String> resources, FileTypeAccessPolicy defaultTypeResourceAccess) {
            super(access, types, resources, defaultTypeResourceAccess);
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public FileTypeAccessPolicy getPolicyForType(String name, ClassFile file, ClassPathModel.Type outerType) {
            return (FileTypeAccessPolicy)this.getType(name);
        }

        @Override
        protected Set<String> getTypeNames() {
            return super.getTypeNames();
        }

        @Override
        protected Set<String> getResourceNames() {
            return super.getResourceNames();
        }

        @Override
        protected FileTypeAccessPolicy getDefaultTypeResourceAccess() {
            return (FileTypeAccessPolicy)super.getDefaultTypeResourceAccess();
        }
    }

    static class FileAccessPolicy
    extends FileExportSpecification<FilePackageAccessPolicy>
    implements AccessPolicy<FilePackageAccessPolicy> {
        public FileAccessPolicy(Object id, String owner, String source, ExportDomains domains, Map<String, FilePackageAccessPolicy> packages, FilePackageAccessPolicy defaultPackageAccess, FilePackageAccessPolicy nullPackageAccess) {
            super(id, owner, source, domains, packages, defaultPackageAccess, nullPackageAccess);
        }

        @Override
        public FilePackageAccessPolicy getPolicyForPackage(String name, ClassPathModel.Package packag, ClassFile infoFile) {
            return (FilePackageAccessPolicy)this.getPackage(name);
        }

        @Override
        protected Collection<String> getPackageNames() {
            return super.getPackageNames();
        }

        @Override
        protected FilePackageAccessPolicy getDefaultPackageAccess() {
            return (FilePackageAccessPolicy)super.getDefaultPackageAccess();
        }

        @Override
        protected FilePackageAccessPolicy getNullPackageAccess() {
            return (FilePackageAccessPolicy)super.getNullPackageAccess();
        }
    }

    public static class AccessPolicyReader
    extends ExportSpecificationReader<FileAccessPolicy, FilePackageAccessPolicy, FileTypeAccessPolicy> {
        @Override
        public FileAccessPolicy createAccessModel(Object id, String owner, String source, ExportDomains domains, Map<String, FilePackageAccessPolicy> packages, FilePackageAccessPolicy defaultPackageAccess, FilePackageAccessPolicy nullPackageAccess) {
            return new FileAccessPolicy(id, owner, source, domains, packages, defaultPackageAccess, nullPackageAccess);
        }

        @Override
        public FilePackageAccessPolicy createPackageAccessModel(Access access, Map<String, FileTypeAccessPolicy> types, Set<String> resources, FileTypeAccessPolicy defaultTypeResourceAccess) {
            return new FilePackageAccessPolicy(access, types, resources, defaultTypeResourceAccess);
        }

        @Override
        public FileTypeAccessPolicy createTypeAccessModel(Access access, Access extension, Set<String> members, Access defaultMemberAccess) {
            return new FileTypeAccessPolicy(access, extension, members, defaultMemberAccess);
        }
    }

    private static class AnnotationMemberAccessPolicy
    implements AccessPolicy.MemberAccessPolicy {
        private final Access access;
        private final String comment;

        AnnotationMemberAccessPolicy(Access access, String comment) {
            this.access = access;
            this.comment = comment;
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return this.comment;
        }
    }

    private static class AnnotationTypeAccessPolicy
    implements AccessPolicy.TypeAccessPolicy {
        private static final AnnotationMemberAccessPolicy MEMBER_EXPORTED_POLICY = new AnnotationMemberAccessPolicy(Access.EXPORTED, null);
        private static final AnnotationMemberAccessPolicy MEMBER_CONCEALED_POLICY = new AnnotationMemberAccessPolicy(Access.CONCEALED, null);
        private static final AnnotationMemberAccessPolicy MEMBER_NULL_POLICY = new AnnotationMemberAccessPolicy(null, null);
        private final Access access;
        private final String comment;
        private final Access extension;

        AnnotationTypeAccessPolicy(Access access, String comment, Access extension) {
            this.access = access;
            this.comment = comment;
            this.extension = extension;
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public Access getExtension() {
            return this.extension;
        }

        @Override
        public Access getMember(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AnnotationMemberAccessPolicy getAccessForMethodOrConstructor(String name, ClassFile.ClassMethod method) {
            return this.getAccessForMember(method.getDeclaredAnnotations());
        }

        @Override
        public AnnotationMemberAccessPolicy getAccessForField(String name, ClassFile.ClassField field) {
            return this.getAccessForMember(field.getDeclaredAnnotations());
        }

        private AnnotationMemberAccessPolicy getAccessForMember(ClassFile.ClassAnnotation[] annotations) {
            if (this.access == null) {
                return MEMBER_NULL_POLICY;
            }
            for (ClassFile.ClassAnnotation annotation : annotations) {
                switch (annotation.getAnnotationType().toString()) {
                    case "Loracle/javatools/annotations/Concealed;": {
                        ClassFile.ComponentValue[] values = annotation.getComponentValues();
                        String comment = values.length == 1 ? values[0].getComponentValue().toString() : "";
                        return comment.trim().isEmpty() ? MEMBER_CONCEALED_POLICY : new AnnotationMemberAccessPolicy(Access.CONCEALED, comment);
                    }
                    case "Loracle/javatools/annotations/Exported;": {
                        return MEMBER_EXPORTED_POLICY;
                    }
                }
            }
            return this.access == Access.EXPORTED ? MEMBER_EXPORTED_POLICY : MEMBER_CONCEALED_POLICY;
        }
    }

    private static class AnnotationPackageAccessPolicy
    implements AccessPolicy.PackageAccessPolicy<AnnotationTypeAccessPolicy> {
        private static final AnnotationTypeAccessPolicy TYPE_ALL_EXPORTED_POLICY = new AnnotationTypeAccessPolicy(Access.EXPORTED, null, Access.EXPORTED);
        private static final AnnotationTypeAccessPolicy TYPE_ALL_EXPORTED_FINAL_POLICY = new AnnotationTypeAccessPolicy(Access.EXPORTED, null, Access.CONCEALED);
        private static final AnnotationTypeAccessPolicy TYPE_CONCEALED_POLICY = new AnnotationTypeAccessPolicy(Access.CONCEALED, null, Access.EXPORTED);
        private static final AnnotationTypeAccessPolicy TYPE_NULL_POLICY = new AnnotationTypeAccessPolicy(null, null, null);
        private final Access access;
        private final String comment;
        private final AccessPolicy.TypeAccessPolicy defaultTypeResourceAccess;

        AnnotationPackageAccessPolicy(Access access, String comment, AccessPolicy.TypeAccessPolicy defaultTypeResourceAccess) {
            this.access = access;
            this.comment = comment;
            this.defaultTypeResourceAccess = defaultTypeResourceAccess;
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public AnnotationTypeAccessPolicy getType(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Access getResource(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AnnotationTypeAccessPolicy getPolicyForType(String name, ClassFile file, ClassPathModel.Type outerType) {
            if (this.access == null) {
                return TYPE_NULL_POLICY;
            }
            assert (outerType == null || outerType.getAccess() != null) : "Type " + outerType + " not proprietary";
            for (ClassFile.ClassAnnotation annotation : file.getDeclaredAnnotations()) {
                switch (annotation.getAnnotationType().toString()) {
                    case "Loracle/javatools/annotations/Concealed;": {
                        ClassFile.ComponentValue[] concealed = annotation.getComponentValues();
                        String comment = concealed.length == 1 ? concealed[0].getComponentValue().toString() : "";
                        return comment.trim().isEmpty() ? TYPE_CONCEALED_POLICY : new AnnotationTypeAccessPolicy(Access.CONCEALED, comment, Access.EXPORTED);
                    }
                    case "Loracle/javatools/annotations/Exported;": {
                        ClassFile.ComponentValue[] exported = annotation.getComponentValues();
                        if (exported.length == 1 && "CONCEALED".equals(((ClassFile.EnumReference)exported[0].getComponentValue()).getName().toString())) {
                            return TYPE_ALL_EXPORTED_FINAL_POLICY;
                        }
                        return TYPE_ALL_EXPORTED_POLICY;
                    }
                }
            }
            if (outerType == null) {
                return this.access == Access.EXPORTED ? TYPE_ALL_EXPORTED_POLICY : TYPE_CONCEALED_POLICY;
            }
            assert (outerType.getAccess() != null);
            return outerType.getAccess() == Access.EXPORTED ? TYPE_ALL_EXPORTED_POLICY : TYPE_CONCEALED_POLICY;
        }
    }

    private static class AnnotationAccessPolicy
    implements AccessPolicy<AnnotationPackageAccessPolicy> {
        private static final AnnotationTypeAccessPolicy TYPE_ALL_EXPORTED_POLICY = new AnnotationTypeAccessPolicy(Access.EXPORTED, null, Access.EXPORTED);
        private static final AnnotationTypeAccessPolicy TYPE_CONCEALED_POLICY = new AnnotationTypeAccessPolicy(Access.CONCEALED, null, Access.EXPORTED);
        private static final AnnotationTypeAccessPolicy TYPE_NULL_POLICY = new AnnotationTypeAccessPolicy(null, null, null);
        private static final AnnotationPackageAccessPolicy PACKAGE_EXPORTED_POLICY = new AnnotationPackageAccessPolicy(Access.EXPORTED, null, TYPE_ALL_EXPORTED_POLICY);
        private static final AnnotationPackageAccessPolicy PACKAGE_CONCEALED_POLICY = new AnnotationPackageAccessPolicy(Access.CONCEALED, null, TYPE_CONCEALED_POLICY);
        private static final AnnotationPackageAccessPolicy PACKAGE_NULL_POLICY = new AnnotationPackageAccessPolicy(null, null, TYPE_NULL_POLICY);
        private final String owner;
        private final String source;
        private final ExportDomains domains;

        AnnotationAccessPolicy(String owner, String source, ExportDomains domains) {
            this.owner = owner;
            this.source = source;
            this.domains = domains;
        }

        @Override
        public Path getId() {
            return null;
        }

        @Override
        public String getOwner() {
            return this.owner;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public AnnotationPackageAccessPolicy getPackage(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AccessPolicy.PackageAccessPolicy getPolicyForPackage(String name, ClassPathModel.Package packag, ClassFile packageInfoFile) {
            if (!this.domains.controls(name)) {
                return PACKAGE_NULL_POLICY;
            }
            if (packag != null) {
                return packag.getAccess() == Access.EXPORTED ? PACKAGE_EXPORTED_POLICY : PACKAGE_CONCEALED_POLICY;
            }
            if (packageInfoFile != null) {
                for (ClassFile.ClassAnnotation annotation : packageInfoFile.getDeclaredAnnotations()) {
                    switch (annotation.getAnnotationType().toString()) {
                        case "Loracle/javatools/annotations/Concealed;": {
                            String comment;
                            ClassFile.ComponentValue[] values = annotation.getComponentValues();
                            String string = comment = values.length == 1 ? values[0].getComponentValue().toString() : null;
                            if (comment == null || comment.trim().isEmpty()) {
                                return PACKAGE_CONCEALED_POLICY;
                            }
                            return new AnnotationPackageAccessPolicy(Access.CONCEALED, comment, TYPE_CONCEALED_POLICY);
                        }
                        case "Loracle/javatools/annotations/Exported;": {
                            return PACKAGE_EXPORTED_POLICY;
                        }
                    }
                }
                return PACKAGE_CONCEALED_POLICY;
            }
            return PACKAGE_CONCEALED_POLICY;
        }

        public boolean equals(Object that) {
            return that.getClass() == this.getClass();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class FixedMemberAccessPolicy
    implements AccessPolicy.MemberAccessPolicy {
        private final Access access;

        public FixedMemberAccessPolicy(Access access) {
            this.access = access;
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return null;
        }
    }

    public static class FixedTypeAccessPolicy
    implements AccessPolicy.TypeAccessPolicy {
        private final Access access;
        private final FixedMemberAccessPolicy memberPolicy;

        public FixedTypeAccessPolicy(Access access) {
            this.access = access;
            this.memberPolicy = new FixedMemberAccessPolicy(access);
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public Access getExtension() {
            return this.access;
        }

        @Override
        public Access getMember(String name) {
            return this.access;
        }

        @Override
        public FixedMemberAccessPolicy getAccessForMethodOrConstructor(String name, ClassFile.ClassMethod method) {
            return this.memberPolicy;
        }

        @Override
        public FixedMemberAccessPolicy getAccessForField(String name, ClassFile.ClassField field) {
            return this.memberPolicy;
        }
    }

    public static class FixedPackageAccessPolicy
    implements AccessPolicy.PackageAccessPolicy<FixedTypeAccessPolicy> {
        private final Access access;
        private final FixedTypeAccessPolicy typePolicy;

        public FixedPackageAccessPolicy(Access access) {
            this.access = access;
            this.typePolicy = new FixedTypeAccessPolicy(access);
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public FixedTypeAccessPolicy getType(String name) {
            return this.typePolicy;
        }

        @Override
        public Access getResource(String name) {
            return this.access;
        }

        @Override
        public FixedTypeAccessPolicy getPolicyForType(String name, ClassFile file, ClassPathModel.Type outerType) {
            return this.typePolicy;
        }
    }

    private static class FixedAccessPolicy
    implements AccessPolicy<FixedPackageAccessPolicy> {
        private final FixedPackageAccessPolicy packagePolicy;
        private final Access access;

        public FixedAccessPolicy(Access access) {
            this.access = access;
            this.packagePolicy = new FixedPackageAccessPolicy(access);
        }

        @Override
        public Path getId() {
            return null;
        }

        @Override
        public String getOwner() {
            return null;
        }

        @Override
        public String getSource() {
            return null;
        }

        @Override
        public FixedPackageAccessPolicy getPackage(String name) {
            return this.packagePolicy;
        }

        @Override
        public FixedPackageAccessPolicy getPolicyForPackage(String name, ClassPathModel.Package packag, ClassFile infoFile) {
            return this.packagePolicy;
        }

        public boolean equals(Object that) {
            return that.getClass() == this.getClass() && this.access == ((FixedAccessPolicy)that).access;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + (Object)((Object)this.access) + "]";
        }
    }
}

