/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.classpath.AccessPolicy;
import oracle.javatools.exports.classpath.ClassFiles;
import oracle.javatools.exports.classpath.ClassPathRoot;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandLog;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.specification.ExportDomains;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.util.UnexpectedExceptionError;

public class ClassPathModel {
    private final Map<Path, ClassPathRoot> allRoots;
    private final CommandLog log;
    private final Map<String, Package> allPackages = new TreeMap<String, Package>();
    private final Map<String, Type> allTypes = new HashMap<String, Type>();
    private static final Set<String> primitiveTypes = new HashSet<String>(Arrays.asList("boolean", "byte", "char", "short", "int", "long", "float", "double"));

    public ClassPathModel(LinkedHashMap<Path, ClassPathRoot> roots, final CommandLog log) throws CommandException {
        this.log = log;
        this.allRoots = roots;
        for (final ClassPathRoot root : this.allRoots.values()) {
            if (!root.isProprietary() || !root.exists()) continue;
            int typesAlreadyProcessed = this.allTypes.size();
            try {
                final Path rootPath = root.getRootPath();
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                        try {
                            ClassPathModel.this.createType(path, rootPath.relativize(path).toString().replace('\\', '/'), root);
                        }
                        catch (Exception e) {
                            throw new UnexpectedExceptionError("exception visiting file " + path + ": " + e, (Throwable)e);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path path, IOException e) {
                        log.error("file %s visit failed: %s", Paths.toString(path), new Object[]{e});
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e) {
                throw new CommandException(e, "Root %s scan failed: %s", root.getPath(), e);
            }
            int count = this.allTypes.size() - typesAlreadyProcessed;
            log.note("scanned %d class%s under %s", count, count == 1 ? "" : "es", Paths.toString(root.getPath()));
        }
    }

    public void closeFileSystems() {
        for (ClassPathRoot root : this.allRoots.values()) {
            root.closeFileSystem();
        }
    }

    public void writeExportSpecification(String owner, List<String> consumers, ExportDomains domains, Path path) throws CommandException {
        if (path == null) {
            return;
        }
        this.log("", CommandLog.NOTE, "domains for export specification: %s", domains);
        try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));){
            writer.println("<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>");
            writer.print("<lib-exports");
            if (owner != null) {
                writer.print(" owner=\"");
                writer.print(owner);
                writer.print('\"');
            }
            writer.print(" xmlns=\"http://xmlns.oracle.com/ide/export\"");
            int rootCloses = 0;
            for (String consumer : consumers) {
                if (rootCloses++ == 0) {
                    writer.println('>');
                }
                ClassPathModel.writeIndent(1, writer);
                writer.print("<consumer team=\"");
                writer.print(consumer.trim());
                writer.println("\"/>");
            }
            if (!domains.controlsAll()) {
                if (rootCloses++ == 0) {
                    writer.println('>');
                }
                for (ExportDomains.Domain domain : domains) {
                    ClassPathModel.writeIndent(1, writer);
                    writer.write("<domain name=\"");
                    String name = domain.getName();
                    writer.write(name, 0, name.length() - 1);
                    List<String> exceptions = domain.getExceptions();
                    if (!exceptions.isEmpty()) {
                        writer.println("\">");
                        for (String exception : exceptions) {
                            ClassPathModel.writeIndent(2, writer);
                            writer.write("<except name=\"");
                            writer.write(exception);
                            writer.println("\"/>");
                        }
                        ClassPathModel.writeIndent(1, writer);
                        writer.println("</domain>");
                        continue;
                    }
                    writer.println("\"/>");
                }
            }
            for (Package packag : this.getPackages()) {
                String packageName = packag.getName();
                if (!domains.controls(packageName)) {
                    this.log(packag, CommandLog.WARNING, "package %s outside domains: ignoring", packag.getFullName());
                    continue;
                }
                if (!packag.hasProprietaryChildren()) continue;
                assert (packag.getAccess() != null);
                if (packag.isDeprecated()) {
                    this.log(packag, CommandLog.WARNING, "package %s deprecated but not concealed", packag.getFullName());
                }
                if (!packag.hasExportedTypesOrResources()) {
                    if (packag.getAccess() != Access.EXPORTED) continue;
                    this.log(packag, CommandLog.WARNING, "package %s exported but no children exported: treating as concealed", packag.getFullName());
                    continue;
                }
                if (rootCloses++ == 0) {
                    writer.println('>');
                }
                ClassPathModel.writeIndent(1, writer);
                writer.print("<package name=\"");
                writer.print(packageName);
                if (packag.hasConcealedTypesOrResources() || packag.hasInextensibleTypes()) {
                    writer.println("\">");
                    String lastTypeName = "";
                    for (Type type : packag.getTypes()) {
                        String tag;
                        String prefix;
                        if (!type.isProprietary()) continue;
                        String typeName = type.getName();
                        if (typeName.startsWith(prefix = lastTypeName + "_") && !(tag = Locale.forLanguageTag(typeName.substring(prefix.length())).toLanguageTag()).isEmpty()) {
                            this.log(type, CommandLog.WARNING, "type %s appears to be locale-specific (%s) but evaded the default exclusion algorithm", type.getName(), tag);
                        }
                        lastTypeName = typeName;
                        if (!type.isSelfOrMemberExported()) continue;
                        if (type.isDeprecated()) {
                            this.log(packag, CommandLog.WARNING, "type %s deprecated but not concealed", type.getFullName());
                        }
                        if (!type.hasExportedChildren() && type.hasConcealedChildren()) {
                            this.log(type, CommandLog.WARNING, "type %s exported but no children exported", type.getFullName());
                        }
                        ClassPathModel.writeIndent(2, writer);
                        writer.print("<");
                        String typeElementName = type.isInterface() ? "interface" : "class";
                        writer.print(typeElementName);
                        writer.print(" name=\"");
                        writer.print(typeName);
                        if (type.isInextensible()) {
                            writer.print("\" extension=\"concealed");
                        }
                        if (type.hasExportedChildren() && type.hasConcealedChildren()) {
                            writer.println("\">");
                            for (Member<?> member : type.getDeclaredMembers()) {
                                if (!member.isExported()) continue;
                                String memberLabel = member.getClass().getSimpleName().toLowerCase();
                                if (member.isDeprecated()) {
                                    this.log(member, CommandLog.WARNING, "%s %s deprecated but not concealed", memberLabel, member.getFullName());
                                }
                                ClassPathModel.writeIndent(3, writer);
                                writer.print("<");
                                writer.print(memberLabel);
                                if (member instanceof Field) {
                                    writer.print(' ');
                                }
                                writer.print(" name=\"");
                                writer.print(member.getName());
                                writer.println("\"/>");
                            }
                            ClassPathModel.writeIndent(2, writer);
                            writer.print("</");
                            writer.print(typeElementName);
                            writer.println(">");
                            continue;
                        }
                        if (type.hasConcealedChildren()) {
                            writer.println("\" members=\"concealed\"/>");
                            continue;
                        }
                        writer.println("\"/>");
                    }
                    ClassPathModel.writeIndent(1, writer);
                    writer.println("</package>");
                    continue;
                }
                writer.println("\"/>");
            }
            writer.println(rootCloses++ == 0 ? "/>" : "</lib-exports>");
        }
        catch (IOException e) {
            throw new CommandException(e, "Export specification %s not created: %s" + path, e);
        }
    }

    private static void writeIndent(int depth, PrintWriter writer) {
        for (int i = 0; i < depth; ++i) {
            writer.print("  ");
        }
    }

    Type findTypeInClassPath(String typeName) {
        String relativePath = typeName + ".class";
        Type type = this.allTypes.get(relativePath);
        if (type != null) {
            return type;
        }
        for (ClassPathRoot root : this.allRoots.values()) {
            Path path;
            if (!root.exists() || !Files.exists(path = root.getRootPath().resolve(relativePath), new LinkOption[0])) continue;
            try {
                type = this.createType(path, relativePath, root);
                if (type == null) continue;
                return type;
            }
            catch (IOException e) {
                this.log.log(CommandLog.WARNING, "exception creating type %s from %s: %s", typeName, path, e);
            }
        }
        int slash = typeName.lastIndexOf(47);
        String qualifier = slash >= 0 ? typeName.substring(0, slash).replace('/', '.') + "." : "";
        String name = typeName.substring(slash + 1).replace('$', '.');
        type = new Type(qualifier, name);
        this.allTypes.put(relativePath, type);
        this.log(type, CommandLog.WARNING, "unresolved type %s", type.getFullName());
        return type;
    }

    private Type createType(Path path, String relativePath, ClassPathRoot root) throws IOException {
        AccessPolicy.PackageAccessPolicy packageAccessPolicy;
        Type type = this.allTypes.get(relativePath);
        if (type != null) {
            return type;
        }
        int slash = relativePath.lastIndexOf(47);
        String fileName = relativePath.substring(slash + 1);
        if (!fileName.endsWith(".class") || fileName.equals("package-info.class")) {
            return null;
        }
        String packageName = slash < 0 ? "" : relativePath.substring(0, slash).replace('/', '.');
        Package packag = this.allPackages.get(packageName);
        if (packag == null) {
            String packageComment;
            ClassFile packageInfoClass;
            Path info = path.resolveSibling("package-info.class");
            if (Files.exists(info, new LinkOption[0])) {
                try {
                    packageInfoClass = ClassFiles.readClassFile(info, null);
                }
                catch (IOException e) {
                    this.log.log(packageName, CommandLog.ERROR, "exception visiting file %s: %s", ClassPathModel.toString(info), e);
                    packageInfoClass = null;
                }
            } else {
                packageInfoClass = null;
            }
            packageAccessPolicy = root.getAccessPolicy().getPolicyForPackage(packageName, packag, packageInfoClass);
            Access packageAccess = packageAccessPolicy.getAccess();
            if (root.isProprietary() && packageAccess == null) {
                this.log(packageName, CommandLog.WARNING, "package %s not in domains", packageName);
            }
            if ((packageComment = packageAccessPolicy.getComment()) == null) {
                packageComment = root.getComments().get(packageName);
            }
            packag = new Package(packageName, packageAccess, packageComment, packageInfoClass);
            this.allPackages.put(packageName, packag);
        } else {
            packageAccessPolicy = root.getAccessPolicy().getPolicyForPackage(packageName, packag, null);
        }
        return this.createTypeInPackage(path, relativePath, packag, fileName, root, packageAccessPolicy);
    }

    private Type createTypeInPackage(Path path, String relativePath, Package packag, String fileName, ClassPathRoot root, AccessPolicy.PackageAccessPolicy packageAccessPolicy) throws IOException {
        Type type;
        Access typeAccess;
        AccessPolicy.TypeAccessPolicy typeAccessPolicy;
        String outerRelativePath;
        SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);
        Type outerType = null;
        String typeName = fileName.substring(0, fileName.length() - ".class".length()).replace('$', '.');
        int dot = typeName.lastIndexOf(46);
        if (dot >= 0 && (outerType = this.allTypes.get(outerRelativePath = relativePath.substring(0, relativePath.length() - ".class".length() - (typeName.length() - dot)) + ".class")) == null) {
            String outerFileName = typeName.substring(0, dot).replace('.', '$') + ".class";
            Path outerPath = path.resolveSibling(outerFileName);
            try {
                outerType = this.createTypeInPackage(outerPath, outerRelativePath, packag, outerFileName, root, packageAccessPolicy);
                if (outerType == null) {
                    return null;
                }
            }
            catch (IOException e) {
                this.log.log(packag.getFullName() + '.' + typeName, CommandLog.ERROR, "exception loading outer type %s for %s: %s", ClassPathModel.toString(outerPath), ClassPathModel.toString(path), e);
                return null;
            }
        }
        ClassFile file = ClassFiles.readClassFile(path, channel);
        int modifiers = file.getModifiers();
        String packageName = packag.getFullName();
        String sourceFileName = file.getSourceFilename();
        if (sourceFileName == null) {
            sourceFileName = "";
        }
        boolean typeReachable = !(!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || packageName.isEmpty() || outerType != null && !outerType.isReachable() && !Modifier.isStatic(modifiers) || sourceFileName.endsWith(".groovy") || this.isLocaleSpecific(path, fileName));
        Map<String, String> comments = root.getComments();
        if (typeReachable) {
            typeAccessPolicy = packageAccessPolicy.getPolicyForType(typeName, file, outerType);
            typeAccess = typeAccessPolicy.getAccess();
            String typeComment = typeAccessPolicy.getComment();
            if (typeComment == null) {
                typeComment = comments.get(packageName.isEmpty() ? typeName : packageName + "." + typeName);
            }
            type = new Type(packag, outerType, typeName, root, typeReachable, typeAccess, typeComment, typeAccessPolicy.getExtension(), file, path);
            if ((outerType != null ? outerType : packag).getAccess() == Access.CONCEALED && typeAccess == Access.EXPORTED) {
                this.log(type, CommandLog.WARNING, "type %s expands access", type.getFullName());
            }
        } else {
            typeAccessPolicy = null;
            typeAccess = Access.CONCEALED;
            type = new Type(packag, outerType, typeName, root, typeReachable, typeAccess, null, Access.CONCEALED, file, path);
            if (this.hasExportedAnnotation(file.getDeclaredAnnotations())) {
                if (packageName.isEmpty()) {
                    this.log(type, CommandLog.ERROR, "@Exported ignored on type in default package %s", type.getFullName());
                } else if (sourceFileName.endsWith(".groovy")) {
                    this.log(type, CommandLog.ERROR, "@Exported ignored on Groovy type %s", type.getFullName());
                } else if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) {
                    this.log(type, CommandLog.ERROR, "@Exported ignored on private type %s: type must be public or protected", type.getFullName());
                } else {
                    this.log(type, CommandLog.ERROR, "@Exported ignored on non-static inner type %s: outer type must be public or protected", type.getFullName());
                }
            }
        }
        if (root.isProprietary() && root.exists()) {
            root.addPackage(packageName);
        }
        for (ClassFile.ClassMethod classMethod : file.getDeclaredConstructors()) {
            Constructor member;
            if (!ClassFiles.publicOrProtected(classMethod.getModifiers())) continue;
            ClassFiles.MethodDescriptor constructorDescriptor = ClassFiles.parseMethodDescriptor(type, "", classMethod.getDescriptor());
            if (typeReachable) {
                AccessPolicy.MemberAccessPolicy memberAccessPolicy = typeAccessPolicy.getAccessForMethodOrConstructor(type.getName() + constructorDescriptor.toString(), classMethod);
                String memberComment = memberAccessPolicy.getComment();
                if (memberComment == null) {
                    memberComment = comments.get(type.getFullName() + constructorDescriptor.toString());
                }
                member = new Constructor(type, constructorDescriptor, memberAccessPolicy.getAccess(), memberComment, classMethod);
                if (typeAccess == Access.CONCEALED && memberAccessPolicy.getAccess() == Access.EXPORTED) {
                    this.log(member, CommandLog.WARNING, "constructor %s expands access", member.getFullName());
                }
            } else {
                member = new Constructor(type, constructorDescriptor, Access.CONCEALED, null, classMethod);
                if (this.hasExportedAnnotation(classMethod.getDeclaredAnnotations())) {
                    this.log(member, CommandLog.ERROR, "@Exported ignored on constructor of inaccessible type %s", member.getFullName());
                }
            }
            if (type.addOrGetMember(member) == member) continue;
            this.log(type, CommandLog.ERROR, "constructor %s duplicated (%s)", member.getFullName(), type.getLocation());
        }
        for (ClassFile.ClassMethod classMethod : file.getDeclaredMethods()) {
            Method member;
            int methodModifiers = classMethod.getModifiers();
            if (!ClassFiles.publicOrProtected(methodModifiers) || ClassFiles.bridge(methodModifiers)) continue;
            ClassFiles.MethodDescriptor methodDescriptor = ClassFiles.parseMethodDescriptor(type, classMethod.getMethodName(), classMethod.getDescriptor());
            if (typeReachable) {
                AccessPolicy.MemberAccessPolicy memberAccessPolicy = typeAccessPolicy.getAccessForMethodOrConstructor(methodDescriptor.toString(), classMethod);
                String memberComment = memberAccessPolicy.getComment();
                if (memberComment == null) {
                    memberComment = comments.get(type.getFullName() + "." + methodDescriptor.toString());
                }
                member = new Method(type, methodDescriptor, memberAccessPolicy.getAccess(), memberComment, classMethod);
                if (typeAccess == Access.CONCEALED && memberAccessPolicy.getAccess() == Access.EXPORTED) {
                    this.log(member, CommandLog.WARNING, "method %s expands access", member.getFullName());
                }
            } else {
                member = new Method(type, methodDescriptor, Access.CONCEALED, null, classMethod);
                if (this.hasExportedAnnotation(classMethod.getDeclaredAnnotations())) {
                    this.log(member, CommandLog.ERROR, "@Exported ignored on method of inaccessible type %s", member.getFullName());
                }
            }
            if (type.addOrGetMember(member) == member) continue;
            this.log(member, CommandLog.ERROR, "method %s duplicated (%s)", member.getFullName(), type.getLocation());
        }
        for (ClassFile.ClassMethod classMethod : file.getDeclaredFields()) {
            Field member;
            if (!ClassFiles.publicOrProtected(classMethod.getModifiers())) continue;
            if (typeReachable) {
                AccessPolicy.MemberAccessPolicy memberAccessPolicy = typeAccessPolicy.getAccessForField(classMethod.getFieldName(), (ClassFile.ClassField)classMethod);
                String memberComment = memberAccessPolicy.getComment();
                if (memberComment == null) {
                    memberComment = comments.get(type.getFullName() + "." + classMethod.getFieldName());
                }
                member = new Field(type, classMethod.getFieldName(), memberAccessPolicy.getAccess(), memberComment, (ClassFile.ClassField)classMethod);
                if (typeAccess == Access.CONCEALED && memberAccessPolicy.getAccess() == Access.EXPORTED) {
                    this.log(member, CommandLog.WARNING, "field %s expands access", member.getFullName());
                }
            } else {
                member = new Field(type, classMethod.getFieldName(), Access.CONCEALED, null, (ClassFile.ClassField)classMethod);
                if (this.hasExportedAnnotation(classMethod.getDeclaredAnnotations())) {
                    this.log(member, CommandLog.ERROR, "@Exported ignored on field of inaccessible type %s", member.getFullName());
                }
            }
            if (type.addOrGetMember(member) == member) continue;
            this.log(type, CommandLog.ERROR, "field %s duplicated (%s)", member.getFullName(), type.getLocation());
        }
        if (packag.addOrGetChild(type) != type) {
            this.log(type, CommandLog.WARNING, "type %s duplicated (%s precedes %s)", type.getFullName(), packag.getType(type.getName()).getLocation(), type.getLocation());
            return null;
        }
        this.allTypes.put(relativePath, type);
        return type;
    }

    private boolean isLocaleSpecific(Path path, String fileName) {
        int dot = fileName.length() - ".class".length();
        int bar = fileName.lastIndexOf(95, dot - 2);
        if (bar < 0) {
            return false;
        }
        switch (fileName.substring(bar + 1, dot)) {
            case "ar": 
            case "ca": 
            case "cs": 
            case "da": 
            case "de": 
            case "el": 
            case "en": 
            case "es": 
            case "fi": 
            case "fr": 
            case "he": 
            case "hu": 
            case "it": 
            case "iw": 
            case "ja": 
            case "ko": 
            case "nl": 
            case "no": 
            case "pl": 
            case "pt": 
            case "ro": 
            case "ru": 
            case "sk": 
            case "sv": 
            case "th": 
            case "tr": {
                return Files.exists(path.resolveSibling(fileName.substring(0, bar) + ".class"), new LinkOption[0]);
            }
            case "AU": 
            case "BR": 
            case "CA": 
            case "CN": 
            case "ES": 
            case "GB": 
            case "IE": 
            case "IN": 
            case "NZ": 
            case "TW": 
            case "US": 
            case "ZA": {
                int rebar = fileName.lastIndexOf(95, bar - 3);
                if (rebar < 0) {
                    return false;
                }
                switch (fileName.substring(rebar + 1, dot)) {
                    case "en_AU": 
                    case "en_CA": 
                    case "en_GB": 
                    case "en_IE": 
                    case "en_IN": 
                    case "en_NZ": 
                    case "en_ZA": 
                    case "en_US": 
                    case "es_ES": 
                    case "fr_CA": 
                    case "pt_BR": 
                    case "zh_CN": 
                    case "zh_TW": {
                        return Files.exists(path.resolveSibling(fileName.substring(0, rebar) + ".class"), new LinkOption[0]);
                    }
                }
            }
        }
        return false;
    }

    private boolean hasExportedAnnotation(ClassFile.ClassAnnotation[] annotations) {
        for (ClassFile.ClassAnnotation annotation : annotations) {
            switch (annotation.getAnnotationType().toString()) {
                case "Loracle/javatools/annotations/Concealed;": {
                    return false;
                }
                case "Loracle/javatools/annotations/Exported;": {
                    return true;
                }
            }
        }
        return false;
    }

    public Collection<ClassPathRoot> getRoots() {
        return this.allRoots.values();
    }

    public Collection<Package> getPackages() {
        return this.allPackages.values();
    }

    public Package getPackage(String name) {
        return this.allPackages.get(name);
    }

    public void log(Element element, CommandLog.Severity severity, String format, Object ... arguments) {
        this.log.log(element.getFullName(), severity, format, arguments);
    }

    public void log(String scope, CommandLog.Severity severity, String format, Object ... arguments) {
        this.log.log(scope, severity, format, arguments);
    }

    static String toString(Path path) {
        if (path == null) {
            return "<unknown>";
        }
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return path.toString();
        }
        return Paths.get(path.getFileSystem().toString(), new String[0]) + "!" + path;
    }

    public static class Field
    extends Member<Field> {
        private String typeName;

        Field(Type parent, String name, Access access, String accessComment, ClassFile.ClassField field) {
            super(parent, parent.getFullName() + '.', name, field.isDeprecated(), access, accessComment);
            this.typeName = ClassFiles.parseFieldDescriptor(field.getDescriptor());
        }

        String getTypeName() {
            return this.typeName;
        }

        @Override
        public Set<Type> getProblemTypes(ClassPathModel model) {
            TreeSet<Type> types = new TreeSet<Type>();
            this.maybeAddProblemType(this.typeName, "field", types, model);
            return types;
        }
    }

    public static class Method
    extends Member<Method> {
        private final ClassFiles.MethodDescriptor descriptor;

        Method(Type parent, ClassFiles.MethodDescriptor descriptor, Access access, String accessComment, ClassFile.ClassMethod method) {
            super(parent, parent.getFullName() + '.', descriptor.toString(), method.isDeprecated(), access, accessComment);
            this.descriptor = descriptor;
        }

        public String getMethodName() {
            return this.descriptor.getMethodName();
        }

        public List<String> getParameterTypeNames() {
            return this.descriptor.getParameterTypeNames();
        }

        public String getReturnTypeName() {
            return this.descriptor.getReturnTypeName();
        }

        @Override
        public Set<Type> getProblemTypes(ClassPathModel model) {
            TreeSet<Type> types = new TreeSet<Type>();
            for (String typeName : this.descriptor.getParameterTypeNames()) {
                this.maybeAddProblemType(typeName, "parameter", types, model);
            }
            String returnTypeName = this.descriptor.getReturnTypeName();
            if (!"void".equals(returnTypeName)) {
                this.maybeAddProblemType(returnTypeName, "return", types, model);
            }
            return types;
        }
    }

    public static class Constructor
    extends Member<Constructor> {
        private final String typeSimpleName;
        private List<String> parameterTypeNames;

        Constructor(Type parent, ClassFiles.MethodDescriptor descriptor, Access access, String accessComment, ClassFile.ClassMethod constructor) {
            super(parent, parent.getFullName(), descriptor.toString(), constructor.isDeprecated(), access, accessComment);
            this.typeSimpleName = parent.getName();
            this.parameterTypeNames = descriptor.getParameterTypeNames();
        }

        @Override
        public String getName() {
            return this.typeSimpleName + super.getName();
        }

        @Override
        public Set<Type> getProblemTypes(ClassPathModel model) {
            TreeSet<Type> types = new TreeSet<Type>();
            for (String typeName : this.parameterTypeNames) {
                this.maybeAddProblemType(typeName, "parameter", types, model);
            }
            return types;
        }
    }

    public static abstract class Member<T>
    extends TypeOrMember {
        Member(Type parent, String qualifier, String name, boolean deprecated, Access access, String accessComment) {
            super(qualifier, name, deprecated, parent.isReachable(), access, parent.isJDK(), accessComment);
        }

        public boolean isConcealed() {
            return this.all(16, 64);
        }

        public boolean isExported() {
            return this.all(16, 32);
        }

        public abstract Set<Type> getProblemTypes(ClassPathModel var1);

        void maybeAddProblemType(String typeName, String context, Set<Type> problemTypes, ClassPathModel model) {
            if (typeName.endsWith("[]")) {
                this.maybeAddProblemType(typeName.substring(0, typeName.length() - 2), context, problemTypes, model);
                return;
            }
            if (primitiveTypes.contains(typeName)) {
                return;
            }
            Type type = model.findTypeInClassPath(typeName);
            if (type.isJDK()) {
                return;
            }
            if (type.isUnresolved()) {
                problemTypes.add(type);
                model.log(this, CommandLog.WARNING, "unresolved %s type %s in %s", context, type.getFullName(), this.getFullName());
            } else if (!type.isReachable() || !type.isSelfOrMemberExported() || type.isForeign()) {
                problemTypes.add(type);
            }
        }
    }

    public static class Type
    extends TypeOrMember {
        private final Object origin;
        private final Type outerType;
        private final Path path;
        private final String superClassName;
        private final List<String> interfaceNames;
        private Type superClass;
        private List<Type> interfaces;
        private final Map<String, Member<?>> members = new TreeMap();
        private Iterable<Member<?>> declaredMemberIterable = new Iterable<Member<?>>(this){
            final /* synthetic */ Type this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<Member<?>> iterator() {
                return new Iterator<Member<?>>(){
                    private Iterator<Member<?>> i;
                    private Member<?> next;
                    {
                        this.i = this$0.members.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        while (this.i.hasNext()) {
                            Member<?> member = this.i.next();
                            if (!this$0.isDeclaredMember(member)) continue;
                            this.next = member;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Member<?> next() {
                        if (this.next != null) {
                            Member<?> next = this.next;
                            this.next = null;
                            return next;
                        }
                        while (this.i.hasNext()) {
                            Member<?> member = this.i.next();
                            if (!this$0.isDeclaredMember(member)) continue;
                            return member;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };

        Type(Package parent, Type outerType, String name, ClassPathRoot root, boolean reachable, Access access, String accessComment, Access extension, ClassFile file, Path path) {
            super(parent.getName().isEmpty() ? "" : parent.getName() + '.', name, file.isDeprecated(), reachable, access, root.isJDK(), accessComment);
            this.origin = root.getOrigin();
            if (name.endsWith("[]")) {
                throw new IllegalStateException("array type not supported");
            }
            if (primitiveTypes.contains(name)) {
                throw new IllegalStateException("primitive type not supported");
            }
            this.outerType = outerType;
            int modifiers = file.getModifiers();
            this.set(2, file.isInterface());
            this.set(4, Modifier.isStatic(modifiers));
            this.set(256, reachable && access == Access.EXPORTED && extension == Access.CONCEALED);
            this.superClassName = file.getBaseClass() != null ? file.getBaseClass().toString() : null;
            this.interfaceNames = new ArrayList<String>();
            for (Name s : file.getBaseInterfaces()) {
                this.interfaceNames.add(s.toString());
            }
            this.path = path;
        }

        Type(String qualifier, String name) {
            super(qualifier, name, false, false, null, false, null);
            this.set(1);
            this.origin = null;
            this.outerType = null;
            this.path = null;
            this.superClassName = "java/lang/Object";
            this.interfaceNames = Collections.emptyList();
        }

        public boolean isUnresolved() {
            return this.is(1);
        }

        public boolean isInterface() {
            return this.is(2);
        }

        public Type getOuterType() {
            return this.outerType;
        }

        boolean isStatic() {
            return this.all(4);
        }

        public boolean isNonStaticInnerClass() {
            return this.outerType != null && !this.isStatic();
        }

        public boolean isSelfOrMemberExported() {
            return this.all(16, 32) || this.is(2048);
        }

        public boolean isSelfOrMemberConcealed() {
            return this.all(16, 64) || this.is(8192);
        }

        public boolean hasExportedChildren() {
            return this.is(2048);
        }

        public boolean hasConcealedChildren() {
            return this.is(8192);
        }

        public boolean isInextensible() {
            return this.is(256);
        }

        <C extends Member<C>> C addOrGetMember(C member) {
            Member<?> predecessor = this.members.putIfAbsent(member.getKey(), member);
            if (predecessor != null) {
                return (C)predecessor;
            }
            if (member.isExported()) {
                this.set(2048);
            }
            if (member.isConcealed()) {
                this.set(8192);
            }
            return member;
        }

        <C extends Member<C>> C addInheritedMember(C member) {
            if (member.getClass() == Constructor.class) {
                throw new IllegalArgumentException("child is constructor");
            }
            Member<?> predecessor = this.members.putIfAbsent(member.getKey(), member);
            if (predecessor != null) {
                throw new IllegalStateException(member.getClass().getSimpleName() + ' ' + member.getFullName() + " duplicates " + predecessor.getClass().getSimpleName() + ' ' + predecessor.getFullName());
            }
            return member;
        }

        public <C extends Member<C>> C getDeclaredMember(String key) {
            Member<?> member = this.members.get(key);
            return (C)(member != null && this.isDeclaredMember(member) ? member : null);
        }

        public Iterable<Member<?>> getDeclaredMembers() {
            return this.declaredMemberIterable;
        }

        private boolean isDeclaredMember(Member<?> member) {
            String qualifier = member.getQualifier();
            String fullName = this.getFullName();
            return qualifier.length() - fullName.length() == (member instanceof Constructor ? 0 : 1) && qualifier.regionMatches(0, fullName, 0, fullName.length());
        }

        public <C extends Member<C>> C getDeclaredOrInheritedMember(String name, ClassPathModel model) {
            Type type;
            Member<Object> child = this.members.get(name);
            if (child != null) {
                return (C)child;
            }
            for (type = this.getSuperClass(model); type != null; type = type.getSuperClass(model)) {
                child = type.members.get(name);
                if (child == null) continue;
                return (C)this.addInheritedMember(child);
            }
            for (type = this; type != null; type = type.getSuperClass(model)) {
                for (Type i : type.getInterfaces(model)) {
                    child = i.getDeclaredOrInheritedMember(name, model);
                    if (child == null) continue;
                    return (C)this.addInheritedMember(child);
                }
            }
            return null;
        }

        Type getSuperClass(ClassPathModel model) {
            if (this.superClass != null) {
                return this.superClass;
            }
            if (this.superClassName == null) {
                return null;
            }
            this.superClass = model.findTypeInClassPath(this.superClassName);
            if (this.superClass.isUnresolved()) {
                model.log(this, CommandLog.WARNING, "unresolved base class %s in %s", this.superClass.getFullName(), this.getFullName());
            }
            return this.superClass;
        }

        Iterable<Type> getInterfaces(final ClassPathModel model) {
            if (this.interfaces == null) {
                this.interfaces = new ArrayList<Type>(this.interfaceNames.size());
            }
            return new Iterable<Type>(){

                @Override
                public Iterator<Type> iterator() {
                    return new Iterator<Type>(){
                        private int index = 0;
                        private Type next;

                        @Override
                        public boolean hasNext() {
                            if (this.next != null) {
                                return true;
                            }
                            while (this.index < interfaces.size()) {
                                this.next = (Type)interfaces.get(this.index++);
                                if (this.next == null) continue;
                                return true;
                            }
                            while (this.index < interfaceNames.size()) {
                                this.next = model.findTypeInClassPath((String)interfaceNames.get(this.index++));
                                if (this.next.isUnresolved()) {
                                    model.log(this, CommandLog.WARNING, "unresolved base interface %s in %s", this.next.getFullName(), this.getFullName());
                                }
                                if (interfaces.contains(this.next)) {
                                    this.next = null;
                                }
                                interfaces.add(this.next);
                                if (this.next == null) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Type next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Type result = this.next;
                            this.next = null;
                            return result;
                        }
                    };
                }
            };
        }

        String getLocation() {
            return this.getLocation(null);
        }

        public Object getOrigin() {
            return this.origin;
        }

        public String getLocation(Path baseDirectory) {
            if (this.path == null) {
                return "<unknown>";
            }
            if (this.path.getFileSystem() == FileSystems.getDefault()) {
                return baseDirectory != null ? baseDirectory.relativize(this.path).toString() : this.path.toString();
            }
            Path filePath = Paths.get(this.path.getFileSystem().toString(), new String[0]);
            if (baseDirectory != null) {
                filePath = baseDirectory.relativize(filePath);
            }
            return filePath.toString() + '!' + this.path.toString();
        }
    }

    static abstract class TypeOrMember
    extends Element {
        public TypeOrMember(String qualifier, String name, boolean deprecated, boolean reachable, Access access, boolean jdk, String accessComment) {
            super(qualifier, name, deprecated, access, accessComment);
            this.set(16, reachable);
            this.set(128, jdk);
        }

        public boolean isReachable() {
            return this.is(16);
        }

        public boolean isProprietary() {
            return this.any(32, 64) && this.is(16);
        }

        public boolean isForeign() {
            return this.none(64, 32, 128);
        }

        boolean isJDK() {
            return this.is(128);
        }

        public boolean isUsed() {
            return this.is(1024);
        }

        public void setUsed(boolean used) {
            this.set(1024, used);
        }
    }

    public static class Package
    extends Element {
        private final Map<String, Type> types = new TreeMap<String, Type>();

        Package(String name, Access access, String accessComment, ClassFile packageInfoFile) {
            super(null, name, packageInfoFile != null ? packageInfoFile.isDeprecated() : false, access, accessComment);
        }

        @Override
        public String getFullName() {
            return this.getName();
        }

        public boolean hasProprietaryChildren() {
            return this.any(2048, 8192);
        }

        public boolean hasExportedTypesOrResources() {
            return this.is(2048);
        }

        public boolean hasConcealedTypesOrResources() {
            return this.all(8192);
        }

        public boolean hasInextensibleTypes() {
            return this.all(4096);
        }

        boolean hasUsedChildren() {
            return this.is(1024);
        }

        public void setHasUsedChildren(boolean hasUsed) {
            this.set(1024, hasUsed);
        }

        Type addOrGetChild(Type child) {
            Type predecessor = this.types.putIfAbsent(child.getKey(), child);
            if (predecessor != null) {
                return predecessor;
            }
            if (child.isInextensible()) {
                this.set(4096);
            }
            if (child.isSelfOrMemberExported()) {
                this.set(2048);
            }
            if (child.isSelfOrMemberConcealed()) {
                this.set(8192);
            }
            return child;
        }

        public Type getType(String key) {
            return this.types.get(key);
        }

        public Collection<Type> getTypes() {
            return this.types.values();
        }
    }

    public static abstract class Element
    implements Comparable<Element> {
        static final short UNRESOLVED = 1;
        static final short INTERFACE = 2;
        static final short STATIC = 4;
        static final short DEPRECATED = 8;
        static final short REACHABLE = 16;
        static final short EXPORTED = 32;
        static final short CONCEALED = 64;
        static final short JDK = 128;
        static final short INEXTENSIBLE = 256;
        static final short USED = 1024;
        static final short HAS_EXPORTED_CHILDREN = 2048;
        static final short HAS_INEXTENSIBLE_CHILDREN = 4096;
        static final short HAS_CONCEALED_CHILDREN = 8192;
        private final String qualifier;
        private final String name;
        private final String accessComment;
        private short flags;

        final boolean is(int flag) {
            return (this.flags & flag) != 0;
        }

        final boolean all(int ... flags) {
            int union = 0;
            for (int flag : flags) {
                union |= flag;
            }
            return (this.flags & union) == union;
        }

        final boolean any(int ... flags) {
            int union = 0;
            for (int flag : flags) {
                union |= flag;
            }
            return (this.flags & union) != 0;
        }

        final boolean none(int ... flags) {
            int union = 0;
            for (int flag : flags) {
                union |= flag;
            }
            return (this.flags & union) == 0;
        }

        final boolean set(int flag, boolean value) {
            this.flags = value ? (short)(this.flags | flag) : (short)(this.flags & ~flag);
            return value;
        }

        final void set(int flag) {
            this.flags = (short)(this.flags | flag);
        }

        String flags() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.is(32) ? (this.is(256) || !(this instanceof Type) ? "exported-inextensible," : "exported,") : (this.is(64) ? "concealed," : (this.is(128) ? "jdk," : "foreign,")));
            if (this.is(16)) {
                builder.append("exportable,");
            }
            if (this.is(4)) {
                builder.append("static,");
            }
            if (this.is(8)) {
                builder.append("deprecated,");
            }
            if (this.is(1024)) {
                builder.append("used,");
            }
            if (this.is(2048)) {
                builder.append("has-exported,");
            }
            if (this.is(8192)) {
                builder.append("has-concealed,");
            }
            if (this.is(4096)) {
                builder.append("has-final,");
            }
            if (builder.length() > 0) {
                builder.setLength(builder.length() - 1);
            }
            return builder.toString();
        }

        Element(String qualifier, String name, boolean deprecated, Access access, String accessComment) {
            this.qualifier = qualifier;
            this.name = name;
            this.accessComment = accessComment;
            this.set(8, deprecated);
            this.set(32, access == Access.EXPORTED);
            this.set(64, access == Access.CONCEALED);
        }

        String getQualifier() {
            return this.qualifier;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.qualifier + this.getKey();
        }

        String getKey() {
            return this.name;
        }

        public boolean isDeprecated() {
            return this.is(8);
        }

        public Access getAccess() {
            return this.is(32) ? Access.EXPORTED : (this.is(64) ? Access.CONCEALED : null);
        }

        public String getAccessComment() {
            return this.accessComment;
        }

        public boolean equals(Object that) {
            return this.getClass().equals(that.getClass()) && this.qualifier.equals(((Element)that).qualifier) && this.getKey().equals(((Element)that).getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        @Override
        public int compareTo(Element that) {
            return this.getKey().compareTo(that.getKey());
        }

        public String toString() {
            String kind = this.getClass().getSimpleName().toLowerCase();
            Access access = this.getAccess();
            return (access != null ? access.toString().toLowerCase() + ' ' : "") + kind + ' ' + this.getName() + '[' + this.flags() + ']';
        }
    }
}

