/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.headless;

import java.io.Console;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.dbtools.headless.HeadlessResources;
import oracle.dbtools.headless.HeadlessStarter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.standalone.connection.RaptorConnectionCreator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DefaultPasswordPrompter;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;

public class HeadlessRunner
extends IdeRunner {
    private static final String NS = "http://xmlns.oracle.com/sqldeveloper/sqldev-headless";
    public static final ElementName ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/sqldeveloper/sqldev-headless", "sqldev-headless-hook");
    private static final String COMMAND_ELEMENT = "feature";
    private static final String COMMAND_CLASS = "featureClass";
    private static final String COMMAND_NAME = "featureName";
    private static final String DESC = "desc/#text";
    private static Map<String, CommandDefinition> s_cmds = new TreeMap<String, CommandDefinition>();
    private DefaultHeadlessCore m_core = new DefaultHeadlessCore();

    public void runCommand(IdeStarter ideStarter) {
        this.registerHeadlessPasswordPrompter();
        HeadlessStarter headlessStarter = (HeadlessStarter)ideStarter;
        HashStructureHook hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(ELEMENT_NAME);
        hashStructureHook.addHashStructureHookListener((HashStructureHookListener)new Listener());
        String string = headlessStarter.getCommand();
        String[] stringArray = headlessStarter.getArguments();
        if (string == null || string.toUpperCase().equals("HELP") || string.toUpperCase().equals("-HELP") || string.equals("?") || string.equals("-?")) {
            if (stringArray == null || stringArray.length == 0) {
                this.exit(false, this.getUsageLines(HeadlessResources.getString("COMMAND_HELP_LIST")));
            } else {
                CommandDefinition commandDefinition = s_cmds.get(stringArray[0]);
                if (commandDefinition == null) {
                    this.exit(true, this.getUsageLines(HeadlessResources.format("COMMAND_NOT_FOUND", string)));
                } else {
                    HeadlessCommandProcessor headlessCommandProcessor = null;
                    try {
                        headlessCommandProcessor = commandDefinition.createCommand();
                        this.exit(false, headlessCommandProcessor.getUsageString());
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        this.exit(true, HeadlessResources.format("COMMAND_NOT_CREATED", string));
                    }
                }
            }
        } else {
            CommandDefinition commandDefinition = s_cmds.get(string);
            if (commandDefinition == null) {
                this.exit(true, this.getUsageLines(HeadlessResources.format("COMMAND_NOT_FOUND", string)));
            }
            HeadlessCommandProcessor headlessCommandProcessor = null;
            try {
                headlessCommandProcessor = commandDefinition.createCommand();
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                this.exit(true, HeadlessResources.format("COMMAND_NOT_CREATED", string));
            }
            try {
                HeadlessCoreWrapper headlessCoreWrapper = new HeadlessCoreWrapper(this.m_core);
                HeadlessTask headlessTask = headlessCommandProcessor.parseCommandArguments((HeadlessCore)headlessCoreWrapper, stringArray);
                if (headlessTask != null) {
                    headlessCoreWrapper.setOutputEnabled(false);
                    RaptorTaskDescriptor raptorTaskDescriptor = headlessTask.getDescriptor();
                    raptorTaskDescriptor.addListener((IRaptorTaskListener)new HeadlessTaskListener());
                    RaptorTaskManager.getInstance().addTask((RaptorTask)headlessTask);
                } else {
                    this.exit(false, HeadlessResources.getString("MESSAGE_SUCCESS"));
                }
            }
            catch (InvalidCommandArgumentException invalidCommandArgumentException) {
                this.exit(true, invalidCommandArgumentException.getLocalizedMessage());
            }
        }
    }

    private void registerHeadlessPasswordPrompter() {
        DatabaseProvider.registerConnectionCreator((String)"oraJDBC", (ConnectionCreator)new RaptorConnectionCreator());
        DatabaseProviderHelper.setPasswordPrompter((DatabaseProviderHelper.PasswordPrompter)new DefaultPasswordPrompter(){

            public Connection promptForPassword(DatabaseProvider databaseProvider) throws SQLException {
                ConnectionCreator connectionCreator = DatabaseProvider.getCreator((DatabaseProvider)databaseProvider);
                return this.promptForPassword(databaseProvider.getProperties(), databaseProvider.getName(), connectionCreator);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Connection promptForPassword(Properties properties, String string, ConnectionCreator connectionCreator) throws SQLException {
                Connection connection = null;
                String string2 = properties.getProperty("UnsharedWorksheetOriginalConnectionName");
                if (string2 != null) {
                    try {
                        return Connections.getInstance().getConnection(string2, true);
                    }
                    catch (DBException dBException) {
                        Throwable throwable = dBException.getCause();
                        if (!(throwable instanceof SQLException)) return connection;
                        throw (SQLException)throwable;
                    }
                }
                if (properties.getProperty("password") == null) {
                    Console console = System.console();
                    if (console != null) {
                        char[] cArray = console.readPassword("Password for " + string + "?", new Object[0]);
                        properties.setProperty("password", new String(cArray));
                        connection = connectionCreator.getConnection(properties);
                        this.cache(properties);
                        return connection;
                    } else {
                        System.out.println("Password was not saved with the connection information - please either save the password or run sdcli from the command prompt");
                    }
                    return connection;
                } else {
                    connection = connectionCreator.getConnection(properties);
                    this.cache(properties);
                }
                return connection;
            }
        });
    }

    private String[] getUsageLines(String string) {
        String[] stringArray = new String[s_cmds.size() + 1];
        stringArray[0] = string;
        int n = 1;
        for (CommandDefinition commandDefinition : s_cmds.values()) {
            stringArray[n++] = HeadlessResources.format("COMMAND_USAGE_FORMAT", commandDefinition.getCommandID(), commandDefinition.getDescription());
        }
        return stringArray;
    }

    private void exit(boolean bl, String ... stringArray) {
        ExitCommand.shutdown();
        if (bl) {
            this.m_core.printErrorMessage(stringArray);
            System.exit(1);
        } else {
            this.m_core.printMessage(stringArray);
            System.exit(0);
        }
    }

    private class HeadlessTaskListener
    extends RaptorTaskAdapter {
        private HeadlessTaskListener() {
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            StringWriter stringWriter = new StringWriter();
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (throwable != null) {
                throwable.printStackTrace(new PrintWriter(stringWriter));
            }
            HeadlessRunner.this.exit(true, new String[]{HeadlessResources.getString("MESSAGE_FAILURE"), stringWriter.getBuffer().toString()});
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            HeadlessRunner.this.exit(false, new String[]{HeadlessResources.getString("MESSAGE_SUCCESS")});
        }

        public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
            RaptorTaskDescriptor raptorTaskDescriptor = raptorTaskEvent.getTaskDescriptor();
            String string = raptorTaskDescriptor.getMessage();
            HeadlessRunner.this.m_core.printMessage(new String[]{string});
        }

        public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
        }
    }

    private static class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processHashStructure(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processHashStructure(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processHashStructure(HashStructure hashStructure) {
            List list = hashStructure.getAsList(HeadlessRunner.COMMAND_ELEMENT);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    try {
                        CommandDefinition commandDefinition = CommandDefinition.createCommand(hashStructure2);
                        s_cmds.put(commandDefinition.getCommandID(), commandDefinition);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.severe(HeadlessRunner.class, (Throwable)illegalArgumentException);
                    }
                }
            }
        }
    }

    private static class CommandDefinition {
        private String m_id;
        private String m_desc;
        private MetaClass<? extends HeadlessCommandProcessor> m_class;

        static CommandDefinition createCommand(HashStructure hashStructure) throws IllegalArgumentException {
            String string = hashStructure.getString(HeadlessRunner.COMMAND_NAME);
            if (!ModelUtil.hasLength((String)string)) {
                throw new IllegalArgumentException("Missing command id");
            }
            String string2 = hashStructure.getString(HeadlessRunner.DESC);
            if (!ModelUtil.hasLength((String)string2)) {
                throw new IllegalArgumentException("Missing description for id " + string);
            }
            MetaClass metaClass = LazyClassAdapter.getInstance((HashStructure)hashStructure).getMetaClass(HeadlessRunner.COMMAND_CLASS);
            if (metaClass == null) {
                throw new IllegalArgumentException("Missing command class for id " + string);
            }
            return new CommandDefinition(string, string2, (MetaClass<? extends HeadlessCommandProcessor>)metaClass);
        }

        private CommandDefinition(String string, String string2, MetaClass<? extends HeadlessCommandProcessor> metaClass) {
            this.m_id = string;
            this.m_desc = string2;
            this.m_class = metaClass;
        }

        HeadlessCommandProcessor createCommand() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            return (HeadlessCommandProcessor)this.m_class.newInstance();
        }

        String getCommandID() {
            return this.m_id;
        }

        String getDescription() {
            return this.m_desc;
        }
    }

    private static final class HeadlessCoreWrapper
    extends HeadlessCore {
        private DefaultHeadlessCore m_core;
        private boolean m_enabled = true;

        HeadlessCoreWrapper(DefaultHeadlessCore defaultHeadlessCore) {
            this.m_core = defaultHeadlessCore;
        }

        void setOutputEnabled(boolean bl) {
            this.m_enabled = bl;
        }

        public boolean isOutputEnabled() {
            return this.m_enabled;
        }

        protected PrintWriter getOutputWriter() {
            return this.m_core.m_out;
        }

        protected PrintWriter getErrorWriter() {
            return this.m_core.m_err;
        }
    }

    private static final class DefaultHeadlessCore
    extends HeadlessCore {
        PrintWriter m_out = new PrintWriter(System.out);
        PrintWriter m_err = new PrintWriter(System.out);

        private DefaultHeadlessCore() {
        }

        public boolean isOutputEnabled() {
            return true;
        }

        protected PrintWriter getOutputWriter() {
            return this.m_out;
        }

        protected PrintWriter getErrorWriter() {
            return this.m_err;
        }
    }
}

