/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.extract.ui.panels.PredicatePanel;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class OSCHIPredicatePanel
extends PredicatePanel
implements IRaptorTaskListener {
    private static final long serialVersionUID = 1L;
    private ExtractObject _dataObject;
    private static final char SLASH = '/';

    public OSCHIPredicatePanel(ExtractObject extractObject, String string, boolean bl) {
        super(extractObject, string, bl);
        this._dataObject = extractObject;
    }

    protected String getObjectWhereToolTip() {
        return HadoopWizArb.getString("OSCH_WHERE_TOOLTIP");
    }

    public String getSQL() {
        ArrayList arrayList = super.getPartitions();
        if (arrayList == null || arrayList.size() == 1 && ((String)arrayList.get(0)).equals("*")) {
            return super.getBaseSql() + " " + this.getPredicate() + this.getGlobalPredicate();
        }
        StringBuffer stringBuffer = new StringBuffer();
        DBObject dBObject = this._dataObject.getDBObject();
        String string = HadoopUtils.isHiveConnection(dBObject.getConnectionName()) ? dBObject.getSchemaName() + "." + dBObject.getObjectName() : DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
        stringBuffer.append("select " + this._dataObject.getColumns() + " from " + string + " where ");
        stringBuffer.append(this.getWhere());
        return stringBuffer.toString();
    }

    public String getWhere() {
        ArrayList arrayList = super.getPartitions();
        String string = this.getPredicate();
        string = string != null && string.length() > 7 ? string.substring(7) : "";
        if (arrayList == null || arrayList.size() == 1 && ((String)arrayList.get(0)).equals("*")) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        DBObject dBObject = this._dataObject.getDBObject();
        boolean bl = true;
        for (String string2 : arrayList) {
            if (string2 == null || string2.isEmpty()) continue;
            if (!bl) {
                stringBuffer.append(" OR ");
            }
            bl = false;
            stringBuffer.append(this.normalizePredicate(string2));
        }
        if (!string.isEmpty()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" OR ");
            }
            stringBuffer.append("( " + string + " )");
        }
        return stringBuffer.toString();
    }

    private String normalizePredicate(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            stringBuffer.append("( ");
            for (int i = 0; i < n; ++i) {
                if (string.charAt(i) != '/' && string.charAt(i) != '%') {
                    stringBuffer.append(string.charAt(i));
                    continue;
                }
                if (i < n - 1 && string.charAt(i) == '/' && string.charAt(i + 1) == '/') {
                    stringBuffer.append('/');
                    ++i;
                    continue;
                }
                if (i < n - 2 && string.charAt(i) == '%' && string.charAt(i + 1) == '3' && string.charAt(i + 2) == 'A') {
                    stringBuffer.append(':');
                    ++i;
                    ++i;
                    continue;
                }
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, raptorTaskEvent.getTaskDescriptor().getMessage(), raptorTaskEvent);
        if (raptorTaskEvent.getThrowable() != null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getThrowable().getMessage(), (String)"Execution Exception", null);
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, raptorTaskEvent.getTaskDescriptor().getMessage(), raptorTaskEvent);
        }
    }

    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
        boolean bl = true;
    }

    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
    }
}

