/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.execute.BDACopyExec;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.icons.OracleIcons;

public class BDACopyWizSummaryPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    protected JTree _summaryTree = new JTree();
    private JTabbedPane _summaryTabbedPane = new JTabbedPane();
    private JTextComponent _scriptPane;
    HadoopProperties _hProps;
    ExtractListModel _listModel;
    BDACopyExec _bdaCopyExec;
    boolean _isStagingMethod = false;

    public BDACopyWizSummaryPage() {
        this.setLayout(new BorderLayout());
        this._summaryTree.setCellRenderer(new NodeRenderer());
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_SUMMARY_TITLE"), new JScrollPane(this._summaryTree, 20, 30));
        this._scriptPane = this.createTextPane(false);
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_PROCESS_TITLE"), new JScrollPane(this._scriptPane, 20, 30));
        this.add(this._summaryTabbedPane, "Center");
        this._bdaCopyExec = new BDACopyExec();
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        this._isStagingMethod = this._hProps.get(ImportKeys.LOAD_METHOD).equals(3);
        ExitCode exitCode = this._bdaCopyExec.start(this._hProps);
        String string = this._bdaCopyExec.getScript();
        this._hProps.put(HadoopKeys.SCRIPT, string);
        this._scriptPane.setText(string);
        this._summaryTree.removeAll();
        this._summaryTree.setModel(this.getSummaryTreeModel(HadoopWizArb.getString("STEP_SUMMARY")));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this._bdaCopyExec.doExec();
        }
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        Object object;
        Serializable serializable;
        Object object22;
        Object object3;
        Cloneable cloneable;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(ExtractListModel.getSummaryLabelItem((String)StringUtils.stripMnemonic((String)HadoopWizArb.getString("COPY_METHOD_SUM")), (String)(this._isStagingMethod ? HadoopWizArb.getString("COPY_METHOD_STAGED") : HadoopWizArb.getString("COPY_METHOD_DIRECT"))));
        JLabel jLabel = new JLabel();
        String string2 = Connections.getDisplayName((String)Connections.getInstance().getConnectionName(this._listModel.getSourceConn()));
        jLabel.setText(HadoopWizArb.getString("S_BORDER") + ": " + string2);
        jLabel.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        JLabel jLabel2 = new JLabel();
        ExtractObject extractObject = this._listModel.getFirstExtractObject();
        DBObject dBObject = extractObject.getDBObject();
        jLabel2.setIcon(DBURLFormatHelper.getIcon((URL)dBObject.getURL()));
        jLabel2.setText(HadoopWizArb.getString("DB_OBJECT") + " " + dBObject.getSchemaName() + "." + dBObject.getObjectName());
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(jLabel2);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        String string3 = extractObject.getColumns();
        if (string3 != null && !string3.equals("*")) {
            cloneable = new DefaultMutableTreeNode(HadoopWizArb.getString("SELECTED_COLS"));
            defaultMutableTreeNode3.add((MutableTreeNode)((Object)cloneable));
            for (Object object22 : object3 = string3.split(",")) {
                serializable = new JLabel();
                serializable.setIcon(HadoopWizArb.getIcon("COLUMN_ICON"));
                serializable.setText((String)object22);
                ((DefaultMutableTreeNode)cloneable).add(new DefaultMutableTreeNode(serializable));
            }
        }
        if (!((cloneable = extractObject.getPartitions()) == null || ((ArrayList)cloneable).isEmpty() || ((ArrayList)cloneable).size() == 1 && ((String)((ArrayList)cloneable).get(0)).equals("*"))) {
            object3 = new DefaultMutableTreeNode(HadoopWizArb.getString("SELECTED_PARTS"));
            defaultMutableTreeNode3.add((MutableTreeNode)object3);
            object = ((ArrayList)cloneable).iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                JLabel jLabel3 = new JLabel();
                jLabel3.setIcon(HadoopWizArb.getIcon("PARTITION_ICON"));
                jLabel3.setText(string4);
                ((DefaultMutableTreeNode)object3).add(new DefaultMutableTreeNode(jLabel3));
            }
        }
        if ((object3 = extractObject.getWhere()) != null && ((String)object3).length() > 0) {
            object = new DefaultMutableTreeNode(HadoopWizArb.getString("WHERE"));
            defaultMutableTreeNode3.add((MutableTreeNode)object);
            ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(extractObject.getWhere()));
        }
        if (this._isStagingMethod) {
            object = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this._listModel.getSourceConnName(), null, (String)"SYS", (String)"DIRECTORY");
            URL uRL = DBURLFormatHelper.getURL((URL)object, (String)((String)this._hProps.get(ImportKeys.ORADIRNAME)));
            JLabel jLabel4 = new JLabel();
            object22 = DDLTypes.getFolderName((String)"DIRECTORY");
            jLabel4.setText(StringUtils.stripMnemonic((String)HadoopWizArb.getString("ORA_DIR")) + " " + (String)this._hProps.get(ImportKeys.ORADIRNAME));
            jLabel4.setIcon(DBURLFormatHelper.getIcon((URL)uRL));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel4));
        }
        object = (int)((Integer)this._hProps.get(HadoopKeys.PARALLEL));
        defaultMutableTreeNode2.add(ExtractListModel.getSummaryLabelItem((String)StringUtils.stripMnemonic((String)HadoopWizArb.getString("PARALLEL_SUMM")), (String)((Integer)object).toString()));
        JLabel jLabel5 = new JLabel();
        String string5 = Connections.getDisplayName((String)((String)this._hProps.get(HadoopKeys.DEST_CONN_NAME)));
        jLabel5.setText(HadoopWizArb.getString("D_BORDER") + ": " + string5);
        jLabel5.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
        object22 = new DefaultMutableTreeNode(jLabel5);
        defaultMutableTreeNode.add((MutableTreeNode)object22);
        serializable = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)((String)this._hProps.get(HadoopKeys.DEST_CONN_NAME)), null, (String)((String)this._hProps.get(HadoopKeys.DEST_SCHEMA)), (String)"TABLE");
        URL uRL = DBURLFormatHelper.getURL((URL)serializable, (String)((String)this._hProps.get(HadoopKeys.DEST_TABLE)));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(StringUtils.stripMnemonic((String)HadoopWizArb.getString("XTAB")) + " " + (String)this._hProps.get(HadoopKeys.DEST_TABLE));
        jLabel6.setIcon(DBURLFormatHelper.getIcon((URL)uRL));
        ((DefaultMutableTreeNode)object22).add(new DefaultMutableTreeNode(jLabel6));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(HadoopWizArb.getString("DEST_DIR") + " " + (String)this._hProps.get(HadoopKeys.DEST_DIR));
        jLabel7.setIcon(HadoopWizArb.getIcon("FILES_ICON"));
        ((DefaultMutableTreeNode)object22).add(new DefaultMutableTreeNode(jLabel7));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(StringUtils.stripMnemonic((String)HadoopWizArb.getString("SSH_CONN_BDA")) + ": " + (String)this._hProps.get(HadoopKeys.SSH_HOST));
        jLabel8.setIcon(OracleIcons.getIcon((String)"hostconnection.png"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(jLabel8);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

