/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.hadoop.core.HadoopGenericTable;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.BDACopyOptionalParmsPage;
import oracle.dbtools.raptor.hadoop.ui.BDACopySingleGeneralPage;
import oracle.dbtools.raptor.hadoop.ui.BDACopySinglePredicatePage;
import oracle.dbtools.raptor.hadoop.ui.BDACopyWelcomePage;
import oracle.dbtools.raptor.hadoop.ui.BDACopyWizSummaryPage;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.MessageDialog;

public class BDACopySingleWizMain
extends AbstractMenuAction {
    static final String STATE_A = "StateA";
    static final String TRANSITION_A = "A";
    static final String STATE_B = "StateB";
    static final String TRANSITION_B = "B";
    static final String STATE_C = "StateC";
    static final String TRANSITION_C = "C";
    static final String STATE_D = "StateD";
    static final String TRANSITION_D = "D";
    static final String STATE_E = "StateE";
    static final String TRANSITION_E = "E";
    static final String STATE_F = "StateF";
    static final String TRANSITION_F = "F";
    static final String TRANSITION_FIN = "Fin";
    static final String STATE_FIN = "StateFin";
    public static final String WIZARD_TYPE_TOOL = "1";
    static final String KEY_FILENAME = "FILENAME";
    static final String KEY_CONN = "CONNECTION";
    static final String KEY_CNAME = "CONNECTION_NAME";
    static final String KEY_TARGETFORMAT = "TARGETFORMAT";
    static final String KEY_DATA_LIST = "DATA_LIST";
    static final String KEY_ACTION_OBJECT_LIST = "ACTION_OBJECT_LIST";
    static final String KEY_WIZARD_TYPE = "WIZARD_TYPE";
    public static final String OLHI_NAME = "raptor.olhiWizard";
    public static final int OLHI_ACTION = Ide.findOrCreateCmdID((String)"raptor.olhiWizard");
    private static BDACopySingleWizMain INSTANCE;
    private DBObject _dbo;
    private HadoopGenericTable _hiveTable;
    private boolean _isExistingTable;

    private static FSM getFSMforDBTool() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(HadoopWizArb.getString("BDA_STEP1"), BDACopyWelcomePage.class, "f1_help_id_for_bdastep1");
        fSMBuilder.newStartState(step, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_B, (Object)STATE_B);
        Step step2 = new Step(HadoopWizArb.getString("BDA_STEP2"), BDACopySingleGeneralPage.class, "f1_help_id_for_bdastep2");
        fSMBuilder.newState((Object)STATE_B, step2, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_E, (Object)STATE_E);
        Step step3 = new Step(HadoopWizArb.getString("BDA_STEP3"), BDACopySinglePredicatePage.class, "f1_help_id_for_bdastep3");
        fSMBuilder.newState((Object)STATE_E, step3, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_F, (Object)STATE_F);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step4 = new Step(HadoopWizArb.getString("OLH_STEP6"), BDACopyOptionalParmsPage.class, "f1_help_id_for_olhstep5");
        fSMBuilder.newState((Object)STATE_F, step4, null);
        fSMBuilder.addStateTrans((Object)TRANSITION_FIN, (Object)STATE_FIN);
        Step step5 = new Step(HadoopWizArb.getString("STEP_SUMMARY"), BDACopyWizSummaryPage.class, "f1_help_id_for_bdasummary");
        fSMBuilder.newFinalState((Object)STATE_FIN, step5);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public void launchForDBTool() {
        this._isExistingTable = this._dbo.getObjectType().equals("TABLE");
        if (this._isExistingTable) {
            this._hiveTable = new HadoopGenericTable(this._dbo.getConnection(), this._dbo.getSchemaName(), this._dbo.getObjectName());
            if (this._hiveTable.getOrigin().isEmpty()) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)HadoopWizArb.getString("BDA_SOURCE_NOT_SQLDEV"), (String)HadoopWizArb.getString("ERROR"), null);
                return;
            }
        }
        FSM fSM = BDACopySingleWizMain.getFSMforDBTool();
        this.launchWizard(fSM, WIZARD_TYPE_TOOL);
    }

    public void launchWizard(FSM fSM, String string) {
        Namespace namespace = new Namespace();
        namespace.put(KEY_WIZARD_TYPE, (Object)string);
        HadoopProperties hadoopProperties = new HadoopProperties();
        namespace.put("HADOOP_PROPERTIES", (Object)hadoopProperties);
        namespace.put("IMPORT_PROPERTIES", (Object)hadoopProperties.getIProps());
        hadoopProperties.put(ImportKeys.DBOBJECT, this._dbo);
        String string2 = this._dbo.getConnectionName();
        hadoopProperties.put(ImportKeys.CONNECTION_NAME, string2);
        hadoopProperties.put(HadoopKeys.DEST_CONN_NAME, string2);
        hadoopProperties.put(ImportKeys.IS_CONFIGFILE, false);
        hadoopProperties.put(ImportKeys.IS_EXISTING_TABLE, this._isExistingTable);
        if (this._hiveTable != null) {
            hadoopProperties.put(HadoopKeys.DEST_GENERIC_TABLE, (Object)this._hiveTable);
            hadoopProperties.put(HadoopKeys.ORIGIN, this._hiveTable.getOrigin());
        }
        namespace.put("HADOOP_PROPERTIES", (Object)hadoopProperties);
        ExtractListModel extractListModel = new ExtractListModel();
        namespace.put("EXTRACT_LIST_MODEL", (Object)extractListModel);
        namespace.put("IMPORT_PROPERTIES", (Object)hadoopProperties.getIProps());
        hadoopProperties.put(HadoopKeys.EXTRACT_LIST_MODEL, extractListModel);
        extractListModel.isDDLEnabled(false);
        extractListModel.isDataEnabled(true);
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD, ExtractDataFormat.DELIMITED);
        hadoopProperties.put(HadoopKeys.EXTRACT_DATA_FORMAT, extractDataFormat);
        extractListModel.setDataFormat(extractDataFormat);
        DDLTypes dDLTypes = new DDLTypes();
        dDLTypes.setShow(false);
        dDLTypes.setEnable(false);
        dDLTypes.setTable(true);
        dDLTypes.setView(false);
        dDLTypes.setMatView(true);
        dDLTypes.setShowTable(true);
        dDLTypes.setShowView(false);
        dDLTypes.setShowMatView(true);
        extractListModel.setDDLTypes(dDLTypes);
        FSMWizard fSMWizard = new FSMWizard(fSM, namespace);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        hadoopProperties.put(ImportKeys.OBJECTACTION, this.getObjectAction());
        this.setBlockOACRefresh(true);
        hadoopProperties.put(HadoopKeys.DIALOG, bigWizardDialog);
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        fSMWizard.setWizardTitle(this._isExistingTable ? HadoopWizArb.getString("BDA_MAIN_TITLE") : HadoopWizArb.getString("BDA_MAIN_TITLE_NEW"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ExportWizArb.getImage((String)"WIZ_IMAGE"));
        fSMWizard.setLogoImage(ExportWizArb.getImage((String)"WIZ_LOGO"));
        fSMWizard.setRoadmapVisible(true);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        WizardLauncher.runDialog((JDialog)wizardDialog);
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)OLHI_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public void launch() {
        ColumnMapMediator.getInstance().clearMap();
        this._dbo = this.getDBObject();
        this.launchForDBTool();
    }

    public static BDACopySingleWizMain getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BDACopySingleWizMain();
        }
        return INSTANCE;
    }

    static boolean acquireLock(String string) {
        return LockedConnection.acquireLock(string);
    }

    static void freeLock() {
        LockedConnection.freeLock();
    }

    private static class LockedConnection {
        private static String _connName;
        private static boolean _locked;

        private LockedConnection() {
        }

        static synchronized boolean acquireLock(String string) {
            boolean bl = false;
            LockedConnection.freeLock();
            bl = _locked = Connections.getInstance().lock(string, true);
            if (bl) {
                _connName = string;
            }
            return bl;
        }

        static synchronized void freeLock() {
            if (_connName != null && _locked) {
                Connections.getInstance().unlock(_connName);
                _locked = false;
                _connName = null;
            }
        }

        static {
            _locked = false;
        }
    }
}

