/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.execute;

import com.jcraft.jsch.Session;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorGroupLoader;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public abstract class HadoopExec {
    private static final Logger LOGGER = Logger.getLogger(HadoopExec.class.getName());
    public static final int TYPE_DB_OBJECTS = 0;
    public static final int TYPE_QUERY = 1;
    protected static final String NEW_LINE = "\n";
    private static final String DEFAULT_GROUP_QUOTE = "hadoopgen";
    protected final String ENCODING_UTF8 = "UTF-8";
    protected final String DQUOTE = "\"";
    private static StringTemplateGroup _templateGroup = null;
    private DatabaseQueryTask<Void> _task = null;
    private File _file;
    private OutputStream _fout;
    private BufferedOutputStream _bout;
    private boolean _suppressLogging = false;
    private boolean _isUseLogger = false;
    private String _copyLogName;
    protected boolean _cancel = false;
    protected String _logPrefix;
    protected Writer _out;
    protected Connection _srcConn;
    protected Connection _destConn;
    protected String _srcConnName;
    protected String _destConnName;
    protected String _srcConnDisplayName;
    protected String _destConnDisplayName;
    protected String _destConnUrl;
    protected String _destUser;
    protected String _destP;
    protected String _host;
    protected DBObject _destDbo;
    protected String _destTableName;
    protected Session _session;
    protected String encoding = IdeUtil.getIdeEncoding();
    protected ExitCode _exitCode;
    protected HadoopProperties _hProps;

    public ExitCode start(HadoopProperties hadoopProperties) {
        this._hProps = hadoopProperties;
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, HadoopWizArb.getString("START_GEN"));
        try {
            this._destDbo = (DBObject)hadoopProperties.get(ImportKeys.DBOBJECT);
            this._destTableName = "'\"" + this._destDbo.getSchemaName() + "\".\"" + this._destDbo.getObjectName() + "\" '";
            this._srcConn = (Connection)this._hProps.get(HadoopKeys.SOURCE_CONN);
            this._srcConnName = (String)this._hProps.get(HadoopKeys.SOURCE_CONN_NAME);
            this._srcConnDisplayName = Connections.getDisplayName((String)this._srcConnName);
            this._destConnName = (String)this._hProps.get(HadoopKeys.DEST_CONN_NAME);
            this._destConn = Connections.getInstance().getConnection(this._destConnName);
            this._destConnDisplayName = Connections.getDisplayName((String)this._destConnName);
            Properties properties = Connections.getInstance().getConnectionInfo(this._destConnName);
            this._destUser = properties.getProperty("user");
            this._destConnUrl = properties.getProperty("customUrl");
            this._host = (String)this._hProps.get(HadoopKeys.SSH_HOST);
            this._session = HadoopUtils.getSshSession(this._host);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exception.getMessage());
            return exitCode;
        }
        return ExitCode.EXIT_SUCCESS;
    }

    public abstract ExitCode doExec();

    private String getTerm() {
        return HadoopUtils.getTerm();
    }

    public void cancelExex() {
        this._cancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExitCode pstmtExec(Connection connection, String string) {
        if (Connections.getInstance().lock(connection)) {
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                preparedStatement.execute();
                ExitCode exitCode = ExitCode.EXIT_SUCCESS;
                return exitCode;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                this._exitCode = ExitCode.EXIT_ERROR;
                this._exitCode.setMessage(exception.getLocalizedMessage());
                ExitCode exitCode = this._exitCode;
                return exitCode;
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return ExitCode.EXIT_SUCCESS;
    }

    protected void loadTemplates() {
        RaptorGroupLoader raptorGroupLoader = new RaptorGroupLoader("oracle/dbtools/raptor/hadoop/templates", this.getClass().getClassLoader());
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)raptorGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        _templateGroup = StringTemplateGroup.loadGroup((String)DEFAULT_GROUP_QUOTE);
        this.setTemplateName(DEFAULT_GROUP_QUOTE);
    }

    protected void setTemplateName(String string) {
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        _templateGroup = stringTemplateGroup;
    }

    protected StringTemplateGroup getTemplateGroup() {
        if (_templateGroup == null) {
            this.loadTemplates();
        }
        return _templateGroup;
    }

    protected void openLog() {
        this.openLog(false);
    }

    protected void openLog(boolean bl) {
        if (!this._suppressLogging) {
            try {
                if (bl) {
                    this._out = new StringWriter();
                } else {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
                    StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
                    this._copyLogName = Ide.getUserSettingsDirectory() + this._logPrefix + stringBuilder + ".log";
                    this._file = new File(this._copyLogName);
                    this._fout = new FileOutputStream(this._file.getPath());
                    this._bout = new BufferedOutputStream(this._fout);
                    this._out = new OutputStreamWriter((OutputStream)this._bout, this.encoding);
                }
            }
            catch (IOException iOException) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)CopyPanelArb.getString((String)"FILE_CREATION_ERROR"), (String)(this._file.getPath() + this._file.getName()), null);
            }
        }
    }

    protected void lineStart() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString((String)"CopyAPI.169") + this.getTerm());
            } else if (this._isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, HadoopWizArb.getString("LINE_START"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected void lineEnd() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString((String)"CopyAPI.170") + this.getTerm());
            } else if (this._isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, HadoopWizArb.getString("LINE_END"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected void lineError() {
        try {
            if (this._out != null) {
                this._out.write(Messages.getString((String)"CopyAPI.171") + this.getTerm());
            } else if (this._isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, HadoopWizArb.getString("LINE_ERROR"));
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected void log(String string) {
        try {
            if (this._out != null) {
                this._out.write(string + this.getTerm());
            } else if (this._isUseLogger) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, string);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public String getLogFromTest() {
        try {
            this._out.flush();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return this._out.toString();
    }

    protected File getLogFile() {
        return this._file;
    }

    protected void closeLog() {
        try {
            if (this._out != null) {
                this._out.flush();
                this._out.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    protected String getFormattedOutput(ScriptOutput scriptOutput) {
        return "*** STDOUT ***\n" + (scriptOutput.stdout != null && !scriptOutput.stdout.isEmpty() ? scriptOutput.stdout : "") + HadoopUtils.getTerm() + (scriptOutput.stderr != null && !scriptOutput.stderr.isEmpty() ? "*** STDERR ***\n" + scriptOutput.stderr : "") + HadoopUtils.getTerm();
    }

    protected static void openLogNode(final URL uRL) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TextNode textNode = new TextNode(uRL);
                    Context context = Context.newIdeContext((Node)textNode);
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    openEditorOptions.setFlags(1);
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        });
    }

    protected final boolean checkCanProceed() {
        return !this._cancel;
    }

    protected final void setExitCodeHighest(ExitCode exitCode) {
        if (exitCode.getSeverity() > this._exitCode.getSeverity()) {
            this._exitCode = exitCode;
        }
    }

    protected final boolean isExitCodeError() {
        return this._exitCode == ExitCode.EXIT_SEVERE || this._exitCode == ExitCode.EXIT_ERROR;
    }

    protected final boolean isCancelled() {
        return this._cancel;
    }

    public void signalCancel() {
        this._cancel = true;
    }

    protected static void openSqlNodeForURL(URL uRL) throws Exception {
        SqlNode sqlNode = null;
        sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
        final SqlNode sqlNode2 = sqlNode;
        if (sqlNode2 != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                        }
                    });
                }
            });
        }
    }
}

