/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.Table;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.utils.DBObject;

public class HadoopGenericTable
extends GenericTable {
    private Connection _conn;
    private String _ddl;
    private String[] _partitions;
    private String _location;
    private String _comment;
    private boolean _isPartitioned;
    private boolean _isText;
    private boolean _isDataPump;
    private boolean _isOrc;
    private boolean _isParquet;
    private static final int STATE_START = 0;
    private static final int STATE_ORIGIN = 1;
    String OPENP = "(";
    String CLOSEP = ")";
    private static String COMMA = ",";
    private static String COMMENT = "COMMENT";
    private static String LOCATION = "LOCATION";
    public static String ORIGIN = "<OriginSQLDeveloper>";
    private static String T_BIGINT = "bigint";
    private static String T_BOOLEAN = "boolean";
    private static String T_CHAR = "char";
    private static String T_DATE = "date";
    private static String T_DECIMAL = "decimal";
    private static String T_DOUBLE = "double";
    private static String T_FLOAT = "float";
    private static String T_INT = "int";
    private static String T_INTEGER = "INTEGER";
    private static String T_NUMBER = "NUMBER";
    private static String T_SMALLINT = "smallint";
    private static String T_STRING = "string";
    private static String T_TIMESTAMP = "timestamp";
    private static String T_TINYINT = "tinyint";
    private static String T_VARCHAR = "varchar";
    private static String T_VARCHAR2 = "VARCHAR2";
    private static final int STATE_COL_NAME = 0;
    private static final int STATE_TYPE = 1;
    private static final int STATE_PREC = 3;
    private static final int STATE_COMMENT = 4;
    private static final int STATE_COMMENT_VALUE = 5;
    private static final int STATE_TERM = 6;
    private static final int STATE_COL_DONE = 7;
    private static final int STATE_ALL_COLS_DONE = 8;
    private static final int STATE_TABLE_COMMENT = 9;
    private static final int STATE_LOCATION = 10;
    private static final char TIC = '`';
    private static final char SINGLEQ = '\'';

    public HadoopGenericTable(DBObject dBObject) {
        this._conn = dBObject.getConnection();
        this._schemaName = dBObject.getSchemaName();
        this.populateTable(this._conn, "\"" + this._schemaName + "\"", "\"" + dBObject.getObjectName() + "\"");
    }

    public HadoopGenericTable(Connection connection, String string, String string2) {
        this._conn = connection;
        this._schemaName = string;
        this.populateTable(connection, string, string2);
    }

    public HadoopGenericTable(Table table) {
        this._table = table;
    }

    public HadoopGenericTable() {
        this._table = new Table();
    }

    private void populateTable(Connection connection, String string, String string2) {
        DBObject dBObject = HadoopUtils.getDBO(connection, "TABLE", string, string2);
        this._table = HadoopUtils.isHiveConnection(dBObject.getConnectionName()) ? this.getMetaData(dBObject) : this.getMetaDataOra(connection, string, string2);
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getSchema() {
        return this._schemaName;
    }

    public String getDDL() {
        return this._ddl;
    }

    public String getComment() {
        return this._comment;
    }

    public String getOrigin() {
        String string = "";
        ArrayList<String> arrayList = this.getTokens(this._comment);
        String string2 = "";
        int n = 0;
        boolean bl = false;
        block4: for (int i = 0; i < arrayList.size() && !bl; ++i) {
            string2 = arrayList.get(i).trim();
            switch (n) {
                case 0: {
                    if (!string2.equals(ORIGIN)) continue block4;
                    n = 1;
                    continue block4;
                }
                case 1: {
                    string = string2;
                    bl = true;
                }
            }
        }
        return string;
    }

    public String getLocation() {
        return this._location;
    }

    public boolean isPartitioned() {
        return this._isPartitioned;
    }

    public String[] getPartitions() {
        return this._partitions;
    }

    public boolean isText() {
        return this._isText;
    }

    public boolean isOrc() {
        return this._isOrc;
    }

    public boolean isDataPump() {
        return this._isDataPump;
    }

    public boolean isParquet() {
        return this._isParquet;
    }

    private Table getMetaData(DBObject dBObject) {
        Table table = null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        String string = HadoopUtils.getHiveDescribe(dBObject);
        this._ddl = HadoopUtils.getHiveDDL(dBObject);
        int n = this._ddl.indexOf(this.OPENP);
        if (n != -1) {
            String string2 = this._ddl.substring(this._ddl.indexOf(this.OPENP) + 1).trim();
            ArrayList<String> arrayList2 = this.getTokens(string2);
            int n2 = 0;
            Column column = new Column();
            boolean bl = false;
            String string3 = "";
            block12: for (int i = 0; i < arrayList2.size() && !bl; ++i) {
                string3 = arrayList2.get(i).trim();
                switch (n2) {
                    case 0: {
                        if (string3.equals(this.CLOSEP)) {
                            n2 = 8;
                            continue block12;
                        }
                        if (string3.isEmpty()) continue block12;
                        column.setName(string3);
                        n2 = 1;
                        continue block12;
                    }
                    case 1: {
                        n2 = 4;
                        if (string3.startsWith(T_INT) || string3.startsWith(T_BIGINT) || string3.startsWith(T_SMALLINT) || string3.startsWith(T_TINYINT)) {
                            column.setType(T_INTEGER);
                            continue block12;
                        }
                        if (string3.startsWith(T_DOUBLE) || string3.startsWith(T_FLOAT)) {
                            column.setType(T_NUMBER);
                            continue block12;
                        }
                        if (string3.startsWith(T_STRING)) {
                            column.setType(T_VARCHAR2);
                            column.setPrecision(4000);
                            continue block12;
                        }
                        if (string3.startsWith(T_DATE)) {
                            column.setType(T_DATE.toUpperCase());
                            column.setFormat("YYYY-MM-DD");
                            continue block12;
                        }
                        if (string3.startsWith(T_TIMESTAMP)) {
                            column.setType(T_TIMESTAMP.toUpperCase());
                            column.setFormat("YYYY-MM-DD HH24:MI:SS.FF");
                            column.setPrecision(9);
                            continue block12;
                        }
                        if (string3.startsWith(T_BOOLEAN)) {
                            column.setType(T_VARCHAR2);
                            column.setPrecision(5);
                            continue block12;
                        }
                        if (string3.startsWith(T_DOUBLE) || string3.startsWith(T_FLOAT)) {
                            column.setType(T_NUMBER);
                            continue block12;
                        }
                        if (string3.startsWith(T_DECIMAL)) {
                            column.setType(T_NUMBER);
                            n2 = 3;
                            continue block12;
                        }
                        if (!string3.startsWith(T_VARCHAR) && !string3.startsWith(T_CHAR)) continue block12;
                        column.setType(T_VARCHAR2);
                        column.setPrecision(4000);
                        n2 = 3;
                        continue block12;
                    }
                    case 3: {
                        int n3 = string3.indexOf(this.OPENP);
                        if (n3 == -1) {
                            --i;
                        } else {
                            int n4 = string3.indexOf(COMMA);
                            if (n4 == -1) {
                                column.setPrecision(Integer.parseInt(string3.substring(n3 + 1, string3.length() - 1)));
                            } else {
                                column.setPrecision(Integer.parseInt(string3.substring(n3 + 1, n4)));
                                column.setScale(Integer.parseInt(string3.substring(n4 + 1, string3.length() - 1)));
                            }
                        }
                        n2 = 4;
                        continue block12;
                    }
                    case 4: {
                        if (string3.startsWith(COMMENT)) {
                            n2 = 5;
                            continue block12;
                        }
                        --i;
                        n2 = 6;
                        continue block12;
                    }
                    case 5: {
                        if (string3.length() > 2) {
                            column.setComment(string3.substring(1, string3.length() - 1));
                        }
                        n2 = 6;
                        continue block12;
                    }
                    case 6: {
                        if (string3.startsWith(COMMA)) {
                            n2 = 7;
                            continue block12;
                        }
                        column.setNullable(true);
                        arrayList.add(column);
                        n2 = 8;
                        continue block12;
                    }
                    case 7: {
                        column.setNullable(true);
                        arrayList.add(column);
                        column = new Column();
                        column.setName(string3);
                        n2 = 1;
                        continue block12;
                    }
                    case 8: {
                        if (string3.equals(COMMENT)) {
                            n2 = 9;
                            continue block12;
                        }
                        if (!string3.equals(LOCATION)) continue block12;
                        n2 = 10;
                        continue block12;
                    }
                    case 9: {
                        this._comment = this.unquote(string3);
                        n2 = 8;
                        continue block12;
                    }
                    case 10: {
                        this._location = this.unquote(string3);
                        bl = true;
                    }
                }
            }
        }
        this._partitions = HadoopUtils.getHivePartitionKeys(this._ddl);
        this._isPartitioned = this._partitions != null && this._partitions.length > 0;
        int n5 = -1;
        n5 = this._ddl.indexOf("ROW FORMAT SERDE");
        if (n5 != -1) {
            if (this._ddl.indexOf("lazy.LazySimpleSerDe", n5) != -1) {
                this._isText = true;
            } else if (this._ddl.indexOf("orc.OrcSerde", n5) != -1) {
                this._isOrc = true;
            } else if (this._ddl.indexOf("datapump.DPSerDe", n5) != -1) {
                this._isDataPump = true;
            } else if (this._ddl.indexOf("parquet.serde.ParquetHiveSerDe", n5) != -1) {
                this._isParquet = true;
            }
        } else {
            n5 = this._ddl.indexOf("STORED AS INPUTFORMAT");
            if (n5 != -1) {
                if (this._ddl.indexOf("mapred.TextInputFormat", n5) != -1) {
                    this._isText = true;
                } else if (this._ddl.indexOf("orc.OrcInputFormat", n5) != -1) {
                    this._isOrc = true;
                } else if (this._ddl.indexOf("datapump.DPInputFormat", n5) != -1) {
                    this._isDataPump = true;
                } else if (this._ddl.indexOf("parquet.MapredParquetInputFormat", n5) != -1) {
                    this._isParquet = true;
                }
            }
        }
        table = new Table();
        table.setTablename(dBObject.getObjectName());
        table.setColumns(arrayList);
        return table;
    }

    private ArrayList<String> getTokens(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.isEmpty()) {
            return arrayList;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        block0: for (int i = 0; !bl && i < string.length(); ++i) {
            stringBuffer = new StringBuffer();
            if (string.charAt(i) == '`') {
                ++i;
                while (i < n && (string.charAt(i) != '`' || string.charAt(i) == '`' && string.charAt(i + 1) == '`')) {
                    stringBuffer.append(string.charAt(i));
                    if (string.charAt(i) == '`' && string.charAt(i + 1) == '`') {
                        stringBuffer.append('`');
                        ++i;
                    }
                    ++i;
                }
                arrayList.add(stringBuffer.toString().trim());
                bl2 = true;
                continue;
            }
            if (string.charAt(i) == '\'') {
                stringBuffer.append('\'');
                ++i;
                while ((string.charAt(i) != '\'' || string.charAt(i) == '\'' && string.charAt(i + 1) == '\'') && i < n) {
                    stringBuffer.append(string.charAt(i));
                    if (string.charAt(i) == '\'' && string.charAt(i + 1) == '\'') {
                        stringBuffer.append('\'');
                        ++i;
                    }
                    ++i;
                }
                stringBuffer.append('\'');
                arrayList.add(stringBuffer.toString().trim());
                bl2 = true;
                continue;
            }
            if (string.charAt(i) == '(') {
                stringBuffer.append("(");
                ++i;
                while (string.charAt(i) != ')' && i < n) {
                    stringBuffer.append(string.charAt(i));
                    ++i;
                }
                stringBuffer.append(")");
                arrayList.add(stringBuffer.toString().trim());
                bl2 = true;
                continue;
            }
            while (i < n) {
                if (string.charAt(i) == ' ' || string.charAt(i) == '\t' || string.charAt(i) == '\n' || string.charAt(i) == '\r') {
                    if (stringBuffer.length() <= 0) continue block0;
                    arrayList.add(stringBuffer.toString());
                    bl2 = true;
                    continue block0;
                }
                if (string.charAt(i) == '(') {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                        bl2 = true;
                    }
                    stringBuffer = new StringBuffer("(");
                    ++i;
                    while (string.charAt(i) != ')' && i < n) {
                        stringBuffer.append(string.charAt(i));
                        ++i;
                    }
                    stringBuffer.append(")");
                    arrayList.add(stringBuffer.toString().trim());
                    bl2 = true;
                    continue block0;
                }
                if (string.charAt(i) == ',') {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                    }
                    arrayList.add(String.valueOf(string.charAt(i)));
                    bl2 = true;
                    continue block0;
                }
                if (string.charAt(i) == ')') {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                        bl2 = true;
                    }
                    arrayList.add(String.valueOf(string.charAt(i)));
                    bl2 = true;
                    continue block0;
                }
                stringBuffer.append(string.charAt(i));
                bl2 = false;
                ++i;
            }
        }
        if (!bl2) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    private String unquote(String string) {
        String string2 = "";
        if (string != null && string.startsWith("'") && string.endsWith("'")) {
            string2 = string.substring(1, string.length() - 1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getMetaDataOra(Connection connection, String string, String string2) {
        Table table = null;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        if (LockManager.lock((Connection)connection)) {
            try {
                PreparedStatement preparedStatement;
                ResultSetMetaData resultSetMetaData;
                String string3 = "";
                String[] stringArray = string2.split("@");
                String string4 = stringArray[0];
                if (stringArray.length > 1) {
                    string4 = string4 + "@" + stringArray[1];
                }
                if ((resultSetMetaData = (preparedStatement = connection.prepareStatement(string3 = string != null && string.length() > 0 ? "select * from " + string + "." + string4 + " where 1 = 2" : "select * from " + string4 + " where 1 = 2")).getMetaData()) != null) {
                    int n = resultSetMetaData.getColumnCount();
                    Integer n2 = 0;
                    while (n2 < n) {
                        Object object = new Column();
                        Object object2 = resultSetMetaData.getColumnName(n2 + 1);
                        if (object2 != null && ((String)object2).length() > 0) {
                            String[] stringArray2 = ((String)object2).split("\\.");
                            object.setName(stringArray2.length > 1 ? stringArray2[1] : stringArray2[0]);
                        } else {
                            object.setName("COLUMN" + n2.toString());
                        }
                        object.setNullable(resultSetMetaData.isNullable(n2 + 1) == 1);
                        object.setType(resultSetMetaData.getColumnTypeName(n2 + 1));
                        object.setPrecision(resultSetMetaData.getPrecision(n2 + 1));
                        object.setScale(resultSetMetaData.getScale(n2 + 1));
                        arrayList.add((Column)object);
                        object = n2;
                        n2 = n2 + 1;
                        object2 = n2;
                    }
                    table = new Table();
                    table.setTablename(string2);
                    table.setColumns(arrayList);
                }
            }
            catch (Exception exception) {
            }
            finally {
                LockManager.unlock((Connection)connection);
            }
        }
        return table;
    }

    public void addColumn(Column column) {
        this._table.addColumn(column);
    }

    public Column getColumn(int n) {
        return this.getColumns()[n];
    }

    public Column[] getColumns() {
        return this._table.getColumns().toArray(new Column[this._table.getColumns().size()]);
    }

    public int getColumnCount() {
        return this._table.getColumnCount();
    }

    public String getDataType(Column column) {
        return column.getType();
    }

    public Table getTable() {
        return this._table;
    }

    public void setColumns(Column[] columnArray) {
        List list = this._table.getColumns();
        if (list != null) {
            list.clear();
            for (int i = 0; i < columnArray.length; ++i) {
                list.add(columnArray[i]);
            }
            this._table.setColumns(list.toArray(new Column[list.size()]));
        }
    }

    public void setTableName(String string) {
        this._table.setTablename(string);
    }

    public Column getColumnByName(String string) {
        for (Column column : this._table.getColumns()) {
            if (!column.getName().equalsIgnoreCase(string)) continue;
            return column;
        }
        return null;
    }
}

