/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.core;

import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.transfer.utility.ScriptOutput;

public class HadoopFileHelper {
    private String _rootDir;
    private String _hostName;
    private Vector<String> _dirs;
    private Vector<String> _files;
    private Vector<String> _dirsAndFiles;
    private boolean _isLoaded = false;

    public HadoopFileHelper(String string, String string2) {
        this._hostName = string;
        this._rootDir = string2;
    }

    public Vector<String> getDirs() {
        if (!this._isLoaded) {
            this.loadHadoopFiles();
        }
        return this._dirs;
    }

    public Vector<String> getFiles() {
        if (!this._isLoaded) {
            this.loadHadoopFiles();
        }
        return this._files;
    }

    public Vector<String> getDirsAndFiles() {
        if (!this._isLoaded) {
            this.loadHadoopFiles();
        }
        return this._dirsAndFiles;
    }

    public String getHost() {
        return this._hostName;
    }

    public void setHost(String string) {
        if (!this._hostName.equals(string)) {
            this._isLoaded = false;
        }
        this._hostName = string;
    }

    public String getRootDir() {
        return this._rootDir;
    }

    public void setRootDir(String string) {
        if (!this._rootDir.equals(string)) {
            this._isLoaded = false;
        }
        this._rootDir = string;
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public boolean isDir(String string) {
        if (!this._isLoaded) {
            this.loadHadoopFiles();
        }
        if (this._rootDir.equals(string)) {
            return true;
        }
        for (String string2 : this._dirs) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean loadHadoopFiles() {
        String string = "hadoop fs -ls " + this._rootDir;
        Session session = HadoopUtils.getSshSession(this._hostName);
        ScriptOutput scriptOutput = HadoopUtils.executeCommand(session, string);
        this._dirs = new Vector();
        this._files = new Vector();
        this._dirsAndFiles = new Vector();
        if (scriptOutput.rc != 0) {
            String string2 = "STDOUT: " + scriptOutput.stdout + HadoopUtils.getTerm() + "STDERR: " + scriptOutput.stderr + HadoopUtils.getTerm();
            MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
            messageDetailsDialog.showErrorDialog(HadoopWizArb.getString("ROOT_DIR_ERROR"), string2);
            return false;
        }
        StringReader stringReader = new StringReader(scriptOutput.stdout);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                String[] stringArray = string3.split("\\s+");
                try {
                    if (stringArray.length == 8) {
                        if (stringArray[0].startsWith("d") && stringArray[4].equals("0")) {
                            this._dirs.add(stringArray[stringArray.length - 1]);
                        } else {
                            this._files.add(stringArray[stringArray.length - 1]);
                        }
                        this._dirsAndFiles.add(stringArray[stringArray.length - 1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        this._isLoaded = true;
        return true;
    }

    public Vector<String> getFileChildren(String string) {
        if (!this._isLoaded) {
            this.loadHadoopFiles();
        }
        return this._files;
    }
}

