/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.applet;

import ice.debug.Debug;
import ice.pilots.applet.AppletEvent;
import ice.pilots.applet.AudioClipCallback;
import ice.pilots.applet.ErrorComponent;
import ice.pilots.applet.ThePilot;
import ice.pilots.html4.DAppletElement;
import ice.pilots.html4.DElement;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.JavaVersion;
import ice.util.MajorMinorReleaseVersionComparator;
import ice.util.MajorMinorVersionComparator;
import ice.util.alg.IThread;
import ice.util.net.URLResolver;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class AppletViewer
implements AppletStub,
AppletContext,
AudioClip {
    private Thread handlerThread;
    private final Object eventQueueLock = new Object();
    private AppletEvent eventQueueFirst;
    private AppletEvent eventQueueLast;
    private boolean status_loaded;
    private boolean status_inited;
    private boolean status_running;
    private boolean status_destroyed;
    private boolean status_disposed;
    private Hashtable paramList = new Hashtable();
    ThePilot pilot;
    private Container appletPanel;
    private Component errorPanel;
    private Applet applet;
    private String apname;
    private String baseTargetFrame = "_self";
    private ClassLoader loader = null;
    private URL[] loader_urls;
    private static final Object loaderAccessLock = new Object();
    private URL docBase;
    private URL appletCodeBase;
    private Hashtable streams = new Hashtable();
    private static JavaVersion vmVersion = JavaVersion.getVMVersion();
    private static MajorMinorReleaseVersionComparator _mmbvc = new MajorMinorReleaseVersionComparator();
    private static MajorMinorVersionComparator _mmvc = new MajorMinorVersionComparator();
    private static final int APPLET_DISPOSE = 0;
    private static final int APPLET_LOAD = 1;
    private static final int APPLET_INIT = 2;
    private static final int APPLET_START = 3;
    private static final int APPLET_STOP = 4;
    private static final int APPLET_DESTROY = 5;
    private static final int APPLET_QUIT = 6;
    private static final int APPLET_ERROR = 7;
    private static final int APPLET_RESIZE = 8;
    private static final int APPLET_LOADING_COMPLETED = 9;
    private static final int APPLET_SHOW_DOCUMENT = 10;
    private boolean in_resize = false;

    static AppletViewer create() {
        AppletViewer result = null;
        result = (AppletViewer)Defs.newClassInstance("ice.pilots.applet.jdk12.AppletViewer_jdk12");
        return result;
    }

    void init(ThePilot pilot, Container appletPanel) {
        this.pilot = pilot;
        this.appletPanel = appletPanel;
    }

    Applet getAppletComponent() {
        return this.applet;
    }

    void loadApplet(ContentLoader cl) {
        this.paramList = cl.getParams();
        if (Debug.all) {
            Enumeration keys = this.paramList.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object o = this.paramList.get(key);
                Debug.p("Applet param: " + key + ", val = " + o);
            }
        }
        this.apname = this.extractAppletname(this.paramList);
        if (!this.isVersionCompliant(this.paramList)) {
            return;
        }
        this.docBase = this.extractDocbase(this.paramList, cl);
        this.appletCodeBase = this.extractCodebase(this.paramList, this.docBase, false);
        this.runLoader();
        this.initHandler();
    }

    private String extractAppletname(Hashtable params) {
        int idx;
        String returnVal = (String)params.get("java_code");
        if (returnVal == null) {
            returnVal = (String)params.get("code");
        }
        if (returnVal == null && (returnVal = (String)params.get("classid")) != null && returnVal.indexOf("java:") > -1) {
            returnVal = returnVal.substring(5);
        }
        if (returnVal.endsWith(".class") || returnVal.endsWith(".CLASS")) {
            returnVal = returnVal.substring(0, returnVal.lastIndexOf(46));
        }
        if ((idx = returnVal.lastIndexOf(47)) > 0) {
            returnVal = returnVal.substring(idx + 1);
        }
        return returnVal;
    }

    private URL extractCodebase(Hashtable params, URL docbase, boolean jpiCodeBase) {
        URL returnVal;
        block11: {
            int slash;
            String path;
            returnVal = null;
            if (params != null) {
                String cbase = null;
                if (!jpiCodeBase) {
                    cbase = (String)params.get("java_codebase");
                    if (cbase == null) {
                        cbase = (String)params.get("codebase");
                    }
                } else {
                    cbase = (String)params.get("jpi_codebase");
                }
                if (cbase != null) {
                    if (!cbase.endsWith("/")) {
                        cbase = cbase + "/";
                    }
                    try {
                        returnVal = new URL(docbase, cbase);
                    }
                    catch (MalformedURLException e) {
                        returnVal = null;
                    }
                }
            }
            if (returnVal == null && !(path = (returnVal = docbase).getFile()).endsWith("/") && (slash = path.lastIndexOf(47)) >= 0) {
                path = path.substring(0, slash + 1);
                try {
                    returnVal = new URL(returnVal, path);
                }
                catch (MalformedURLException e) {
                    if (!Debug.ex) break block11;
                    Debug.ex(e);
                }
            }
        }
        return returnVal;
    }

    private URL extractDocbase(Hashtable params, ContentLoader cl) {
        String tmp;
        URL returnVal = null;
        if (params != null && (tmp = (String)params.get("docbase")) != null) {
            try {
                returnVal = new URL(tmp);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (returnVal == null) {
            returnVal = cl.getURL();
        }
        return returnVal;
    }

    void doStart() {
        this.queueEvent(2);
    }

    void doStop() {
        this.queueEvent(4);
        this.queueEvent(5);
        this.queueEvent(0);
    }

    private void initHandler() {
        if (this.status_inited) {
            return;
        }
        final Object loadSessionTag = this.status_disposed ? null : this.pilot.getPilotViewport().addOnloadBlocker(this);
        this.handlerThread = new IThread(new Runnable(){

            public void run() {
                AppletViewer.this.run_handler(loadSessionTag);
            }
        }, this.apname + "-handler");
        this.handlerThread.start();
    }

    private void queueEvent(int id) {
        this.queueEvent(new AppletEvent(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueEvent(AppletEvent event) {
        Object object = this.eventQueueLock;
        synchronized (object) {
            if (this.eventQueueLast == null) {
                this.eventQueueFirst = event;
            } else {
                this.eventQueueLast.next = event;
            }
            this.eventQueueLast = event;
            this.eventQueueLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppletEvent getNextEvent() throws InterruptedException {
        Object object = this.eventQueueLock;
        synchronized (object) {
            while (this.eventQueueLast == null && !this.status_disposed) {
                this.eventQueueLock.wait(100L);
            }
            if (this.status_disposed) {
                return null;
            }
            AppletEvent event = this.eventQueueFirst;
            this.eventQueueFirst = event.next;
            if (this.eventQueueFirst == null) {
                this.eventQueueLast = null;
            }
            return event;
        }
    }

    void run_handler(Object loadSessionTag) {
        while (true) {
            AppletEvent evt;
            try {
                evt = this.getNextEvent();
                if (evt == null || this.status_disposed) {
                    return;
                }
            }
            catch (InterruptedException e) {
                return;
            }
            try {
                switch (evt.id) {
                    case 2: {
                        this.initApplet(loadSessionTag);
                    }
                    case 3: {
                        this.startApplet();
                        break;
                    }
                    case 4: {
                        this.stopApplet();
                        break;
                    }
                    case 10: {
                        this.appletShowDocument(evt);
                        break;
                    }
                    case 5: {
                        this.destroyApplet();
                        break;
                    }
                    case 0: {
                        this.disposeApplet(loadSessionTag);
                        return;
                    }
                    case 8: {
                        break;
                    }
                    case 6: {
                        return;
                    }
                    case 9: {
                        this.showStatus("Applet <" + this.apname + "> Loading Completed");
                    }
                }
                continue;
            }
            catch (Exception e) {
                if (!Debug.ex) continue;
                Debug.ex(e);
                continue;
            }
            catch (Throwable e) {
                if (!Debug.ex) continue;
                Debug.ex(e);
                continue;
            }
            break;
        }
    }

    private final String mapViewportName(String t) {
        Viewport v;
        if (t == null) {
            t = "_self";
        }
        if ((v = this.pilot.getPilotViewport()) == null) {
            return t;
        }
        if ((v = v.getParent()) == null) {
            return t;
        }
        if (t.equals("_self")) {
            return v.getId();
        }
        if (t.equals("_parent")) {
            if (v.getParent() != null) {
                v = v.getParent();
            }
            return v.getId();
        }
        return t;
    }

    private void stopApplet() {
        if (!this.status_running) {
            this.showStatus("Stop: applet <" + this.apname + "> not running.");
            return;
        }
        this.applet.setVisible(false);
        this.applet.stop();
        this.status_running = false;
        this.showStatus("Stop: applet <" + this.apname + "> stopped.");
    }

    private void initApplet(Object loadSessionTag) {
        if (this.status_inited) {
            return;
        }
        if (!this.status_loaded) {
            this.showStatus("Init: <" + this.apname + "> not loaded.");
            return;
        }
        this.appletPanel.setVisible(false);
        this.appletPanel.add((Component)this.applet, "Center");
        this.appletPanel.validate();
        this.applet.init();
        this.pilot.getPilotViewport().removeOnloadBlocker(loadSessionTag, this);
        this.status_inited = true;
        this.showStatus("Init: applet <" + this.apname + "> initialized");
    }

    private void startApplet() {
        if (!this.status_inited) {
            this.showStatus("Start: applet <" + this.apname + "> not initialized.");
            return;
        }
        if (this.status_running) {
            return;
        }
        this.applet.start();
        this.appletPanel.validate();
        this.appletPanel.setVisible(true);
        this.status_running = true;
        this.showStatus("Start: Applet <" + this.apname + "> started.");
    }

    private void destroyApplet() {
        if (!this.status_inited) {
            this.showStatus("Destroy: <" + this.apname + "> not stopped.");
            return;
        }
        this.applet.setVisible(false);
        this.applet.destroy();
        this.status_running = false;
        this.status_destroyed = true;
        this.showStatus("Destroy: Applet <" + this.apname + "> destroyed.");
    }

    private void disposeApplet(Object loadSessionTag) {
        if (!this.status_destroyed) {
            this.showStatus("Dispose: <" + this.apname + "> not destroyed.");
            return;
        }
        this.status_loaded = false;
        this.status_running = false;
        this.status_disposed = true;
        this.pilot.getPilotViewport().removeOnloadBlocker(loadSessionTag, this);
        this.showStatus("Dispose: Applet <" + this.apname + "> disposed.");
    }

    private void appletShowDocument(AppletEvent evt) {
        String t = this.mapViewportName(evt.targetFrame);
        this.pilot.renderContent(evt.url.toString(), null, t);
    }

    private boolean isVersionCompliant(Hashtable params) {
        String tmp = (String)params.get("classid");
        if (tmp == null || tmp.indexOf("clsid") == -1) {
            return true;
        }
        boolean isCompliant = true;
        tmp = (String)params.get("java_type");
        if (tmp == null) {
            tmp = (String)params.get("type");
        }
        if (tmp != null) {
            int spos = tmp.indexOf("version=");
            if (spos > -1) {
                String appletVersionString = tmp.substring(spos + "version=".length());
                JavaVersion appletVersion = null;
                try {
                    appletVersion = JavaVersion.getVersion(appletVersionString);
                }
                catch (NumberFormatException nfe) {
                    tmp = "Init: <" + this.apname + "> Error parsing Applet version string: " + appletVersionString;
                    this.showErrorStatus(tmp);
                    this.status_disposed = true;
                    return false;
                }
                if (tmp.indexOf("jpi-version") > -1) {
                    boolean bl = isCompliant = _mmbvc.compare(vmVersion, appletVersion) == 0;
                    if (!isCompliant) {
                        tmp = "Init: <" + this.apname + "> Static version requirement: " + appletVersion + " not met by VM version: " + vmVersion;
                    }
                } else {
                    boolean bl = isCompliant = _mmvc.compare(vmVersion, appletVersion) >= 0;
                    if (!isCompliant) {
                        tmp = "Init: <" + this.apname + "> Dynamic version requirement: " + appletVersion + " not met by VM version: " + vmVersion;
                    }
                }
                if (!isCompliant) {
                    if (Defs.booleanProperty("ice.pilots.applet.loadAllApplets", false)) {
                        isCompliant = true;
                    } else {
                        this.showErrorStatus(tmp);
                        this.status_disposed = true;
                    }
                }
            } else {
                tmp = "Init: <" + this.apname + "> 'type' or 'Java_type' field unsupported value";
                this.showErrorStatus(tmp);
                isCompliant = false;
            }
        }
        return isCompliant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLoader() {
        if (this.status_loaded) {
            return;
        }
        this.status_disposed = false;
        this.status_destroyed = false;
        int repeat = 0;
        while (repeat < 3) {
            String archive = null;
            if (this.paramList != null) {
                String cacheArchive;
                archive = (String)this.paramList.get("java_archive");
                if (archive == null) {
                    archive = (String)this.paramList.get("archive");
                }
                if ((cacheArchive = (String)this.paramList.get("cache_archive")) != null) {
                    archive = archive == null ? cacheArchive : archive + "," + cacheArchive;
                }
            }
            this.initAppletClassLoader(this.getCodeBase(), archive);
            if (this.apname == null) {
                this.status_disposed = true;
            } else {
                this.apname = this.apname.endsWith(".class") ? this.apname.substring(0, this.apname.length() - 6).replace('/', '.') : (this.apname.endsWith(".java") ? this.apname.substring(0, this.apname.length() - 5).replace('/', '.') : this.apname.substring(0, this.apname.length()).replace('/', '.'));
            }
            try {
                Class<?> appletClass = this.loader.loadClass(this.apname);
                this.applet = (Applet)appletClass.newInstance();
                this.notifyAboutAppletCreation();
                if (Thread.interrupted()) {
                    this.status_disposed = true;
                    this.applet = null;
                    this.showStatus("load: loading thread interrupted. Applet: <" + this.apname + ">");
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                if (++repeat < 3) {
                    block31: {
                        int slash;
                        if (repeat == 1) {
                            this.appletCodeBase = this.docBase;
                        } else if (repeat == 2) {
                            this.appletCodeBase = this.extractCodebase(this.paramList, this.docBase, true);
                        }
                        String path = this.appletCodeBase.getFile();
                        if (!path.endsWith("/") && (slash = path.lastIndexOf(47)) >= 0) {
                            path = path.substring(0, slash + 1);
                            try {
                                this.appletCodeBase = new URL(this.appletCodeBase, path);
                            }
                            catch (Exception ex) {
                                if (!Debug.ex) break block31;
                                Debug.ex(ex);
                            }
                        }
                    }
                    this.loader = null;
                    continue;
                }
                this.status_disposed = true;
                String err = "load: class <" + this.apname + "> not found: " + e.getMessage();
                this.showErrorStatus(err);
                return;
            }
            catch (Exception e) {
                if (Debug.ex) {
                    Debug.ex(e);
                }
                this.status_disposed = true;
                this.showStatus("load: error loading <" + this.apname + ">" + e.getMessage());
                return;
            }
            catch (ThreadDeath e) {
                if (Debug.ex) {
                    Debug.ex(e);
                }
                this.status_disposed = true;
                this.showStatus("load: Applet <" + this.apname + "> Thread killed");
                return;
            }
            catch (Throwable e) {
                if (Debug.ex) {
                    Debug.ex(e);
                }
                this.status_disposed = true;
                this.showStatus("load: Applet <" + this.apname + "> " + e.getMessage());
                return;
            }
            finally {
                this.queueEvent(9);
                continue;
            }
            repeat = 10;
        }
        this.applet.setStub(this);
        this.status_loaded = true;
    }

    private void notifyAboutAppletCreation() {
        DAppletElement applet_elem;
        Viewport appletViewport = this.pilot.getPilotViewport();
        DElement holder = DElement.getEmbeddedViewHolder(appletViewport);
        if (holder instanceof DAppletElement && (applet_elem = (DAppletElement)holder) != null) {
            applet_elem.setApplet(this.applet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAppletClassLoader(URL codebase, String archives) {
        Object p;
        Object[] urls = null;
        if (archives != null) {
            Vector<URL> v = new Vector<URL>();
            StringTokenizer st = new StringTokenizer(archives, " \t\n\r,");
            while (st.hasMoreTokens()) {
                String loc = st.nextToken();
                URL u = URLResolver.newURL(codebase, loc);
                if (u == null) continue;
                v.addElement(u);
            }
            urls = new URL[v.size() + 1];
            v.copyInto(urls);
        }
        if (urls == null) {
            urls = new URL[1];
        }
        urls[urls.length - 1] = codebase;
        Vector appletPilots = new Vector();
        this.pilot.getAllPilotInstances(appletPilots);
        ClassLoader another_loader = null;
        URL[] another_urls = null;
        Hashtable another_streams = null;
        Viewport another_viewport = null;
        for (int i = appletPilots.size() - 1; i >= 0; --i) {
            AppletViewer another;
            p = (ThePilot)appletPilots.elementAt(i);
            if (p == this.pilot || (another = ((ThePilot)p).viewer) == null) continue;
            Object object = loaderAccessLock;
            synchronized (object) {
                URL[] urls2 = another.loader_urls;
                if (urls2 != null && AppletViewer.sameUrlArrays((URL[])urls, urls2)) {
                    another_loader = another.loader;
                    another_urls = urls2;
                    another_streams = another.streams;
                    another_viewport = ((Pilot)p).getPilotViewport();
                    break;
                }
                continue;
            }
        }
        if (another_loader != null) {
            Object i = loaderAccessLock;
            synchronized (i) {
                this.loader = another_loader;
                this.loader_urls = another_urls;
                this.streams = another_streams;
            }
            if (Debug.trace && Debug.trace) {
                Debug.trace("Reusing " + another_loader + " from " + another_viewport);
            }
        } else {
            ClassLoader new_loader = this.pilot.getStorm().getURLClassLoaderFactory().createURLClassLoader((URL[])urls);
            p = loaderAccessLock;
            synchronized (p) {
                this.loader = new_loader;
                this.loader_urls = urls;
            }
            if (Debug.trace) {
                StringBuffer sb = new StringBuffer();
                sb.append("New loader: ");
                sb.append(new_loader);
                for (int i = 0; i != urls.length; ++i) {
                    sb.append('\n');
                    sb.append("\turls[");
                    sb.append(i);
                    sb.append("]=");
                    sb.append(urls[i]);
                }
                Debug.trace(sb.toString());
            }
        }
    }

    private static boolean sameUrlArrays(URL[] u1, URL[] u2) {
        if (u1.length != u2.length) {
            return false;
        }
        for (int i = u1.length - 1; i >= 0; --i) {
            if (u1[i].equals(u2[i])) continue;
            return false;
        }
        return true;
    }

    void addParam(String name, String value) {
        if (this.status_inited) {
            return;
        }
        this.paramList.put(name.trim().toLowerCase(), value);
    }

    private void showErrorStatus(String message) {
        this.showStatus(message);
        this.errorPanel = new ErrorComponent(message);
        this.appletPanel.add(this.errorPanel, "Center");
    }

    void setTargetFrame(String target) {
        this.baseTargetFrame = target;
    }

    public boolean isActive() {
        return this.status_running;
    }

    public URL getDocumentBase() {
        return this.docBase;
    }

    public URL getCodeBase() {
        return this.appletCodeBase;
    }

    public String getParameter(String param) {
        Object obj = this.paramList.get(param.toLowerCase());
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public void appletResize(int width, int height) {
        if (this.in_resize) {
            return;
        }
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public AudioClip getAudioClip(URL url) {
        AppletViewer appletViewer = this;
        AudioClipCallback c = appletViewer.pilot.getAudioClipCallback();
        if (c != null) {
            return c.getAudioClip(url);
        }
        try {
            Class<?> appletAudioClip = Class.forName("sun.applet.AppletAudioClip");
            Class[] paramTypes = new Class[]{Class.forName("java.net.URL")};
            Constructor<?> constructor = appletAudioClip.getConstructor(paramTypes);
            Object[] arg = new Object[]{url};
            AudioClip result = (AudioClip)constructor.newInstance(arg);
            return result;
        }
        catch (Exception ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            return this;
        }
    }

    public Image getImage(URL url) {
        Image img = null;
        if (this.loader != null) {
            img = Toolkit.getDefaultToolkit().getImage(url);
        }
        return img;
    }

    public Applet getApplet(String name) {
        if (name == null) {
            return this.getAppletComponent();
        }
        Viewport v = this.pilot.getPilotViewport();
        v = v.getParent();
        Enumeration ee = v.getChildren();
        while (ee.hasMoreElements()) {
            ThePilot pp;
            String tmp;
            v = (Viewport)ee.nextElement();
            Pilot p = v.getPilot();
            if (p == null || !(p instanceof ThePilot) || (tmp = (String)(pp = (ThePilot)p).getViewportProperty("name")) == null || !tmp.equals(name)) continue;
            return pp.getApplet();
        }
        return null;
    }

    public Enumeration getApplets() {
        Vector<Applet> c = new Vector<Applet>();
        Viewport v = this.pilot.getPilotViewport();
        v = v.getParent();
        Enumeration ee = v.getChildren();
        while (ee.hasMoreElements()) {
            ThePilot pp;
            Applet cc;
            v = (Viewport)ee.nextElement();
            Pilot p = v.getPilot();
            if (p == null || !(p instanceof ThePilot) || (cc = (pp = (ThePilot)p).getApplet()) == null) continue;
            c.addElement(cc);
        }
        return c.elements();
    }

    public void showDocument(URL url) {
        this.showDocument(url, this.baseTargetFrame);
    }

    public void showDocument(URL url, String target) {
        this.queueEvent(new AppletEvent(10, url, target));
    }

    public void showStatus(String status) {
        this.pilot.firePropertyChange("statusLine", null, status);
        if (Debug.trace) {
            Debug.trace(status);
        }
    }

    public InputStream getStream(String key) {
        return (InputStream)this.streams.get(key);
    }

    public void setStream(String key, InputStream is) throws IOException {
        int n;
        byte[] array = new byte[4097];
        int size = 0;
        while ((n = is.read(array, size, array.length - size)) != -1) {
            if ((size += n) != array.length) continue;
            throw new IOException();
        }
        byte[] tmp = new byte[size];
        System.arraycopy(array, 0, tmp, 0, size);
        array = tmp;
        ByteArrayInputStream proxy = new ByteArrayInputStream(array);
        this.streams.put(key, proxy);
    }

    protected final Hashtable getStreams() {
        return this.streams;
    }

    public void loop() {
    }

    public void play() {
    }

    public void stop() {
    }
}

