/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.NativeJavaMethod;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class FieldAndMethods
extends NativeJavaMethod {
    private Field field;
    private Object javaObject;
    private String name;

    FieldAndMethods(Method[] methods, Field field, String name) {
        super(methods);
        this.field = field;
        this.name = name;
    }

    void setJavaObject(Object javaObject) {
        this.javaObject = javaObject;
    }

    String getName() {
        if (this.field == null) {
            return this.name;
        }
        return this.field.getName();
    }

    Field getField() {
        return this.field;
    }

    public Object getDefaultValue(Class hint) {
        Class<?> type;
        Object rval;
        if (hint == ScriptRuntime.FunctionClass) {
            return this;
        }
        try {
            rval = this.field.get(this.javaObject);
            type = this.field.getType();
        }
        catch (IllegalAccessException accEx) {
            throw Context.reportRuntimeError1("msg.java.internal.private", this.getName());
        }
        Context cx = Context.getContext();
        rval = cx.getWrapFactory().wrap(cx, this, rval, type);
        if (rval instanceof Scriptable) {
            rval = ((Scriptable)rval).getDefaultValue(hint);
        }
        return rval;
    }

    public Object clone() {
        FieldAndMethods result = new FieldAndMethods(this.methods, this.field, this.name);
        result.javaObject = this.javaObject;
        return result;
    }
}

