/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

public class TablePartition
extends AbstractChildBuildableObject {
    public static final String TYPE = "PARTITION";
    public static final String COMPRESS = "COMPRESS";
    public static final String NOCOMPRESS = "NOCOMPRESS";
    private static final char COMMA = ',';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private transient String m_display;

    public TablePartition() {
    }

    public TablePartition(String string) {
        this(string, null, null);
    }

    public TablePartition(OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        this(null, partitionType, objectType);
    }

    public TablePartition(String string, OracleTablePartitions.PartitionType partitionType, OracleTablePartitions.ObjectType objectType) {
        this();
        this.setName(string);
        this.setPartitionType(partitionType);
        this.setObjectType(objectType);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setPartitionType(OracleTablePartitions.PartitionType partitionType) {
        this.m_display = null;
        this.setProperty("partitionType", (Object)partitionType);
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public OracleTablePartitions.PartitionType getPartitionType() {
        return (OracleTablePartitions.PartitionType)((Object)this.getProperty("partitionType"));
    }

    public void setObjectType(OracleTablePartitions.ObjectType objectType) {
        this.setProperty("objectType", (Object)objectType);
    }

    public OracleTablePartitions.ObjectType getObjectType() {
        return (OracleTablePartitions.ObjectType)((Object)this.getProperty("objectType"));
    }

    @Override
    public void setName(String string) {
        this.m_display = null;
        super.setName(string);
    }

    public void setSegmentAttributes(OracleStorageProperties oracleStorageProperties) {
        this.setProperty("segmentAttributes", oracleStorageProperties);
    }

    public OracleStorageProperties getSegmentAttributes() {
        return (OracleStorageProperties)this.getProperty("segmentAttributes");
    }

    @Deprecated
    @Transient
    public void setCompression(String string) {
        OracleTableProperties oracleTableProperties;
        OracleTableProperties oracleTableProperties2 = oracleTableProperties = string == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
        if (oracleTableProperties != null) {
            oracleTableProperties.setTableCompression(OracleTableProperties.OracleTableCompression.migrateFrom(string));
        }
    }

    @Deprecated
    public String getCompression() {
        OracleTableProperties.OracleTableCompression oracleTableCompression;
        String string = null;
        OracleTableProperties oracleTableProperties = (OracleTableProperties)this.getProperty("OracleTableProperties");
        if (oracleTableProperties != null && (oracleTableCompression = oracleTableProperties.getTableCompression()) != null) {
            string = oracleTableProperties.getTableCompression().toString();
        }
        return string;
    }

    public void setLOBDescriptors(LOBDescriptor[] lOBDescriptorArray) {
        this.getChildSupport("LOBDescriptors").setChildArray(lOBDescriptorArray);
    }

    public void addLOBDescriptor(LOBDescriptor lOBDescriptor) {
        this.getChildSupport("LOBDescriptors").addChild(lOBDescriptor);
    }

    public void removeLOBDescriptor(LOBDescriptor lOBDescriptor) {
        this.getChildSupport("LOBDescriptors").removeChild(lOBDescriptor);
    }

    public void removeAllLOBDescriptors() {
        this.getChildSupport("LOBDescriptors").clearChildren();
    }

    public LOBDescriptor[] getLOBDescriptors() {
        return this.getChildSupport("LOBDescriptors").getChildArray(LOBDescriptor.class);
    }

    public void setValues(Object[] objectArray) {
        Object[] objectArray2;
        if (objectArray == null) {
            objectArray2 = null;
        } else {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = this.normaliseValue(objectArray[i]);
            }
        }
        this.getChildSupport("values").setChildArray(objectArray2);
    }

    private Object normaliseValue(Object object) {
        if (object instanceof String) {
            OracleTablePartitions.PartitionType partitionType = this.getPartitionType();
            String string = (String)object;
            if (partitionType == OracleTablePartitions.PartitionType.LIST && ("NULL".equalsIgnoreCase(string) || "DEFAULT".equalsIgnoreCase(string))) {
                object = ListValue.valueOf(string.toUpperCase());
            } else if (partitionType == OracleTablePartitions.PartitionType.RANGE && "MAXVALUE".equalsIgnoreCase(string)) {
                object = RangeValue.valueOf(string.toUpperCase());
            }
        }
        return object;
    }

    public void setValues(String string) {
        if (ModelUtil.hasLength((String)string)) {
            List<String> list = TablePartition.splitValues(string);
            this.setValues(list.toArray(new String[list.size()]));
        }
    }

    public Object[] getValues() {
        return this.getChildSupport("values").getChildArray(Object.class);
    }

    public void addValue(Object object) {
        this.m_display = null;
        if (object != null) {
            this.getChildSupport("values").addChild(object);
        }
    }

    public void addValue(Object object, int n) {
        this.m_display = null;
        if (object != null) {
            this.getChildSupport("values").addChild(n, object);
        }
    }

    public void removeValue(Object object) {
        this.m_display = null;
        this.getChildSupport("values").removeChild(object);
    }

    public void setPartitionLevelSubpartitions(OracleTablePartitions oracleTablePartitions) {
        this.setProperty("partitionLevelSubpartitions", oracleTablePartitions);
    }

    public OracleTablePartitions getPartitionLevelSubpartitions() {
        return (OracleTablePartitions)this.getProperty("partitionLevelSubpartitions");
    }

    @Override
    public String toString() {
        if (this.m_display == null) {
            OracleTablePartitions.PartitionType partitionType;
            String string = this.getName();
            StringBuffer stringBuffer = new StringBuffer();
            if (ModelUtil.hasLength((String)string)) {
                stringBuffer.append(string).append(" ");
            }
            if ((partitionType = this.getPartitionType()) == OracleTablePartitions.PartitionType.LIST) {
                stringBuffer.append("VALUES (");
            } else if (partitionType == OracleTablePartitions.PartitionType.RANGE) {
                stringBuffer.append("VALUES LESS THAN (");
            }
            Iterator<Object> iterator = Arrays.asList(this.getValues()).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            if (partitionType == OracleTablePartitions.PartitionType.LIST || partitionType == OracleTablePartitions.PartitionType.RANGE) {
                stringBuffer.append(")");
            }
            this.m_display = stringBuffer.length() > 0 ? stringBuffer.toString() : "<partition>";
        }
        return this.m_display;
    }

    public static List<String> splitValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ModelUtil.hasLength((String)string)) {
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl) {
                    bl = c != '\'';
                    continue;
                }
                if (bl2) {
                    bl2 = c != '\"';
                    continue;
                }
                if (n > 0) {
                    n += c == '(' ? 1 : (c == ')' ? -1 : 0);
                    continue;
                }
                if (c == ',') {
                    String string2 = string.substring(n2, i).trim();
                    if (ModelUtil.hasLength((String)string2)) {
                        arrayList.add(string2);
                    }
                    n2 = i + 1;
                    continue;
                }
                bl = c == '\'';
                bl2 = c == '\"';
                n = c == '(' ? 1 : 0;
            }
            if (n2 < string.length()) {
                arrayList.add(string.substring(n2).trim());
            }
        }
        return arrayList;
    }

    public static enum ListValue {
        NULL,
        DEFAULT;

    }

    public static enum RangeValue {
        MAXVALUE;

    }
}

