/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.resource.APIBundle;

public class StatementWrapper {
    private static ExecutionProxy s_proxy;
    private static final List<ExecutionRunnable> s_running;
    private static final Iterator<String> s_tsKeyGen;
    private Database m_db;
    private DBObject m_contextObj;
    private boolean m_reconnectFirst;
    private boolean m_executing;
    private boolean m_cancelled;
    private Connection m_conn;
    private String m_name;
    private String m_identifier;
    private Statement m_stmt;
    private String[] m_statement;
    private boolean m_ignoreErrors;
    private boolean m_noThreads;
    private long m_nanos;
    private final StringBuffer m_queryLog = new StringBuffer();
    private static Collection<Listener> s_listeners;

    public StatementWrapper(String string, Connection connection, String ... stringArray) {
        this.m_name = string;
        this.m_conn = connection;
        this.setStatement(stringArray);
    }

    public StatementWrapper(Database database, String ... stringArray) {
        this(database, database.isConnectionClosed(null) == null, stringArray);
    }

    protected StatementWrapper(Database database, boolean bl, String ... stringArray) {
        this.m_db = database;
        this.m_reconnectFirst = bl;
        this.setStatement(stringArray);
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    public void setContextObject(DBObject dBObject) {
        this.m_contextObj = dBObject;
    }

    public void setStatement(String ... stringArray) {
        this.m_statement = stringArray;
    }

    protected final String[] getStatementStrings() {
        return this.m_statement;
    }

    public String getStatementTextForLog() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_statement != null) {
            for (String string : this.m_statement) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected final Statement getStatement() throws SQLException {
        if (this.m_stmt == null) {
            Integer n;
            if (!this.m_executing) {
                throw new IllegalStateException("not executing, statement cannot be retrieved");
            }
            this.m_stmt = this.createStatment();
            GlobalSettings globalSettings = GlobalSettings.getInstance();
            if (globalSettings != null && (n = globalSettings.getStatementTimeout()) != null) {
                try {
                    this.m_stmt.setQueryTimeout(n);
                }
                catch (SQLException sQLException) {
                    boolean bl = true;
                    if (this.m_db == null) {
                        bl = !AbstractDatabase.isSQLStateNotImplemented(sQLException);
                    } else if (this.m_db instanceof AbstractDatabase) {
                        boolean bl2 = bl = !((AbstractDatabase)this.m_db).isUnsupportedOperation(sQLException);
                    }
                    if (bl) {
                        this.getLogger().warning(APIBundle.format("STATEMENT_TIMEOUT_ERR", sQLException.getMessage()));
                    }
                }
                catch (Throwable throwable) {
                    this.getLogger().log(DBLog.getExceptionLogLevel(), APIBundle.format("STATEMENT_TIMEOUT_ERR", throwable.getMessage()), throwable);
                }
            }
        }
        return this.m_stmt;
    }

    protected Statement createStatment() throws SQLException {
        return this.getConnection().createStatement();
    }

    public void setBypassExecutionProxy(boolean bl) {
        this.m_noThreads = bl;
    }

    protected final void setExecuting(boolean bl) {
        this.m_executing = bl;
    }

    protected final boolean isCancelled() {
        return this.m_cancelled;
    }

    public boolean execute() throws DBException {
        return this.doExecute(new ExecutionRunnable<Boolean>(){

            @Override
            public Boolean runImpl() throws DBException {
                boolean bl = false;
                if (StatementWrapper.this.m_statement != null) {
                    StatementWrapper.this.setExecuting(true);
                    try {
                        if (StatementWrapper.this.m_db != null) {
                            ConnectionWrapper connectionWrapper = new ConnectionWrapper(StatementWrapper.this.m_db, StatementWrapper.this.getStatementTextForLog());
                            bl = connectionWrapper.call(new ConnectionWrapper.SQLCallable<Boolean>(connectionWrapper){

                                @Override
                                public Boolean call() throws SQLException {
                                    return StatementWrapper.this.executeStatements();
                                }
                            });
                        } else {
                            try {
                                bl = StatementWrapper.this.executeStatements();
                            }
                            catch (SQLException sQLException) {
                                StatementWrapper.this.throwDBException(sQLException);
                            }
                        }
                    }
                    finally {
                        StatementWrapper.this.close();
                        StatementWrapper.this.setExecuting(false);
                    }
                }
                return bl;
            }
        });
    }

    private boolean executeStatements() throws SQLException {
        boolean bl = true;
        for (String string : this.m_statement) {
            if (string == null) continue;
            try {
                bl = this.executeImpl(string) || bl;
            }
            catch (SQLException sQLException) {
                if (this.m_ignoreErrors) continue;
                throw sQLException;
            }
        }
        return bl;
    }

    protected boolean executeImpl(String string) throws SQLException {
        this.sqlTrace(this.getConnectionName(), string, new Object[0]);
        return this.getStatement().execute(string);
    }

    protected final <T> T doExecute(ExecutionRunnable<T> executionRunnable) throws DBException {
        if (Thread.currentThread().isInterrupted()) {
            StatementWrapper.throwCancelledException();
        }
        Object object = null;
        try {
            this.queryStarted();
            ExecutionProxy executionProxy = StatementWrapper.getExecutionProxy();
            if (executionProxy == null || this.m_noThreads) {
                executionRunnable.run();
                object = executionRunnable.getResult();
            } else {
                object = executionProxy.doExecute(executionRunnable);
            }
        }
        catch (DBException dBException) {
            if (this.m_cancelled && !(dBException instanceof CancelledException)) {
                StatementWrapper.throwCancelledException();
            }
            throw dBException;
        }
        finally {
            this.queryFinished();
        }
        return (T)object;
    }

    public void close() {
        if (this.m_stmt != null) {
            try {
                this.m_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final String getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(String string) {
        this.m_identifier = string;
    }

    protected final Database getDatabase() {
        return this.m_db;
    }

    protected final void setDatabase(Database database) {
        this.m_db = database;
    }

    protected final String getConnectionName() {
        if (this.m_db == null) {
            return this.m_name;
        }
        return this.m_db.getConnectionName();
    }

    protected final Connection getConnection() {
        Connection connection;
        if (this.m_db == null) {
            connection = this.m_conn;
        } else {
            try {
                connection = this.m_db.getConnection(this.m_reconnectFirst);
            }
            catch (DBException dBException) {
                connection = this.m_db.getConnection();
            }
        }
        return connection;
    }

    protected boolean isIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    public void setIgnoreErrors(boolean bl) {
        this.m_ignoreErrors = bl;
    }

    protected final void throwDBException(DBObject dBObject, String string, SQLException sQLException) throws DBException {
        throw this.createDBSQLException(dBObject, string, sQLException);
    }

    protected DBSQLException createDBSQLException(DBObject dBObject, String string, SQLException sQLException) {
        return StatementWrapper.createDBSQLException(this.m_db, dBObject, string, sQLException);
    }

    public final void throwDBException(SQLException sQLException) throws DBException {
        this.throwDBException(this.m_contextObj, sQLException);
    }

    public final void throwDBException(DBObject dBObject, SQLException sQLException) throws DBException {
        if (this.hasCancelled(sQLException)) {
            StatementWrapper.throwCancelledException();
        }
        this.throwDBException(dBObject, this.getStatementTextForLog(), sQLException);
    }

    protected boolean hasCancelled(SQLException sQLException) {
        return sQLException instanceof CancelledSQLException;
    }

    protected final synchronized void sqlTrace(String string, String string2, Object ... objectArray) {
        StringBuilder stringBuilder = null;
        if (objectArray != null) {
            stringBuilder = new StringBuilder();
            for (int i = 0; i < objectArray.length; ++i) {
                int n = string2.indexOf(63);
                if (n < 0) continue;
                String string3 = objectArray[i] == null ? "<null>" : "'" + objectArray[i] + "'";
                string2 = string2.substring(0, n) + string3 + string2.substring(n + 1);
                stringBuilder.append(string3).append(", ");
            }
        }
        this.m_queryLog.append('\n');
        this.m_queryLog.append(string2.trim());
        if (stringBuilder != null && stringBuilder.length() > 0) {
            this.m_queryLog.append('\n');
            this.m_queryLog.append(APIBundle.get("STATEMENT_EXECUTE_BINDS"));
            this.m_queryLog.append(' ');
            this.m_queryLog.append((CharSequence)stringBuilder);
        }
    }

    protected final void queryStarted() {
        this.m_nanos = System.nanoTime();
        if (s_listeners != null) {
            for (Listener listener : s_listeners) {
                try {
                    listener.queryStarted(this);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace(exception);
                }
            }
        }
    }

    protected final synchronized void queryFinished() {
        double d = (double)(System.nanoTime() - this.m_nanos) / 1000000.0;
        this.m_nanos = 0L;
        if (s_listeners != null) {
            for (Listener listener : s_listeners) {
                try {
                    listener.queryFinished(this);
                }
                catch (Exception exception) {
                    DBLog.logStackTrace(exception);
                }
            }
        }
        if (this.m_queryLog != null) {
            this.m_queryLog.append('\n');
            this.m_queryLog.append(APIBundle.format("STATEMENT_EXECUTE_TIMING", Double.toString(d)));
            DBLog.getSQLLog().log(Level.FINE, this.getConnectionName() + ": " + this.m_queryLog.toString());
        }
    }

    public void cancel() {
        this.m_cancelled = true;
        Statement statement = this.m_stmt;
        if (statement != null) {
            try {
                statement.cancel();
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                this.getLogger().warning(APIBundle.get("STATEMENT_CANNOT_CANCEL"));
            }
            catch (SQLException sQLException) {
                this.getLogger().warning(APIBundle.get("STATEMENT_CANCEL_ERR") + sQLException.getMessage());
            }
        }
    }

    protected static final DBSQLException createDBSQLException(Database database, DBObject dBObject, String string, SQLException sQLException) {
        if (database instanceof AbstractDatabase) {
            String string2 = ((AbstractDatabase)database).getDBExceptionMessage(sQLException);
            return new DBSQLException(dBObject, string, string2, sQLException);
        }
        return new DBSQLException(dBObject, string, sQLException);
    }

    public static final void addListener(Listener listener) {
        if (listener != null) {
            if (s_listeners == null) {
                s_listeners = new HashSet<Listener>();
            }
            s_listeners.add(listener);
        }
    }

    public static final boolean removeListener(Listener listener) {
        return s_listeners != null && s_listeners.remove(listener);
    }

    public static void setExecutionProxy(ExecutionProxy executionProxy) {
        if (s_proxy != null) {
            DBLog.getLogger(StatementWrapper.class).info("changing execution proxy for db queries from " + s_proxy.getClass().getName() + " to " + (executionProxy == null ? "null" : executionProxy.getClass().getName()));
        }
        s_proxy = executionProxy;
    }

    public static ExecutionProxy getExecutionProxy() {
        return s_proxy;
    }

    public static void throwCancelledException() throws CancelledException {
        throw StatementWrapper.createCancelledException();
    }

    private static CancelledException createCancelledException() {
        return new CancelledException(APIBundle.get("CANCELLED_STMT_EX"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelExecution(Thread thread) {
        List<ExecutionRunnable> list = s_running;
        synchronized (list) {
            for (ExecutionRunnable executionRunnable : s_running) {
                if (thread != executionRunnable.m_runningThread) continue;
                executionRunnable.cancel();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExecutionProxyThread(Thread thread, Thread thread2) {
        boolean bl = false;
        List<ExecutionRunnable> list = s_running;
        synchronized (list) {
            for (ExecutionRunnable executionRunnable : s_running) {
                if (executionRunnable.m_parentThread != thread || executionRunnable.m_runningThread != thread2) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static {
        s_running = Collections.synchronizedList(new ArrayList());
        s_tsKeyGen = DBUtil.getTimestampKeyGenerator(StatementWrapper.class.getName());
    }

    public abstract class ExecutionRunnable<T>
    implements Runnable {
        private T m_result;
        private DBException m_dbe;
        private Thread m_parentThread;
        private Thread m_runningThread;

        @Override
        public synchronized void run() {
            String string = (String)s_tsKeyGen.next();
            try {
                DBUtil.suspendTimestampChecking(StatementWrapper.this.m_db, string);
                this.m_result = null;
                this.m_dbe = null;
                this.m_runningThread = Thread.currentThread();
                s_running.add(this);
                if (StatementWrapper.this.m_cancelled || this.m_runningThread.isInterrupted()) {
                    this.m_dbe = StatementWrapper.createCancelledException();
                } else {
                    this.m_result = this.runImpl();
                }
            }
            catch (DBException dBException) {
                this.m_dbe = dBException;
            }
            catch (Throwable throwable) {
                this.m_dbe = new DBException(throwable);
            }
            finally {
                this.m_runningThread = null;
                s_running.remove(this);
                DBUtil.resumeTimestampChecking(StatementWrapper.this.m_db, string);
            }
        }

        public abstract T runImpl() throws DBException;

        public T getResult() throws DBException {
            if (this.m_dbe != null) {
                throw this.m_dbe;
            }
            return this.m_result;
        }

        public String getName() {
            return StatementWrapper.this.m_db == null ? "" : StatementWrapper.this.m_db.getConnectionName();
        }

        public String getLogText() {
            return StatementWrapper.this.m_queryLog == null ? null : StatementWrapper.this.m_queryLog.toString();
        }

        public final void cancel() {
            StatementWrapper.this.cancel();
        }
    }

    public static abstract class ExecutionProxy {
        private <T> T doExecute(ExecutionRunnable<T> executionRunnable) throws DBException {
            try {
                ((ExecutionRunnable)executionRunnable).m_parentThread = Thread.currentThread();
                T t = this.execute(executionRunnable);
                return t;
            }
            finally {
                ((ExecutionRunnable)executionRunnable).m_parentThread = null;
            }
        }

        public abstract <T> T execute(ExecutionRunnable<T> var1) throws DBException;
    }

    public static interface Listener {
        public void queryStarted(StatementWrapper var1);

        public void queryFinished(StatementWrapper var1);
    }
}

