/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GeneratorCache {
    private Map<Class, Subcache> m_cache = new HashMap<Class, Subcache>();

    GeneratorCache() {
    }

    synchronized <T> void registerGenerator(Class<T> clazz, String string, T t) {
        Subcache subcache = this.m_cache.get(clazz);
        if (subcache == null) {
            subcache = new Subcache();
            this.m_cache.put(clazz, subcache);
        }
        subcache.registerGenerator(string, t);
    }

    synchronized <T> boolean unregisterGenerator(Class<T> clazz, String string, T t) {
        Subcache subcache = this.m_cache.get(clazz);
        if (subcache != null) {
            return subcache.unregisterGenerator(string, t);
        }
        return false;
    }

    <T> List<T> getGenerators(Class<T> clazz, String string) {
        Subcache subcache = this.m_cache.get(clazz);
        if (subcache != null) {
            return subcache.getGenerators(string);
        }
        return Collections.emptyList();
    }

    boolean containsType(Class clazz, String string) {
        Subcache subcache = this.m_cache.get(clazz);
        if (subcache != null) {
            return subcache.containsType(string);
        }
        return false;
    }

    private class Subcache<G> {
        private Map<String, List<G>> m_subcache = new HashMap<String, List<G>>();

        private Subcache() {
        }

        private void registerGenerator(String string, G g) {
            List<G> list = this.m_subcache.get(string);
            if (list == null) {
                list = new ArrayList<G>();
                this.m_subcache.put(string, list);
            }
            list.add(0, g);
        }

        private boolean unregisterGenerator(String string, G g) {
            List<G> list = this.m_subcache.get(string);
            if (list != null) {
                return list.remove(g);
            }
            return false;
        }

        private List<G> getGenerators(String string) {
            List<G> list = this.m_subcache.get(string);
            if (list != null) {
                return list;
            }
            return Collections.emptyList();
        }

        private boolean containsType(String string) {
            return this.m_subcache.containsKey(string);
        }
    }
}

