/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.ModelUtil;

public class Table
extends Relation {
    public static final String TYPE = "TABLE";
    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    @PropertyKey(value=TableType.class, childOf={Table.class})
    public static final String TABLE_TYPE_KEY = "TableType";

    public Table() {
        this.setProperty(TABLE_TYPE_KEY, (Object)TableType.NORMAL);
    }

    public Table(String string, Schema schema) {
        super(string, schema);
        this.setProperty(TABLE_TYPE_KEY, (Object)TableType.NORMAL);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Index[] getIndexes() {
        return this.getChildSupport("indexes").getChildArray(Index.class);
    }

    public void setIndexes(Index[] indexArray) {
        this.getChildSupport("indexes").setChildArray(indexArray);
    }

    public void addIndex(Index index) {
        this.getChildSupport("indexes").addChild(index);
    }

    public void removeIndex(Index index) {
        this.getChildSupport("indexes").removeChild(index);
    }

    public Index getIndex(String string) {
        return (Index)this.getChildSupport("indexes").findChild(string);
    }

    @Override
    public void setSchema(Schema schema) {
        Schema schema2 = this.getSchema();
        super.setSchema(schema);
        if (schema != schema2 && this.getPropertySupport().isBuilt("indexes")) {
            for (Index index : this.getIndexes()) {
                Schema schema3 = index.getSchema();
                if (schema3 == null) continue;
                String string = schema3.getName();
                if ((schema2 == null || !ModelUtil.areEqual((Object)string, (Object)schema2.getName())) && (schema == null || !ModelUtil.areEqual((Object)string, (Object)schema.getName()))) continue;
                index.setSchema(null);
            }
        }
    }

    @Override
    public void setProperty(String string, Object object) {
        if ("compression".equals(string) || "parallel".equals(string)) {
            OracleTableProperties oracleTableProperties;
            OracleTableProperties oracleTableProperties2 = oracleTableProperties = object == null ? (OracleTableProperties)this.getProperty("OracleTableProperties") : OracleTableProperties.findOrCreateOracleTableProperties(this);
            if (oracleTableProperties != null) {
                if ("compression".equals(string)) {
                    oracleTableProperties.setTableCompression(OracleTableProperties.OracleTableCompression.migrateFrom(object));
                } else {
                    oracleTableProperties.setParallelDegree((Integer)object);
                }
            }
        } else {
            super.setProperty(string, object);
        }
    }

    public static enum TableType {
        NORMAL,
        TRANSACTION_TEMP,
        SESSION_TEMP,
        INDEX_ORGANIZED,
        EXTERNAL;

    }
}

