/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.ModelUtil;

public class CascadeRequiredException
extends DBException {
    private final Collection<DBObjectID> m_deps = new ArrayList<DBObjectID>();
    private final Collection<DBObject> m_objs = new ArrayList<DBObject>();
    private String m_detailMessage;

    public CascadeRequiredException(DBObject dBObject, String string) {
        this(dBObject);
        this.m_detailMessage = string;
    }

    public CascadeRequiredException(DBObject dBObject) {
        this(dBObject, (Collection<DBObjectID>)null);
    }

    public CascadeRequiredException(DBObject dBObject, Collection<DBObjectID> collection) {
        this(Arrays.asList(dBObject), collection);
    }

    public CascadeRequiredException(Collection<? extends DBObject> collection, Collection<DBObjectID> collection2) {
        super((Throwable)null);
        if (collection != null) {
            this.m_objs.addAll(collection);
        }
        if (collection2 != null) {
            this.m_deps.addAll(collection2);
        }
    }

    public void include(CascadeRequiredException cascadeRequiredException) {
        this.m_objs.addAll(cascadeRequiredException.m_objs);
        this.m_deps.addAll(cascadeRequiredException.m_deps);
    }

    @Override
    public String getMessage() {
        Object object;
        if (this.m_objs == null || this.m_objs.size() == 0) {
            object = APIBundle.get("CASCADE_DELETE");
        } else {
            Object object2;
            StringBuilder stringBuilder = new StringBuilder();
            for (DBObject object3 : this.m_objs) {
                if (object3 == null) continue;
                stringBuilder.append("\n").append(object3.getName());
            }
            stringBuilder.append("\n");
            if (this.m_deps != null && this.m_deps.size() > 0) {
                object2 = new StringBuilder();
                for (DBObjectID dBObjectID : this.m_deps) {
                    ((StringBuilder)object2).append("\n").append(DBUtil.getFullyQualifiedName(dBObjectID));
                }
                object = APIBundle.format("CASCADE_DELETE_ERR_VERBOSE", stringBuilder, ((StringBuilder)object2).toString());
            } else {
                object2 = APIBundle.format("CASCADE_DELETE_ERR", stringBuilder);
                object = ModelUtil.hasLength((String)this.m_detailMessage) ? (String)object2 + " " + this.m_detailMessage : object2;
            }
        }
        return object;
    }

    @Override
    public DBObject getObject() {
        return this.m_objs == null || this.m_objs.size() == 0 ? super.getObject() : this.m_objs.iterator().next();
    }

    public Collection<DBObject> getObjects() {
        return this.m_objs;
    }

    public Collection<DBObjectID> getDependents() {
        return this.m_deps;
    }
}

