/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.resource.IdeIcons;
import oracle.jdeveloper.java.locator.ModularizedJdkClassLocator;

class ModularizedJdkURLFileSystemHelper
extends URLFileSystemHelper {
    static final String MODULE_JDK_PROTOCOL = "mjdk";
    static final String JRTFS_URL_SEPARATOR = "!/";

    ModularizedJdkURLFileSystemHelper() {
    }

    static URL createDirURL(String jrtfsJarPath, String module, String dirName) {
        return URLFactory.newURL((String)MODULE_JDK_PROTOCOL, (String)(jrtfsJarPath + JRTFS_URL_SEPARATOR + module + JRTFS_URL_SEPARATOR + dirName.replace('.', '/')));
    }

    static URL createClassURL(String jrtfsJarPath, String module, String className) {
        return URLFactory.newURL((String)MODULE_JDK_PROTOCOL, (String)(jrtfsJarPath + JRTFS_URL_SEPARATOR + module + JRTFS_URL_SEPARATOR + className.replace('.', '/') + ".class"));
    }

    public boolean exists(URL url) {
        UrlParts urlParts = this.getUrlParts(url);
        ModularizedJdkClassLocator classLocator = this.getLocator(urlParts);
        if (classLocator != null) {
            if (urlParts.name.endsWith(".class")) {
                return classLocator.classExists(urlParts.module, urlParts.name);
            }
            return classLocator.packageExists(urlParts.name.replace('/', '.'));
        }
        return false;
    }

    public boolean canCreate(URL url) {
        return false;
    }

    public boolean canDelete(URL url) {
        return false;
    }

    public boolean canRead(URL url) {
        return this.exists(url);
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        throw new UnknownServiceException();
    }

    public String getFileName(URL url) {
        UrlParts urlParts = this.getUrlParts(url);
        if (urlParts != null) {
            String pathName = urlParts.name;
            int index = pathName.lastIndexOf(47);
            return index > 0 ? pathName.substring(index + 1) : pathName;
        }
        return null;
    }

    public long getLength(URL url) {
        try {
            ModularizedJdkClassLocator locator;
            UrlParts urlParts = this.getUrlParts(url);
            if (urlParts != null && urlParts.name.endsWith(".class") && (locator = this.getLocator(urlParts)) != null) {
                byte[] bytes = locator.getBytes(urlParts.module, urlParts.name);
                return bytes.length;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    public long lastModified(URL url) {
        UrlParts urlParts = this.getUrlParts(url);
        ModularizedJdkClassLocator locator = this.getLocator(urlParts);
        if (locator != null) {
            return locator.getLastModified();
        }
        return -1L;
    }

    public URL getParent(URL url) {
        String lastName;
        int index;
        UrlParts urlParts = this.getUrlParts(url);
        if (urlParts != null && (index = (lastName = urlParts.name).lastIndexOf(47)) > 0) {
            return ModularizedJdkURLFileSystemHelper.createDirURL(urlParts.jrtfsFile, urlParts.module, lastName.substring(0, index));
        }
        return null;
    }

    public InputStream openInputStream(URL url) throws IOException {
        ModularizedJdkClassLocator locator;
        UrlParts urlParts = this.getUrlParts(url);
        if (urlParts != null && urlParts.name.endsWith(".class") && (locator = this.getLocator(urlParts)) != null) {
            byte[] bytes = locator.getBytes(urlParts.module, urlParts.name);
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        throw new UnknownServiceException();
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        if (this.isDirectory(url1)) {
            UrlParts urlParts1 = this.getUrlParts(url1);
            UrlParts urlParts2 = this.getUrlParts(url2);
            if (urlParts1 != null && urlParts2 != null) {
                return urlParts1.jrtfsFile.equals(urlParts2.jrtfsFile) && urlParts1.module.equals(urlParts2.module) && urlParts2.name.startsWith(urlParts1.name + "/");
            }
        }
        return false;
    }

    public URL canonicalize(URL url) {
        UrlParts urlParts = this.getUrlParts(url);
        if (urlParts != null) {
            URL fileURL = URLFactory.newFileURL((String)urlParts.jrtfsFile);
            URL canonicalized = URLFileSystem.canonicalize((URL)fileURL);
            if (this.isDirectory(url)) {
                return ModularizedJdkURLFileSystemHelper.createDirURL(canonicalized.getPath(), urlParts.module, urlParts.name);
            }
            if (urlParts.name.endsWith(".class")) {
                return ModularizedJdkURLFileSystemHelper.createClassURL(canonicalized.getPath(), urlParts.module, urlParts.name.substring(0, urlParts.name.length() - 6));
            }
        }
        return url;
    }

    public Icon getDefaultIcon(URL url) {
        if (url != null) {
            if (this.isDirectory(url)) {
                return IdeIcons.getIcon((int)26);
            }
            return IdeIcons.getIcon((int)28);
        }
        return null;
    }

    public boolean isDirectory(URL url) {
        return this.exists(url) && !url.getPath().endsWith(".class");
    }

    public boolean isDirectoryPath(URL url) {
        return this.isDirectory(url);
    }

    public boolean isLocal(URL url) {
        UrlParts urlParts = this.getUrlParts(url);
        ModularizedJdkClassLocator locator = this.getLocator(urlParts);
        if (locator != null) {
            return locator.isLocal();
        }
        return true;
    }

    public URL[] list(URL url) {
        UrlParts urlParts;
        ModularizedJdkClassLocator locator;
        if (this.isDirectory(url) && (locator = this.getLocator(urlParts = this.getUrlParts(url))) != null) {
            ArrayList<String> packages = new ArrayList<String>();
            String dottedPackage = urlParts.name.replace('/', '.');
            locator.getPackages(dottedPackage, packages);
            Collection<String> classes = locator.getClassesInPackage(dottedPackage);
            int packagesSize = packages.size();
            URL[] urls = new URL[packagesSize + classes.size()];
            int count = 0;
            for (String onePackage : packages) {
                urls[count++] = ModularizedJdkURLFileSystemHelper.createDirURL(urlParts.jrtfsFile, urlParts.module, urlParts.name + "/" + onePackage);
            }
            for (String oneClass : classes) {
                urls[count++] = ModularizedJdkURLFileSystemHelper.createClassURL(urlParts.jrtfsFile, urlParts.module, urlParts.name + "/" + oneClass);
            }
            return urls;
        }
        return null;
    }

    public String toRelativeSpec(URL url, URL base) {
        return url.toString();
    }

    public URL getBaseParent(URL url, String relativeSpec) {
        return this.isDirectory(url) ? url : this.getParent(url);
    }

    public String getPath(URL url) {
        UrlParts urlParts = this.getUrlParts(url);
        if (urlParts != null) {
            return urlParts.name;
        }
        return null;
    }

    private UrlParts getUrlParts(URL url) {
        String[] parts;
        String path;
        if (url != null && (path = url.getPath()) != null && (parts = path.split(JRTFS_URL_SEPARATOR)) != null && parts.length == 3) {
            return new UrlParts(parts[0], parts[1], parts[2]);
        }
        return null;
    }

    private ModularizedJdkClassLocator getLocator(UrlParts urlParts) {
        if (urlParts != null) {
            return ModularizedJdkClassLocator.getInstance(URLFactory.newFileURL((String)urlParts.jrtfsFile));
        }
        return null;
    }

    private static class UrlParts {
        String jrtfsFile;
        String module;
        String name;

        UrlParts(String jrtfsFile, String module, String name) {
            this.jrtfsFile = jrtfsFile;
            this.module = module;
            this.name = name;
        }
    }
}

