/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bm.util.ui.EnablingJPanel;
import oracle.bm.util.ui.table.SingleSelectionTable;

public class ForwardingScrollPane
extends EnablingJPanel {
    private SingleSelectionTable m_table;
    private JScrollPane m_scrollPane;

    public ForwardingScrollPane(SingleSelectionTable table) {
        this.m_table = table;
        this.setLayout(new BorderLayout());
        NavigationPanel previous = new NavigationPanel(0);
        previous.setLayout(new BorderLayout());
        this.add((Component)previous, "Center");
        this.m_scrollPane = new JScrollPane(table);
        previous.add((Component)this.m_scrollPane, "Center");
        NavigationPanel next = new NavigationPanel(table.getColumnCount() - 1);
        next.setPreferredSize(new Dimension(0, 0));
        previous.add((Component)next, "East");
    }

    @Override
    public void requestFocus() {
        this.m_table.requestFocus();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.m_scrollPane.getVerticalScrollBar().setEnabled(enable);
        this.m_scrollPane.getHorizontalScrollBar().setEnabled(enable);
        this.m_table.setEnabled(enable);
    }

    private class NavigationPanel
    extends EnablingJPanel
    implements FocusListener {
        private int m_columnIndex;

        public NavigationPanel(int columnIndex) {
            this.m_columnIndex = columnIndex;
            this.addFocusListener(this);
        }

        @Override
        public boolean isFocusTraversable() {
            return ForwardingScrollPane.this.m_table.isFocusTraversable() && SwingUtilities.findFocusOwner(ForwardingScrollPane.this.m_table) == null;
        }

        @Override
        public void focusGained(FocusEvent event) {
            ForwardingScrollPane.this.m_table.changeSelection(ForwardingScrollPane.this.m_table.getSelectedRow(), this.m_columnIndex, true, false);
            ForwardingScrollPane.this.m_table.editCellAt(ForwardingScrollPane.this.m_table.getSelectedRow(), this.m_columnIndex);
            ForwardingScrollPane.this.m_table.requestFocus();
        }

        @Override
        public void focusLost(FocusEvent event) {
        }
    }
}

