/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.persistence;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.persistence.PersistenceLogger;

public class SecondaryKeyCreatorAdapter
implements SecondaryMultiKeyCreator {
    private final SecondaryKeyProvider provider;
    private final String keyName;

    public SecondaryKeyCreatorAdapter(SecondaryKeyProvider provider, String keyName) {
        this.provider = provider;
        this.keyName = keyName;
    }

    public void createSecondaryKeys(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, Set<DatabaseEntry> results) throws DatabaseException {
        try {
            String primaryKey = new String(key.getData(), "UTF-8");
            Collection<String> keys = this.provider.getSecondaryKeys(this.keyName, primaryKey, data.getData());
            for (String secondaryKey : keys) {
                results.add(new DatabaseEntry(secondaryKey.getBytes("UTF-8")));
            }
        }
        catch (UnsupportedEncodingException e) {
            PersistenceLogger.getLogger().log(Level.SEVERE, "Unable to create secondary key for " + this.keyName, e);
        }
    }
}

