/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;

public final class MigrationResourceManager {
    private static HashMap<String, Image> s_classImageMap = new HashMap();

    private MigrationResourceManager() {
    }

    private static Image getImage(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            return Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Image getImage(Class clazz, String string) {
        String string2 = clazz.getName() + '|' + string;
        Image image = s_classImageMap.get(string2);
        if (image == null) {
            if (string.length() > 0 && string.charAt(0) == '/') {
                String string3 = string.substring(1, string.length());
                image = MigrationResourceManager.getImage(new BufferedInputStream(clazz.getClassLoader().getResourceAsStream(string3)));
            } else {
                image = MigrationResourceManager.getImage(clazz.getResourceAsStream(string));
            }
            s_classImageMap.put(string2, image);
        }
        return image;
    }

    public static Image getImage(String string) {
        return MigrationResourceManager.getImage("default", string);
    }

    public static Image getImage(String string, String string2) {
        String string3 = string + '|' + MigrationResourceManager.class.getName() + '|' + string2;
        Image image = s_classImageMap.get(string3);
        if (image == null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                image = MigrationResourceManager.getImage(fileInputStream);
                s_classImageMap.put(string3, image);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return image;
    }

    public static void clearImages(String string) {
        Iterator<String> iterator = s_classImageMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string + '|')) continue;
            Image image = s_classImageMap.get(string2);
            image.flush();
            iterator.remove();
        }
    }

    public static ImageIcon getIcon(Class clazz, String string) {
        return MigrationResourceManager.getIcon(MigrationResourceManager.getImage(clazz, string));
    }

    public static ImageIcon getIcon(String string) {
        return MigrationResourceManager.getIcon("default", string);
    }

    public static ImageIcon getIcon(String string, String string2) {
        return MigrationResourceManager.getIcon(MigrationResourceManager.getImage(string, string2));
    }

    public static ImageIcon getIcon(Image image) {
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }
}

